//sipbst_opt_val.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipbst.h"
#include "bnf_parser.h"
#include "sipb_bnftools.h"
#include "sipb_bnfrules_forcreate.h"
#include "sipb_bnfrules_forparse.h"

//                                                                            
void sipbst_opt_val::_work()
{
   
   sipb_bnftools::fullset_optval(pcr,servhost_name,get_servport(),
				 username,userhost_name,max_contlen,!is_reliable_trans());
      //if reliable trans we MUST add Content-Length
   
   if (!av_csrp_reqresp()) return;
   
   if (!check_2xx_status())
     return;
   if (pv_recv.get_quan("Allow")!=1)
     add_last_error("Allow header not present. But SHOULD be (rfc3261 11.2)");
   if (pv_recv.get_quan("Accept")!=1)
     add_last_warning("Accept header not present. But SHOULD be (rfc3261 11.2)");
   if (pv_recv.get_quan("Accept-Encoding")!=1)
     add_last_warning("Accept-Encoding header not present. But SHOULD be (rfc3261 11.2)");
   if (pv_recv.get_quan("Accept-Language")!=1)
     add_last_warning("Accept-Language header not present. But SHOULD be (rfc3261 11.2)");
   return;
}
