//sipbst_reg_del.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipbst.h"
#include "bnf_parser.h"
#include "sipb_bnftools.h"
#include "sipb_bnfrules_forcreate.h"
#include "sipb_bnfrules_forparse.h"
#include "sipb_md5.h"

//                                                                            
void sipbst_reg_del::_work()
{
   //FIRST REQUEST
   sipb_bnftools::set_rulebydef(pcr);
   sipb_bnftools::set_reqline(pcr,"REGISTER",servhost_name,"",get_servport());
   sipb_bnftools::set_maxfor(pcr , random()%70 + 1);
   sipb_bnftools::set_to_nottag(pcr, servhost_name, username,1024 + random()%30000);
   sipb_bnftools::set_cseq(pcr,"REGISTER");
   sipb_bnftools::set_from(pcr,servhost_name,username,1024 +random()%30000 );
   int port1 = 10000 + random() % 10000;
   sipb_bnftools::set_contact(pcr, userhost_name, username,
			      port1,false,"Contact"); 
   sipb_bnftools::set_expires(pcr,60);
   string uri=string("sip:")+username+"@"+servhost_name;   
   if (!av_csrprr_auth("REGISTER",uri,username,password,max_contlen,
		       "Contact","Expires"))
     return;
   if (!check_2xx_status())
     return;
   sipb_errwarn ew;
   sipb_bnftools::check_regcontact(&pv_recv,&pv_send,ew);
   add_last_errwarn(ew);
   if (pv_recv.get_quan("Date")!=1)
     add_last_warning("The REGISTER-responce SHOULD include a Date header field (rfc3261 10.3 page 66)");

   //Two way to delete record -- sent Contact=* Expires=0
   //and Contact=....;expires=0
   bool send_cstar=random() % 2;
   if (send_cstar)  //send Contact=*
     {
	sipb_bnftools::set_contact_star(pcr,"Contact");
	sipb_bnftools::set_expires(pcr,0);
	if (!av_csrprr_auth("REGISTER",uri,username,password,max_contlen,
			    "Contact Expires"))
	  return;
     }
   else  
     {
	sipb_bnftools::set_contact(pcr, userhost_name, username,
				   port1,false,"Contact",0,false); 
	if (!av_csrprr_auth("REGISTER",uri,username,password,max_contlen,
			    "Contact","Expires"))
	  return;
     }
   if (!check_2xx_status())
     return;
   if (pv_recv.get_quan("Date")!=1)
     add_last_warning("The REGISTER-responce SHOULD include a Date header field (rfc3261 10.3 page 66)");
   //Check what server delete record
   if (send_cstar)
     {
	if (pv_recv.is_present("Contact"))
	  add_last_error("We send Contact=* and Expires=0 ... all Contact must be removed!");
     }
   else
     {
	if (sipb_bnftools::find_contact_port(&pv_recv,port1))
	  add_last_error("Contact-record with port="+
			 sipb_bnftools::str(port1)+" should be removed"+
			 "(we send this field with expires=0)");
     }
}

