//sipbst_reg_mcexp.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)
#include "sipbst.h"
#include "bnf_parser.h"
#include "sipb_bnftools.h"
#include "sipb_bnfrules_forcreate.h"
#include "sipb_bnfrules_forparse.h"
#include "sipb_md5.h"

sipbst_reg_mcexp::sipbst_reg_mcexp()
{
   paramlist()->add_wanted(SIPB_SP_PASSWORD,true,SIPB_SP_PASSWORD_DEF);
   paramlist()->add_wanted_int(SIPB_SP_EXPIRES,true,0,
			       SIPB_SP_MAX_INT,
			       SIPB_SP_EXPIRES_DEF);
}
//                                                                            
void sipbst_reg_mcexp::_run_beforework()
{
   password=paramlist()->get(SIPB_SP_PASSWORD);
   expires=paramlist()->get_int(SIPB_SP_EXPIRES);
}
//                                                                            
void sipbst_reg_mcexp::_work()
{
   //FIRST REQUEST
   sipb_bnftools::set_rulebydef(pcr);
   sipb_bnftools::set_reqline(pcr,"REGISTER",servhost_name,"",get_servport());
   sipb_bnftools::set_maxfor(pcr , random()%70 + 1);
   sipb_bnftools::set_to_nottag(pcr, servhost_name, username,1024 + random()%30000);
   sipb_bnftools::set_cseq(pcr,"REGISTER");
   sipb_bnftools::set_from(pcr,servhost_name,username,1024 +random()%30000 );
   int port1 = 10000 + random() % 10000;
   int port2 = 30000 + random() % 10000;
   bool gen_expires=random() % 2;
   if (gen_expires)  //set Expires header (not set in Contact)
     {
	sipb_bnftools::set_contact(pcr, userhost_name, username,
				   port1,false,"Contact",-1); //not send expir
	sipb_bnftools::set_expires(pcr,expires);
     }
   else   //set in Contact (and in Expires but in Expires not mean)
     {
	sipb_bnftools::set_contact(pcr, userhost_name, username,
				   port1,false,"Contact",expires,false);
	sipb_bnftools::set_expires(pcr,expires * 10); 
     }
   sipb_bnftools::set_contact(pcr,userhost_name,username,
			      port2,false,"Contact-1",expires * 10,false);
   string uri=string("sip:")+username+"@"+servhost_name;
   if (gen_expires)
     {
	if (!av_csrprr_auth("REGISTER",uri,username,password,max_contlen,
			    "Contact Contact-1 Expires"))
	  return;
     }
   else
     {
	if (!av_csrprr_auth("REGISTER",uri,username,password,max_contlen,
			    "Contact Contact-1","Expires"))
	  return;
     }
   if (status_code==403) //Interval To Brief
     {
	if (pv_recv.get_quan("Min-Expires"))
	  add_last_error("403 - Interval To Brief MUST contain Min-Expires field (rfc3261 10.3 page 65)");
	return; //This is OK
     }
   if (!check_2xx_status())
     return;
   if (expires < 5)
     {
	add_last_warning(string("We send packet with too small expires")+
			 " parameter but server don't send 403 responce"+
			 " Its may be dangerous");
     }   
   sipb_errwarn ew;
   sipb_bnftools::check_regcontact(&pv_recv,&pv_send,ew);
   add_last_errwarn(ew);
   if (pv_recv.get_quan("Date")!=1)
     add_last_warning("The REGISTER-responce SHOULD include a Date header field (rfc3261 10.3 page 66)");
   
   //Now we wait expires * 2 second end check .... 
   add_gen_info("We go to sleep on "+sipb_bnftools::str(expires * 2)+" second");
   sleep(expires * 2);
   if (!av_csrprr_auth("REGISTER",uri,username,password,max_contlen,""))
     return;
   if (!check_2xx_status())
     return;
   if (pv_recv.get_quan("Date")!=1)
     add_last_warning("The REGISTER-responce SHOULD include a Date header field (rfc3261 10.3 page 66)");
   //Check remove record
   if (sipb_bnftools::find_contact_port(&pv_recv,port1))  
	  //Hm this record MUST be removed after expires second
     {
	add_last_warning("Record with expires="+sipb_bnftools::str(expires)+
			 " (port="+sipb_bnftools::str(port1)+
			 ") should be removed (we wait expires*2 second)");
     }
   if (!sipb_bnftools::find_contact_port(&pv_recv,port2))
     {
	add_last_warning("Record with expires="+sipb_bnftools::str(expires*10)+
			 " (port="+sipb_bnftools::str(port2)+
			 ") should not be removed (we wait only expires*2 second)");
     }
   
}
