//sipbst_reg_val.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipbst.h"
#include "bnf_parser.h"
#include "sipb_bnftools.h"
#include "sipb_bnfrules_forcreate.h"
#include "sipb_bnfrules_forparse.h"
#include "sipb_md5.h"

sipbst_reg_val::sipbst_reg_val()
{
   paramlist()->add_wanted(SIPB_SP_PASSWORD,true,SIPB_SP_PASSWORD_DEF);
}
//                                                                            
void sipbst_reg_val::_run_beforework()
{
   password=paramlist()->get(SIPB_SP_PASSWORD);
}
//                                                                            
void sipbst_reg_val::_work()
{
   //FIRST REQUEST
   sipb_bnftools::set_rulebydef(pcr);
   sipb_bnftools::set_reqline(pcr,"REGISTER",servhost_name,"",get_servport());
   sipb_bnftools::set_maxfor(pcr , random()%70 + 1);
   sipb_bnftools::set_to_nottag(pcr, servhost_name, username,1024 + random()%30000);
   sipb_bnftools::set_cseq(pcr,"REGISTER");
   sipb_bnftools::set_expires(pcr,60);
   sipb_bnftools::set_from(pcr,servhost_name,username,1024 +random()%30000 );
   sipb_bnftools::set_contact(pcr, userhost_name, username,
			      1024 + random() % 30000);
   string uri=string("sip:")+username+"@"+servhost_name;   
   if (!av_csrprr_auth("REGISTER",uri,username,password,max_contlen,"Contact",
		       "Expires"))  //Expires optionaly
     return;
   if (!check_2xx_status())
     return;
   sipb_errwarn ew;
   sipb_bnftools::check_regcontact(&pv_recv,&pv_send,ew);
   add_last_errwarn(ew);
   if (pv_recv.get_quan("Date")!=1)
     add_last_warning("The REGISTER-responce SHOULD include a Date header field (rfc3261 10.3 page 66)");
}
