//sipbst_sendrecv.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipbst_sendrecv.h"
#include "sipb_bnftools.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdexcept>

//                                                                            
sipbst_sendrecv::sipbst_sendrecv()
{
   tr_send=new sipb_udptrans;
   tr_recv=new sipb_udptrans;
   is_sr_same=true;
   paramlist()->add_wanted(SIPB_SP_SIPSERVER,true,
			   SIPB_SP_SIPSERVER_DEF);
   paramlist()->add_wanted_int(SIPB_SP_SERV_UDPPORT,true,0,
			       SIPB_SP_MAX_PORT,
			       SIPB_SP_SERV_UDPPORT_DEF);
   paramlist()->add_wanted_int(SIPB_SP_SERV_TCPPORT,true,0,
			       SIPB_SP_MAX_PORT,
			       SIPB_SP_SERV_TCPPORT_DEF);
   vector<string> tmp;
   tmp.push_back(SIPB_TRANS_UDP);
   tmp.push_back(SIPB_TRANS_TCP);
   tmp.push_back(SIPB_TRANS_TCP_BROKEN);
   tmp.push_back(SIPB_TRANS_ANY);
   paramlist()->add_wanted_voriants(SIPB_SP_TRANSPORT,true,tmp);
   
   paramlist()->add_wanted_int(SIPB_SP_NSEND,true,0,
			       SIPB_SP_MAX_INT,
			       SIPB_SP_NSEND_DEF);
   paramlist()->add_wanted_int(SIPB_SP_NRESEND,true,0,
			       SIPB_SP_MAX_INT,
			       SIPB_SP_NRESEND_DEF);
   paramlist()->add_wanted_int(SIPB_SP_RESEND_TIMEOUT,true,0,
			       SIPB_SP_MAX_INT,
			       SIPB_SP_RESEND_TIMEOUT_DEF);
}
//                                                                            
sipbst_sendrecv::~sipbst_sendrecv()
{
   delete tr_send;
   delete tr_recv;
}
//                                                                            
void sipbst_sendrecv::work()
{
   //Read parameters from paramlist
   servhost_name=paramlist()->get(SIPB_SP_SIPSERVER);
   if (!serv_ip.try_set(paramlist()->get(SIPB_SP_SIPSERVER)))
     {
	add_gen_error("Bad server name");
	return;
     }
   udp_port=paramlist()->get_int(SIPB_SP_SERV_UDPPORT);
   tcp_port=paramlist()->get_int(SIPB_SP_SERV_TCPPORT);
   transport=paramlist()->get(SIPB_SP_TRANSPORT);
   n_send=paramlist()->get_int(SIPB_SP_NSEND);
   n_resend=paramlist()->get_int(SIPB_SP_NRESEND);
   resend_timeout=paramlist()->get_int(SIPB_SP_RESEND_TIMEOUT);
   
   //get add parameters
   run_beforework();
   
   //work
   for (int i=0 ; i < n_send ; i++)
     {
	//Add general Information -- we start new iteration
	add_gen_info("--- Start new test iteration --- ");
	refresh_net();
	_work();
	if (check_wantstop())
	  i=n_send;
     }
}
//                                                                            
int sipbst_sendrecv::get_waitport()
{
   if (is_sr_same)
     return tr_send->get_port();
   return tr_recv->get_port();
}
//                                                                            
string sipbst_sendrecv::get_waitif()
{
   if (is_sr_same)
     return tr_send->get_if();
   return tr_recv->get_if();
}
//                                                                            
bool sipbst_sendrecv::send_recv(sipb_stpacket* tosend,sipb_stpacket* torecv)
{
   //TODO: then TCP(broken) may be we need rebin tr_send!!!
   
   //choose transport for recive (write to tmp_recv)
   sipb_transport* tmp_recv=tr_recv;
   if (is_sr_same)
     tmp_recv=tr_send; //only for TCP
   int tr=0;          //number of resend (try)
   while ( tr <= n_resend )
     {
	//send packet
	if (!tr_send->send(serv_ip.ip(), serv_port() , *tosend))
	  {
	     if (tr_send->check_hungup())
	       {
		  add_gen_error("Probably server down (then send)");
		  set_wantstop();
		  return false;
	       }
	     tosend->add_error("Can't Send packet (for UDP probably packet too big)");
	     return false;
	  }
	if (!is_sr_same)  //for TCP we must broken connection
                          //(if we want to recive by tr_recv)
	                  //(we not need reset via because!!!)
	  tr_send->rebind();
	if (torecv==NULL)  //if not want recive
	  return false;
	//try recive packet
	if (tmp_recv->recv(serv_ip.ip(),serv_port(),*torecv,
			   resend_timeout))
	  return true;
	if (tmp_recv->check_hungup() || tr_send->check_hungup())
	  {
	     add_gen_error("Probably server down (then recv)");
	     set_wantstop();
	     return false;
	  }
	tr++;
     }
   return false;
}
//                                                                           
bool sipbst_sendrecv::recv(sipb_stpacket* torecv)
{
   if (!torecv)
     return false;
   sipb_transport* tmp_recv=tr_recv;
   if (is_sr_same)
     tmp_recv=tr_send; //only for TCP
   //try recive packet
   if (tmp_recv->recv(serv_ip.ip(),serv_port(),*torecv,
		      resend_timeout))
     return true;
   if (tmp_recv->check_hungup())
     {
	add_gen_error("Probably server down (then recv)");
	set_wantstop();
	return false;
     }
   return false;
}
//                                                                           
bool sipbst_sendrecv::send(sipb_stpacket* tosend)
{
   if (!tr_send->send(serv_ip.ip(), serv_port() , *tosend))
     {
	if (tr_send->check_hungup())
	  {
	     add_gen_error("Probably server down (then send)");
	     set_wantstop();
	     return false;
	  }
	tosend->add_error("Can't Send packet (for UDP probably packet too big)");
	return false;
     }
   return true;
}
//                                                                           
void sipbst_sendrecv::refresh_net()
{
   delete tr_send;
   delete tr_recv;
   is_sr_same=false;
   string transport_now=transport;
   if (transport_now==SIPB_TRANS_ANY)
     {
	if (random()%2)
	  transport_now=SIPB_TRANS_UDP;
	else
	  transport_now=SIPB_TRANS_TCP_RANDOM;
     }
   if (transport_now==SIPB_TRANS_TCP_RANDOM)
     {
	if (random()%2)
	  transport_now=SIPB_TRANS_TCP;
	else
	  transport_now=SIPB_TRANS_TCP_BROKEN;
     }
   if (transport_now==SIPB_TRANS_UDP)
     {
	is_sr_same=false;
	tr_send=new sipb_udptrans;
	tr_recv=new sipb_udptrans;
     }
   else if (transport_now==SIPB_TRANS_TCP)
     {
	is_sr_same=true;
	tr_send=new sipb_tcptrans;
	tr_recv=new sipb_tcptrans;
     }
   else if (transport_now==SIPB_TRANS_TCP_BROKEN)
     {
	is_sr_same=false;
	tr_send=new sipb_tcptrans;
	tr_recv=new sipb_tcptrans;
     }
   else 
     qFatal("sipbst_sendrecv::refresh_net: logic Error bad transport=%s",transport_now.c_str());
}
//                                                                           
int sipbst_sendrecv::serv_port()
{
   if (sipb_bnftools::casecmp(tr_send->get_if(),"udp"))
     return udp_port;
   if (sipb_bnftools::casecmp(tr_send->get_if(),"tcp"))
     return tcp_port;
   throw logic_error("Error in sipbst_sendrecv::serv_port");
}
//                                                                           
