# httpd.rs - Windows HTTP Plugin Written By Narrow (nss@privacyx.com)

push @wplugins, 'win_httpd';
push @wplugins, 'win_h8080';

sub win_h8080 {
$httpd_host = shift;
&win_httpd($httpd_host, 8080);
}

sub win_httpd {
$httpd_host = shift;
$httpd_port = shift;
$httpd_port = 80 if (!$httpd_port); 
if($debug) { print "Checking for httpd:$httpd_port ...\n"; }
$server="";
$SIG{"ALRM"} = sub { close sock; return 0; };
alarm($time_con);
$iaddr = inet_aton($httpd_host) || return 0;
$paddr = sockaddr_in($httpd_port, $iaddr);
$proto = getprotobyname('tcp');
socket(sock, PF_INET, SOCK_STREAM, $proto) || return 0;
connect(sock, $paddr) || return 0;
send(sock, "HEAD / HTTP/1.0\r\nConnection: close\r\n\r\n", 0);

while(<sock>) {
    if (/^Server: (.*)/) {
	$server=$1;
	close sock;
    }
}
close sock; chomp $server;
if(!$server) { return; }
$_=$server;
    if(/microsoft-iis/i && /([1-4]).0/) {
	print "[$httpd_host] - [Microsoft-IIS $1.0]\n";
	print LOG "[$httpd_host] - [Microsoft-IIS $1.0]\n";
	return;
    }
    if(/vqserver/i) {
	print "[$httpd_host] - [VqServer]\n";
	print LOG "[$httpd_host] - [VqServer]\n";
	return;
    }
    if(/alibaba/i && /([2-3]).0/) {
	print "[$httpd_host] - [Alibaba $1.0]\n";
	print LOG "[$httpd_host] - [Alibaba $1.0]\n";
	return;
    }
    # Check out http://www.legion2000.cc/ (Under "INFO") for
    # more information ...
    if(/jweb/i && /1.([0-5])/) {
	print "[$httpd_host] - [JWeb 1.$1]\n";
	print LOG "[$httpd_host] - [JWeb 1.$1]\n";
	return;
    }
    if(/falcon/i && /1.0.0.1006/) {
	print "[$httpd_host] - [Falcon Web Server 1.0.0.1006]\n";
	print LOG "[$httpd_host] - [Falcon Web Server 1.0.0.1006]\n";
	return;
    }
    if(/url live/i && /1.0/) {
	print "[$httpd_host] - [URL Live! 1.0]\n";
	print LOG "[$httpd_host] - [URL Live! 1.0]\n";
	return;
    }
    if(/thttpd/i && /2.04/) {
	print "[$httpd_host] - [THTTPD 2.04]\n";
	print LOG "[$httpd_host] - [THTTPD 2.04]\n";
	return;
    }
    if(/eserv/i && /2.50/) {
	print "[$httpd_host] - [EServ 2.50]\n";
	print LOG "[$httpd_host] - [EServ 2.50]\n";
	return;
    }
    if(/sambar/i && /4.2.1/) {
	print "[$httpd_host] - [Sambar 4.2.1]\n";
	print LOG "[$httpd_host] - [Sambar 4.2.1]\n";
	return;
    }
    if(/zbserver/i && /1.5/) {
	print "[$httpd_host] - [ZBServer 1.5]\n";
	print LOG "[$httpd_host] - [ZBServer 1.5]\n";
	return;
    }
    if(/savant/i && /2.0/) {
	print "[$httpd_host] - [Savant Web Server 2.0]\n";
	print LOG "[$httpd_host] - [Savant Web Server 2.0]\n";
	return;
    }
    if(/camshot webcam/i && /2.5/) {
	print "[$httpd_host] - [CamShot WebCam 2.5]\n";
	print LOG "[$httpd_host] - [CamShot WebCam 2.5]\n";
	return;
    }
    if(/fasttrack/i && /3.01/) {
	print "[$httpd_host] - [Netscape FastTrack 3.01]\n";
	print LOG "[$httpd_host] - [Netscape FastTrack 3.01]\n";
	return;
    }
    if(/websitepro/i && /2.3.18/) {
	print "[$httpd_host] - [WebSitePro 2.3.18]\n";
	print LOG "[$httpd_host] - [WebSitePro 2.3.18]\n";
	return;
    }
    if(/websuite/i && /2.1/) {
	print "[$httpd_host] - [WebSuite 2.1]\n";
	print LOG "[$httpd_host] - [WebSuite 2.1]\n";
	return;
    }
    if(/netscape enterprise/i && /3.6/) {
	print "[$httpd_host] - [Netscape Enterprise 3.6]\n";
	print LOG "[$httpd_host] - [Netscape Enterprise 3.6]\n";
	return ;
    }
} print;