/* $Id: respond.c,v 1.5 2000/03/16 02:58:44 roesch Exp $ */
/*
** Copyright (C) 1998,1999,2000 Martin Roesch <roesch@clark.net>
** Copyright (C) 1999,2000 Christian Lademann <cal@zls.de>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* $Id: respond.c,v 1.5 2000/03/16 02:58:44 roesch Exp $ */

/*
** CREDITS:
**
** The functionality presented here was inspired by
** the program "couic" by Michel Arboi <arboi@bigfoot.com>
**
*/


#ifdef ENABLE_RESPONSE

    #include <libnet.h>
    #include "respond.h"

extern OptTreeNode *otn_tmp; /* global ptr to current rule data */

int SendICMP_UNREACH(int, u_long, u_long, Packet *);
int SendTCPRST(u_long, u_long, u_short, u_short, int, int);


/****************************************************************************

 *
 * Function: Respond(Packet *p)
 *
 * Purpose: Respond to hostile connection attempts
 *
 * Arguments:
 *
 * Returns: void function
 *
 ***************************************************************************/

void Respond(Packet *p)
{
    if (otn_tmp && otn_tmp->response_flag)
    {
        if (otn_tmp->response_flag & (RESP_RST_SND | RESP_RST_RCV))
        {
            if (p->iph->ip_proto == IPPROTO_TCP)
            {
                int i;

                for (i = 0; i < 5; i++)
                {
                    if (otn_tmp->response_flag & RESP_RST_SND)
                        SendTCPRST(p->iph->ip_dst.s_addr, p->iph->ip_src.s_addr,
                                   p->tcph->th_dport, p->tcph->th_sport,
                                   p->tcph->th_ack, p->tcph->th_seq + i);

                    if (otn_tmp->response_flag & RESP_RST_RCV)
                        SendTCPRST(p->iph->ip_src.s_addr, p->iph->ip_dst.s_addr,
                                   p->tcph->th_sport, p->tcph->th_dport,
                                   p->tcph->th_seq, p->tcph->th_ack + i);
                }
            }
        }

        if (otn_tmp->response_flag & RESP_BAD_NET)
            SendICMP_UNREACH(ICMP_UNREACH_NET, p->iph->ip_dst.s_addr,
                             p->iph->ip_src.s_addr, p);

        if (otn_tmp->response_flag & RESP_BAD_HOST)
            SendICMP_UNREACH(ICMP_UNREACH_HOST, p->iph->ip_dst.s_addr,
                             p->iph->ip_src.s_addr, p);

        if (otn_tmp->response_flag & RESP_BAD_PORT)
            SendICMP_UNREACH(ICMP_UNREACH_PORT, p->iph->ip_dst.s_addr,
                             p->iph->ip_src.s_addr, p);
    }
    return;
}


int SendICMP_UNREACH(int type, u_long saddr, u_long daddr, Packet *p)
{
    u_char *buf;
    int data_sz, addt_sz, sz;


    if (! p)
        return(-1);

    data_sz = (p->dsize > 8 ? 8 : p->dsize);
    addt_sz = ntohs(p->iph->ip_len) + data_sz;
    sz = IP_H + ICMP_UNREACH_H + addt_sz;

    if (libnet_init_packet(sz, &buf) < 0)
    {
        libnet_error(LIBNET_ERR_CRITICAL, "SendICMP_UNREACH: libnet_init_packet");
        return -1;
    }

    memset(buf, 0, sz);

    libnet_build_ip(ICMP_UNREACH_H + addt_sz, 0xF4,
                    libnet_get_prand(PRu16) /* IP ID */,
                    0 /* fragmentation */, 64 /* TTL */, IPPROTO_ICMP,
                    saddr, daddr, NULL, 0, buf);

    libnet_build_icmp_unreach(ICMP_UNREACH, type,
                              p->iph->ip_len, p->iph->ip_tos, p->iph->ip_id,
                              p->iph->ip_off, p->iph->ip_ttl, p->iph->ip_proto,
                              p->iph->ip_src.s_addr, p->iph->ip_dst.s_addr,
                              p->data, data_sz,
                              buf + IP_H);

    libnet_do_checksum(buf, IPPROTO_ICMP, sz - IP_H);

    if (libnet_write_ip(nd, buf, sz) < sz)
    {
        libnet_error(LIBNET_ERR_CRITICAL, "SendICMP_UNREACH: libnet_write_ip");
        return -1;
    }

    return 0;
}


int SendTCPRST(u_long saddr, u_long daddr, u_short sport, u_short dport, int seq, int ack)
{
    u_char *buf;
    int sz = IP_H + TCP_H;


    if ((buf = malloc(sz)) == NULL)
    {
        perror("SendTCPRST: malloc");
        return -1;
    }

    memset(buf, 0, sz);

    libnet_build_ip(TCP_H, 0xF4,
                    libnet_get_prand(PRu16) /* IP ID */,
                    0 /* fragmentation */, 64 /* TTL */, IPPROTO_TCP,
                    saddr, daddr, NULL, 0, buf);

    libnet_build_tcp(ntohs(sport), ntohs(dport), ntohl(seq), ntohl(ack),
                     TH_RST, 1024, 0, NULL, 0, buf + IP_H);


    libnet_do_checksum(buf, IPPROTO_TCP, sz - IP_H);
    if (libnet_write_ip(nd, buf, sz) < sz)
    {
        libnet_error(LIBNET_ERR_CRITICAL, "SendTCPRST: libnet_write_ip");
        return -1;
    }

    libnet_destroy_packet(&buf);
    return 0;
}

#endif
