/*
** Copyright (C) 2000 Jed Pickel <jed@pickel.net> <jpickel@cert.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* $Id */

/* This file gets included in plugbase.h when it is integrated into the rest 
 * of the program.  Sometime in The Future, I'll whip up a bad ass Perl script
 * to handle automatically loading all the required info into the plugbase.*
 * files.
 */
#include "snort.h"
#ifdef ENABLE_POSTGRESQL
    #include <libpq-fe.h>

    #ifndef __SPO_LOG_POSTGRESQL_H__
        #define __SPO_LOG_POSTGRESQL_H__

PGconn     *conn;
PGresult   *res;
char       *dbString;
char       *dsn;
int        sensor_id;

/* some constants */
        #define MAX_QUERY_LENGTH 600
        #define QUERY_FAILED "query failed\n"

/* list of function prototypes for this preprocessor */
void SetupLogPostgresql();
void LogPostgresqlInit(u_char *);
void ParsePostgresqlArgs(char *);
void LogPostgresql(Packet *, char *);
void InitPostgresqlDB();
int CleanExec();

    #endif
#endif  /* __SPO_LOG_POSTGRESQL_H__ */
