
/*
	VoIPong Voice Over IP Sniffer
	Copyright (C) 2004 Murat Balaban <murat || enderunix.org>
	All rights reserved.

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <netdb.h>
#include <syslog.h>
#include <pthread.h>
#include <errno.h>
#include <signal.h>
#include <pwd.h>
#include <fcntl.h>

#include <miscutil.h>
#include <conf.h>
#include <voipongmgmt.h>
#include <voipong.h>
#include <voipongsock.h>
#include <voipongrtp.h>
#include <voipongrtcp.h>

#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/resource.h>
#include <sys/param.h>

#include <netinet/in.h>

extern config cfg;
extern int gdbg;
extern time_t gstarttime;
extern char gcfgfile[];
extern char gmgmt_password[];
extern rtp_session *rtps;

static int mgmtfd = -1;
static int mgmtconnected = 0;
static int authok = 0;
static int passtries = 0;
static FILE *fp;
static char prevline[1024];

static void 
uptime()
{
	char str[512];

	fprintf(fp, "Up %s\n", misc_getuptimestr(str, 512, gstarttime));
}

static void
checkpass(char *line)
{
	char password[128];

	if (strlen(line) < 6 || memcmp(line, "pass", 4) != 0) {
		fprintf(fp, "please identify yourself. use pass command to enter management password, carefull for shoulder-sniffers!\n");
		return;
	}
	strncpy(password, line + 5, 127);
	if (strncmp(password, gmgmt_password, 128) == 0) {
		authok = 1;
		fprintf(fp, "login successfull\n");
		misc_debug(0, "voipongmgmt: MANAGEMENT SESSION OPENED !!!\n");
	}
	else {
		fprintf(fp, "invalid password\n");
		if (++passtries > MGMTMAXPASSTRIES) {
			misc_debug(0, "voipongmgmt: WARNING! too many authentication failures!!!\n");
			close_mgmt_client();
		}
	}
}

static void 
help()
{
	fprintf(fp, "Commands:\n");
	fprintf(fp, "help                  : this one\n");
	fprintf(fp, "quit                  : quit management console\n");
	fprintf(fp, "logrotate             : rotate server's logs\n");
	fprintf(fp, "shutdown              : shutdown server\n");
	fprintf(fp, "rusage                : CPU usage statistics for the server\n");
	fprintf(fp, "info                  : General server information\n");
	fprintf(fp, "uptime                : Server uptime\n");
	fprintf(fp, "calllist              : Show currently monitored calls\n");
	fprintf(fp, "killsession [id]      : end monitoring session with [id]\n");
	fflush(fp);
}

static void
cagriliste()
{
	rtp_session *rtp;
	int i = 0;
	char tstr[64];
	time_t now;

	fprintf(fp, "ID      NODE1                     NODE2                     STRT. TIME.         DURATION\n");
	fprintf(fp, "------- ------------------------- ------------------------- ------------------- ------------------\n");

	time(&now);
	for (rtp = rtps; rtp != NULL; rtp = rtp->next, i++) {
		misc_strftimegiven(tstr, sizeof(tstr) - 1, "%d/%m/%y %H:%M:%S", rtp->stime);
		fprintf(fp, "%7d %s:%d %s:%d %s %d seconds\n", rtp->pid, misc_inet_ntoa(rtp->ip1), ntohs(rtp->port1),
				misc_inet_ntoa(rtp->ip2), ntohs(rtp->port2),
				tstr, (now - (int)rtp->stime)
				);
	}
	fprintf(fp, "Total listed: %d\n", i);
}

static void 
info()
{
	struct passwd *pwd;
	char tmp[512];

	fprintf(fp, "General Server Info:\n");
	fprintf(fp, "--------------------------:\n");
	fprintf(fp, "Server version            : %s\n", VERSION);
	fprintf(fp, "System                    : %s\n", misc_getunamestr(tmp, 512));
	getcwd(tmp, 512);
	fprintf(fp, "Current work. direct.     : %s\n", tmp);
	fprintf(fp, "Log level                 : %d\n", gdbg);
	fprintf(fp, "Process ID (PID)          : %d\n", getpid());
	pwd = getpwuid(getuid());
	fprintf(fp, "User                      : %s [%s]\n", pwd->pw_name, pwd->pw_gecos);
	fprintf(fp, "Group                     : %d\n", pwd->pw_gid);

}

int 
rusage()
{
	struct rusage ru;

	if (getrusage(RUSAGE_SELF, &ru) < 0) {
		misc_debug(0, "mgmt_console: rusage error : %s\n", strerror(errno));
		fprintf(fp, "mgmt_console: rusage error : %s\n", strerror(errno));
		return -1;
	}

	fprintf(fp, "Current CPU usage stats:\n");
	fprintf(fp, "----------------------------------------\n");
	fprintf(fp, "Total  \"user\" time                  : %ld seconds\n", ru.ru_utime.tv_sec);
	fprintf(fp, "Total used \"system\" time            : %ld seconds\n", ru.ru_stime.tv_sec);
	fprintf(fp, "Shared Memory Size                    : %ld KB\n", ru.ru_ixrss);
	fprintf(fp, "Integral Memory Size                  : %ld KB\n", ru.ru_idrss);
	fprintf(fp, "Integral stack Size                   : %ld KB\n", ru.ru_isrss);
	fprintf(fp, "Page requests                         : %ld\n", ru.ru_minflt);
	fprintf(fp, "Page errors                           : %ld\n", ru.ru_majflt);
	fprintf(fp, "Block input operations                : %ld\n", ru.ru_inblock);
	fprintf(fp, "Block output operations               : %ld\n", ru.ru_oublock);
	fprintf(fp, "Messages sent                         : %ld\n", ru.ru_msgsnd);
	fprintf(fp, "Messages received                     : %ld\n", ru.ru_msgrcv);
	fprintf(fp, "Signals                               : %ld\n", ru.ru_nsignals);
	fprintf(fp, "Voluntary \"context switch\"s         : %ld\n", ru.ru_nvcsw);
	fprintf(fp, "Involuntary \"context switch\"s       : %ld\n", ru.ru_nivcsw);

	return 0;

}

int 
is_mgmt_active()
{
	return mgmtconnected;
}

int 
get_mgmt_fd()
{
	return mgmtfd;
}

void 
accept_mgmt_client(int fd)
{
	struct sockaddr_in cin;
	size_t len;
	int nsd;
	int flags;
	char tmp[512];

	len = sizeof(cin);
	memset(&cin, 0, sizeof(cin));
	if ((nsd = accept(fd, (void *)&cin, &len)) < 0) {
		misc_debug(0, "accept error: %s\n", strerror(errno));
		return;
	}
	flags = fcntl(nsd, F_GETFL, 0);
	fcntl(nsd, F_SETFL, flags | O_NONBLOCK);
	if (is_mgmt_active() == 1)
		close_mgmt_client();

	misc_debug(0, "New management console request [%s:%d] has been accepted!\n", misc_inet_ntoa(cin.sin_addr.s_addr), ntohs(cin.sin_port));
	if ((fp = fdopen(nsd, "r+")) == NULL) {
		misc_debug(0, "MGMT: fdopen: %s\n", strerror(errno));
		return;
	}
	mgmtconnected = 1;
	mgmtfd = nsd;
	add_to_select_set(mgmtfd);
	memset(prevline, 0, 1024);

	fprintf(fp, "%s Welcome to management console\r\n", PROGRAM);
	fprintf(fp, "System:  %s\r\n\r\n", misc_getunamestr(tmp, 512));
	fprintf(fp, "voipong> ");
	fflush(fp);
}

void 
process_mgmt_request()
{
	char line[1024];


	if ((fgets(line, 1023, fp)) == NULL) {
		misc_debug(0, "process_mgmt_read: fgets error: %s\n", strerror(errno));
		close_mgmt_client();
		return;
	}

	misc_trimnewline(line, strlen(line));
	if (strlen(line) == 0) {
		fprintf(fp, "voipong> ");
		fflush(fp);
		return;
	}
	if (!authok) {
		checkpass(line);
		fprintf(fp, "voipong> ");
		fflush(fp);
		return;
	}

	if (memcmp(line, "!", 1) == 0) {
		if (strlen(prevline) == 0)
			return;
		strncpy(line, prevline, 1023);
	}
	if (memcmp(line, "quit", 4) == 0) {
		fprintf(fp, "Byes...!\n\n");
		close_mgmt_client();
		return;
	} else 
	if (memcmp(line, "shutdown", 8) == 0) {
		fprintf(fp, "SHUTDOWN received!, shutting down the server!!!\n\n");
		graceful_shutdown();
		return;
	}
	if (memcmp(line, "logrotate", 9) == 0) {
		fprintf(fp, "Rotating server logs\n\n");
		if (misc_rotatelog() < 0)
			fprintf(fp, "logrotate error!\n");
		else
			fprintf(fp, "logrorate successfull!\n");
	} else
	if (memcmp(line, "help", 4) == 0) {
		help();
	} else
	if (memcmp(line, "rusage", 6) == 0) {
		rusage();
	} else
	if (memcmp(line, "info", 4) == 0) {
		info();
	} else
	if (memcmp(line, "calllist", 8) == 0) {
		cagriliste();
	} else
	if (memcmp(line, "baba", 4) == 0) {
		fprintf(fp, "\n\n\n\n\n\tVOIPONG designed and developed by:\n");
		fprintf(fp, "\n\tMurat BALABAN [murat || enderunix.org]\n");
		fprintf(fp, "\tTarih: 23/08/2004\n\n\n\n\n\n\n\n");
	}
	else
	if (memcmp(line, "uptime", 6) == 0) {
		uptime();
	}
	else {
		fprintf(fp, "HATA: error cmd: %s\n", line);
	}
	strncpy(prevline, line, 1023);
	fprintf(fp, "voipong> ");
	fflush(fp);
}


void 
close_mgmt_client()
{
	misc_debug(0, "Shutting down management console...\n");
	close(mgmtfd);
	remove_from_select_set(mgmtfd);
	mgmtconnected = 0;
	mgmtfd = -1;
	authok = 0;
	passtries = 0;
}


