
/*
	VoIPong Voice Over IP Sniffer
	Copyright (C) 2004 Murat Balaban <murat || enderunix.org>
	All rights reserved.

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <netdb.h>
#include <syslog.h>
#include <pthread.h>
#include <errno.h>
#include <signal.h>
#include <fcntl.h>

#include <voipongsock.h>
#include <voipongmgmt.h>
#include <miscutil.h>
#include <conf.h>

#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>

#include <netinet/in.h>

extern config conf;
extern int pcapfd, mgmtfd;

static fd_set allset;

void
initsock()
{
	FD_ZERO(&allset);
}

void
add_to_select_set(int sd)
{
	FD_SET(sd, &allset);
}

void
remove_from_select_set(int sd)
{
	FD_CLR(sd, &allset);
}

int
getmaxfd()
{
	int maxfd;
	int mfd = get_mgmt_fd();

	if (mgmtfd > pcapfd)
		maxfd =  mgmtfd;
	else
		maxfd = pcapfd;

	if (mfd > maxfd)
		return mfd;
	else
		return maxfd;
}

int 
open_server_socket(int port, int *lsnfd)
{
	struct sockaddr_in sin;
	int flags;
	int optval = 1;

	memset(&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = htonl(INADDR_ANY);
	sin.sin_port = htons(port);

	if ((*lsnfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		misc_debug(0, "cannot create server socket: %s\n", strerror(errno));
		return -1;
	}

	if (setsockopt(*lsnfd, SOL_SOCKET, SO_REUSEADDR, &optval, sizeof(optval)) == -1) {
		misc_debug(0, "cannot set SO_REUSEADDR socket option: %s\n", strerror(errno));
		return -1;
	}
	
	/* Set socket mode non-blocking	*/
	flags = fcntl(*lsnfd, F_GETFL, 0);
	fcntl(*lsnfd, F_SETFL, flags | O_NONBLOCK);

	if (bind(*lsnfd, (void *)&sin, sizeof(sin)) < 0) {
		misc_debug(0, "cannot bind to server port %d: %s\n", port, strerror(errno));
		return -1;
	}

	if (listen(*lsnfd, 128) < 0) {
		misc_debug(0, "cannot listen on server port %d: %s\n", port, strerror(errno));
		return -1;
	}
	add_to_select_set(*lsnfd);
	return 0;
}

void 
sockets_run(void)
{
	fd_set rset;
	struct timeval tv;
	int nready;
	
	tv.tv_sec = 1;
	tv.tv_usec = 0;

	for ( ; ; ) {
		rset = allset;
		if ((nready = select(getmaxfd() + 1, &rset, NULL, NULL, &tv)) < 0) {
			misc_debug(0, "select: %s\n", strerror(errno));
			continue;
		}
		if (FD_ISSET(mgmtfd, &rset)) {
			accept_mgmt_client(mgmtfd);
			nready--;
		}

		if (nready > 0 && FD_ISSET(pcapfd, &rset)) {
			peekpcap();
			nready--;
		}

		if (nready > 0 && is_mgmt_active()) {
			if (FD_ISSET(get_mgmt_fd(), &rset)) {
				process_mgmt_request();
				nready--;
			}
		}
	}
}

