/*
 * This module contains the critical algorithm and secret key
 * used by British Sky Broadcasting in their Videocrypt pay-TV
 * chip card in 1994 and 1995. It is expected that most
 * information in this file becomes obsolete when the next card
 * generation (0a) is activated.
 */

#include "decrypt.h"
#include "rompages.h"


#define bit int

extern unsigned char indata[];      // input, 32-byte message
extern unsigned char outdata[];     // output, answer to 32-byte message

/*
 * the secret key -- for your eyes only :-)     07-series
 */
/*
const unsigned char key[56] = {
  0x65, 0xe7, 0x71, 0x1a, 0xb4, 0x88, 0xd7, 0x76,
  0x28, 0xd0, 0x4c, 0x6e, 0x86, 0x8c, 0xc8, 0x43,
  0xa9, 0xec, 0x60, 0x42, 0x05, 0xf2, 0x3d, 0x1c,
  0x6c, 0xbc, 0xaf, 0xc3, 0x2b, 0xb5, 0xdc, 0x90,
  0xf9, 0x05, 0xea, 0x51, 0x46, 0x9d, 0xe2, 0x60,
  0x70, 0x52, 0x67, 0x26, 0x61, 0x49, 0x42, 0x09,
  0x50, 0x99, 0x90, 0xa2, 0x36, 0x0e, 0xfd, 0x39
};
*/

unsigned char oi;
extern unsigned char last_nano, last_subnano;
extern char screenbuf[];

/***********************************************************************
*                                                                      *
*      03  decode                      parent = 01  main               *
*                                                                      *
***********************************************************************/
int decode ( void )
{
extern unsigned char mod08;
extern unsigned char mod81;
extern unsigned char mod83;
extern unsigned char modaa;
extern unsigned char mod7e;
extern unsigned char modfe;

unsigned char nanos[0x0f];
unsigned char nano;
unsigned char card_command;
unsigned int i, j;
unsigned int check = 0;
unsigned int rom_page = 1;
unsigned char b = 0;
unsigned char eedta, ee_offset;
bit done;
bit doit;
unsigned char xx, akk, xre;
unsigned int eepoint;

eepoint=0;
ee_offset=0;
xx = 0;
rom_page = 1;

for (i = 0; i < 8; i++) outdata[i] = 0;
for (i = 0; i < 0x10; i++) nanos[i] = 0;
oi = 0;

for (i = 0; i < 0x0c; i++) kernel_b (indata[i]);

xx = indata[1] ^ indata[2];
xx = (xx>>4) | (xx<<4);
b = indata[2];

for (i = 0; i < 4; i++)
  {
  b = (b<<1) | (b>>7);
  nanos[i] = xx + b;
  b = nanos[i];
  }

card_command = nanos[0] ^ indata[3];

xx = nanos[2];
for (i = 0; i < 0x0f; i++)
  {
  nanos[i] = xx ^ indata[i+0x0c];
  kernel_b (indata[i+0x0c]);
  }

xx = 0;
check = 0;
for (i = 0x1b; i < 0x1f; i++)              // signature  
  {
  kernel_b (xx);
  kernel_b (xx);
  xx = indata[i];
  if (outdata[7] != xx) check |= 1;
  }

xx = indata[0x1f];

if (card_command == 0x80)
  {
  // send("\x60", 1);          // that takes time, so send "wait"

  xx=0;
  i=0;
  done = 0;
  do                           // process nano commands and subcommands
    {
    nano = nanos[xx];
    doit = 1;
    switch ( nano )
      {
      case 0x03:
        FastPrintf(21,60, 4,"03");
        akk = xx;
        xre = 0x03;
        doit = 0;
        done = 1;
        break;
        
      case 0x09:
        FastPrintf(21,60, 4,"09");
        eepoint = (nanos[xx+1])*0x100 + nanos[xx+2];
        akk = 0x63;
        xre = 0x00;
        xx += 3;
        break;
        
      case 0x11:
        FastPrintf(21,60, 4,"11");
        eepoint = (nanos[xx+2]*0x100) + (nanos[xx+3]);
        eedta = nanos[xx+1];
        switch (eepoint)
          {
          case 0x08:                           // 17.5.1995
            FastPrintf(21,63, 4,"08");
            mod08 = eedta;
            if (mod08==0xc0) rom_page=2;
            if (mod08==0x40) rom_page=1;
            // break;

          case 0x81: 
            // FastPrintf(21,63, 4,"81");
            eedta &= 0xb7;
            eedta |= 0x40;
            mod81 = eedta;
            break;
           
          case 0xaa:
            FastPrintf(21,63, 4,"aa");
            modaa = eedta;
            break;

          case 0xfe:
            FastPrintf(21,63, 4,"fe");
            modfe = eedta;
            break;

          default:
            sprintf(screenbuf,"%02x",eepoint);
            FastPrintf(21,63, 4,screenbuf);
            // if (indata[0]&8)
            //   last_subnano=eepoint;        // for display purposes
            break;
          } /* end switch eepoint */
        
        akk = eedta;
        xre = 0x00;
        xx += 4;
        break;

      case 0x19:
        FastPrintf(21,60, 4,"19");
        akk = xx;
        xre = 0x19;
        xx += 1;
        break;
        
      case 0x28:
        FastPrintf(21,60, 4,"28");
        akk = nanos[xx+4];
        xre = xx;
        xx += 5;
        break;

      case 0x30:
        FastPrintf(21,60, 4,"30");
        ee_offset=nanos[xx+1];
        do
          {
          if (rom_page==1)                               // 17.5.95       
            eedta = ext_ee[eepoint+ee_offset];
           else
            eedta = ext_ee2[eepoint+ee_offset];

          if (eepoint+ee_offset == 0x08) eedta = mod08;  // 17.5.95
           else
          if (eepoint+ee_offset == 0x81) eedta = mod81;
           else
          if (eepoint+ee_offset == 0x83) eedta = mod83;
           else
          if (eepoint+ee_offset == 0xaa) eedta = modaa;
           else
          if (eepoint+ee_offset == 0x7e) eedta = modfe;  // 7.4.95
           else
          if (eepoint+ee_offset == 0xfe) eedta = modfe;  // 7.4.95
          
          kernel_b(eedta);
          } while ( --ee_offset < 0x80 );  // this is the vampire hack i think
        
        akk = eedta;
        xre = ee_offset;
        xx += 2;
        break;

      case 0x39:
        FastPrintf(21,60, 4,"39");
        akk = nanos[xx+1];
        xre = 0x00;
        xx += 2;
        break;

      case 0x46:                                 // this is the break command
        FastPrintf(21,60, 4,"46");
        outdata[7] &= 0x7f;
        if ((check & 1) == 0)   return check;    // all fine ...
        for (i = 0; i < 8; i++) outdata[i] = 0;  // indicate error ...
        outdata[0]=1;
        return check;

      default:
        sprintf(screenbuf,"%02x",nano);
        FastPrintf(21,60, 4,screenbuf);
        akk = 0x00;
        xre = 0x00;
        xx += 1;
        done = 1;
        doit = 0;
        break;
      } /* end - switch (nano) */
    if ( doit )
      {
      kernel_b(akk);
      kernel_b(xre);
      }
    } while ( (xx<=0x0f) && !done ); /* end do while */
  } /* end - if (card_command == 0x80 ) */
  
// last iteration 64 times
if ( indata[0] & 8 == 0 ) return check;    // speed up if no key necc.

for ( i = 0 ; i < 0x40 ; i++ ) kernel_b(xx);
outdata[7] &= 0x7F;            // only 60 bits in answer needed, blank out
                               // last nibble

// test checksum of datastream
b = 0;
for (i = 0; i < 0x20; i++) b += indata[i];
if (b != 0) check |= 2;

if ((check & 1) == 0)   return check;      // all fine ...

for (i = 0; i < 8; i++) outdata[i] = 0;    // else prepare answer ...
outdata[0]=1;

return check;
}

/***********************************************************************
*                                                                      *
*      05  kernel_b                    parent = 03  decode             *
*                                                                      *
*                                                                      *
*      This is the core function of the decryption algorithm           *
*      which is iterated 99 times by decode(). This code assumes that  *
*      unsigned char is exactly 8-bit long.                            *
*                                                                      *
***********************************************************************/
void kernel_b( unsigned char in )
{
unsigned char a, b, c, d, i;
unsigned int m;


if ( indata[0] & 8 == 0 ) return;      // speed up

a = in;
for (i = 0; i <= 4; i += 2)
  {
  b = outdata[i] & 0x3f;
  if (indata[0] <= 8 )
    {
    if (indata[0] == 2)
      {
      b = ext_ee[0x06e9 + b];
      }
     else
      {
      if (indata[0] < 2 && b == 0) 
        b = ext_ee[0x0736 + b];
       else
        b =  ext_ee[0x6a9 + b] ^ ext_ee[0x0741 + b];
      }
    }
   else
    {
    b =  ext_ee[0x6a9 + b] ^ ext_ee[0x0741 + b];
    }

  c = a + b - outdata[i+1];
  d = (outdata[i] - outdata[i+1]) ^ a;
  m = d * c;
  outdata[i + 2] ^= (m & 0xff);
  outdata[i + 3] += m >> 8;
  a = (a << 1) | (a >> 7);
  a += 0x49;
  } /* end for i */

m = outdata[6] * outdata[7];
a = (m & 0xff) + outdata[0];
if (a < outdata[0]) a++;
outdata[0] = a + 0x39;
a = (m >> 8) + outdata[1];
if (a < outdata[1]) a++;
outdata[1] = a + 0x8f;
oi = 7;

return;
}

