
#include "crc32.h"
#include <commdlg.h>
#include <dlgs.h>

#define IDM_FILEOPEN 1
#define IDM_EXIT 2
#define IDM_ABOUT 3
LONG APIENTRY WndProc( HWND hWnd, UINT message, UINT wParam, LONG lParam);
BOOL GetFileCRC( HWND hWnd);

HINSTANCE g_hInst;
 
int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow )
{

    MSG msg;                         
    WNDCLASS wc;
    HWND hWnd;              

    g_hInst = hInstance;

    // Usual Windows mumbo-jumbo.
    wc.style = 0;
    wc.lpfnWndProc = (WNDPROC)WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(1));
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH); 
    wc.lpszMenuName =  MAKEINTRESOURCE(1);
    wc.lpszClassName = "FileCRC32WClass";

    if (!RegisterClass(&wc))
		return (0);	// Create the main window.

    // Create a window. 
    hWnd = CreateWindow(
        "FileCRC32WClass",
        "CRC-32 Sample Application",
        WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        NULL,
        NULL,
        g_hInst,
        NULL
    );

    if (!hWnd)
        return (0);

    ShowWindow(hWnd, nCmdShow);  
    UpdateWindow(hWnd);          
           
    while (GetMessage(&msg,NULL,0,0))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    return (msg.wParam);
}


LONG APIENTRY WndProc( HWND hWnd, UINT message, UINT wParam, LONG lParam)
{

    switch (message) {
        case WM_COMMAND:
            switch( LOWORD( wParam ))
            {
                case IDM_FILEOPEN:
                    GetFileCRC(hWnd);
                    break;

                case IDM_EXIT:
                    PostQuitMessage(0);
                    break;

                case IDM_ABOUT:
                    AboutCrc32(hWnd);
                    break;

                default:
                    return (DefWindowProc(hWnd, message, wParam, lParam));

            }
            break;

        case WM_DESTROY:
            PostQuitMessage(0);
            break;


        default:
            return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (0);
}


BOOL GetFileCRC( HWND hWnd)
{
    HANDLE hFile;
    DWORD dwBytesRead;
	DWORD dwFileSize;
	OPENFILENAME ofn;
	TCHAR         szFile[MAX_PATH]      = "\0";
	char *lpBufPtr;
	TCHAR	szCrc[120];

    *szFile = 0;

	ofn.lStructSize       = sizeof(OPENFILENAME);
    ofn.hwndOwner         = hWnd;
    ofn.hInstance         = g_hInst;
    ofn.lpstrFilter       = NULL;
    ofn.lpstrCustomFilter = NULL;
    ofn.nMaxCustFilter    = 0;
    ofn.nFilterIndex      = 0;
    ofn.lpstrFile         = szFile;
    ofn.nMaxFile          = sizeof(szFile);
    ofn.lpstrFileTitle    = NULL;
    ofn.nMaxFileTitle     = 0;
    ofn.lpstrInitialDir   = NULL;
    ofn.lpstrTitle        = "Open a File";
    ofn.nFileOffset       = 0;
    ofn.nFileExtension    = 0;
    ofn.lpstrDefExt       = NULL;
    ofn.lCustData         = 0L;
	ofn.lpfnHook 		   = NULL; 
	ofn.lpTemplateName    = NULL;
    ofn.Flags             = 0;

    if (GetOpenFileName(&ofn))
    {
		// Open the file.
		if ((hFile = CreateFile((LPCTSTR)ofn.lpstrFile,
			GENERIC_READ,
			FILE_SHARE_READ,
			NULL,
			OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL,
			(HANDLE)NULL)) == (HANDLE)-1)
		{
	    	MessageBox( hWnd, "Can't open file.", NULL, MB_OK );
	    	return FALSE;
		}

		// Get the size of the file.
		dwFileSize = GetFileSize(hFile, NULL);
		if (dwFileSize == 0xFFFFFFFF)
		{
	    	MessageBox( NULL, "Can't get file size.", NULL, MB_OK);
	    	return FALSE;
		}

		// Allocate a buffer.
		lpBufPtr = (char *)GlobalAlloc( GMEM_FIXED, dwFileSize );
		if (lpBufPtr == NULL)
		{
	    	MessageBox( NULL, "Not enough memory.", NULL, MB_OK);
	    	CloseHandle( hFile );
	    	return FALSE;
		}

		// Read file into a buffer.
		ReadFile(hFile,(LPVOID)lpBufPtr, dwFileSize, &dwBytesRead, NULL);

		if (dwBytesRead == 0)
		{
	    	MessageBox( hWnd, "Couldn't read file.", NULL, MB_OK );
	    		return FALSE;
		}

        // Calculate CRC32.
                wsprintf(szCrc, "The CRC-32 of %s is %X.", ofn.lpstrFile, ArrayCrc32((BYTE*)lpBufPtr, dwBytesRead));
		MessageBox(hWnd, szCrc, "File CRC-32", MB_OK);

		// Release buffer.
                GlobalFree(lpBufPtr);

		// Close the file.
		CloseHandle(hFile);

		return TRUE;
    }
    else
	return FALSE;	
}
