;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; CRCDEMO.EXE
;;
;; This simple program demonstrates how to use CRC32.DLL
;;
;; Copyright (c) 1997 G. Adam Stanislav
;; All rights reserved.
;;
;; e-mail: whizkid@bigfoot.com
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; This is essentially a useless program. All it does is calculate CRC-32
;; of the text string "Windows 95" and displays the result. Then it does
;; the same with another string.
;;
;; Its purpose is to illustrate how to create DLLs for Windows 95 and NT
;; in assembly language, and how to access those (or any) DLLs from
;; assembly language programs.
;;
;; The companion file CRC32.ASM contains the code for CRC32.DLL, a
;; Windows95/NT DLL which calculates CRC-32 values.
;;
;; This file, CRCDEMO.ASM, contains the code for a simple program that
;; shows how to access the routines in CRC32.DLL.
;;
;; And of course, there is MAKEFILE which explains how the DLL and EXE are
;; built from their source code.
;;
;; Both ASM files need to be assembled with Microsoft MASM, version 6.1
;; or (presumably) later.
;;
;; I have created these two files for educational purposes. Assembly
;; language has always been my prefered language in DOS programming.
;; When the world switched to Windows, there was essentially no information
;; available how to create Windows programs in assembly language.
;;
;; Luckily for me, other programmers were willing to share their knowledge
;; with me and provided sample source code. This is my attempt in helping
;; yet others understand how to write Windows 95/NT programs in assembly
;; language.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.386
.model flat
option prologue:none
option epilogue:none
MB_OK			EQU	000h
MB_OKCANCEL		EQU	001h
MB_ABORTRETRYIGNORE	EQU	002h
MB_YESNOCANCEL		EQU	003h
MB_YESNO		EQU	004h
MB_RETRYCANCEL		EQU	005h
MB_ICONERROR		EQU	010h
MB_ICONQUESTION         EQU     020h
MB_ICONWARNING		EQU	030h
MB_ICONINFORMATION      EQU     040h

IDOK			EQU	01h
IDCANCEL		EQU	02h
IDABORT			EQU	03h
IDRETRY			EQU	04h
IDIGNORE		EQU	05h
IDYES			EQU	06h
IDNO			EQU	07h
IDCLOSE			EQU	08h
IDHELP			EQU	09h

extern __imp__MessageBoxA@16:dword
extern __imp_crc32:dword
extern __imp_initcrc32:dword
extern __imp_finishcrc32:dword
extern __imp_arraycrc32:dword
extern __imp_partialcrc32:dword
extern __imp_aboutcrc32:dword

COMMENT %

        What is this "__imp_" stuff and why bother with it??

        All the sample Win95 assembly language programs I have seen
        (and there are few samples available) use either INVOKE or
        at least a straight CALL.

        Well INVOKE is certainly convenient, and even a straight
        call is simpler. And under TRADITIONAL wisdom it is also
        faster. Not so in Windows (95 or not).

        Consider the following source code:

                .code
                call    crc32
                ; some other code
                end

        It will be assembled as you would expect. BUT, just what
        does the "crc32" label refers to? NOT the crc32 proc in
        crc32.dll because LINK.EXE has no idea where it will be
        located during run time, and Windows will not tell.

        Link will create a DWORD label called __imp_crc32, and
        Windows will place the address of the real crc32 at that
        label. The code above will actually end up being linked as:

                call    crc32
                ; some other code
            crc32:
                jmp     DWORD PTR [__imp_crc32]

        So there is an extra step. That is why it is more efficient
        to code the above example as:

                .code
                call    DWORD PTR [__imp_crc32]
                ;some other code
                end

        This applies to ALL calls into a DLL, including all system
        calls. In addition, stdcall procedures used mangled names:
        They are preceded by an underline, and @## (where ## is the
        number of bytes in the function parameters) is appended.

        Thus, MessageBoxA, which requires 4 DWORD parameters, or
        16 bytes actually is _MessageBoxA@16. And the import label
        is __imp__MessageBox@16.

%

.const
progname        db      "CRC-32 Demo", 0
                db      0Dh, 0Ah, "Copyright (c) 1997 G. Adam Stanislav"
                db      0Dh, 0Ah, "All rights reserved.", 0Dh, 0Ah, 0Ah
hexbytes        db      '0123456789ABCDEF'
.data
; Note: Can't use typographically proper quotes in the string because
; Windows system font does not support them. Talk about nerds!
agmsg           db      "And again, the "
wmsg            db      'CRC-32 of "'
win95           db      "Windo"
win95len1       equ     $-win95
win952          db      "ws 95"
win95len2       equ     $-win952
win95len        equ     $-win95
                db      '" is '
wcrchex         db      "00000000.", 0
amsg            db      'The CRC-32 of "'
asmlan          db      "assembly language"
asmlen          equ     $-asmlan
                db      '" is '
acrchex         db      "01234567.", 0
.code
crcdemo proc    stdcall public

        ; Initialize CRC-32 to FFFFFFFF
        ;       Of course, you could just mov eax, -1 here,
        ;       but that would not demonstrate the use of DLL programming.
        call    [__imp_initcrc32]

        ; Calculate CRC-32 of the string "Windows 95"
        mov     ecx, win95len   ; size of the string
        lea     ebx, win95      ; pointer to the start of the string

@@:
        mov     dl, [ebx]
        call    [__imp_crc32]
        inc     ebx
        loop    @B

        ; Get the final value of CRC-32
        call    [__imp_finishcrc32]

        ; Convert it to a hexadecimal number
        lea     ebx, wcrchex
        call    hexit

        ; Now tell us about it
        push    MB_OKCANCEL or MB_ICONINFORMATION
        push    NEAR PTR progname
        push    NEAR PTR wmsg
        push    0
        call    [__imp__MessageBoxA@16]
        cmp     eax, IDCANCEL
        je      @F

        ; Now do the same for another string, but this time
        ; call the arraycrc32 function.
        lea     ebx, asmlan
        mov     ecx, asmlen
        call    [__imp_arraycrc32]
        lea     ebx, acrchex
        call    hexit
        push    MB_OKCANCEL or MB_ICONINFORMATION
        push    NEAR PTR progname
        push    NEAR PTR amsg
        push    0
        call    [__imp__MessageBoxA@16]
        cmp     eax, IDCANCEL
        je      @F

        ; Finally, recalculate CRC-32 of "Windows 95" using
        ; partial array calculations
        ;
        ; First, initialize CRC-32 to FFFFFFFF
        call    [__imp_initcrc32]

        ; Then calculate CRC-32 of the first part of the string array
        lea     ebx, win95
        mov     ecx, win95len1
        call    [__imp_partialcrc32]

        ; Calculate CRC-32 of the rest of the array
        lea     ebx, win952
        mov     ecx, win95len2
        call    [__imp_partialcrc32]

        ; Get the final value of CRC-32
        call    [__imp_finishcrc32]

        ; Convert to hex text
        lea     ebx, wcrchex
        call    hexit

        ; And display it.
        push    MB_OK or MB_ICONINFORMATION
        push    NEAR PTR progname
        push    NEAR PTR agmsg
        push    0
        call    [__imp__MessageBoxA@16]

@@:
        ; Finally, tell us about the library, and a little shameless ad
        sub     eax, eax
        call    [__imp_aboutcrc32]

        ; That's it!
        ret

crcdemo endp

hexit   proc    private

        mov     ecx, 4

@@:
        rol     eax, 8
        mov     dl, al
        shr     dl, 4
        movzx   edx, dl
        mov     dl, hexbytes[edx]
        mov     [ebx], dl
        inc     ebx

        mov     dl, al
        and     edx, 0Fh
        mov     dl, hexbytes[edx]
        mov     [ebx], dl
        inc     ebx
        loop    @B
        ret

hexit   endp

end
