;------------------------------------------------------------------
      .586
      .model flat, stdcall
      option casemap :none   ; case sensitive

      include \masm32\include\windows.inc
      include \masm32\include\user32.inc
      include \masm32\include\kernel32.inc
      include \masm32\include\comdlg32.inc
      include \masm32\include\shell32.inc
      include aplib.inc

      includelib \masm32\lib\user32.lib
      includelib \masm32\lib\kernel32.lib
      includelib \masm32\lib\comdlg32.lib
      includelib \masm32\lib\shell32.lib
      includelib aplib.lib
;------------------------------------------------------------------
      WndProc PROTO :DWORD,:DWORD,:DWORD,:DWORD

      GetExeFile PROTO
      UnmapFile PROTO
      MapFile PROTO :DWORD
      ResizeMapFile PROTO :DWORD,:DWORD
      ConvertFO2VA PROTO :DWORD,:DWORD
      ConvertVA2FO PROTO :DWORD,:DWORD
      GetSectionNumber PROTO :DWORD,:DWORD
      IsSectionPackable PROTO :DWORD
      CreateOutFile PROTO :DWORD
      CloseOutFile PROTO
      WriteData PROTO :DWORD,:DWORD
      cProgress PROTO C :DWORD,:DWORD,:DWORD,:DWORD
      lProgress PROTO :DWORD
      ExtractOverlay PROTO :DWORD,:DWORD
      AddOverlay PROTO :DWORD,:DWORD
      CompressSection PROTO :DWORD,:DWORD,:DWORD
      FindMainIcon PROTO
;------------------------------------------------------------------
 .data
    	szTMP db "Overlay.ovl",0h

	dlgname db "TESTWIN",0
	dlgTitle db "RLPack - BasicEdition",0h
 ;
 ; Promenljive za OpenFileName dialog
 ;
	ofn OPENFILENAME <>
	FilterString db "All .exe Files",0,"*.exe",0h,"All .dll Files",0,"*.dll",0h,"All Files",0,"*.*",0h,0h
	OurTitle db "RLPack - BasicEdition by ap0x",0h
	szCHM db "help.chm",0h
 ;
 ; Razno
 ;
	szPackedExe db ".bak",0h
	szSN_text db ".text",0h
	szSN_code db "CODE",0h
	szSN_Ddata db "DATA",0h
	szSN_bss db "BSS",0h
	szSN_tls db ".tls",0h
	szSN_data db ".data",0h
	szSN_rdata db ".rdata",0h
	szSN_idata db ".idata",0h
	szSN_edata db ".edata",0h
	szSN_rsrc db ".rsrc",0h
	szSN_reloc db ".reloc",0h

	comma db ",",0h
 ;
 ; Messages
 ;
	szInfo_Version db " RLPack Basic Edition 1.17, (c)2007 by Reversing Labs",0h
	szInfo_UserName db " Licensed to: PUBLIC",0h
	szInfo_License1 db " License type: GNU/GPL",0h

	OSize_format db "Original size: %d bytes",0h
	PSize_format db "Packed size: %d bytes",0h
	Ratio_format db "Ratio: %d percent",0h

	szOpen db "open",0h
	WebSite db "http://rlpack.jezgra.net/buy.html",0h

	szPackStart db "Packing started...",0h
	szLoadIat db "Loading IAT",0h
	szPackingSections db "Packing sections",0h
	szPackingResources db "Packing resources",0h
	szPackingExport db "Packing export table",0h
	szFilePacked db "File has been packed!",0h
	szSaveOverlay db "Saving overlay",0h
	szPackEnded db "Packing ended...",0h
	szUnpackable db "File can not be packed!",0h
	szErrorText db "[Error] Error while opening file or file not selected!",0h
	szErrorTitle db "[Error]",0h
	szNotAValidEXEFile db "Selected file is not a valid EXE file!",0h
	szNotAValidPEFile db "Selected file is not a valid PE32 file!",0h
	szFileAlreadyPacked db "Selected file is already packed with RLPack or some other packer!",0h
	szAboutTitle db "About RLPack:",0h
	szAboutText db "RLPack 1.17 BasicEdition",0Dh,0Ah,"Visit http://rlpack.jezgra.net, the home of RLPack!",0Dh,0Ah,"Program uses aPLib 0.43 by Jorgen Ibsen",0Dh,0Ah,"Program uses LZMA 4.30 by Igor Pavlov",0Dh,0Ah,0Dh,0Ah,"Coded by: ap0x",0Dh,0Ah,"Licensed to: PUBLIC [GNU/GLP license]",0h
 ;
 ; LZMA
 ;
	szAPLIB db "aPLib 0.43",0h
	szSLZMA db "LZMA 4.30",0h

	szLZMA db "lzma.dll",0h
	szCompress db "Compress",0h
	szFreeCompressionMemory db "FreeCompressionMemory",0h
 ;
 ; New PeHeader
 ;
	nPEHeader	db 04Dh,05Ah,090h,000h,003h,000h,000h,000h
			db 004h,000h,000h,000h,0FFh,0FFh,000h,000h
			db 0B8h,000h,000h,000h,000h,000h,000h,000h
			db 040h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,0B0h,000h,000h,000h
			db 00Eh,01Fh,0BAh,00Eh,000h,0B4h,009h,0CDh
			db 021h,0B8h,001h,04Ch,0CDh,021h,054h,068h
			db 069h,073h,020h,070h,072h,06Fh,067h,072h
			db 061h,06Dh,020h,063h,061h,06Eh,06Eh,06Fh
			db 074h,020h,062h,065h,020h,072h,075h,06Eh
			db 020h,069h,06Eh,020h,044h,04Fh,053h,020h
			db 06Dh,06Fh,064h,065h,02Eh,00Dh,00Dh,00Ah
			db 024h,000h,000h,000h,000h,000h,000h,000h
			db 05Dh,065h,0FDh,0C8h,019h,004h,093h,09Bh
			db 019h,004h,093h,09Bh,019h,004h,093h,09Bh
			db 097h,01Bh,080h,09Bh,011h,004h,093h,09Bh
			db 0E5h,024h,081h,09Bh,018h,004h,093h,09Bh
			db 052h,069h,063h,068h,019h,004h,093h,09Bh
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 050h,045h,000h,000h,04Ch,001h,002h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,0E0h,000h,000h,000h
			db 00Bh,001h,005h,00Ch,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,010h,000h,000h,000h,002h,000h,000h
			db 004h,000h,000h,000h,000h,000h,000h,000h
			db 004h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,002h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,010h,000h,000h,010h,000h,000h
			db 000h,000h,010h,000h,000h,010h,000h,000h
			db 000h,000h,000h,000h,010h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 02Eh,070h,061h,063h,06Bh,065h,064h,000h
			db 000h,060h,000h,000h,000h,010h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,020h,000h,000h,0E0h
			db 02Eh,052h,04Ch,050h,061h,063h,06Bh,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,020h,000h,000h,0E0h
			db 000h,000h,000h,000h,000h,000h,000h,000h
			db 000h,000h,000h,000h,000h,000h,000h,000h
	DLLAPISpacer db 01h
	Hundred dd 100
 .data?
	Compressor dd ?
 ;
 ; LZMA
 ;
	hLZMA dd ?
	hCompress dd ?
	hFreeCompressionMemory dd ?
 ;
 ; Misc
 ;
	HW dd ?
	BoxHwnd dd ?
	BoxHwnd2 dd ?
	szOpenFileName db MAX_PATH dup(?)
	szPackedFileName db MAX_PATH dup(?)
 ;
 ; Mapiranje fajla
 ;
	FileHWND dd ?
	FileSize dd ?
	FileMap dd ?
	FileMapVA dd ?
 ;
 ; Ostale promenljive
 ;
	hInstance dd ?
	buffer db 512 dup(?)
	rawbuffer db 512 dup(?)
	rPack dd ?
 ;
 ; Pe.Data
 ;
	SizeOfImage dd ?
	ImageBase dd ?
	PackedOEP dd ?
	NumberOfSections dd ?
	PEHeader dd ?
	TimeDateStamp dd ?
	Characteristics dd ?
	SubSytem dd ?
 ;
 ; Pack variables
 ;
	MAIN_ICON dd ?
	CurrentSectionNumber dd ?
        CurrentSectionOffset dd ?
        CompressSectionOffset dd ?
        VirtualSize dd ?
        VirtualOffset dd ?
        RawSize dd ?
        RawOffset dd ?
        SectionFlags dd ?
        
        OutMemBuffSize dd ?
        OutMemBuff dd ?
        WorkMemSize dd ?
        WorkMemBuff dd ?
        PackedSize dd ?
        hPackedFile dd ?
        hPackedFileBuff dd ?
        hPackedFilePos dd ?
        NumberOfBytesWritten dd ?
        
	SectionWriteOffset dd ?
	PackedSectionTable db 100 dup(?)
	STUB_DATA db 1024 dup(?)
	STUB_OEP dd ?
	STUB_OEP_OFFSET dd ?

	DLLNumber dd ?
	DLLPointer dd ?
	DLLNameBuff dd ?
	APINameBuff dd ?
	DLLNameBuff_Base dd ?
	APINameBuff_Base dd ?
	
	pFirst dd ?
	pRSRC dd ?
	RSRCSize dd ?
	pRSRCBuff dd ?
	pRSRCBuffPos dd ?
	pRSRCBuffSize dd ?
	Level1_CNT dd ?
	Level2_CNT dd ?
	Level3_CNT dd ?
	pSize dd ?
	pType dd ?
	pName dd ?
	pRelOffsetToData dd ?
	pDataRVA dd ?
	pOffset dd ?
	oStripReloc dd ?
	oStripTLS dd ?
	OriginalSize dd ?
	Ratio dd ?
	LastRatio dd ?
	oStripRSRC dd ?
	ThreadRunning dd ?
	oOverlay dd ?
	oExportTable dd ?
	orgExportAddr dd ?
	orgExportSize dd ?
	ExportTableBuffSize dd ?
	ExportTableBuff dd ?
	OverlayExists dd ?
	hSaveFile dd ?
	eStart dd ?
	eSize dd ?
	RelocationRVA dd ?
	IsDll dd ?
	ReadDataBuffer db 1000h dup(?)
 .code

start:
        invoke GetModuleHandle, NULL
        mov hInstance, eax

        ; -------------------------------------------
        ; Call the dialog box stored in resource file
        ; -------------------------------------------
        invoke DialogBoxParam,hInstance,ADDR dlgname,0,ADDR WndProc,0

        invoke ExitProcess,eax

WndProc proc hWin   :DWORD,
             uMsg   :DWORD,
             wParam :DWORD,
             lParam :DWORD

      .if uMsg == WM_INITDIALOG
		invoke SendMessage,hWin,WM_SETTEXT,0,ADDR dlgTitle
		invoke LoadIcon,hInstance,500    ; icon ID

		PUSH EAX
		PUSH 0
		PUSH 80h
		PUSH hWin
		CALL SendMessage

		PUSH 600
		PUSH DWORD PTR DS:[hWin]
		CALL GetDlgItem
		PUSH 1
		PUSH 600
		PUSH [hWin]
		CALL CheckDlgButton
		
		PUSH 601
		PUSH DWORD PTR DS:[hWin]
		CALL GetDlgItem
		PUSH 1
		PUSH 601
		PUSH [hWin]
		CALL CheckDlgButton

		PUSH 610
		PUSH DWORD PTR DS:[hWin]
		CALL GetDlgItem
		PUSH 1
		PUSH 610
		PUSH [hWin]
		CALL CheckDlgButton

		PUSH 611
		PUSH DWORD PTR DS:[hWin]
		CALL GetDlgItem
		PUSH 1
		PUSH 611
		PUSH [hWin]
		CALL CheckDlgButton

		PUSH 6Fh
		PUSH [hWin]
		CALL GetDlgItem
		MOV [BoxHwnd],EAX
		PUSH 0
		PUSH 0
		PUSH 184h
		PUSH [BoxHwnd]
		CALL SendMessage

		PUSHAD
		INVOKE LoadLibrary,addr szLZMA
		MOV hLZMA,EAX
		INVOKE GetProcAddress,hLZMA,addr szCompress
		MOV hCompress,EAX
		INVOKE GetProcAddress,hLZMA,addr szFreeCompressionMemory
		MOV hFreeCompressionMemory,EAX
		INVOKE GetDlgItem,hWin,1001
		MOV BoxHwnd2,EAX
		INVOKE SendMessage,BoxHwnd2,CB_ADDSTRING,NULL,addr szAPLIB
		INVOKE SendMessage,BoxHwnd2,CB_ADDSTRING,NULL,addr szSLZMA
		INVOKE SendMessage,BoxHwnd2,CB_SETCURSEL,NULL,NULL
		POPAD

		MOV EAX,[hWin]
		MOV [HW],EAX

		PUSHAD
		PUSH offset szInfo_Version
		CALL _show_log_message_2
		PUSH offset szInfo_UserName
		CALL _show_log_message_2
		PUSH offset szInfo_License1
		CALL _show_log_message_2
		POPAD

      .elseif uMsg == WM_DROPFILES
		PUSHAD
		invoke DragQueryFile,wParam,0,ADDR buffer,256
		INVOKE lstrcpy,addr szOpenFileName,addr buffer
		INVOKE lstrcpy,addr szPackedFileName,addr buffer
		INVOKE lstrcat,addr szPackedFileName,addr szPackedExe
		PUSH offset szOpenFileName
		PUSH 102
		PUSH DWORD PTR DS:[hWin]
		CALL SetDlgItemText
		POPAD

      .elseif uMsg == WM_CLOSE
        invoke EndDialog,hWin,0

      .elseif uMsg == WM_COMMAND

        .if wParam == 107
		.if BYTE PTR[szOpenFileName] != 0
			.if ThreadRunning == 0
				PUSH offset ThreadRunning
				PUSH NULL
				PUSH NULL
				PUSH offset pack
				PUSH NULL
				PUSH NULL
				CALL CreateThread
			.endif
		.else
			INVOKE MessageBox,NULL,addr szErrorText,addr szErrorTitle,30h
		.endif
        .endif
        .if wParam == 106
		INVOKE ShellExecute,NULL,addr szOpen,addr szCHM,NULL,NULL,TRUE
        .endif
        .if wParam == 108
		INVOKE GetExeFile

		PUSH offset szOpenFileName
		PUSH 102
		PUSH DWORD PTR DS:[hWin]
		CALL SetDlgItemText
        .endif
        .if wParam == 109
		INVOKE MessageBox,NULL,addr szAboutText,addr szAboutTitle,40h
        .endif
        .if wParam == 110
		INVOKE ShellExecute,NULL,addr szOpen,addr WebSite,NULL,NULL,TRUE
        .endif

      .endif

    xor eax, eax
    ret

WndProc endp
;------------------------------------------------------------------
; Pocetak packera
;
;
pack:
	PUSHAD
;
; Erase all variables!
;
	INVOKE RtlZeroMemory,addr FileHWND,4000
	MOV ThreadRunning,1

	INVOKE SendMessage,BoxHwnd2,CB_GETCURSEL,NULL,NULL
	INC EAX
	MOV Compressor,EAX

	PUSH 6Fh
	PUSH DWORD PTR DS:[HW]
	CALL GetDlgItem
	MOV [BoxHwnd],EAX
	PUSH 0
	PUSH 0
	PUSH 184h
	PUSH [BoxHwnd]
	CALL SendMessage

	PUSH offset szPackStart
	CALL _show_log_message

	INVOKE GetDlgItem,HW,1002
	MOV ESI,EAX
	INVOKE GetWindowTextLength,ESI
	INC EAX
	INVOKE GetWindowText,ESI,addr buffer,EAX
	INVOKE lstrcat,addr buffer,addr comma

	MOV EAX,offset buffer
	MOV EBX,offset rawbuffer
	MOV ECX,EAX
	.while BYTE PTR[EAX] != 0
		.if BYTE PTR[EAX] == ','
			MOV BYTE PTR[EAX],0
			MOV EDX,EAX
			PUSH ECX
			CALL _convert_text_2_number
			MOV DWORD PTR[EBX],EAX
			ADD EBX,4
			MOV EAX,EDX
			LEA ECX,DWORD PTR[EAX+1]
		.endif
		INC EAX
	.endw

	PUSH 600
	PUSH [HW]
	CALL IsDlgButtonChecked
	.if EAX == TRUE
		INVOKE CopyFile,addr szOpenFileName,addr szPackedFileName,FALSE
	.endif

	PUSH 601
	PUSH [HW]
	CALL IsDlgButtonChecked
	.if EAX == TRUE
		MOV oStripReloc,1
	.endif

	PUSH 602
	PUSH [HW]
	CALL IsDlgButtonChecked
	.if EAX == TRUE
		MOV oStripTLS,1
	.endif

	PUSH 610
	PUSH [HW]
	CALL IsDlgButtonChecked
	.if EAX == TRUE
		MOV oStripRSRC,1
	.endif

	PUSH 611
	PUSH [HW]
	CALL IsDlgButtonChecked
	.if EAX == TRUE
		MOV oOverlay,1
	.endif

	PUSH 619
	PUSH [HW]
	CALL IsDlgButtonChecked
	.if EAX == TRUE
		MOV oExportTable,1
	.endif

;------------------------------------------------------------------
; Check the PE32/exe file
;

	INVOKE MapFile,addr szOpenFileName
	MOV EBX,FileMapVA
	.if WORD PTR[EBX] != 'ZM'
		INVOKE MessageBox,NULL,addr szNotAValidEXEFile,addr szErrorTitle,MB_ICONERROR+MB_OK
		PUSH offset szUnpackable
		CALL _show_log_message
		MOV EAX,offset ERROR_EXIT
		JMP EAX
	.endif
	ADD EBX,3Ch
	ADD BX,WORD PTR[EBX]		;WinME/98/95 compatibility!
	SUB BX,3Ch			;
	.if WORD PTR[EBX] != 'EP'
		INVOKE MessageBox,NULL,addr szNotAValidPEFile,addr szErrorTitle,MB_ICONERROR+MB_OK
		PUSH offset szUnpackable
		CALL _show_log_message
		MOV EAX,offset ERROR_EXIT
		JMP EAX
	.endif
	MOVZX ECX,WORD PTR[EBX+6h]
	MOV EAX,DWORD PTR[EBX+28h]
	INVOKE GetSectionNumber,FileMapVA,EAX
	.if ECX > EAX
		INVOKE MessageBox,NULL,addr szFileAlreadyPacked,addr szErrorTitle,MB_ICONERROR+MB_OK
		PUSH offset szUnpackable
		CALL _show_log_message
		MOV EAX,offset ERROR_EXIT
		JMP EAX
	.endif
	INVOKE UnmapFile

;------------------------------------------------------------------
; Copy Overlay
;

	.if oOverlay == 1
		INVOKE ExtractOverlay,addr szOpenFileName,addr szTMP
		.if EAX > 0
			MOV OverlayExists,EAX
		.endif
	.endif

;------------------------------------------------------------------
; Begin packing
;

	INVOKE MapFile,addr szOpenFileName

	MOV EAX,FileSize
	MOV OriginalSize,EAX
	PUSH EAX
	PUSH offset OSize_format
	PUSH offset buffer
	CALL wsprintf
	ADD ESP,0Ch
	PUSH 603
	PUSH DWORD PTR DS:[HW]
	CALL GetDlgItem
	PUSH offset buffer
	PUSH EAX
	CALL SetWindowText

	MOV EAX,FileSize
	ADD EAX,500000h
	INVOKE VirtualAlloc,NULL,EAX,MEM_COMMIT,PAGE_EXECUTE_READWRITE
	MOV hPackedFileBuff,EAX
	MOV hPackedFilePos,EAX

	INVOKE RtlMoveMemory,hPackedFilePos,addr nPEHeader,200h
	ADD hPackedFilePos,200h

	MOV EBX,FileMapVA
	ADD EBX,3Ch
	ADD BX,WORD PTR[EBX]		;WinME/98/95 compatibility!
	SUB BX,3Ch			;
	MOV PEHeader,EBX
	MOV EAX,DWORD PTR[EBX+28h]
	MOV PackedOEP,EAX
	MOV EAX,DWORD PTR[EBX+34h]
	MOV ImageBase,EAX
	ADD PackedOEP,EAX
	MOVZX EAX,WORD PTR[EBX+6h]
	MOV NumberOfSections,EAX
	MOV CurrentSectionNumber,EAX

;------------------------------------------------------------------
; Load needed PE.data
;
;
	MOV EAX,DWORD PTR[EBX+8h]
	MOV TimeDateStamp,EAX
	MOV EAX,DWORD PTR[EBX+16h]
	MOV Characteristics,EAX
	MOVZX EAX,WORD PTR[EBX+5Ch]
	MOV SubSytem,EAX
	MOV EAX,DWORD PTR[EBX+0A0h]
	MOV IsDll,0
	MOV RelocationRVA,0
	TEST WORD PTR[Characteristics],2000h
	JE _not_a_dll
		MOV RelocationRVA,EAX
		MOV IsDll,1
 _not_a_dll:

;------------------------------------------------------------------
; SizeOfImage calculation
;
;
	MOV EAX,DWORD PTR[EBX+50h]
	MOV EDI,EAX
	CDQ
	MOV ECX,1000h
	DIV ECX
	IMUL EAX,1000h
	.if EDI > EAX
		ADD EAX,1000h
	.endif
	MOV SizeOfImage,EAX

;------------------------------------------------------------------
; Load IAT
;
;

	PUSH offset szLoadIat
	CALL _show_log_message

	INVOKE VirtualAlloc,NULL,500000h,MEM_COMMIT,PAGE_EXECUTE_READWRITE
	MOV DLLNameBuff,EAX
	MOV DLLNameBuff_Base,EAX
	INVOKE VirtualAlloc,NULL,500000h,MEM_COMMIT,PAGE_EXECUTE_READWRITE
	MOV APINameBuff,EAX
	MOV APINameBuff_Base,EAX

	MOV EAX,PEHeader
	MOV EAX,DWORD PTR[EAX+80h]
	.if EAX != 0
		ADD EAX,ImageBase
		INVOKE ConvertVA2FO,FileMapVA,EAX
		ADD EAX,FileMapVA
		MOV DLLPointer,EAX
		.while DLLPointer != 0
			INC DLLNumber

			MOV EBX,DLLPointer
			ADD EBX,12
			MOV EBX,DWORD PTR[EBX]
			ADD EBX,ImageBase

			INVOKE ConvertVA2FO,FileMapVA,EBX
			ADD EAX,FileMapVA
			MOV EDI,EAX
			INVOKE lstrcpy,DLLNameBuff,EAX
			INVOKE lstrlen,DLLNameBuff
			INC EAX
			ADD DLLNameBuff,EAX
			INVOKE RtlZeroMemory,EDI,EAX

			MOV EBX,DLLPointer
			MOV ECX,DWORD PTR[EBX]
			MOV EDX,ECX
			ADD EDX,ImageBase

			ADD EBX,16
			MOV ECX,DWORD PTR[EBX]
			.if EDX == ImageBase
				ADD EDX,ECX
			.endif

			ADD ECX,ImageBase
			MOV EAX,APINameBuff
			MOV DWORD PTR[EAX],ECX
			ADD APINameBuff,4

			INVOKE ConvertVA2FO,FileMapVA,EDX
			ADD EAX,FileMapVA
			.while DWORD PTR[EAX] != 0
				MOV EBX,DWORD PTR[EAX]
				.if EBX < 80000000h
					ADD EBX,2
					ADD EBX,ImageBase
					PUSHAD
					INVOKE ConvertVA2FO,FileMapVA,EBX
					ADD EAX,FileMapVA
					MOV EDI,EAX;;;
					INVOKE lstrcpy,APINameBuff,EAX
					INVOKE lstrlen,APINameBuff
					INC EAX
					ADD APINameBuff,EAX
					INVOKE RtlZeroMemory,EDI,EAX
					POPAD
				.else
					PUSHAD
					MOV ECX,APINameBuff
					MOV DWORD PTR[ECX],EBX
					ADD APINameBuff,4
					POPAD
				.endif
				MOV DWORD PTR[EAX],0
				ADD EAX,4
			.endw
			INC APINameBuff
			ADD DLLPointer,14h
			MOV EAX,DLLPointer
			ADD EAX,12
			.if DWORD PTR[EAX] == 0
				MOV DLLPointer,0
			.endif
		.endw
	.endif

;------------------------------------------------------------------
; Strip IAT
;
;

	MOV EAX,FileMapVA
	ADD EAX,3Ch
	ADD AX,WORD PTR[EAX]		;WinME/98/95 compatibility!
	SUB AX,3Ch			;
	MOV EBX,DWORD PTR[EAX+0D8h]
	MOV ECX,DWORD PTR[EAX+0DCh]
	.if EBX > 0 && ECX > 0
		ADD EBX,ImageBase
		INVOKE ConvertVA2FO,FileMapVA,EBX
		ADD EAX,FileMapVA
		INVOKE RtlZeroMemory,EAX,ECX
	.endif

;------------------------------------------------------------------
; Strip export table
;
;

	.if oExportTable == 1
		MOV EAX,FileMapVA
		ADD EAX,3Ch
		ADD AX,WORD PTR[EAX]		;WinME/98/95 compatibility!
		SUB AX,3Ch			;
		MOV EBX,DWORD PTR[EAX+78h]
		MOV ECX,DWORD PTR[EAX+7Ch]
		.if EBX > 0 && ECX > 0
			ADD EBX,ImageBase
			INVOKE ConvertVA2FO,FileMapVA,EBX
			ADD EAX,FileMapVA
			INVOKE RtlZeroMemory,EAX,ECX
		.endif
	.endif

;------------------------------------------------------------------

	PUSH offset szPackingSections
	CALL _show_log_message

;------------------------------------------------------------------
; Pack sections / aplib
;

	.if Compressor == 1
		MOV EAX,PEHeader
		ADD AX,WORD PTR[EAX+14h]
		ADD EAX,18h
		MOV CurrentSectionOffset,EAX
		MOV ESI,offset PackedSectionTable
		MOV EDI,hPackedFilePos
		.while CurrentSectionNumber > 0
			MOV EBX,CurrentSectionOffset
			MOV ECX,FileMapVA
			ADD EBX,8
			MOV EAX,DWORD PTR[EBX]
			MOV VirtualSize,EAX
			MOV EAX,DWORD PTR[EBX+4]
			MOV VirtualOffset,EAX
			MOV EAX,DWORD PTR[EBX+8]
			MOV RawSize,EAX
			MOV EAX,DWORD PTR[EBX+12]
			MOV RawOffset,EAX
			MOV CompressSectionOffset,EAX
			ADD CompressSectionOffset,ECX
			MOV EAX,DWORD PTR[EBX+1Ch]
			MOV SectionFlags,EAX
	
			SUB EBX,8
			PUSH EBX
			CALL IsSectionPackable
			.if EAX == 1
				CALL initProgress
				MOV DWORD PTR[ESI],EDI
				ADD ESI,4
				MOV EAX,VirtualOffset
				ADD EAX,ImageBase
				MOV DWORD PTR[ESI],EAX
				ADD ESI,4

				INVOKE aP_max_packed_size,RawSize
				MOV OutMemBuffSize,EAX
	
				INVOKE VirtualAlloc,NULL,EAX,MEM_COMMIT,PAGE_EXECUTE_READWRITE
	
				MOV OutMemBuff,EAX
				INVOKE aP_workmem_size,RawSize
				MOV WorkMemSize,EAX
	
				INVOKE VirtualAlloc,NULL,EAX,MEM_COMMIT,PAGE_EXECUTE_READWRITE
	
				MOV WorkMemBuff,EAX
	
				INVOKE aP_pack,CompressSectionOffset,OutMemBuff,RawSize,WorkMemBuff,addr cProgress,NULL
				ADD EAX,4
				MOV PackedSize,EAX
				ADD EDI,PackedSize

				INVOKE VirtualFree,WorkMemBuff,WorkMemSize,MEM_DECOMMIT
				PUSH PackedSize
				PUSH OutMemBuff
				CALL WriteData
	
				INVOKE VirtualFree,OutMemBuff,OutMemBuffSize,MEM_DECOMMIT
			.elseif EAX == 2
				NOP
			.elseif EAX == 3
				.if oStripRSRC == 0
					CALL RSRCPack
				.endif
				CALL initProgress			
				MOV DWORD PTR[ESI],EDI
				ADD ESI,4
				MOV EAX,VirtualOffset
				ADD EAX,ImageBase
				MOV DWORD PTR[ESI],EAX
				ADD ESI,4
	
				INVOKE aP_max_packed_size,RawSize
				MOV OutMemBuffSize,EAX
	
				INVOKE VirtualAlloc,NULL,EAX,MEM_COMMIT,PAGE_EXECUTE_READWRITE
	
				MOV OutMemBuff,EAX
				INVOKE aP_workmem_size,RawSize
				MOV WorkMemSize,EAX
	
				INVOKE VirtualAlloc,NULL,EAX,MEM_COMMIT,PAGE_EXECUTE_READWRITE
	
				MOV WorkMemBuff,EAX
	
				INVOKE aP_pack,CompressSectionOffset,OutMemBuff,RawSize,WorkMemBuff,addr cProgress,NULL
				ADD EAX,4
				MOV PackedSize,EAX
				ADD EDI,PackedSize
	
				INVOKE VirtualFree,WorkMemBuff,WorkMemSize,MEM_DECOMMIT
				PUSH PackedSize
				PUSH OutMemBuff
				CALL WriteData
	
				INVOKE VirtualFree,OutMemBuff,OutMemBuffSize,MEM_DECOMMIT
				INVOKE VirtualFree,pRSRC,pSize,MEM_DECOMMIT
			.else
				ADD EDI,RawSize
	
				PUSH RawSize
				PUSH CompressSectionOffset
				CALL WriteData
			.endif
			ADD CurrentSectionOffset,28h
			DEC CurrentSectionNumber
		.endw
	.endif

;------------------------------------------------------------------
; Pack sections / lzma
;

	.if Compressor == 2
		MOV EAX,PEHeader
		ADD AX,WORD PTR[EAX+14h]
		ADD EAX,18h
		MOV CurrentSectionOffset,EAX
		MOV ESI,offset PackedSectionTable
		MOV EDI,hPackedFilePos
		.while CurrentSectionNumber > 0
			MOV EBX,CurrentSectionOffset
			MOV ECX,FileMapVA
			ADD EBX,8
			MOV EAX,DWORD PTR[EBX]
			MOV VirtualSize,EAX
			MOV EAX,DWORD PTR[EBX+4]
			MOV VirtualOffset,EAX
			MOV EAX,DWORD PTR[EBX+8]
			MOV RawSize,EAX
			MOV EAX,DWORD PTR[EBX+12]
			MOV RawOffset,EAX
			MOV CompressSectionOffset,EAX
			ADD CompressSectionOffset,ECX
			MOV EAX,DWORD PTR[EBX+1Ch]
			MOV SectionFlags,EAX
	
			SUB EBX,8
			PUSH EBX
			CALL IsSectionPackable
			.if EAX == 1
				CALL initProgress
				MOV DWORD PTR[ESI],EDI
				ADD ESI,4
				MOV EAX,VirtualOffset
				ADD EAX,ImageBase
				MOV DWORD PTR[ESI],EAX
				ADD ESI,4
	
				MOV EAX,RawSize
				ADD EAX,1024
				MOV OutMemBuffSize,EAX
	
				INVOKE VirtualAlloc,NULL,EAX,MEM_COMMIT,PAGE_EXECUTE_READWRITE
	
				MOV OutMemBuff,EAX
	
				INVOKE CompressSection,OutMemBuff,CompressSectionOffset,RawSize
				ADD EAX,4
				MOV PackedSize,EAX
				ADD EDI,PackedSize
	
				PUSH PackedSize
				PUSH OutMemBuff
				CALL WriteData
	
				INVOKE VirtualFree,OutMemBuff,OutMemBuffSize,MEM_DECOMMIT
			.elseif EAX == 2
				NOP
			.elseif EAX == 3
				.if oStripRSRC == 0
					CALL RSRCPack
				.endif
				CALL initProgress			
				MOV DWORD PTR[ESI],EDI
				ADD ESI,4
				MOV EAX,VirtualOffset
				ADD EAX,ImageBase
				MOV DWORD PTR[ESI],EAX
				ADD ESI,4
	
				MOV EAX,RawSize
				ADD EAX,1024
				MOV OutMemBuffSize,EAX
	
				INVOKE VirtualAlloc,NULL,EAX,MEM_COMMIT,PAGE_EXECUTE_READWRITE
	
				MOV OutMemBuff,EAX
				
				INVOKE CompressSection,OutMemBuff,CompressSectionOffset,RawSize
				ADD EAX,4
				MOV PackedSize,EAX
				ADD EDI,PackedSize
	
				PUSH PackedSize
				PUSH OutMemBuff
				CALL WriteData
	
				INVOKE VirtualFree,OutMemBuff,OutMemBuffSize,MEM_DECOMMIT
				INVOKE VirtualFree,pRSRC,pSize,MEM_DECOMMIT
			.else
				ADD EDI,RawSize
	
				PUSH RawSize
				PUSH CompressSectionOffset
				CALL WriteData
			.endif
			ADD CurrentSectionOffset,28h
			DEC CurrentSectionNumber
		.endw
	.endif

;------------------------------------------------------------------
; Fix packed file PEHeader
;
;

	MOV EBX,hPackedFileBuff
	ADD EBX,3Ch
	ADD BX,WORD PTR[EBX]		;WinME/98/95 compatibility!
	SUB BX,3Ch			;

	MOV PEHeader,EBX

	MOV EAX,TimeDateStamp
	MOV DWORD PTR[EBX+8h],EAX
	MOV EAX,Characteristics
	MOV DWORD PTR[EBX+16h],EAX
	MOV EAX,SubSytem
	MOV WORD PTR[EBX+5Ch],AX
	MOV EAX,ImageBase
	MOV DWORD PTR[EBX+34h],EAX

	CALL FixPackedHeader

;------------------------------------------------------------------
; Copy STUB and fill it with data / aplib
;

	.if Compressor == 1
		MOV EAX,hPackedFilePos
		MOV STUB_OEP,EAX
		MOV STUB_OEP_OFFSET,EAX
	
		.if IsDll == 0
			MOV EAX,offset __STUB_END
			SUB EAX,offset __STUB_START
			PUSH EAX
			PUSH offset __STUB_START
			CALL WriteData
		.else
			MOV EAX,offset __STUB_END
			SUB EAX,offset __DLL_STUB_START
			PUSH EAX
			PUSH offset __DLL_STUB_START
			CALL WriteData
		.endif

		MOV EAX,hPackedFilePos

		MOV EDX,offset STUB_DATA
		ADD EDX,12			;SectionData pointer
		
		MOV ECX,ImageBase
		MOV EBX,offset PackedSectionTable
		.while DWORD PTR[EBX] != 0
			INVOKE ConvertFO2VA,hPackedFileBuff,DWORD PTR[EBX]
			MOV DWORD PTR[EDX],EAX
			ADD DWORD PTR[EDX],ECX
			ADD EDX,4
			MOV EAX,DWORD PTR[EBX+4]
			MOV DWORD PTR[EDX],EAX
			ADD EDX,4
			ADD EBX,8
		.endw
		SUB EDX,offset STUB_DATA
		ADD EDX,4
		PUSH EDX
		PUSH offset STUB_DATA
		CALL WriteData
	.endif

;------------------------------------------------------------------
; Copy STUB and fill it with data / lzma
;

	.if Compressor == 2
		MOV EAX,hPackedFilePos
		MOV STUB_OEP,EAX
		MOV STUB_OEP_OFFSET,EAX
	
		.if IsDll == 0
			MOV EAX,offset __L_STUB_END
			SUB EAX,offset __L_STUB_START
			PUSH EAX
			PUSH offset __L_STUB_START
			CALL WriteData
		.else
			MOV EAX,offset __L_STUB_END
			SUB EAX,offset __L_DLL_STUB_START
			PUSH EAX
			PUSH offset __L_DLL_STUB_START
			CALL WriteData
		.endif

		MOV EAX,hPackedFilePos

		MOV EDX,offset STUB_DATA
		ADD EDX,12			;SectionData pointer

		MOV ECX,ImageBase
		MOV EBX,offset PackedSectionTable
		.while DWORD PTR[EBX] != 0
			INVOKE ConvertFO2VA,hPackedFileBuff,DWORD PTR[EBX]
			MOV DWORD PTR[EDX],EAX
			ADD DWORD PTR[EDX],ECX
			ADD EDX,4
			MOV EAX,DWORD PTR[EBX+4]
			MOV DWORD PTR[EDX],EAX
			ADD EDX,4
			ADD EBX,8
		.endw
		SUB EDX,offset STUB_DATA
		ADD EDX,4
		PUSH EDX
		PUSH offset STUB_DATA
		CALL WriteData
	.endif

;------------------------------------------------------------------
; Copy IAT / aplib
;

	.if Compressor == 1
		MOV EAX,APINameBuff
		SUB EAX,APINameBuff_Base
		MOV RawSize,EAX
		MOV EBX,DLLNameBuff
		MOV BYTE PTR[EBX],1
		INC DLLNameBuff
		INVOKE RtlMoveMemory,DLLNameBuff,APINameBuff_Base,RawSize
		MOV EAX,DLLNameBuff
		SUB EAX,DLLNameBuff_Base
		ADD RawSize,EAX
	
		INVOKE aP_max_packed_size,RawSize
		MOV OutMemBuffSize,EAX
	
		INVOKE VirtualAlloc,NULL,EAX,MEM_COMMIT,PAGE_EXECUTE_READWRITE
	
		MOV OutMemBuff,EAX
		INVOKE aP_workmem_size,RawSize
		MOV WorkMemSize,EAX
	
		INVOKE VirtualAlloc,NULL,EAX,MEM_COMMIT,PAGE_EXECUTE_READWRITE
	
		MOV WorkMemBuff,EAX
	
		INVOKE aP_pack,DLLNameBuff_Base,OutMemBuff,RawSize,WorkMemBuff,NULL,NULL
		ADD EAX,4
		MOV PackedSize,EAX
	
		INVOKE VirtualFree,WorkMemBuff,WorkMemSize,MEM_DECOMMIT
		PUSH PackedSize
		PUSH OutMemBuff
		CALL WriteData
	
		INVOKE VirtualFree,OutMemBuff,OutMemBuffSize,MEM_DECOMMIT
	       	CALL FixPackedHeader
	.endif

;------------------------------------------------------------------
; Copy IAT / lzma
;

	.if Compressor == 2
		MOV EAX,APINameBuff
		SUB EAX,APINameBuff_Base
		MOV RawSize,EAX
		MOV EBX,DLLNameBuff
		MOV BYTE PTR[EBX],1
		INC DLLNameBuff
		INVOKE RtlMoveMemory,DLLNameBuff,APINameBuff_Base,RawSize
		MOV EAX,DLLNameBuff
		SUB EAX,DLLNameBuff_Base
		ADD RawSize,EAX
	
		MOV EAX,RawSize
		ADD EAX,1024
		MOV OutMemBuffSize,EAX
	
		INVOKE VirtualAlloc,NULL,EAX,MEM_COMMIT,PAGE_EXECUTE_READWRITE
	
		MOV OutMemBuff,EAX
	
		INVOKE CompressSection,OutMemBuff,DLLNameBuff_Base,RawSize
		ADD EAX,4
		MOV PackedSize,EAX
	
		PUSH PackedSize
		PUSH OutMemBuff
		CALL WriteData
	
		INVOKE VirtualFree,OutMemBuff,OutMemBuffSize,MEM_DECOMMIT
	       	CALL FixPackedHeader
	.endif

;------------------------------------------------------------------
; Copy TLS
;
;
	.if oStripTLS == 0
		MOV EBX,FileMapVA
		ADD EBX,3Ch
		ADD BX,WORD PTR[EBX]		;WinME/98/95 compatibility!
		SUB BX,3Ch			;

		MOV PEHeader,EBX
	
		MOV EBX,SizeOfImage
		ADD EBX,1000h
		MOV ECX,hPackedFilePos
		SUB ECX,hPackedFileBuff
		SUB ECX,200h
		ADD ECX,EBX
	
		MOV EBX,PEHeader
		MOV ESI,DWORD PTR[EBX+0C0h]
		MOV EDI,DWORD PTR[EBX+0C4h]
		ADD ESI,ImageBase
		INVOKE ConvertVA2FO,FileMapVA,ESI
		ADD EAX,FileMapVA
		MOV ESI,EAX
	
		.if ESI > 0 && EDI > 0
			PUSH EDI
			PUSH ESI
			CALL WriteData
		.endif
	
		MOV EBX,hPackedFileBuff
		ADD EBX,3Ch
		ADD BX,WORD PTR[EBX]		;WinME/98/95 compatibility!
		SUB BX,3Ch			;

		MOV PEHeader,EBX
	
		.if ESI > 0 && EDI > 0
			MOV EAX,PEHeader
			MOV DWORD PTR[EAX+0C0h],ECX
			MOV DWORD PTR[EAX+0C4h],EDI
		.endif
	.endif
       	CALL FixPackedHeader

;------------------------------------------------------------------
; Pack export table
;

	.if oExportTable == 0
		MOV EAX,FileMapVA
		ADD EAX,3Ch
		ADD AX,WORD PTR[EAX]		;WinME/98/95 compatibility!
		SUB AX,3Ch			;
		MOV EBX,DWORD PTR[EAX+78h]
		MOV ECX,DWORD PTR[EAX+7Ch]
		.if EBX > 0 && ECX > 0
			PUSH offset szPackingExport
			CALL _show_log_message

			MOV orgExportAddr,EBX
			MOV orgExportSize,ECX

			ADD EBX,ImageBase
			INVOKE ConvertVA2FO,FileMapVA,EBX
			MOV EBX,EAX
			ADD EBX,FileMapVA

			PUSHAD
			MOV ExportTableBuffSize,ECX
			INVOKE VirtualAlloc,NULL,ECX,MEM_COMMIT,PAGE_EXECUTE_READWRITE
			MOV ExportTableBuff,EAX
			POPAD

			INVOKE RtlMoveMemory,ExportTableBuff,EBX,ExportTableBuffSize

			MOV EAX,hPackedFilePos
			INVOKE ConvertFO2VA,hPackedFileBuff,EAX
			MOV ESI,EAX

			MOV EAX,hPackedFileBuff
			ADD EAX,3Ch
			ADD AX,WORD PTR[EAX]		;WinME/98/95 compatibility!
			SUB AX,3Ch			;
			ADD EAX,78h
			MOV DWORD PTR[EAX],ESI
			MOV ECX,orgExportSize
			MOV DWORD PTR[EAX+4],ECX

			MOV EAX,ExportTableBuff
			MOV EBX,DWORD PTR[EAX+32]	;Name Pointer RVA
			SUB EBX,orgExportAddr
			ADD EBX,ExportTableBuff
			MOV ECX,DWORD PTR[EAX+24]	;Number of Name Pointers
			.while ECX > 0
				MOV EDX,DWORD PTR[EBX]
				SUB EDX,orgExportAddr
				ADD EDX,ESI
                                MOV DWORD PTR[EBX],EDX
                                ADD EBX,4
				DEC ECX
			.endw

			MOV EBX,DWORD PTR[EAX+12]	;Name RVA
			SUB EBX,orgExportAddr
			ADD EBX,ESI
			MOV DWORD PTR[EAX+12],EBX
			MOV EBX,DWORD PTR[EAX+28]	;Export Address Table RVA
			SUB EBX,orgExportAddr
			ADD EBX,ESI
			MOV DWORD PTR[EAX+28],EBX
			MOV EBX,DWORD PTR[EAX+32]	;Name Pointer RVA
			SUB EBX,orgExportAddr
			ADD EBX,ESI
			MOV DWORD PTR[EAX+32],EBX
			MOV EBX,DWORD PTR[EAX+36]	;Ordinal Table RVA
			SUB EBX,orgExportAddr
			ADD EBX,ESI
			MOV DWORD PTR[EAX+36],EBX

			PUSH ExportTableBuffSize
			PUSH ExportTableBuff
			CALL WriteData

			INVOKE VirtualFree,ExportTableBuff,ExportTableBuffSize,MEM_DECOMMIT
		       	CALL FixPackedHeader
		.endif
	.endif

;------------------------------------------------------------------
; Fix OEP and IAT / aplib
;

	.if Compressor == 1 && IsDll == 0
		INVOKE ConvertFO2VA,hPackedFileBuff,STUB_OEP
		MOV EBX,PEHeader
		ADD EBX,28h
		MOV DWORD PTR[EBX],EAX
		
		MOV ESI,EAX
		ADD ESI,ImageBase

		MOV EDX,STUB_OEP_OFFSET
		LEA EBX,DWORD PTR[EDX+((offset __kernel32 - offset __STUB_START))]
		LEA ECX,DWORD PTR[EDX+((offset __dllName - offset __STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX

		LEA EBX,DWORD PTR[EDX+((offset __locloadlib - offset __STUB_START))]
		LEA ECX,DWORD PTR[EDX+((offset __FirstThunk - offset __STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __loadlib - offset __STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __locloadlib - offset __STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __gpa - offset __STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __locgpa - offset __STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __va - offset __STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __locva - offset __STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __vf - offset __STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __locvf - offset __STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA ECX,DWORD PTR[EDX+((offset __PE32_IMAGEBASE - offset __STUB_START))]
		MOV EAX,ImageBase
		MOV DWORD PTR[ECX],EAX
		LEA ECX,DWORD PTR[EDX+((offset __RELOCATION - offset __STUB_START))]
		MOV EAX,RelocationRVA
		MOV DWORD PTR[ECX],EAX

		LEA EBX,DWORD PTR[EDX+((offset __STUB_OEP_JUMP - offset __STUB_START))+1]
		LEA ECX,DWORD PTR[EDX+((offset __STUB_OEP_JUMP - offset __STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,ECX
		ADD EAX,ImageBase
		MOV ECX,PackedOEP
		SUB ECX,EAX
		SUB ECX,5
		MOV DWORD PTR[EBX],ECX

		MOV EAX,RawSize
		LEA EBX,DWORD PTR[EDX+((offset __STUB_VA_SIZE - offset __STUB_START))+1]
		MOV DWORD PTR[EBX],EAX
		LEA EBX,DWORD PTR[EDX+((offset __STUB_VF_SIZE - offset __STUB_START))+1]
		MOV DWORD PTR[EBX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __iat - offset __STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX

		MOV EBX,PEHeader
		MOV DWORD PTR[EBX+80h],EAX
		MOV DWORD PTR[EBX+84h],28h
	.endif

;------------------------------------------------------------------
; Fix OEP and IAT / lzma
;

	.if Compressor == 2 && IsDll == 0
		INVOKE ConvertFO2VA,hPackedFileBuff,STUB_OEP
		MOV EBX,PEHeader
		ADD EBX,28h
		MOV DWORD PTR[EBX],EAX
		
		MOV ESI,EAX
		ADD ESI,ImageBase
	
		MOV EDX,STUB_OEP_OFFSET
		LEA EBX,DWORD PTR[EDX+((offset __L_kernel32 - offset __L_STUB_START))]
		LEA ECX,DWORD PTR[EDX+((offset __L_dllName_k - offset __L_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __L_locloadlib - offset __L_STUB_START))]
		LEA ECX,DWORD PTR[EDX+((offset __L_FirstThunk_k - offset __L_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX

		LEA EBX,DWORD PTR[EDX+((offset __L_loadlib - offset __L_STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __L_locloadlib - offset __L_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __L_gpa - offset __L_STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __L_locgpa - offset __L_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __L_va - offset __L_STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __L_locva - offset __L_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __L_vf - offset __L_STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __L_locvf - offset __L_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA ECX,DWORD PTR[EDX+((offset __L_PE32_IMAGEBASE - offset __L_STUB_START))]
		MOV EAX,ImageBase
		MOV DWORD PTR[ECX],EAX
		LEA ECX,DWORD PTR[EDX+((offset __L_RELOCATION - offset __L_STUB_START))]
		MOV EAX,RelocationRVA
		MOV DWORD PTR[ECX],EAX

		LEA EBX,DWORD PTR[EDX+((offset __L_STUB_OEP_JUMP - offset __L_STUB_START))+1]
		LEA ECX,DWORD PTR[EDX+((offset __L_STUB_OEP_JUMP - offset __L_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,ECX
		ADD EAX,ImageBase
		MOV ECX,PackedOEP
		SUB ECX,EAX
		SUB ECX,5
		MOV DWORD PTR[EBX],ECX

		MOV EAX,RawSize
		LEA EBX,DWORD PTR[EDX+((offset __L_STUB_VA_SIZE - offset __L_STUB_START))+1]
		MOV DWORD PTR[EBX],EAX
		LEA EBX,DWORD PTR[EDX+((offset __L_STUB_VF_SIZE - offset __L_STUB_START))+1]
		MOV DWORD PTR[EBX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __L_iat - offset __L_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX

		MOV EBX,PEHeader
		MOV DWORD PTR[EBX+80h],EAX
		MOV DWORD PTR[EBX+84h],28h
	.endif

;------------------------------------------------------------------
; Fix OEP and IAT / aplib
;

	.if Compressor == 1 && IsDll == 1
		INVOKE ConvertFO2VA,hPackedFileBuff,STUB_OEP
		MOV EBX,PEHeader
		ADD EBX,28h
		MOV DWORD PTR[EBX],EAX
		
		MOV ESI,EAX
		ADD ESI,ImageBase

		MOV EDX,STUB_OEP_OFFSET
		LEA EBX,DWORD PTR[EDX+((offset __kernel32 - offset __DLL_STUB_START))]
		LEA ECX,DWORD PTR[EDX+((offset __dllName - offset __DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX

		LEA EBX,DWORD PTR[EDX+((offset __locloadlib - offset __DLL_STUB_START))]
		LEA ECX,DWORD PTR[EDX+((offset __FirstThunk - offset __DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __loadlib - offset __DLL_STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __locloadlib - offset __DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __gpa - offset __DLL_STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __locgpa - offset __DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __va - offset __DLL_STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __locva - offset __DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __vf - offset __DLL_STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __locvf - offset __DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA ECX,DWORD PTR[EDX+((offset __PE32_IMAGEBASE - offset __DLL_STUB_START))]
		MOV EAX,ImageBase
		MOV DWORD PTR[ECX],EAX
		LEA ECX,DWORD PTR[EDX+((offset __RELOCATION - offset __DLL_STUB_START))]
		MOV EAX,RelocationRVA
		MOV DWORD PTR[ECX],EAX

		LEA EBX,DWORD PTR[EDX+((offset __STUB_OEP_JUMP - offset __DLL_STUB_START))+1]
		LEA ECX,DWORD PTR[EDX+((offset __STUB_OEP_JUMP - offset __DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,ECX
		ADD EAX,ImageBase
		MOV ECX,PackedOEP
		SUB ECX,EAX
		SUB ECX,5
		MOV DWORD PTR[EBX],ECX

		MOV EAX,RawSize
		LEA EBX,DWORD PTR[EDX+((offset __STUB_VA_SIZE - offset __DLL_STUB_START))+1]
		MOV DWORD PTR[EBX],EAX
		LEA EBX,DWORD PTR[EDX+((offset __STUB_VF_SIZE - offset __DLL_STUB_START))+1]
		MOV DWORD PTR[EBX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __iat - offset __DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX

		MOV EBX,PEHeader
		MOV DWORD PTR[EBX+080h],EAX
		MOV DWORD PTR[EBX+084h],28h
		LEA EAX,DWORD PTR[EDX+((offset __WIN9x_RELOCATION - offset __DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EAX
		MOV DWORD PTR[EBX+0A0h],EAX
		MOV DWORD PTR[EBX+0A4h],8
	.endif

;------------------------------------------------------------------
; Fix OEP and IAT / lzma
;

	.if Compressor == 2 && IsDll == 1
		INVOKE ConvertFO2VA,hPackedFileBuff,STUB_OEP
		MOV EBX,PEHeader
		ADD EBX,28h
		MOV DWORD PTR[EBX],EAX
		
		MOV ESI,EAX
		ADD ESI,ImageBase
	
		MOV EDX,STUB_OEP_OFFSET
		LEA EBX,DWORD PTR[EDX+((offset __L_kernel32 - offset __L_DLL_STUB_START))]
		LEA ECX,DWORD PTR[EDX+((offset __L_dllName_k - offset __L_DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __L_locloadlib - offset __L_DLL_STUB_START))]
		LEA ECX,DWORD PTR[EDX+((offset __L_FirstThunk_k - offset __L_DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX

		LEA EBX,DWORD PTR[EDX+((offset __L_loadlib - offset __L_DLL_STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __L_locloadlib - offset __L_DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __L_gpa - offset __L_DLL_STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __L_locgpa - offset __L_DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __L_va - offset __L_DLL_STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __L_locva - offset __L_DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __L_vf - offset __L_DLL_STUB_START))-2]
		LEA ECX,DWORD PTR[EDX+((offset __L_locvf - offset __L_DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX
		MOV DWORD PTR[ECX],EAX
	
		LEA ECX,DWORD PTR[EDX+((offset __L_PE32_IMAGEBASE - offset __L_DLL_STUB_START))]
		MOV EAX,ImageBase
		MOV DWORD PTR[ECX],EAX
		LEA ECX,DWORD PTR[EDX+((offset __L_RELOCATION - offset __L_DLL_STUB_START))]
		MOV EAX,RelocationRVA
		MOV DWORD PTR[ECX],EAX

		LEA EBX,DWORD PTR[EDX+((offset __L_STUB_OEP_JUMP - offset __L_DLL_STUB_START))+1]
		LEA ECX,DWORD PTR[EDX+((offset __L_STUB_OEP_JUMP - offset __L_DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,ECX
		ADD EAX,ImageBase
		MOV ECX,PackedOEP
		SUB ECX,EAX
		SUB ECX,5
		MOV DWORD PTR[EBX],ECX

		MOV EAX,RawSize
		LEA EBX,DWORD PTR[EDX+((offset __L_STUB_VA_SIZE - offset __L_DLL_STUB_START))+1]
		MOV DWORD PTR[EBX],EAX
		LEA EBX,DWORD PTR[EDX+((offset __L_STUB_VF_SIZE - offset __L_DLL_STUB_START))+1]
		MOV DWORD PTR[EBX],EAX
	
		LEA EBX,DWORD PTR[EDX+((offset __L_iat - offset __L_DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EBX

		MOV EBX,PEHeader
		MOV DWORD PTR[EBX+80h],EAX
		MOV DWORD PTR[EBX+84h],28h
		LEA EAX,DWORD PTR[EDX+((offset __L_WIN9x_RELOCATION - offset __L_DLL_STUB_START))]
		INVOKE ConvertFO2VA,hPackedFileBuff,EAX
		MOV DWORD PTR[EBX+0A0h],EAX
		MOV DWORD PTR[EBX+0A4h],8
	.endif

;------------------------------------------------------------------

	CALL FindMainIcon

;------------------------------------------------------------------
; Load Resources
;
;

	PUSH offset szPackingResources
	CALL _show_log_message

	PUSH MAIN_ICON

	MOV pFirst,1
	MOV EBX,FileMapVA
	ADD EBX,3Ch
	ADD BX,WORD PTR[EBX]		;WinME/98/95 compatibility!
	SUB BX,3Ch			;

	MOV PEHeader,EBX
	MOV EAX,DWORD PTR[EBX+88h]
	.if EAX != 0
		ADD EAX,ImageBase
		INVOKE ConvertVA2FO,FileMapVA,EAX
		ADD EAX,FileMapVA
		MOV pRSRC,EAX

		MOVZX EBX,WORD PTR[EAX+12]
		ADD BX,WORD PTR[EAX+14]
		MOV Level1_CNT,EBX
		ADD EAX,16
		.while Level1_CNT > 0
			MOV EBX,DWORD PTR[EAX]
			MOV pType,EBX
			MOV EBX,DWORD PTR[EAX+4]
			XOR EBX,80000000h
			ADD EBX,pRSRC
			MOVZX ECX,WORD PTR[EBX+12]
			ADD CX,WORD PTR[EBX+14]
			MOV Level2_CNT,ECX
			ADD EBX,16
                        .while Level2_CNT > 0
				MOV ECX,DWORD PTR[EBX]
				MOV pName,ECX
				MOV ECX,DWORD PTR[EBX+4]
				XOR ECX,80000000h
				ADD ECX,pRSRC
				MOVZX EDX,WORD PTR[ECX+12]
				ADD DX,WORD PTR[ECX+14]
				MOV Level3_CNT,EDX
				ADD ECX,16
				.while Level3_CNT > 0
					MOV EDX,DWORD PTR[ECX+4]
					ADD EDX,pRSRC
					MOV EDI,DWORD PTR[EDX]
					MOV pDataRVA,EDI
					MOV EDI,DWORD PTR[EDX+4]
					MOV pSize,EDI

					.if pFirst == 1
						MOV pFirst,0
						PUSHAD
						MOV EAX,pDataRVA
						ADD EAX,ImageBase
						INVOKE ConvertVA2FO,FileMapVA,EAX
						ADD EAX,FileMapVA
						SUB EAX,pRSRC
						MOV RSRCSize,EAX
						PUSHAD
						ADD EAX,500000h
						MOV pRSRCBuffSize,EAX
						INVOKE VirtualAlloc,NULL,EAX,MEM_COMMIT,PAGE_EXECUTE_READWRITE
						MOV pRSRCBuff,EAX
						MOV pRSRCBuffPos,EAX
						INVOKE RtlMoveMemory,pRSRCBuff,pRSRC,RSRCSize
						MOV EAX,RSRCSize
						ADD pRSRCBuffPos,EAX
						POPAD
						POPAD
					.endif
					PUSHAD
					MOV rPack,0
					MOV EAX,pType
					MOV EBX,offset rawbuffer
					.while DWORD PTR[EBX] != 0
						.if DWORD PTR[EBX] == EAX
							MOV rPack,1
						.endif
						ADD EBX,4
					.endw
					POPAD
					.if pType == 03h || pType == 0Eh || pType == 18h || rPack == 1
						PUSHAD
						.if ((pType == 03h) && (MAIN_ICON > 0)) || (pType != 03h) || rPack == 1
							.if pType == 03h
								DEC MAIN_ICON
							.endif
							MOV EAX,pDataRVA
							ADD EAX,ImageBase
							INVOKE ConvertVA2FO,FileMapVA,EAX
							ADD EAX,FileMapVA
							MOV EBX,SizeOfImage
							ADD EBX,1000h
							MOV ECX,hPackedFilePos
							SUB ECX,hPackedFileBuff
							SUB ECX,200h
							ADD ECX,EBX
							MOV EBX,pRSRCBuffPos
							SUB EBX,pRSRCBuff
							ADD ECX,EBX

							PUSHAD
							INVOKE RtlMoveMemory,pRSRCBuffPos,EAX,pSize
							MOV EAX,pSize
							ADD pRSRCBuffPos,EAX
							POPAD

							SUB EDX,pRSRC
							ADD EDX,pRSRCBuff
							MOV DWORD PTR[EDX],ECX
						.endif
						POPAD
					.endif

					ADD ECX,8
					DEC Level3_CNT
				.endw
				ADD EBX,8
				DEC Level2_CNT
                        .endw
			ADD EAX,8
			DEC Level1_CNT
		.endw

		MOV EBX,hPackedFileBuff
		ADD EBX,3Ch
		ADD BX,WORD PTR[EBX]		;WinME/98/95 compatibility!
		SUB BX,3Ch			;

		MOV PEHeader,EBX
	
		MOV EBX,SizeOfImage
		ADD EBX,1000h
		MOV ECX,hPackedFilePos
		SUB ECX,hPackedFileBuff
		SUB ECX,200h
		ADD ECX,EBX

		MOV EAX,pRSRCBuffPos
		SUB EAX,pRSRCBuff
		PUSH EAX
		PUSH pRSRCBuff
		CALL WriteData
	
		MOV EAX,PEHeader
		MOV DWORD PTR[EAX+88h],ECX
		MOV ECX,pRSRCBuffPos
		SUB ECX,pRSRCBuff
		MOV DWORD PTR[EAX+8Ch],ECX
	.endif

	POP MAIN_ICON

       	CALL FixPackedHeader

;------------------------------------------------------------------
; Write packed file to disk
;
;
	INVOKE UnmapFile

	INVOKE CreateOutFile,addr szOpenFileName
	MOV EAX,hPackedFilePos
	SUB EAX,hPackedFileBuff
	INVOKE WriteFile,hPackedFile,hPackedFileBuff,EAX,addr NumberOfBytesWritten,NULL
	INVOKE CloseOutFile

;------------------------------------------------------------------
; Copy Overlay
;

	.if oOverlay == 1 && OverlayExists > 0
		PUSH offset szSaveOverlay
		CALL _show_log_message
		INVOKE AddOverlay,addr szOpenFileName,addr szTMP
		INVOKE DeleteFile,addr szTMP
	.endif

;------------------------------------------------------------------
; Free memory
;
;

	INVOKE VirtualFree,pRSRCBuff,pRSRCBuffSize,MEM_DECOMMIT
	INVOKE VirtualFree,DLLNameBuff_Base,500000h,MEM_DECOMMIT
	INVOKE VirtualFree,APINameBuff_Base,500000h,MEM_DECOMMIT

	MOV EAX,FileSize
	ADD EAX,500000h
	INVOKE VirtualFree,hPackedFileBuff,EAX,MEM_DECOMMIT

	PUSH offset szFilePacked
	CALL _show_log_message

	INVOKE MapFile,addr szOpenFileName

	MOV EAX,FileSize
	MOV PackedSize,EAX
	PUSH EAX
	PUSH offset PSize_format
	PUSH offset buffer
	CALL wsprintf
	ADD ESP,0Ch
	PUSH 604
	PUSH DWORD PTR DS:[HW]
	CALL GetDlgItem
	PUSH offset buffer
	PUSH EAX
	CALL SetWindowText

	INVOKE UnmapFile

	MOV Ratio,0

	FILD PackedSize
	FILD OriginalSize
	FDIV ST(1),ST(0)
	FILD Hundred
	FMUL ST(0),ST(2)
	FIST Ratio

	PUSH Ratio
	PUSH offset Ratio_format
	PUSH offset buffer
	CALL wsprintf
	ADD ESP,0Ch
	PUSH 605
	PUSH DWORD PTR DS:[HW]
	CALL GetDlgItem
	PUSH offset buffer
	PUSH EAX
	CALL SetWindowText
 ERROR_EXIT:

	PUSH offset szPackEnded
	CALL _show_log_message

	MOV ThreadRunning,0
	POPAD
	RET
;
; Kraj packera
;------------------------------------------------------------------
; Predefinisane funkcije
;------------------------------------------------------------------
CompressSection PROC inDestionation:DWORD,inSource:DWORD,inSize:DWORD
	LOCAL CompressedSize :DWORD
	LEA EAX,DWORD PTR[CompressedSize]

	PUSH offset lProgress
	PUSH EAX
	PUSH inSize
	PUSH inSource
	CALL DWORD PTR[hCompress]
	.if EAX == 0
		MOV CompressedSize,-1
	.endif

	INVOKE RtlMoveMemory,inDestionation,eax,CompressedSize
	CALL DWORD PTR[hFreeCompressionMemory]

	MOV EAX,CompressedSize
	RET
CompressSection ENDP
;------------------------------------------------------------------
lProgress PROC dwPercent:DWORD
	LOCAL hwndProgress :DWORD
	PUSHAD

	MOV EAX,dwPercent
	.if EAX > LastRatio
		MOV LastRatio,EAX
	        INVOKE GetDlgItem,HW,900
	        MOV hwndProgress,EAX
	        INVOKE SendMessage,hwndProgress,PBM_SETPOS,LastRatio,0
	.endif

	POPAD
	XOR EAX,EAX
	MOV AL,1
	RET
lProgress ENDP
;------------------------------------------------------------------
GetSectionNumber PROC fMap:DWORD,fAddr:DWORD

	LOCAL Converted :DWORD

	PUSHAD
 ;
 ; Konverzija
 ;
	MOV EAX,fMap		; Parametar 1 = FileMapVA
	MOV EBX,fAddr		; Parametar 2 = Adresa za konverziju
	SUB EBX,DWORD PTR[ImageBase]
 ;
 ; elfa_new
 ;
	XOR ECX,ECX
	MOV CX,WORD PTR[EAX+3Ch]
 ;
 ; PEHeader
 ;
	LEA ECX,DWORD PTR[EAX+ECX]
	MOV EAX,ECX
 ;
 ; NumberOfSections
 ;
	XOR ECX,ECX
	MOV CX,WORD PTR[EAX+6]
 ;
 ; Section Tabela
 ;
	ADD AX,WORD PTR[EAX+14h]
	ADD EAX,018h
	.while ECX > 0
		MOV EDX,DWORD PTR[EAX+8]
		MOV EDI,DWORD PTR[EAX+12]
		.if EBX >= EDI
			ADD EDI,EDX
			.if EBX < EDI
				MOV EBX,ECX
				MOV ECX,1
			.endif
		.endif
	ADD EAX,28h
	DEC ECX
	.endw
	MOV DWORD PTR[Converted],EBX
 ; 
 ; Izlaz iz konverzije
 ;
	POPAD
	MOV EAX,DWORD PTR[Converted]
	RET
GetSectionNumber ENDP
;------------------------------------------------------------------
ExtractOverlay proc szFname:DWORD,szSaveFileName:DWORD
	LOCAL Return :DWORD
	PUSHAD
	MOV Return,0
	MOV FileMapVA,0
	INVOKE MapFile,szFname

	.if FileMapVA != 0
		MOV EAX,FileMapVA
		ADD EAX,3Ch
		ADD AX,WORD PTR[EAX]		;WinME/98/95 compatibility!
		SUB AX,3Ch			;
		MOV PEHeader,EAX
		MOVZX EBX,WORD PTR[EAX+6h]
		MOV NumberOfSections,EBX
		ADD AX,WORD PTR[EAX+14h]
		ADD EAX,18h
		MOV ECX,NumberOfSections
		DEC ECX
		IMUL ECX,28h
		ADD EAX,ECX
		ADD EAX,8
	
		MOV EBX,DWORD PTR[EAX+8]
		MOV RawSize,EBX
		MOV EBX,DWORD PTR[EAX+12]
		MOV RawOffset,EBX
	
		XOR EAX,EAX
		ADD EAX,RawOffset
		ADD EAX,RawSize
		.if EAX < FileSize
			MOV EBX,FileSize
			SUB EBX,EAX
			ADD EAX,FileMapVA
			MOV eStart,EAX
			MOV eSize,EBX
	
			INVOKE CreateFile,szSaveFileName,GENERIC_WRITE,NULL,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL
			MOV hSaveFile,EAX
			INVOKE WriteFile,hSaveFile,eStart,eSize,addr NumberOfBytesWritten,NULL
			INVOKE CloseHandle,hSaveFile
			MOV EAX,eSize
			MOV Return,EAX	;Size of extracted file
		.else
			MOV Return,0h	;No overlay
		.endif
	.else
		MOV Return,-1		;Could not map file
	.endif

	INVOKE UnmapFile
	POPAD
	MOV EAX,Return
	RET
ExtractOverlay endp
;------------------------------------------------------------------
AddOverlay proc szFname:DWORD,szOvlFName:DWORD
	LOCAL Return :DWORD
	LOCAL CopyAlloc :DWORD
	LOCAL CopySize :DWORD
	LOCAL CopyStart :DWORD
	PUSHAD
	MOV Return,0
	MOV FileMapVA,0
	INVOKE MapFile,szOvlFName

	.if FileMapVA != 0
		MOV EAX,FileSize
		MOV CopySize,EAX
		INVOKE VirtualAlloc,NULL,CopySize,MEM_COMMIT,PAGE_READWRITE
		MOV CopyAlloc,EAX
		INVOKE RtlMoveMemory,CopyAlloc,FileMapVA,CopySize
		INVOKE UnmapFile

               	INVOKE MapFile,szFname
		MOV EAX,FileSize
               	MOV CopyStart,EAX
		INVOKE UnmapFile

		INVOKE ResizeMapFile,szFname,CopySize
		MOV EAX,FileMapVA
		ADD CopyStart,EAX
		INVOKE RtlMoveMemory,CopyStart,CopyAlloc,CopySize
		INVOKE UnmapFile

		INVOKE VirtualFree,CopyAlloc,CopySize,MEM_DECOMMIT
		MOV Return,1		;Success
	.else
		MOV Return,0		;Could not map file
	.endif

	POPAD
	MOV EAX,Return
	RET
AddOverlay endp
;------------------------------------------------------------------
initProgress PROC
	LOCAL hwndProgress :DWORD
	PUSHAD
	MOV LastRatio,0
        INVOKE GetDlgItem,HW,900
        MOV hwndProgress,EAX
        INVOKE SendMessage,hwndProgress,PBM_SETPOS,LastRatio,0
	POPAD
	RET
initProgress ENDP
;------------------------------------------------------------------
cProgress PROC C inLen:DWORD,inCompressed:DWORD,outCompressed:DWORD,Cparam:DWORD
	LOCAL hwndProgress :DWORD
	PUSHAD

	MOV EAX,inCompressed
	CDQ
	MOV ECX,100
	IMUL ECX
	DIV inLen

	.if EAX > LastRatio
		MOV LastRatio,EAX
	        INVOKE GetDlgItem,HW,900
	        MOV hwndProgress,EAX

	        INVOKE SendMessage,hwndProgress,PBM_SETPOS,LastRatio,0
	.endif

	POPAD
	MOV EAX,1
	RET
cProgress ENDP
;------------------------------------------------------------------
FindMainIcon PROC

	LOCAL fRSRC1	:DWORD
	LOCAL pRSRC1	:DWORD

	PUSHAD
	MOV EBX,FileMapVA
	ADD EBX,3Ch
	ADD BX,WORD PTR[EBX]		;WinME/98/95 compatibility!
	SUB BX,3Ch			;

	MOV EAX,DWORD PTR[EBX+88h]
	MOV EBX,DWORD PTR[EBX+8Ch]
	PUSH EAX
	PUSH EBX
	INVOKE VirtualAlloc,NULL,EBX,MEM_COMMIT,PAGE_EXECUTE_READWRITE
	MOV pRSRC1,EAX
	POP EBX
	POP EAX
	PUSHAD

	ADD EAX,ImageBase
	INVOKE ConvertVA2FO,FileMapVA,EAX
	MOV fRSRC1,EAX
	ADD EAX,FileMapVA

	INVOKE RtlMoveMemory,pRSRC1,EAX,EBX
	POPAD
	.if EAX != 0
		MOV EAX,pRSRC1

		MOVZX EBX,WORD PTR[EAX+12]
		ADD BX,WORD PTR[EAX+14]
		MOV Level1_CNT,EBX
		ADD EAX,16
		.while Level1_CNT > 0
			MOV EBX,DWORD PTR[EAX]
			MOV pType,EBX
			MOV EBX,DWORD PTR[EAX+4]
			XOR EBX,80000000h
			ADD EBX,pRSRC1
			MOVZX ECX,WORD PTR[EBX+12]
			ADD CX,WORD PTR[EBX+14]
			MOV Level2_CNT,ECX
			ADD EBX,16
                        .while Level2_CNT > 0
				MOV ECX,DWORD PTR[EBX]
				MOV pName,ECX
				MOV ECX,DWORD PTR[EBX+4]
				XOR ECX,80000000h
				ADD ECX,pRSRC1
				MOVZX EDX,WORD PTR[ECX+12]
				ADD DX,WORD PTR[ECX+14]
				MOV Level3_CNT,EDX
				ADD ECX,16
				.while Level3_CNT > 0
					MOV EDX,DWORD PTR[ECX+4]
					ADD EDX,pRSRC1
					MOV EDI,DWORD PTR[EDX]
					MOV pDataRVA,EDI
					MOV EDI,DWORD PTR[EDX+4]
					MOV pSize,EDI

					.if pType == 03h || pType == 0Eh || pType == 18h || rPack == 1
						PUSHAD
						MOV EAX,pDataRVA
						ADD EAX,ImageBase
						INVOKE ConvertVA2FO,FileMapVA,EAX
						ADD EAX,pRSRC1
						SUB EAX,fRSRC1
						.if pType == 0Eh && MAIN_ICON == 0
							PUSHAD
							MOVZX EAX,BYTE PTR[EAX+4]
							MOV MAIN_ICON,EAX
							POPAD
						.endif
						POPAD
					.endif

					ADD ECX,8
					DEC Level3_CNT
				.endw
				ADD EBX,8
				DEC Level2_CNT
                        .endw
			ADD EAX,8
			DEC Level1_CNT
		.endw
		MOV EBX,FileMapVA
		ADD EBX,3Ch
		ADD BX,WORD PTR[EBX]		;WinME/98/95 compatibility!
		SUB BX,3Ch			;

		MOV EBX,DWORD PTR[EBX+8Ch]
		INVOKE VirtualFree,pRSRC1,EBX,MEM_DECOMMIT
	.endif
	POPAD
	RET
FindMainIcon ENDP
;------------------------------------------------------------------
RSRCPack PROC

	LOCAL fRSRC	:DWORD
	LOCAL sRSRC	:DWORD

	PUSHAD
	MOV pFirst,1
	PUSH MAIN_ICON
	MOV EBX,FileMapVA
	ADD EBX,3Ch
	ADD BX,WORD PTR[EBX]		;WinME/98/95 compatibility!
	SUB BX,3Ch			;

	MOV EAX,DWORD PTR[EBX+88h]
	MOV EBX,DWORD PTR[EBX+8Ch]
	PUSH EAX
	PUSH EBX
	INVOKE VirtualAlloc,NULL,EBX,MEM_COMMIT,PAGE_EXECUTE_READWRITE
	MOV pRSRC,EAX
	POP EBX
	POP EAX
	PUSHAD

	ADD EAX,ImageBase
	INVOKE ConvertVA2FO,FileMapVA,EAX
	MOV fRSRC,EAX
	ADD EAX,FileMapVA

	INVOKE RtlMoveMemory,pRSRC,EAX,EBX
	POPAD
	.if EAX != 0
		PUSH EBX
		MOV EAX,pRSRC

		MOVZX EBX,WORD PTR[EAX+12]
		ADD BX,WORD PTR[EAX+14]
		MOV Level1_CNT,EBX
		ADD EAX,16
		.while Level1_CNT > 0
			MOV EBX,DWORD PTR[EAX]
			MOV pType,EBX
			MOV EBX,DWORD PTR[EAX+4]
			XOR EBX,80000000h
			ADD EBX,pRSRC
			MOVZX ECX,WORD PTR[EBX+12]
			ADD CX,WORD PTR[EBX+14]
			MOV Level2_CNT,ECX
			ADD EBX,16
                        .while Level2_CNT > 0
				MOV ECX,DWORD PTR[EBX]
				MOV pName,ECX
				MOV ECX,DWORD PTR[EBX+4]
				XOR ECX,80000000h
				ADD ECX,pRSRC
				MOVZX EDX,WORD PTR[ECX+12]
				ADD DX,WORD PTR[ECX+14]
				MOV Level3_CNT,EDX
				ADD ECX,16
				.while Level3_CNT > 0
					MOV EDX,DWORD PTR[ECX+4]
					ADD EDX,pRSRC
					MOV EDI,DWORD PTR[EDX]
					MOV pDataRVA,EDI
					MOV EDI,DWORD PTR[EDX+4]
					MOV pSize,EDI

;					.if pFirst == 1
;						MOV pFirst,0
;						PUSHAD
;						MOV EAX,pDataRVA
;						ADD EAX,ImageBase
;						INVOKE ConvertVA2FO,FileMapVA,EAX
;						SUB EAX,fRSRC
;						MOV sRSRC,EAX
;						POPAD
;					.endif
					PUSHAD
					MOV rPack,0
					MOV EAX,pType
					MOV EBX,offset rawbuffer
					.while DWORD PTR[EBX] != 0
						.if DWORD PTR[EBX] == EAX
							MOV rPack,1
						.endif
						ADD EBX,4
					.endw
					POPAD
					.if (pType == 03h && MAIN_ICON > 0) || rPack == 1
						PUSHAD
						DEC MAIN_ICON
						MOV EAX,pDataRVA
						ADD EAX,ImageBase
						INVOKE ConvertVA2FO,FileMapVA,EAX
						ADD EAX,pRSRC
						SUB EAX,fRSRC
						INVOKE RtlZeroMemory,EAX,pSize
						POPAD
					.endif
					.if pType == 0Eh || pType == 18h || rPack == 1
						PUSHAD
						MOV DWORD PTR[EDX],0
						MOV DWORD PTR[EDX+4],0
						MOV DWORD PTR[EBX],0
						MOV DWORD PTR[EBX+4],0
						MOV DWORD PTR[EAX],0
						MOV DWORD PTR[EAX+4],0
						MOV EAX,pDataRVA
						ADD EAX,ImageBase
						INVOKE ConvertVA2FO,FileMapVA,EAX
						ADD EAX,pRSRC
						SUB EAX,fRSRC
						INVOKE RtlZeroMemory,EAX,pSize
						POPAD
					.endif

					ADD ECX,8
					DEC Level3_CNT
				.endw
				ADD EBX,8
				DEC Level2_CNT
                        .endw
			ADD EAX,8
			DEC Level1_CNT
		.endw
		POP EBX
		MOV pSize,EBX
		MOV EAX,pRSRC
		MOV CompressSectionOffset,EAX
;		INVOKE RtlZeroMemory,pRSRC,sRSRC
	.endif
	POP MAIN_ICON
	POPAD
	RET
RSRCPack ENDP
;------------------------------------------------------------------
FixPackedHeader:
	MOV EAX,PEHeader
	ADD AX,WORD PTR[EAX+14h]
	ADD EAX,18h
	MOV ECX,SizeOfImage
	MOV DWORD PTR[EAX+8],ECX
	ADD EAX,28h
	ADD ECX,1000h
	PUSH ECX
	MOV DWORD PTR[EAX+12],ECX
	MOV ECX,hPackedFilePos
	SUB ECX,hPackedFileBuff
	SUB ECX,200h
	PUSH ECX
	MOV DWORD PTR[EAX+8],ECX
	MOV DWORD PTR[EAX+16],ECX
	MOV ECX,200h
	MOV DWORD PTR[EAX+20],ECX
	POP EDX
	POP ECX
	ADD ECX,EDX
	MOV EAX,PEHeader
	MOV DWORD PTR[EAX+50h],ECX
	RET
;------------------------------------------------------------------
WriteData PROC CopyOffset:DWORD,CopySize:DWORD
	PUSHAD

	INVOKE RtlMoveMemory,hPackedFilePos,CopyOffset,CopySize
	MOV EAX,CopySize
	ADD hPackedFilePos,EAX

	POPAD
	RET
WriteData ENDP
;------------------------------------------------------------------
IsSectionPackable PROC SectionName:DWORD
	LOCAL Compare	:DWORD
	PUSHAD
	MOV Compare,0

	INVOKE lstrcmp,SectionName,addr szSN_reloc
	.if EAX == 0 && oStripReloc == 1 && IsDll == 0
		MOV Compare,2
	.elseif EAX == 0 && oStripReloc == 0 && IsDll == 1
		MOV Compare,1
	.elseif EAX == 0 && IsDll == 1
		MOV Compare,1
	.endif
	INVOKE lstrcmp,SectionName,addr szSN_tls
	.if EAX == 0 && oStripTLS == 0
		MOV Compare,1
	.elseif EAX == 0 && oStripTLS == 1
		MOV Compare,2
	.endif
	INVOKE lstrcmp,SectionName,addr szSN_bss
	.if EAX == 0
		MOV Compare,2
	.endif
	INVOKE lstrcmp,SectionName,addr szSN_Ddata
	.if EAX == 0
		MOV Compare,1
	.endif
	INVOKE lstrcmp,SectionName,addr szSN_text
	.if EAX == 0
		MOV Compare,1
	.endif
	INVOKE lstrcmp,SectionName,addr szSN_code
	.if EAX == 0
		MOV Compare,1
	.endif
	INVOKE lstrcmp,SectionName,addr szSN_data
	.if EAX == 0
		MOV Compare,1
	.endif
	INVOKE lstrcmp,SectionName,addr szSN_rdata
	.if EAX == 0
		MOV Compare,1
	.endif
	INVOKE lstrcmp,SectionName,addr szSN_edata
	.if EAX == 0
		MOV Compare,2
	.endif
	INVOKE lstrcmp,SectionName,addr szSN_idata
	.if EAX == 0
		MOV Compare,2
	.endif
	INVOKE lstrcmp,SectionName,addr szSN_rsrc
	.if EAX == 0
		MOV Compare,3
	.endif

	POPAD
	MOV EAX,Compare
	RET
IsSectionPackable ENDP
;------------------------------------------------------------------
ConvertVA2FO PROC fMap:DWORD,fAddr:DWORD

	LOCAL Converted :DWORD

	PUSHAD
 ;
 ; Konverzija
 ;
	MOV EAX,fMap		; Parametar 1 = FileMapVA
	MOV EBX,fAddr		; Parametar 2 = Adresa za konverziju
	SUB EBX,DWORD PTR[ImageBase]
 ;
 ; elfa_new
 ;
	XOR ECX,ECX
	MOV CX,WORD PTR[EAX+3Ch]
 ;
 ; PEHeader
 ;
	LEA ECX,DWORD PTR[EAX+ECX]
	MOV EAX,ECX
 ;
 ; NumberOfSections
 ;
	XOR ECX,ECX
	MOV CX,WORD PTR[EAX+6]
 ;
 ; Section Tabela
 ;
	ADD AX,WORD PTR[EAX+14h]
	ADD EAX,018h
	.while ECX > 0
		MOV EDX,DWORD PTR[EAX+8]
		MOV EDI,DWORD PTR[EAX+12]
		.if EBX >= EDI
			ADD EDI,EDX
			.if EBX < EDI
				MOV ECX,1
				SUB EBX,EDI
				ADD EBX,EDX
				ADD EBX,DWORD PTR[EAX+20]
;				ADD EBX,DWORD PTR[EBP+8]
			.endif
		.endif
	ADD EAX,28h
	DEC ECX
	.endw
	MOV DWORD PTR[Converted],EBX
 ; 
 ; Izlaz iz konverzije
 ;
	POPAD
	MOV EAX,DWORD PTR[Converted]
	RET
ConvertVA2FO ENDP
;------------------------------------------------------------------
ConvertFO2VA PROC fMap:DWORD,fAddr:DWORD

	LOCAL Converted :DWORD

	PUSHAD
 ; 
 ; Konverzija
 ;
	MOV EAX,fMap		; Parametar 1 = FileMapVA
	MOV EBX,fAddr		; Parametar 2 = Adresa za konverziju
	SUB EBX,EAX
 ;
 ; elfa_new
 ;
	XOR ECX,ECX
	MOV CX,WORD PTR[EAX+3Ch]
 ;
 ; PEHeader
 ;
	LEA ECX,DWORD PTR[EAX+ECX]
	MOV EAX,ECX
 ;
 ; NumberOfSections
 ;
	XOR ECX,ECX
	MOV CX,WORD PTR[EAX+6]
 ;
 ; Section Tabela
 ;
	ADD AX,WORD PTR[EAX+14h]
	ADD EAX,018h
	.while ECX > 0
		MOV EDX,DWORD PTR[EAX+16]
		MOV EDI,DWORD PTR[EAX+20]
		.if EBX >= EDI
			ADD EDI,EDX
			.if EBX <= EDI
				MOV ECX,1
				SUB EBX,EDI
				ADD EBX,EDX
				ADD EBX,DWORD PTR[EAX+12]
;				ADD EBX,DWORD PTR[ImageBase]
			.endif
		.endif
	ADD EAX,28h
	DEC ECX
	.endw
	MOV DWORD PTR[Converted],EBX
 ; 
 ; Izlaz iz konverzije
 ;
	POPAD
	MOV EAX,DWORD PTR[Converted]
	RET
ConvertFO2VA ENDP
;------------------------------------------------------------------
GetExeFile PROC
	PUSHAD

        INVOKE GetModuleHandle,NULL
        MOV DWORD PTR[hInstance],EAX

	PUSH 260
	PUSH offset buffer
	CALL RtlZeroMemory

	MOV ofn.lStructSize,SIZEOF ofn
	MOV ofn.lpstrFilter, OFFSET FilterString
	MOV ofn.lpstrFile, OFFSET buffer
	MOV ofn.nMaxFile,512
	MOV ofn.Flags, OFN_FILEMUSTEXIST or \
			OFN_PATHMUSTEXIST or OFN_LONGNAMES or\
			OFN_EXPLORER or OFN_HIDEREADONLY
	MOV  ofn.lpstrTitle, OFFSET OurTitle
	INVOKE GetOpenFileName, ADDR ofn

	INVOKE lstrcpy,addr szOpenFileName,addr buffer
	INVOKE lstrcpy,addr szPackedFileName,addr buffer
	INVOKE lstrcat,addr szPackedFileName,addr szPackedExe
	.if BYTE PTR[szOpenFileName] == 0
		INVOKE MessageBox,NULL,addr szErrorText,addr szErrorTitle,30h
	.endif

	POPAD
	RET
GetExeFile ENDP
;------------------------------------------------------------------
CreateOutFile PROC fName:DWORD
	PUSHAD
	INVOKE CreateFile,fName,GENERIC_WRITE,NULL,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL
	.if EAX == -1
		INVOKE MessageBox,NULL,addr szErrorText,addr szErrorTitle,30h
		INVOKE ExitProcess,NULL
	.endif
	MOV DWORD PTR[hPackedFile],EAX
	POPAD
	RET
CreateOutFile ENDP
;------------------------------------------------------------------
CloseOutFile PROC
	PUSHAD
        INVOKE CloseHandle,DWORD PTR[hPackedFile]
	POPAD
	RET
CloseOutFile ENDP
;------------------------------------------------------------------
MapFile PROC fName:DWORD
	PUSHAD
	INVOKE CreateFile,DWORD PTR[EBP+8],GENERIC_READ+GENERIC_WRITE,NULL,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
	.if EAX == -1
		INVOKE MessageBox,NULL,addr szErrorText,addr szErrorTitle,30h
		POPAD
		RET
	.endif
	MOV DWORD PTR[FileHWND],EAX
	INVOKE GetFileSize,DWORD PTR[FileHWND],NULL
	MOV DWORD PTR[FileSize],EAX
	INVOKE CreateFileMapping,DWORD PTR[FileHWND],NULL,4,NULL,DWORD PTR[FileSize],NULL
	MOV DWORD PTR[FileMap],EAX
	INVOKE MapViewOfFile,DWORD PTR[FileMap],2,NULL,NULL,NULL
	MOV DWORD PTR[FileMapVA],EAX
	POPAD
	RET
MapFile ENDP
;------------------------------------------------------------------
UnmapFile PROC
	PUSHAD
	INVOKE UnmapViewOfFile,DWORD PTR[FileMapVA]
	INVOKE CloseHandle,DWORD PTR[FileMap]
	INVOKE SetFilePointer,DWORD PTR[FileHWND],DWORD PTR[FileSize],NULL,NULL
	INVOKE SetEndOfFile,DWORD PTR[FileHWND]
	INVOKE CloseHandle,DWORD PTR[FileHWND]
	POPAD
	RET
UnmapFile ENDP
;------------------------------------------------------------------
ResizeMapFile PROC fName:DWORD,fSize:DWORD
	PUSHAD
	INVOKE CreateFile,DWORD PTR[EBP+8],GENERIC_READ+GENERIC_WRITE,NULL,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
	.if EAX == -1
		POPAD
		RET
	.endif
	MOV DWORD PTR[FileHWND],EAX
	INVOKE GetFileSize,DWORD PTR[FileHWND],NULL
	MOV DWORD PTR[FileSize],EAX
	MOV EAX,DWORD PTR[EBP+12]
	ADD DWORD PTR[FileSize],EAX
	INVOKE CreateFileMapping,DWORD PTR[FileHWND],NULL,4,NULL,DWORD PTR[FileSize],NULL
	MOV DWORD PTR[FileMap],EAX
	INVOKE MapViewOfFile,DWORD PTR[FileMap],2,NULL,NULL,NULL
	MOV DWORD PTR[FileMapVA],EAX
	POPAD
	RET
ResizeMapFile ENDP
;------------------------------------------------------------------
     _show_log_message:
	PUSH EBP
	MOV EBP,ESP
	PUSHAD
	PUSH [EBP+8]
	PUSH 0
	PUSH 180h
	PUSH [BoxHwnd]
	CALL SendMessage
	PUSH 0
	PUSH 0
	PUSH 18Bh
	PUSH [BoxHwnd]
	CALL SendMessage
	DEC EAX
	PUSH 0
	PUSH EAX
	PUSH 186h
	PUSH [BoxHwnd]
	CALL SendMessage
	POPAD
	LEAVE
	RET 4
;------------------------------------------------------------------
     _show_log_message_2:
	PUSH EBP
	MOV EBP,ESP
	PUSHAD
	PUSH [EBP+8]
	PUSH 0
	PUSH 180h
	PUSH [BoxHwnd]
	CALL SendMessage
	POPAD
	LEAVE
	RET 4
;------------------------------------------------------------------
    _convert_text_2_number:
	PUSH EBP
	MOV EBP,ESP
	PUSH ECX
	PUSH EDX
	PUSH EBX
	PUSH ESI
	PUSH EDI
	MOV EDI,DWORD PTR SS:[EBP+8]
	MOV ESI,DWORD PTR SS:[EBP+8]
    L007:
	MOV AL,BYTE PTR DS:[EDI]
	INC EDI
	OR AL,AL
	JNE L007
	SUB ESI,EDI
	XOR EBX,EBX
	ADD EDI,ESI
	XOR EDX,EDX
	NOT ESI
	JMP L033
    L017:
	MOV AL,BYTE PTR DS:[EDI]
	CMP AL,41h
	JB L025
	SUB AL,57h
	ADC DL,0
	SHL DL,5
	ADD AL,DL
	JMP L026
    L025:
	SUB AL,30h
    L026:
	LEA ECX,DWORD PTR DS:[ESI-1]
	AND EAX,0Fh
	SHL ECX,2
	SHL EAX,CL
	ADD EBX,EAX
	INC EDI
	DEC ESI
    L033:
	OR ESI,ESI
	JNE L017
	MOV EAX,EBX
	POP EDI
	POP ESI
	POP EBX
	POP EDX
	POP ECX
	LEAVE
	RET 4
;------------------------------------------------------------------
	include Stub_aplib.asm
	include Stub_lzma.asm

end start