/*

DUMPCAB.C Dump Cabinet Files
Clive Turvey, Electronics Engineer, June 1995, April 1997, December 1998
Copyright (C) Tenth Planet Software Intl., Clive Turvey 1995-1998. All rights reserved.

Compiled using Microsoft C/C++ v8.00 (Visual C/C++ v1.00)

******************************************************************************

 ====     ===
  \\      / th
   \\    /
    \\  /  Planet
     \\/    Software
     /\\     International
    /  \\
   /    \\
  /      \\
 ===     ====

     Copyright (C) Tenth Planet Software Intl., C Turvey 1995-1998.
                 Chicago USA & Southampton ENGLAND.

                     CompuServe ID 74011,1732
         Email : 74011.1732@compuserve.com, clive@tbcnet.com

******************************************************************************

This file was created through examination of FDI.LIB and pulling apart
actual .CABs and self extract archives. The primary compression algorithm
is MSZIP which *IS* PK ZIP's Inflate algorithm. Microsoft uses a library
which is based, heavily I might add, on Mark Alder's public domain
INFLATE.C (can be found on several shareware disks, I found mine on NEWT).
Microsoft also uses Mark's code in their KWAJ compression and DriveSpace 3
Ultrapack compression. Go Phil Katz, Go Mark Alder... Code reuse I guess?

The PK Inflate algorithm uses 32K blocks, using stored, fixed or dynamic
huffman tables. The sliding window is also 32K. Microsoft use a 'CK'
(not Calvin Klein, but Chris Kirmse) signature for MSZIP (& KWAJ Mode 4)
blocks.

The second algorithm supported is called Quantum, I have examples of such
files but have not figured out all the ins and outs. It does however support
a sliding window of upto 2MB (yes two megabytes!) which should allow some
serious compression to occur. But you'll probably won't see this used under
DOS! The compressed blocks are packeted in 32K chunks (uncompressed).

The third algorithm supported is called LZX which can have a window from
32KB to 2MB.

Provision for encryption is also provided in Cabinets, I personally have
not seen any, but it exists. It relates to the CAB_FLAG_RESERVE flag and
causes extra fields to appear in the Header, Folder & Data structures.

Some improvements were made in the wake of Sven Schreiber's May 97 DDJ
article, mainly the renaming of some field and adding defines to match
Sven's. I had not labeled some structure fields as the decompressors
ignored them. My structure names CFHEADER, CFDATA.. do match Microsoft's
naming. Sven's CI$ address is 100557.177@compuserve.com and his code is
almost certainly available from www.ddj.com

There is an amazing amount of info in the FDI.LIB, Codeview Symbols &
Type Information, Procedure data.

This code was designed to run under DOS (It should compile as a Win32
console, it just runs on more platforms like this). It is a work in
progress, I have versions which dump actual decompressed data and can
access resource stubs in self-extract archives. This is about as close
to "prime time" as it's going to get, it's FREEWARE, it does what I need.
If you want me to add features or explain my code, please send large
bundles of cash (dollars or pounds I don't much care which)

Intelligent questions related to this code can be sent to me at

	74011.1732@compuserve.com

	clive@tbcnet.com

My Windows Source Home Page (Disassembly Tools for Windows) is located at

	http://www.tbcnet.com/~clive/vcomwinp.html

Also check out other FREEWARE (at the same address)

	DumpPE (Portable Executables),
	DumpLX (Linear Executables LE & LX),
	VxDLib (VMM32.VXD Compressed VxD Archive)

I have plans for some tools for

	Quantum Decompression
	SZDD, KWAJ Microsoft Archives (I know the algorithms)
	Portable Executable Object & Library Analysis
	Codeview & Turbo Debug Symbol Dumpers

******************************************************************************

	History

		1.01	2-Apr-97	First public release

		1.02	5-Apr-97	Added LZX compression identification
										MSZIP decompression, with CABINFL.C
										raw, cooked & off options
										DUMPCAB.MAK & Huge Memory Model
										.CAB as default extention
										execute after decompress & UTF attributes

		1.03	3-Nov-97	Fixed bug in CABINFL.C per bug report from
										Christian Groessler <chris@fast-ag.de>.
										Oops! Thanks Chris

			for(i=0; i<sizeof(c); i++)
				c[i] = 0;

			changed to

			for(i=0; i<(sizeof(c)/sizeof(WORD)); i++)
				c[i] = 0;

		1.04	3-Dec-97	Altered slightly to compile under Linux with
										gcc per request from
										Uwe Bonnes <bon@elektron.ikp.tu-darmstadt.de>.
										See lines with #ifdef linux
										gcc -o dumpcab -Wall dumpcab.c cabinfl.c

		1.05	9-Jun-98	Fixed some spelling and wording.
										CK (Chris Kirmse) emailed me, it's a small world.
										Added -find option, self-extracting cabinets
										are appearing more and more, finding them
										manually is becoming a tad tedious.

		1.06	10-Aug-98	Major overhaul. Fixed MSZIP decompression to use
										global window so it works properly. Added support
										for RESERVE data. Added -decab option, finds and
										extricates .CAB file embedded in .EXE file.
										I also located MS compression tools which can do
										MSZIP, Quantum & LZX. Quantum is incredibly slow,
										LZX is marginally faster and offers better ratios.

******************************************************************************

	Usage

		Regular cabinet (.CAB used by default)

			dumpcab precopy1

		Self-extract, MSZIP, Dump uncompressed data

			dumpcab cabdevkt.exe -off 14db8 -cooked

		Self-extract, Quantum, 2MB Window

			dumpcab cabrsckt.exe -off 19d48

		or

			dumpcab cabrsckt.exe -find

		or

			dumpcab cabrsckt -decab

******************************************************************************

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#ifdef linux
#include <ctype.h>
#endif

typedef unsigned short WORD;
typedef unsigned char BYTE;
typedef unsigned long DWORD;

typedef BYTE BOOL;
typedef BYTE BOOLEAN;

#define FALSE		0
#define TRUE		(! FALSE)

#ifdef linux
#define min(a,b) (((a) < (b)) ? (a) : (b))
#endif

// External Prototypes (CABINFL.C)

extern BYTE *inptr;
extern BYTE *outptr;
extern BYTE *window;
extern inflate(void);

#define WSIZE 0x8000

#define BUFSIZE 0x8000

// Local Prototypes

DWORD checksum(BYTE *,DWORD,DWORD);
void banner(void);
WORD inflate_cabinet(BYTE *, BYTE *);
void cabinet(BYTE *, DWORD);
DWORD locatemscf(BYTE *);
void decabinet(BYTE *, DWORD);
void main(WORD, BYTE **);

BOOL do_raw			= FALSE;
BOOL do_cooked	= FALSE;
BOOL no_banner	= FALSE;
BOOL do_find		= FALSE;
BOOL do_decab		= FALSE;

//******************************************************************************

#define CAB_FLAG_HASPREV				0x0001
#define CAB_FLAG_HASNEXT				0x0002
#define CAB_FLAG_RESERVE				0x0004

#define CAB_FILE_PREV						0xFFFD
#define CAB_FILE_NEXT						0xFFFE
#define CAB_FILE_SPAN						0xFFFF

#define CAB_ATTRIB_READONLY			0x0001	// Standard DOS Attributes
#define CAB_ATTRIB_HIDDEN				0x0002
#define CAB_ATTRIB_SYSTEM				0x0004
#define CAB_ATTRIB_VOLUME				0x0008
#define CAB_ATTRIB_DIRECTORY		0x0010
#define CAB_ATTRIB_ARCHIVE			0x0020
#define CAB_ATTRIB_EXECUTEIT		0x0040	// Execute after extraction
#define CAB_ATTRIB_UTF					0x0080	// Filename in UTF?

#define CAB_MASK_TYPE						0x000F	// Mask for compression type
#define CAB_TYPE_NONE						0x0000	// No compression
#define CAB_TYPE_MSZIP					0x0001	// MSZIP
#define CAB_TYPE_QUANTUM				0x0002	// Quantum   1KB - 2MB Window
#define CAB_TYPE_LZX						0x0003  // LZX      32KB - 2MB Window
#define CAB_BAD									0x000F	// Unspecified compression type

#define CAB_MASK_QUANTUM_LEVEL	0x00F0	// Mask for Quantum Compression Level
#define CAB_QUANTUM_LEVEL_LO		0x0010	// Lowest Quantum Level (1)
#define CAB_QUANTUM_LEVEL_HI		0x0070	// Highest Quantum Level (7)
#define CAB_SHIFT_QUANTUM_LEVEL			 4	// Amount to shift over to get int

#define CAB_MASK_QUANTUM_MEM		0x1F00	// Mask for Quantum Compression Memory
#define CAB_QUANTUM_MEM_LO			0x0A00	// Lowest Quantum Memory (10)
#define CAB_QUANTUM_MEM_HI			0x1500	// Highest Quantum Memory (21)
#define CAB_SHIFT_QUANTUM_MEM				 8	// Amount to shift over to get int

#define CAB_MASK_LZX_WINDOW			0x1F00	// Mask for LZX Compression Memory
#define CAB_LZX_WINDOW_LO				0x0F00	// Lowest LZX Memory (15)
#define CAB_LZX_WINDOW_HI				0x1500	// Highest LZX Memory (21)
#define CAB_SHIFT_LZX_WINDOW				 8	// Amount to shift over to get int

#define CAB_MASK_RESERVED				0xE000	// Reserved bits (high 3 bits)

#define pchar(x)  putchar( ((x > 31) && (x < 127)) ? x : '.');

#define WIDTH 16

//******************************************************************************

// All these structures are byte aligned

#ifndef linux
#pragma pack(1)
#endif

//******************************************************************************

typedef struct {
	BYTE	sig[4];							// MSCF
	DWORD	csumHeader;					// Header Checksum, 0 = None
	DWORD	cbCabinet;					// Size
	DWORD	csumFolders;				// Folders Checksum, 0 = None
	DWORD	coffFiles;					// Offset to CFFILEs
	DWORD	csumFiles;					// Files Checksum, 0 = None
	WORD	version;						// CAB Version 0x0103
	WORD	cFolders;						// Count of CFFOLDERs
	WORD	cFiles;							// Count of CFFILEs
	WORD	flags;							// Flags
	WORD	setID;							// CAB Series #
	WORD	iCabinet;						// CAB #
//WORD	cbCFHeaderReserve;	// Size of per-cabinet reserved area (optional)
//BYTE	cbCFFolderReserve;	// Size of per-folder reserved area (optional)
//BYTE	cbCFDataReserve;		// Size of per-datablock reserved area (optional)
//BYTE	abReserve[];				// Per-cabinet reserved area (optional)
//BYTE	szCabinetPrev[];		// Name of previous cabinet file (optional)
//BYTE	szDiskPrev[];				// Name of previous disk (optional)
//BYTE	szCabinetNext[];		// Name of next cabinet file (optional)
//BYTE	szDiskNext[];				// Name of next disk (optional)
} CFHEADER;

//******************************************************************************

typedef struct {
	WORD	cbCFHeaderReserve;
	BYTE	cbCFFolderReserve;
	BYTE	cbCFDataReserve;
} CFHDRRES;

//******************************************************************************

typedef struct {
	DWORD	coffCabStart;			// Offset to first CFDATA entry
	WORD	cCFData;					// Count of CFDATAs
	WORD	typeCompress;			// Compression 1 = MSZIP, 2 = Quantum, 3 = LZX
//BYTE	abReserve[];			// Per-folder reserved area (optional)
} CFFOLDER;

//******************************************************************************

typedef struct {
	DWORD	csum;							// Checksum      (0 if split)
	WORD	cbData;						// Cooked Length
	WORD	cbUncomp;					// Raw Length    (0 if split)
//BYTE	abReserve[];			// Per-datablock reserved area (optional)
//BYTE	ab[cbData];				// Compressed data bytes
} CFDATA;

//******************************************************************************

typedef struct {
	DWORD	cbFile;						// length
	DWORD	uoffFolderStart;	// offset
	WORD	iFolder;					// folder 0,1,-3,-2 before, after, current
	WORD	date;							// DOS time stamp
	WORD	time;
	WORD	attribs;					// attributes
} CFFILE;

//******************************************************************************

#ifdef linux
/* from Wine lstrncmpi - case insensitive string compare up to n chars */
int strnicmp(char *str1, char *str2, int n)
{
	if (!n)
		return(0);

	while((--n > 0) && *str1)
	{
		int res;

		if ((res = toupper(*str1++) - toupper(*str2++)))
			return(res);
	}

	return(toupper(*str1) - toupper(*str2));
}
#endif

//******************************************************************************

DWORD checksum(buf,len,csum)
BYTE *buf;
DWORD len, csum;
{
	DWORD i;

	i = len >> 2;	// Do all the DWORDs first

	while(i--)
	{
		csum ^= *((DWORD *)buf);

		buf += 4;
	}

	i = len & 3;	// Trailing bytes are not handled as you might expect!

	if (i == 3)
	{
		csum ^= (DWORD)*buf++ << 16l;

		i--;
	}

	if (i == 2)
	{
		csum ^= (DWORD)*buf++ << 8l;

		i--;
	}

	if (i == 1)
	{
		csum ^= (DWORD)*buf++;

		i--;
	}

	return(csum);
}

//******************************************************************************

void dump(len,buf,off)
WORD len;
BYTE *buf;
DWORD off;
{
	WORD i;

	while(len)
	{
		printf(" %08lX: ",off);

		for(i=0; i<WIDTH; i++)
		{
			if (i < len)
			{
				if (i == (WIDTH / 2))
					printf("- ");

				printf("%02X ",buf[i]);
			}
			else
			{
				if (i == (WIDTH / 2))
					printf("     ");
				else
					printf("   ");
			}
		}

		putchar(' ');

		for(i=0; i<min(WIDTH,len); i++)
			pchar(buf[i]);

		putchar('\n');

		len -= i;
		buf += i;
		off += i;
	}
}

//******************************************************************************

BYTE usage[] =	" ====     ===\t\t\tThis FREEWARE product was written by Clive\n"
								"  \\\\      / th\t\t\tTurvey, an English Electronics Engineer.\n"
								"   \\\\    /\n"
								"    \\\\  /   Planet\t\tIt is designed to dump the internal\n"
								"     \\\\/     Software\t\tstructure of Microsoft Cabinet Files.\n"
								"     /\\\\      International\n"
								"    /  \\\\\t\t\tIf you like the software, or find a problem\n"
								"   /    \\\\   CIS 74011,1732\tpost some Email to 74011.1732@compuserve.com\n"
								"  /      \\\\\n"
								" ===     ====\n\n"

								"Usage : DumpCAB [options] <cabinet file>\n\n"

								"Options :\t-quiet\t\tSuppress copyright string\n"
								"\t\t-off <offset>\tSpecify cabinet within .EXE\n"
								"\t\t-find\t\tLocate cabinet embedded within .EXE\n"
								"\t\t-decab\t\tLocate and extract cabinet within .EXE\n"
								"\t\t-raw\t\tDisplay compressed content\n"
								"\t\t-cooked\t\tDisplay uncompressed content (MSZIP only)";

void banner()
{
	fprintf(stderr,"\nDumpCAB v1.06 (c) Copyright Tenth Planet Software Intl., C Turvey 1995-1998.\n"
						"\t\t\t    All rights reserved. Non-Commercial use only.\n\n");
}

//******************************************************************************

WORD inflate_cabinet(BYTE *srcbuffer, BYTE *destbuffer)
{
	WORD rtncode;

	if (!window)
		return(3);	// Not Enough memory

	inptr  = srcbuffer;

	outptr = destbuffer;

	rtncode = 3;	// Error

	if ((inptr[0] == 'C') && (inptr[1] == 'K'))
	{
		inptr += 2;

		rtncode = inflate();
	}

	return(rtncode);
}

//******************************************************************************

void cabinet(BYTE *filename, DWORD offset)
{
	FILE			*fcab;
	CFHEADER	cfheader;
	CFHDRRES	cfhdrres;
	CFFOLDER	**cffolder;
	CFDATA		*cfdata;
	CFFILE		cffile;
	BYTE			*cab_raw, *cab_cooked;
	WORD			file, folder, data, i, j;
	DWORD			fileptr, foldoff, csum;
	WORD			cbCFFolderAndReserve, cbCFDataAndReserve;

	fcab = fopen(filename,"rb");

	if (!fcab)
	{
		fprintf(stderr,"Unable to open file '%s'\n",filename);

		exit(1);
	}

	fseek(fcab, offset, SEEK_SET);

	fread(&cfheader,1,sizeof(CFHEADER), fcab);

	if (strncmp(cfheader.sig,"MSCF",4) != 0)
	{
		fprintf(stderr,"'%s' does not appear to be an Microsoft Cabinet File (MSCF).\n",filename);
		exit(1);
	}

	puts("CFHEADER\n");

	printf("%-40s%08lX (%.4s)\n","Cabinet Signature",
		*((DWORD *)cfheader.sig),
		cfheader.sig);

	printf("%-40s%08lX\n","Checksum Header",
		cfheader.csumHeader);

	printf("%-40s%08lX\n","Cabinet Size",
		cfheader.cbCabinet);

	printf("%-40s%08lX\n","Checksum Folders",
		cfheader.csumFolders);

	printf("%-40s%08lX\n","File List",
		cfheader.coffFiles);

	printf("%-40s%08lX\n","Checksum Files",
		cfheader.csumFiles);

	printf("%-40s%04X\n","Cabinet Version",
		cfheader.version);

	printf("%-40s%04X\n","Number of Folders",
		cfheader.cFolders);

	printf("%-40s%04X\n","Number of Files",
		cfheader.cFiles);

	printf("%-40s%04X\n","Cabinet Flags",
		cfheader.flags);


	if (cfheader.flags & CAB_FLAG_RESERVE)
	{
		puts("\tReserve");

		fread(&cfhdrres,sizeof(CFHDRRES),1,fcab);

		printf("\t %-31s%04X\n","Header Reserve Size",
			cfhdrres.cbCFHeaderReserve);

		printf("\t %-31s%02X\n","Folder Reserve Size",
			cfhdrres.cbCFFolderReserve);

		printf("\t %-31s%02X\n","Data Reserve Size",
			cfhdrres.cbCFDataReserve);

		cbCFFolderAndReserve = sizeof(CFFOLDER) + cfhdrres.cbCFFolderReserve;

		cbCFDataAndReserve = sizeof(CFDATA) + cfhdrres.cbCFDataReserve;

		for(i=0; i<cfhdrres.cbCFHeaderReserve; i++)
		{
			if ((i % 16) == 0)
				printf("\n\t %04X : ",i);

			j = fgetc(fcab);

			printf("%02X ",j);
		}

		putchar('\n');
	}
	else
	{
		cbCFFolderAndReserve = sizeof(CFFOLDER);

		cbCFDataAndReserve = sizeof(CFDATA);
	}


	if (cfheader.flags & CAB_FLAG_HASPREV)
	{
		printf("\tPrevious Cabinet ");

		j = fgetc(fcab);		// szCabinetPrev

		while(j)
		{
			putchar(j);

			j = fgetc(fcab);
		}

		putchar(',');

		j = fgetc(fcab);		// szDiskPrev

		while(j)
		{
			putchar(j);

			j = fgetc(fcab);
		}

		putchar('\n');
	}


	if (cfheader.flags & CAB_FLAG_HASNEXT)
	{
		printf("\tNext Cabinet     ");

		j = fgetc(fcab);		// szCabinetNext

		while(j)
		{
			putchar(j);

			j = fgetc(fcab);
		}

		putchar(',');

		j = fgetc(fcab);		// szDiskNext

		while(j)
		{
			putchar(j);

			j = fgetc(fcab);
		}

		putchar('\n');
	}


	printf("%-40s%04X\n","Cabinet Series",
		cfheader.setID);

	printf("%-40s%04X\n","Cabinet Number",
		cfheader.iCabinet);

	putchar('\n');


	cffolder = (CFFOLDER **) malloc(cfheader.cFolders * sizeof(CFFOLDER *));

	for(folder=0; folder<cfheader.cFolders; folder++)
	{
		cffolder[folder] = (CFFOLDER *)malloc(cbCFFolderAndReserve);

		fread(cffolder[folder],cbCFFolderAndReserve,1,fcab);
	}

	fseek(fcab, (offset + cfheader.coffFiles), SEEK_SET);

	puts("CFFILE   FileSize FldDepth Folder Date Time Attributes Name\n");

	for(file=0; file<cfheader.cFiles; file++)
	{
		if (fread(&cffile,1,sizeof(CFFILE), fcab) != sizeof(CFFILE))
			break;

		printf("%04X :   %08lX %08lX ",
			file,
			cffile.cbFile,
			cffile.uoffFolderStart);

		switch(cffile.iFolder)
		{
			case CAB_FILE_PREV : printf("(PREV)"); break;
			case CAB_FILE_NEXT : printf("(NEXT)"); break;
			case CAB_FILE_SPAN : printf("(SPAN)"); break;

			default : printf(" %04X ",cffile.iFolder); break;
		}

// I could decode the time stamp, but who cares?

		printf(" %04X %04X (%c%c%c%c%c%c%c%c) ",
			cffile.date,
			cffile.time,
			((cffile.attribs & CAB_ATTRIB_READONLY)  ? 'R' : ' '),
			((cffile.attribs & CAB_ATTRIB_HIDDEN)    ? 'H' : ' '),
			((cffile.attribs & CAB_ATTRIB_SYSTEM)    ? 'S' : ' '),
			((cffile.attribs & CAB_ATTRIB_VOLUME)    ? 'V' : ' '),
			((cffile.attribs & CAB_ATTRIB_DIRECTORY) ? 'D' : ' '),
			((cffile.attribs & CAB_ATTRIB_ARCHIVE)   ? 'A' : ' '),
			((cffile.attribs & CAB_ATTRIB_EXECUTEIT) ? 'X' : ' '),
			((cffile.attribs & CAB_ATTRIB_UTF)       ? 'U' : ' '));

		j = fgetc(fcab);

		while(j)
		{
			putchar(j);

			j = fgetc(fcab);
		}

		putchar('\n');
	}

	putchar('\n');

// Allocate sliding window for whole session, subsequent data blocks
// use data left in window after previous deflate operation

	if (do_cooked)
	{
		window = malloc(WSIZE);
	}
	else
	{
		window = NULL;
	}

	for(folder=0; folder<cfheader.cFolders; folder++)
	{
		puts( "CFFOLDER CabStart CFData#  Compression Type\n");

		printf("%04X :   %08lX %04X     %04X ",
			folder,
			cffolder[folder]->coffCabStart,
			cffolder[folder]->cCFData,
			cffolder[folder]->typeCompress);

		switch(cffolder[folder]->typeCompress & CAB_MASK_TYPE)
		{
			case CAB_TYPE_NONE :
				puts("No Compression");
				break;

			case CAB_TYPE_MSZIP :
				puts("MSZIP");
				break;

			case CAB_TYPE_QUANTUM :
				printf("Quantum, Level %d, Memory %ld\n",
					((cffolder[folder]->typeCompress & CAB_MASK_QUANTUM_LEVEL) >> CAB_SHIFT_QUANTUM_LEVEL),
					(DWORD)(1L << ((cffolder[folder]->typeCompress & CAB_MASK_QUANTUM_MEM) >> CAB_SHIFT_QUANTUM_MEM)) );
				break;

			case CAB_TYPE_LZX :
				printf("LZX, Memory %ld\n",
					(DWORD)(1L << ((cffolder[folder]->typeCompress & CAB_MASK_LZX_WINDOW) >> CAB_SHIFT_LZX_WINDOW)) );
				break;

			default :
				puts("Unknown Compression");
		}

		putchar('\n');

		cfdata = (CFDATA *)malloc(cbCFDataAndReserve);

		puts("CFDATA   CabStart   Checksum Data UnComp   Byte[0..1] FldDepth CalcCsum\n");

		foldoff = 0;	// Offset into the folder

		fileptr = cffolder[folder]->coffCabStart; // Where the compress data is

		for(data=0; data<cffolder[folder]->cCFData; data++)
		{
			fseek(fcab, (offset + fileptr), SEEK_SET);

			if (fread(cfdata, 1, cbCFDataAndReserve, fcab) != cbCFDataAndReserve)
				break;

			cab_raw = malloc(cfdata->cbData); // Get the chunk and checksum it

			if (cab_raw) // If it alloc'd - If it's a big mother it won't under DOS
			{
				fread(cab_raw, 1, cfdata->cbData, fcab);

// Checksum the block AND the cbData & cbUncomp fields (ie all except csum)
// It is worth noting that the checksum is of the raw compressed data not the
// uncompressed (which I believe is the case in ZIP files). While this might
// prevent the decompressor from exploding, it could mean a decompression
// failure would not get caught.

				csum = checksum((BYTE *)&cfdata->cbData, (cbCFDataAndReserve - 4l), checksum(cab_raw, cfdata->cbData, 0l));
			}

			printf("%04X :   %08lX | %08lX %04X %04X   | ",
				data,
				fileptr,
				cfdata->csum,
				cfdata->cbData,
				cfdata->cbUncomp);

			if (cab_raw)
				printf("(%02X %02X)",cab_raw[0],cab_raw[1]); // I want to see the CK signature on MSZIP
			else
				printf("(\077\077 \077\077)");

			printf("    %08lX ",foldoff);

// There appears to be a flaw in CAB v1.03, Checksums are only written for
// whole blocks, so in a block that spans a CAB file the first half is
// not checksumed, but the second is.

			if (cab_raw)
			{
//				if (cfdata->cbUncomp) // Complete? perhaps I should check cfdata->csum == 0?
				if (cfdata->csum)
					printf("%08lX\n",csum);
				else
					puts("Partial");
			}
			else
			{
				putchar('\n');
			}

			if (cab_raw && do_raw)
			{
				puts("\nRaw\n");

				dump(cfdata->cbData, cab_raw, 0L);

				putchar('\n');
			}

			if (cab_raw && do_cooked)
			{
				if ((cfdata->cbUncomp) &&		// Complete
						(cab_raw[0] == 'C') &&	// With 'CK' signature
						(cab_raw[1] == 'K') &&	//  & MSZIP
						((cffolder[folder]->typeCompress & CAB_MASK_TYPE) == CAB_TYPE_MSZIP))
				{
					cab_cooked = malloc(cfdata->cbUncomp);

					if (cab_cooked)
					{
						puts("\nCooked\n");

						if (inflate_cabinet(cab_raw,cab_cooked)) // 0 = OK
						{
							fprintf(stderr,"\nWARNING : MSZIP Decompression Error\n");

							exit(1);
						}

						dump(cfdata->cbUncomp, cab_cooked, foldoff);

						putchar('\n');

						free(cab_cooked);
					}
				}
			}

			if (cab_raw)
				free(cab_raw);

			foldoff += cfdata->cbUncomp;

			fileptr += cfdata->cbData + cbCFDataAndReserve;
		}

		free(cfdata);

		putchar('\n');
	}

	if (do_cooked)
	{
		if (window)
			free(window);
	}

	for(folder=0; folder<cfheader.cFolders; folder++)
		free(cffolder[folder]);

	free(cffolder);

	fclose(fcab);
}

//******************************************************************************

DWORD locatemscf(BYTE *filename)
{
	FILE *fcab;
	CFHEADER cfheader;
	DWORD offset, cabbase, cabsize;
	BYTE i, j, k, l;

	fcab = fopen(filename,"rb");

	if (!fcab)
	{
		fprintf(stderr,"Unable to open file '%s'\n",filename);

		exit(1);
	}

	fseek(fcab,0L,SEEK_END);

	cabsize = ftell(fcab);

	fseek(fcab,0L,SEEK_SET);

	cabbase = 0xFFFFFFFFL;

	offset = 0;

	i = fgetc(fcab);
	j = fgetc(fcab);
	k = fgetc(fcab);
	l = fgetc(fcab);

	while(offset < (cabsize - sizeof(CFHEADER)))
	{
		if ((i == 'M') && (j == 'S') && (k == 'C') && (l == 'F'))
		{
			fseek(fcab,offset,SEEK_SET);

			fread(&cfheader,1,sizeof(CFHEADER), fcab);

			if ((cfheader.cbCabinet <= (cabsize - offset)) &&
					(cfheader.version == 0x0103))
			{
				cabbase = offset;

				break;
			}

			fseek(fcab,(offset + 4), SEEK_SET);
		}

		i = j;
		j = k;
		k = l;
		l = fgetc(fcab);

		offset++;
	}

	fclose(fcab);

	if (cabbase == 0xFFFFFFFFL)
	{
		fprintf(stderr,"WARNING : Unable to locate MSCF header\n");

		exit(1);
	}
	else
	{
		printf("Microsoft Cabinet File (MSCF) located at offset 0x%lX\n\n",cabbase);
	}

	return(cabbase);
}

//******************************************************************************

void decabinet(BYTE *filename, DWORD offset)
{
	BYTE			buf[128];
	FILE			*fcab, *fexe;
	CFHEADER	cfheader;
	WORD			j;
	DWORD			size, remaining;
	BYTE			*buffer;

	fexe = fopen(filename,"rb");

	if (!fexe)
	{
		fprintf(stderr,"Unable to open file '%s'\n",filename);

		exit(1);
	}

	fseek(fexe, offset, SEEK_SET);

	fread(&cfheader,1,sizeof(CFHEADER), fexe);

	if ((strncmp(cfheader.sig,"MSCF",4) != 0) ||
			(cfheader.version != 0x0103))
	{
		fprintf(stderr,"'%s' does not appear to be an Microsoft Cabinet File (MSCF).\n",filename);
		exit(1);
	}


	strcpy(buf, filename);

	j = strlen(buf);

	while((buf[j] != '.') &&
#ifdef linux
				(buf[j] != '/') &&
#else
				(buf[j] != '\\') &&
#endif
				(buf[j] != ':') && j)
	{
		j--;
	}

	if (buf[j] == '.')
		buf[j] = 0;

	strcat(buf,".cab");

	fcab = fopen(buf,"wb");

	if (!fcab)
	{
		fprintf(stderr,"Unable to open file '%s'\n",buf);

		exit(1);
	}

	printf("Extricating cabinet within %s to %s\n",filename,buf);

	fwrite(&cfheader,1,sizeof(CFHEADER), fcab);

	remaining = cfheader.cbCabinet - sizeof(CFHEADER);

	buffer = malloc(BUFSIZE);

	if (buffer) // Use block reading/writing if we can allocate a buffer
	{
		while(remaining)
		{
			size = min(BUFSIZE,remaining);

			fread(buffer,(size_t)size,1,fexe);

			fwrite(buffer,(size_t)size,1,fcab);

			putchar('.');

			remaining -= size;
		}

		putchar('\n');

		free(buffer);
	}
	else
	{
		while(remaining--)
			fputc(fgetc(fexe),fcab);
	}

	fclose(fcab);

	fclose(fexe);
}

//******************************************************************************

void main(argc,argv)
WORD argc;
BYTE **argv;
{
	BYTE buf[128];
	WORD i, j;

	DWORD cabbase = 0;

	j = 1;

	for (i=1; i<argc; i++)
	{
		if ((argv[i][0] == '-')
#ifndef linux
		 || (argv[i][0] == '/')
#endif
													 )
		{
			BYTE *arg;

			arg = &argv[i][1];

			if (strnicmp(arg, "?", 1) == 0)
			{
				j = 0;	// Force Usage

				break;
			}

			if (strnicmp(arg, "nobanner", 3) == 0)
			{
				no_banner = TRUE;
				continue;
			}

			if (strnicmp(arg, "quiet", 3) == 0)
			{
				no_banner = TRUE;
				continue;
			}

			if (strnicmp(arg, "find", 3) == 0)
			{
				do_find = TRUE;
				continue;
			}

			if (strnicmp(arg, "raw", 3) == 0)
			{
				do_raw = TRUE;
				continue;
			}

			if (strnicmp(arg, "cooked", 3) == 0)
			{
				do_cooked = TRUE;
				continue;
			}

			if (strnicmp(arg, "decab", 3) == 0)
			{
				do_decab = TRUE;
				continue;
			}

			if (strnicmp(arg, "offset", 3) == 0)
			{
				i++;

				sscanf(argv[i],"%lx",&cabbase);

				continue;
			}

			// Illegal Parameter

			j = 0;	// Force Usage

			break;
		}
		else
		{
			argv[j++] = argv[i];
		}
	}

	argc = j;

	if (!no_banner)
		banner();

	if (argc < 2)
	{
		if (no_banner)
			banner();

		puts(usage);

		exit(1);
	}

	strcpy(buf, argv[1]);

	j = strlen(buf);

	while((buf[j] != '.') &&
#ifdef linux
				(buf[j] != '/') &&
#else
				(buf[j] != '\\') &&
#endif
				(buf[j] != ':') && j)
	{
		j--;
	}

	if (buf[j] != '.')
	{
		if (do_decab || do_find)
			strcat(buf,".exe");
		else
			strcat(buf,".cab");
	}

	if (do_find)
		cabbase = locatemscf(buf);

	if (do_decab)
	{
		if (!cabbase)
			cabbase = locatemscf(buf);

		if (cabbase)
			decabinet(buf,cabbase);

		exit(1);
	}

	cabinet(buf,cabbase);
}

//******************************************************************************

