/*

DumpFB.C	Borland 32-bit Turbo Debugger dumper (FB09 & FB0A)
Clive Turvey, Electronics Engineer, July 1998
Copyright (C) Tenth Planet Software Intl., Clive Turvey 1998. All rights reserved.

Compiled using Microsoft C/C++ v11.00 (Visual C/C++ v5.00)

******************************************************************************

 ====     ===
  \\      / th
   \\    /
    \\  /  Planet
     \\/    Software
     /\\     International
    /  \\
   /    \\
  /      \\
 ===     ====

     Copyright (C) Tenth Planet Software Intl., C Turvey 1998.
                       Chicago & Southampton.

                     CompuServe ID 74011,1732
       Email : 74011.1732@compuserve.com or clive@tbcnet.com

******************************************************************************

 Certain portions of this code and its algorithms remain the intellectual
 property of Clive Turvey, who retains the right to use and/or modify them
 at his discretion in projects for other clients.

******************************************************************************

     REUSE OF THIS CODE IN A COMMERCIAL APPLICATION IS NOT PERMITTED

******************************************************************************

I had been meaning to figure out how Borland 32-bit Debug Symbols were
encoded for quite some time, but I was finally moved into action by a
request for information from Jean-Marc Eber. This code is the result of
several evenings of analysis and coding, some parts are not very pretty,
but it gets the job done.

I have not even attempted to decode the "TYPES" information, the ones
in Codeview are a nightmare and personally I have little need for them.
My goal was to get the "SYMBOLS" information out to do disassembly.

I'd like to thank Jean-Marc Eber, Etienne Roch and Vincent Mahon for
their feedback and encouragement.

If you find any issues, please report them and send examples to me at

clive@tbcnet.com

If you have any FB08 files from the Borland OS/2 32-bit compiler I would
be interested in examining them. Currently I have only one, which is
insufficient for analysis.

******************************************************************************

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

typedef unsigned short WORD;
typedef unsigned char BYTE;
typedef unsigned long DWORD;

typedef BYTE BOOL;
typedef BYTE BOOLEAN;

#define FALSE		0
#define TRUE		(! FALSE)

#ifdef linux
#define __FLAT__
#define min(a,b) (((a) < (b)) ? (a) : (b))
#define max(a,b) (((a) > (b)) ? (a) : (b))
#endif

#if     _MSC_VER >= 800 && _M_IX86 >= 300
#define __FLAT__
#endif

#ifdef __FLAT__
#define HUGE
#else
#define HUGE huge
#endif

#ifndef linux
#pragma pack(1)
#endif

void *allocate(DWORD, DWORD, BYTE *);
void release(void *);

void dumpdata(DWORD, BYTE *);
void dumprecord(DWORD, BYTE *);

void exit(int);
void main(int,char **);

//******************************************************************************

BYTE *SstFrame = NULL;
BYTE *Names = NULL;
BYTE **NameTbl = NULL;

BOOL verbose = FALSE;

//******************************************************************************

void *allocate(DWORD x, DWORD y, BYTE *v)
{
	void *p;

#ifdef __FLAT__
	p = malloc(x * y);
#else
	p = halloc(x,(size_t)y);
#endif

	if ((p == NULL) && (v != NULL))
	{
		fprintf(stderr,"%s\nhalloc(%ld,%ld) fail\n",v,x,y);
		exit(1);
	}

	return(p);
}

//******************************************************************************

void release(void *p)
{
#ifdef __FLAT__
	free(p);
#else
	hfree(p);
#endif
}

//******************************************************************************

#define WIDTH 16

#define pchar(x)  putchar( ((x > 31) && (x < 127)) ? x : '.');

//******************************************************************************

void dumpdata(len,buf)
DWORD len;
BYTE *buf;
{
	DWORD i, off = 0;

	while(len)
	{
		printf(" %08lX: ",off);

		for(i=0; i<WIDTH; i++)
		{
			if (i < len)
			{
				if (i == (WIDTH / 2))
					printf("- ");

				printf("%02X ",buf[i]);
			}
			else
			{
				if (i == (WIDTH / 2))
					printf("     ");
				else
					printf("   ");
			}
		}

		putchar(' ');

		for(i=0; i<min(WIDTH,len); i++)
			pchar(buf[i]);

		putchar('\n');

		len -= i;
		buf += i;
		off += i;
	}
}

//******************************************************************************

void dumprecord(len,buf)
DWORD len;
BYTE *buf;
{
	WORD i;

	while(len)
	{
		putchar('\t');

		for(i=0; i<WIDTH; i++)
		{
			if (i < len)
			{
				if (i == 8)
					printf("- ");

				printf("%02X ",buf[i]);
			}
			else
			{
				if (i == 8)
					printf("     ");
				else
					printf("   ");
			}
		}

		putchar(' ');

		for(i=0; i<min(WIDTH,len); i++)
			pchar(buf[i]);

		putchar('\n');

		len -= i;
		buf += i;
	}
}

//******************************************************************************

BYTE *get_fb_symbolindices(index)
WORD index;
{
	switch(index)
	{
		case 0x0001		: return("S_COMPILE");
		case 0x0002		: return("S_REGISTER");
		case 0x0003		: return("S_CONST");
		case 0x0004		: return("S_UDT");
		case 0x0005		: return("S_SSEARCH");
		case 0x0006		: return("S_END");
		case 0x0007		: return("S_SKIP");
		case 0x0008		: return("S_CVRESERVE");
		case 0x0009		: return("S_OBJNAME");
		case 0x000A		: return("S_NAMESPACE");
		case 0x000B		: return("S_USING");

		case 0x0020		: return("S_GPROCREF");
		case 0x0021		: return("S_GDATAREF");
		case 0x0022		: return("S_EDATA");
		case 0x0023		: return("S_EPROC");
		case 0x0024		: return("S_USES");
		case 0x0025		: return("S_NAMESPACE");
		case 0x0026		: return("S_USING");
		case 0x0027		: return("S_ENUM??");

		case 0x0100		: return("S_BPREL16");
		case 0x0101		: return("S_LDATA16");
		case 0x0102		: return("S_GDATA16");
		case 0x0103		: return("S_PUB16");
		case 0x0104		: return("S_LPROC16");
		case 0x0105		: return("S_GPROC16");
		case 0x0106		: return("S_THUNK16");
		case 0x0107		: return("S_BLOCK16");
		case 0x0108		: return("S_WITH16");
		case 0x0109		: return("S_LABEL16");
		case 0x010A		: return("S_CEXMODEL16");
		case 0x010B		: return("S_VFTPATH16");

		case 0x0110		: return("S_ENTRY16");
		case 0x0111		: return("S_OPTVAL16");
		case 0x0112		: return("S_PROCRET16");
		case 0x0113		: return("S_SAVREGS16");

		case 0x0200		: return("S_BPREL32");
		case 0x0201		: return("S_LDATA32");
		case 0x0202		: return("S_GDATA32");
		case 0x0203		: return("S_PUB32");
		case 0x0204		: return("S_LPROC32");
		case 0x0205		: return("S_GPROC32");
		case 0x0206		: return("S_THUNK32");
		case 0x0207		: return("S_BLOCK32");
		case 0x0208		: return("S_WITH32");
		case 0x0209		: return("S_LABEL32");
		case 0x020A		: return("S_CEXMODEL32");
		case 0x020B		: return("S_VFTPATH32");

		case 0x0210		: return("S_ENTRY32");
		case 0x0211		: return("S_OPTVAL32");
		case 0x0212		: return("S_PROCRET32");
		case 0x0213		: return("S_SAVREGS32");

		default				: return("S_UNKNOWN");
	}
}

//******************************************************************************

char *get_fb_subsection(sst)
int sst;
{
	switch(sst)
	{
		case 0x0120		: return("sstModule");
		case 0x0121		: return("sstTypes");
		case 0x0122		: return("sstPublic");
		case 0x0123		: return("sstPublicSym");
		case 0x0124		: return("sstSymbols");
		case 0x0125		: return("sstAlignSym");
		case 0x0126		: return("sstSrcLnSeg");
		case 0x0127		: return("sstSrcModule");
		case 0x0128		: return("sstLibraries");
		case 0x0129		: return("sstGlobalSym");
		case 0x012A		: return("sstGlobalPub");
		case 0x012B		: return("sstGlobalTypes");
		case 0x012C		: return("sstMPC");
		case 0x012D		: return("sstMystery1");
		case 0x012E		: return("sstMystery2");
		case 0x0130		: return("sstNames");
		case 0x0131		: return("sstBrowse");

		default : return("sstUnknown");
	}
}

//******************************************************************************

char *get_fb_register(reg)
int reg;
{
	switch(reg)
	{
		case 0x00		: return("none"); //? Seen in Delphi
		case 0x01		: return("AL");
		case 0x02		: return("CL");
		case 0x03		: return("DL");
		case 0x04		: return("BL");
		case 0x05		: return("AH");
		case 0x06		: return("CH");
		case 0x07		: return("DH");
		case 0x08		: return("BH");
		case 0x09		: return("AX");
		case 0x0A		: return("CX");
		case 0x0B		: return("DX");
		case 0x0C		: return("BX");
		case 0x0D		: return("SP");
		case 0x0E		: return("BP");
		case 0x0F		: return("SI");
		case 0x10		: return("DI");
		case 0x11		: return("EAX");
		case 0x12		: return("ECX");
		case 0x13		: return("EDX");
		case 0x14		: return("EBX");
		case 0x15		: return("ESP");
		case 0x16		: return("EBP");
		case 0x17		: return("ESI");
		case 0x18		: return("EDI");
		case 0x19		: return("ES");
		case 0x1A		: return("CS");
		case 0x1B		: return("SS");
		case 0x1C		: return("DS");
		case 0x1D		: return("FS");
		case 0x1E		: return("GS");
		case 0x1F		: return("IP");
		case 0x20		: return("FLAGS");
		case 0x21		: return("EIP");

		default : return("regUnknown");
	}
}

//******************************************************************************

void fb_dumpsymbols(sstptr,size)
BYTE *sstptr;
DWORD size;
{
	while(size)
	{
		WORD len, sym;

		len = *((WORD *) &sstptr[0]);
		sym = *((WORD *) &sstptr[2]);

		printf("%04X %04X %-16s ",len,sym,get_fb_symbolindices(sym));

		len += 2;

		switch(sym)
		{
			case 0x0001 : // S_COMPILE
			{
				WORD i, j;

				// +4  D
				// +8  B Pascal String Length

				i = sstptr[8]; // pascal string length

				j = 9;

				while(i--)
					putchar(sstptr[j++]);

				putchar('\n');

				break;
			}

			case 0x0002 : // S_REGISTER
			{
				DWORD name;

				// +4  D type
				// +8  W register
				// +10 D symbol name#
				// +14 D ?
				// +18 W ?

				name = *((DWORD *) &sstptr[10]);

				printf("         %-5s %s\n",
					get_fb_register(*((WORD *) &sstptr[8])),
					(name ? NameTbl[name - 1] : "<none>"));

				break;
			}

			case 0x0003 : // S_CONST
			{
				DWORD name;

				// +4  D type
				// +8  D symbol name#
				// +12 ? other variable crap

				name = *((DWORD *) &sstptr[8]);

				printf("%s\n",
					(name ? NameTbl[name - 1] : "<none>"));

				break;
			}

			case 0x0004 : // S_UDT
			{
				DWORD name;

				name = *((DWORD *) &sstptr[10]);

				printf("%s\n",
					(name ? NameTbl[name - 1] : "<none>"));

				break;
			}

			case 0x0005 : // S_SSEARCH
			case 0x0006 : // S_END
			{
				putchar('\n');
				break;
			}

			case 0x0020 : // S_GPROCREF
			case 0x0021 : // S_GDATAREF
			{
				DWORD name;

				// +4  D addr in AlignSym
				// +8  D type
				// +12 D symbol name#
				// +16 ?
				// +20 D offset
				// +24 W section

				name = *((DWORD *) &sstptr[12]);

				printf("%4X.%08lX %s\n",
					*((WORD *) &sstptr[24]),		// Seg/Section
					*((DWORD *) &sstptr[20]),		// Offset
					(name ? NameTbl[name - 1] : "<none>"));

				break;
			}

			case 0x0024 : // S_USES
			{
				WORD i, j;

				// +4  D symbol name#
				// ..  D symbol name#

				putchar('\n');

				i = (len  - 4) / 4; // Size is apparently implied

				j = 4;

				while(i--)
				{
					DWORD name;

					name = *((DWORD *) &sstptr[j]);

					printf("  %s\n",
						(name ? NameTbl[name - 1] : "<none>"));

					j += 4;
				}

				break;
			}

			case 0x0025 : // S_NAMESPACE (TDUMP 4.2.16.1 screws this up)
			{
				WORD i, j;
				DWORD name;

				// +4  D symbol name# for namespace
				// +12 W count
				// +14 D symbol name#
				// ..  D symbol name#

				name = *((DWORD *) &sstptr[4]);

				printf("Namespace:%s\n",
					(name ? NameTbl[name - 1] : "<none>"));


				i = *((WORD *) &sstptr[12]);

				j = 14;

				while(i--)
				{
					name = *((DWORD *) &sstptr[j]);

					printf("  %s\n",
						(name ? NameTbl[name - 1] : "<none>"));

					j += 4;
				}

				break;
			}

			case 0x0026 : // S_USING
			{
				WORD i, j;

				// +4  W count
				// +8  D symbol name#
				// ..  D symbol name#

				putchar('\n');

				i = *((WORD *) &sstptr[4]);

				j = 6;

				while(i--)
				{
					DWORD name;

					name = *((DWORD *) &sstptr[j]);

					printf("  %s\n",
						(name ? NameTbl[name - 1] : "<none>"));

					j += 4;
				}

				break;
			}

			case 0x0027 : // S_UNKNOWN like S_UDT perhaps S_ENUM??
			{
				DWORD name;

				// +4  D type
				// +8  W ? size
				// +10 D symbol name#
				// +14 W ?
				// +16 W ?
				// +18 D ?

				name = *((DWORD *) &sstptr[10]);

				printf("%s\n",
					(name ? NameTbl[name - 1] : "<none>"));

				break;
			}

			case 0x0200 : // S_BPREL32
			{
				DWORD name;

				// +4  D rel
				// +8  D type
				// +12 D symbol name#
				// +16 ?

				name = *((DWORD *) &sstptr[12]);

				printf("[ebp+%08lX] %s\n",
					*((DWORD *) &sstptr[4]),		// Rel
					(name ? NameTbl[name - 1] : "<none>"));

				break;
			}

			case 0x0201 : // S_LDATA32
			case 0x0202 : // S_GDATA32
			{
				DWORD name;

				// +4  D offset
				// +8  W section
				// +10 W ?
				// +12 D type
				// +16 D symbol name#
				// +20 ?

				name = *((DWORD *) &sstptr[16]);

				printf("%4X.%08lX %s\n",
					*((WORD *) &sstptr[8]),			// Seg/Section
					*((DWORD *) &sstptr[4]),		// Offset
					(name ? NameTbl[name - 1] : "<none>"));

				break;
			}

			case 0x0204 : // S_LPROC32
			case 0x0205 : // S_GPROC32
			{
				DWORD name;

				// +4  D parent\
				// +8  D end     Within this sst record
				// +12 D next  /
				// +16 D length
				// +20 D debug start
				// +24 D debug size
				// +28 D offset
				// +32 W section
				// +34 W ?
				// +36 D type
				// +40 D symbol name#
				// +44 D some length?
				// +48 P linker name (pascal string) optional? check length

				name = *((DWORD *) &sstptr[40]);

				printf("%4X.%08lX~%08lX %s\n",
					*((WORD *) &sstptr[32]),		// Seg/Section
					*((DWORD *) &sstptr[28]),		// Offset
					(*((DWORD *) &sstptr[28]) + *((DWORD *) &sstptr[16]) - 1),
					(name ? NameTbl[name - 1] : "<none>"));

				break;
			}

			case 0x0207 : // S_BLOCK32
			{
				// +4  D parent\
				// +8  D end   / Within this sst record
				// +12 D length
				// +16 D offset
				// +20 W section
				// +24 D ?

				printf("%4X.%08lX~%08lX\n",
					*((WORD *) &sstptr[20]),		// Seg/Section
					*((DWORD *) &sstptr[16]),		// Offset
					(*((DWORD *) &sstptr[16]) + *((DWORD *) &sstptr[12]) - 1));

				break;
			}

			case 0x0210 : // S_ENTRY32
			{
				printf("%4X.%08lX\n",
					*((WORD *) &sstptr[8]),			// Seg/Section
					*((DWORD *) &sstptr[4]));		// Offset

				break;
			}

			case 0x0211 : // S_OPTVAL32
			{
				WORD i, j;

				// +4  W count
				// +6  D start    \
				// +10 D length    Repeat
				// +14 W register /

				i = *((WORD *) &sstptr[4]);

				j = 6;

				putchar('\n');

				while(i--)
				{
					printf("  %-5s +%08lX~%08lX\n",
						get_fb_register(*((WORD *) &sstptr[j+8])),
						*((DWORD *) &sstptr[j+0]),		// Start (relative to PROC/BLOCK)
						(*((DWORD *) &sstptr[j+0]) + *((DWORD *) &sstptr[j+4]) - 1));

					j += 10;
				}

				break;
			}

			case 0x0213 : // S_SAVREGS32
			{
				WORD i;

				// +4  W mask (bit 0=EBX, 1=EDI, 2=ESI)
				// +6  D ebp frame if mask != 0
				// +10 W ?

				i = *((WORD *) &sstptr[4]);

				if (i)
				{
					printf("EBP %08lX",
						*((DWORD *) &sstptr[6]));		// EBP Frame Size negative

					if (i & 1)
						printf(", EBX");

					if (i & 2)
						printf(", EDI");

					if (i & 4)
						printf(", ESI");
				}

				putchar('\n');

				break;
			}

			default :
				putchar('\n');
				dumprecord((DWORD)len,sstptr);
		}

//		dumprecord((DWORD)len,sstptr);
//		putchar('\n');

		if (len == 2)
			break;

		sstptr += len;
		size   -= len;
	}

	putchar('\n');
}

//******************************************************************************

typedef struct {
	DWORD	Start;
	DWORD	End;
} LNSCOPE;

typedef struct {
	WORD	cFile;
	WORD	cSeg;
	DWORD	baseSrcFile[1];	// DWORD		baseSrcFile[cFile]
												// LNSCOPE	SegScope[cSeg]
												// WORD			Seg[cSeg]
} SRCMODHDR;

typedef struct {
	WORD	cSeg;
	DWORD	nName;
	DWORD	baseSrcLn[1];		// DWORD		baseSrcLn[cSeg]
												// LNSCOPE	LineScope[cSeg]
} SRCFILE;

typedef struct {
	WORD	Seg;
	WORD	cPair;
	DWORD	Offset[1];			// DWORD	Offset[cPair]
												// WORD		LineNumber[cPair]
}	SRCLN;

void fb_dumplines(sstptr,size)	// sstSrcModule
BYTE *sstptr;
WORD size;
{
	SRCMODHDR *srcmodhdr;
	LNSCOPE *segscope;
	WORD *seg;
	WORD i;

	if (size)
	{
		srcmodhdr = (SRCMODHDR *)sstptr;

		printf("cFile = %04X, cSeg = %04X\n",srcmodhdr->cFile,srcmodhdr->cSeg);

		segscope = (LNSCOPE *)&srcmodhdr->baseSrcFile[srcmodhdr->cFile];

		seg = (WORD *)&segscope[srcmodhdr->cSeg];

		for(i=0; i<srcmodhdr->cSeg; i++)
		{
			printf(" %4X.%08lX~%08lX\n",
				seg[i],
				segscope[i].Start,
				segscope[i].End);
		}

		putchar('\n');

		for(i=0; i<srcmodhdr->cFile; i++)
		{
			SRCFILE *srcfile;
			LNSCOPE *lnscope;
			WORD j;

			srcfile = (SRCFILE *)&sstptr[srcmodhdr->baseSrcFile[i]];

			lnscope = (LNSCOPE *)&srcfile->baseSrcLn[srcfile->cSeg];

			printf(" %08lX cSeg = %04X, Name = %s\n",
				srcmodhdr->baseSrcFile[i],
				srcfile->cSeg,
				(srcfile->nName ? NameTbl[srcfile->nName - 1] : "<none>"));

			for(j=0; j<srcfile->cSeg; j++)
			{
				SRCLN *srcln;
				DWORD *offset;
				WORD *linenum;
				WORD k;

				srcln = (SRCLN *)&sstptr[srcfile->baseSrcLn[j]];

				offset = (DWORD *)&srcln->Offset[0];

				linenum = (WORD *)&srcln->Offset[srcln->cPair];

//				printf("    %04X %04X\n",
//					srcln->Seg,
//					srcln->cPair);

				printf("   %08lX %4X.%08lX~%08lX\n",
					srcfile->baseSrcLn[j],
					srcln->Seg,
					lnscope[j].Start,
					lnscope[j].End);

				for(k=0; k<srcln->cPair; k++)
				{
					if (k && ((k % 3) == 0))
						putchar('\n');

					printf("    %4X.%08lX %5d",
						srcln->Seg,
						offset[k],
						linenum[k]);
				}

				putchar('\n');

				putchar('\n');
			}
		}
	}
}

//******************************************************************************

void fb_dumpmod(sstptr,size)	// sstModule
BYTE *sstptr;
WORD size;
{
	WORD cseg;
	DWORD name;

	name = *((DWORD *)&sstptr[0x08]);

	if (name)
		puts(NameTbl[name - 1]);

	cseg = *((WORD *)&sstptr[0x04]); // SegCount

	sstptr += 0x1C;

// +0  W Section
// +2  W Flags (1 = CODE, 0 = DATA)
// +4  D Start
// +8  D Length

	while(cseg--)
	{
		printf("%4X.%08lX~%08lX %04X",
				*((WORD *)&sstptr[0]),
				*((DWORD *)&sstptr[4]),
				(*((DWORD *)&sstptr[4]) + *((DWORD *)&sstptr[8]) - 1),
				*((WORD *)&sstptr[2]));

		putchar('\n');

		sstptr += 12;
	}

	putchar('\n');
}

//******************************************************************************

BYTE usage[] =	" ====     ===\t\t\tThis FREEWARE product was written by Clive\n"
								"  \\\\      / th\t\t\tTurvey, an English Electronics Engineer.\n"
								"   \\\\    /\n"
								"    \\\\  /   Planet\t\tTool to dump 32-bit Turbo Debug data.\n"
								"     \\\\/     Software\n"
								"     /\\\\      International\n"
								"    /  \\\\\t\t\tIf you like the software, or find a problem\n"
								"   /    \\\\   CIS 74011,1732\tpost some Email to 74011.1732@compuserve.com\n"
								"  /      \\\\\n"
								" ===     ====\n\n"

								"Usage : DumpFB <EXE/DLL file>\n\n"

								"Should work with 32-bit Turbo Debugger formats FB09 & FB0A";

void banner()
{
	fprintf(stderr,"\nDumpFB v0.04 (c) Copyright Tenth Planet Software Intl., C Turvey 1998.\n"
						"\t\t\t   All rights reserved. Non-Commercial use only.\n\n");
}

//******************************************************************************

void main(argc,argv)
int argc;
char **argv;
{
	FILE *ffb;
	WORD i, j, k, cbdirentry;
	DWORD ifabase, lfodir, cdir;
	BYTE hdrframe[256];

	banner();

	if (argc < 2)
	{
		puts(usage);
		exit(1);
	}

	puts(argv[1]);

	ffb = fopen(argv[1],"rb");

	if (!ffb)
	{
		printf("Can't open file '%s'\n",argv[1]);

		exit(1);
	}

	fseek(ffb,-8l,SEEK_END);

	for(i=0; i<0x08; i++)
		hdrframe[i] = fgetc(ffb);

	for(i=0; i<0x08; i++)
		printf("%02X ",hdrframe[i]);

	putchar('\n');

	if ((hdrframe[0] != 'F') ||
			(hdrframe[1] != 'B'))
	{
		puts("Turbo Debug signature missing.");
		exit(1);
	}

	if ((hdrframe[2] != '0') ||
			((hdrframe[3] != '9') &&
			 (hdrframe[3] != 'A')))
	{
		puts("Not Turbo Debug type FB09 or FB0A.");
		exit(1);
	}

	ifabase = ftell(ffb) - *((DWORD *) &hdrframe[4]);

	fseek(ffb,ifabase,SEEK_SET);

	for(i=0; i<0x08; i++)
		hdrframe[i] = fgetc(ffb);

	for(i=0; i<0x08; i++)
		printf("%02X ",hdrframe[i]);

	putchar('(');

	for(i=0; i<0x04; i++)
		pchar(hdrframe[i]);

	putchar(')');

	putchar('\n');

	if ((hdrframe[0] != 'F') ||
			(hdrframe[1] != 'B'))
	{
		puts("Turbo Debug signature missing.");
		exit(1);
	}

	lfodir = ifabase + *((DWORD *) &hdrframe[4]);

	if (lfodir < ifabase)
	{
		puts("Turbo Debug lfodir before ifabase.");
		exit(1);
	}

	fseek(ffb,0l,SEEK_END);

	if (lfodir > (DWORD)ftell(ffb))
	{
		puts("Turbo Debug lfodir beyond end of file.");
		exit(1);
	}

	fseek(ffb,lfodir,SEEK_SET);

	for(i=0; i<2; i++)
		hdrframe[i] = fgetc(ffb);

	j = *((int *) &hdrframe[0]); // cbDirHeader

	for(i=2; i<j; i++)
		hdrframe[i] = fgetc(ffb);

	for(i=0; i<j; i++)
		printf("%02X ",hdrframe[i]);

	putchar('\n');

	lfodir += (DWORD)j;

	cbdirentry = *((int *) &hdrframe[2]); // cbDirEntry

	cdir = *((DWORD *) &hdrframe[4]);

//	printf("cbdirentry = 0x%04X, cdir = 0x%04X\n",cbdirentry,cdir);

	SstFrame = (BYTE *)allocate(cdir,cbdirentry,"SstFrame,main()");

	fseek(ffb,lfodir,SEEK_SET);

	fread(SstFrame,(size_t)cdir,cbdirentry,ffb);

// Find sstNames section

	for(k=0; k<cdir; k++)
	{
		WORD	ssttype;
		DWORD	sstsize, sstbase;
		BYTE	*sstframe;

		sstframe = &SstFrame[k * cbdirentry];

		ssttype = *((WORD *) &sstframe[0]);

		if (ssttype == 0x0130)	// sstNames
		{
			sstbase = ifabase + *((DWORD *) &sstframe[4]);

			sstsize = *((DWORD *) &sstframe[8]);

			Names = (BYTE *)allocate(sstsize,1,NULL);

			if (Names)
			{
				DWORD x, y, z;

				fseek(ffb,sstbase,SEEK_SET);

				fread(Names,(size_t)sstsize,1,ffb);

				y = *((DWORD *) &Names[0]);

				NameTbl = (BYTE **)allocate(y,sizeof(BYTE *),NULL);

				if (NameTbl)
				{
					z = 4;

					for(x=0; x<y; x++)
					{
						NameTbl[x] = &Names[z + 1];

						z += Names[z] + 2;

						if (verbose)
							printf("%08lX %s\n",x,NameTbl[x]);
					}
				}
			}
		}
	}


	for(k=0; k<cdir; k++)
	{
		BYTE	*sstframe, *sstbuf;
		WORD	ssttype;
		DWORD	sstsize, sstbase;

		sstframe = &SstFrame[k * cbdirentry];

		ssttype = *((WORD *) &sstframe[0]);

		for(i=0; i<cbdirentry; i++)
			printf("%02X ",sstframe[i]);

		printf("%04X %s\n",ssttype,get_fb_subsection(ssttype));

		sstbase = ifabase + *((DWORD *) &sstframe[4]);

		sstsize = *((DWORD *) &sstframe[8]);

		sstbuf = (BYTE *)allocate(sstsize,1,NULL);

		fseek(ffb,sstbase,SEEK_SET);

		fread(sstbuf,(size_t)sstsize,1,ffb);

		if (verbose)
			dumpdata(sstsize,sstbuf);

		if (ssttype == 0x0120) //sstModule
			fb_dumpmod(sstbuf,sstsize);

		if (ssttype == 0x0125) // sstAlignSym
			fb_dumpsymbols(&sstbuf[0x4],sstsize - 0x4);

		if (ssttype == 0x0127) // sstSrcModule
			fb_dumplines(sstbuf,sstsize);

		if (ssttype == 0x0129) // sstGlobalSym
			fb_dumpsymbols(&sstbuf[0x20],*((DWORD *)&sstbuf[0x04]));

		release(sstbuf);
	}

	fclose(ffb);

	if (Names)
		release(Names);

	if (NameTbl)
		release(NameTbl);

	if (SstFrame)
		release(SstFrame);
}

