;
;
;              CONSOLE.INC - procedures for console input/output
;                   (C) Copyright 1998 by ANAKiN [DaVinci]
;
;

Comment %
        m  cinit
        m  cwrite  <buffer> <length>
        m  cwrites <buffer>
        m  cread   <buffer> <length>
        m  ccolor  <color>
        m  cgotoxy <x> <y>
        %

;
; imports
;

Extrn   GetStdHandle             : PROC
Extrn   SetConsoleCursorPosition : PROC
Extrn   SetConsoleTextAttribute  : PROC
Extrn   WriteConsoleA            : PROC
Extrn   ReadConsoleA             : PROC

;
; constants
;

STD_INPUT_HANDLE   equ -10
STD_OUTPUT_HANDLE  equ -11
STD_ERROR_HANDLE   equ -12

;
; data
;

.data

hconout  dd 0
hconin   dd 0
cchRW    dd 0

;
; procedures / macros
;

.code

;
; cinit - initializes input and output stream
; IN:
;  nothing
; OUT:
;  nothing
;

cinit macro
        CALL    _cinit
endm

_cinit proc
        ; init input stream
        PUSH    STD_INPUT_HANDLE  ; fdwDevice
        CALL    GetStdHandle
        CMP     EAX, -1
        JE      ciniterror
        MOV     [hconin], EAX

        ; init output stream
        PUSH    STD_OUTPUT_HANDLE ; fdwDevice
        CALL    GetStdHandle
        CMP     EAX, -1
        JE      ciniterror
        MOV     [hconout], EAX

        RET
endp

ciniterror proc
        PUSH    -1
        CALL    ExitProcess
endp

;
; cwrite - writes string to console
; IN:
;  buffer
;  length
; OUT:
;  nothing
;

cwrite macro buffer, length
        PUSH    0                 ; Reserved
        PUSH    offset cchRW      ; lpcchWritten
        PUSH    length            ; cchToWrite
        PUSH    offset buffer     ; lpvBuffer
        PUSH    [hconout]         ; hConsoleOutput
        CALL    WriteConsoleA
endm

;
; cwrites - writes string to console
; IN:
;  buffer
; OUT:
;  nothing
;

cwrites macro buffer
        cwrite  <buffer> <l&buffer>
endm

;
; cread - reads string from console
; IN:
;  buffer
;  length
; OUT:
;  nothing
;

cread macro buffer, length
        PUSH    0                 ; Reserved
        PUSH    offset cchRW      ; lpcchRead
        PUSH    length            ; cchToRead
        PUSH    offset buffer     ; lpvBuffer
        PUSH    [hconin]          ; hConsoleInput
        CALL    ReadConsoleA
endm

;
; ccolor - sets color for output
; IN:
;  color
; OUT:
;  nothing
;

ccolor macro color
        PUSH    color                    ; wAttr
        PUSH    [hconout]                ; hConsoleOutput
        CALL    SetConsoleTextAttribute
endm

;
; cgotoxy - set new cursorposition
; IN:
;  x
;  y
; OUT:
;  nothing
;

cgotoxy macro x, y
        PUSH    (y shl 16)+x             ; wAttr
        PUSH    [hconout]                ; hConsoleOutput
        CALL    SetConsoleCursorPosition
endm
