.model tiny
.386
.code
org 100h
start:
jmp @@over

leetieText db "               _y/+YOSHi's keypress detection - (c) 1999.$"
altmarker equ $
altText db "A", 07, "L", 07, "T", 07
altlen equ $-altmarker
ctrlmarker equ $
ctrlText db "C", 07, "o", 07, "n", 07, "t", 07, "r", 07, "o", 07, "l", 07
ctrllen equ $-ctrlmarker
leftmarker equ $
leftText db "L", 07, "e", 07, "f", 07, "t", 07, " ", 07, "S", 07, "h", 07, "i", 07, "f", 07, "t", 07
leftlen equ $-leftmarker
rightmarker equ $
rightText db "R", 07, "i", 07, "g", 07, "h", 07, "t", 07, " ", 07, "S", 07, "h", 07, "i", 07, "f", 07, "t", 07
rightlen equ $-rightmarker
insmarker equ $
insText db "I", 07, "n", 07, "s", 07, "e", 07, "r", 07, "t", 07
inslen equ $-insmarker
capsmarker equ $
capsText db "C", 07, "a", 07, "p", 07, "s", 07, " ", 07, "L", 07, "o", 07, "c", 07, "k", 07
capslen equ $-capsmarker
nummarker equ $
numText db "N", 07, "u", 07, "m", 07, " ", 07, "L", 07, "o", 07, "c", 07, "k", 07
numlen equ $-nummarker
scrollmarker equ $
scrollText db "S", 07, "c", 07, "r", 07, "o", 07, "l", 07, "l", 07, " ", 07, "L", 07, "o", 07, "c", 07, "k", 07
scrolllen equ $-scrollmarker

oldVidMode db ?
currentflags db ?

@@over:
mov ah, 0fh
int 10h                                 ; get current video mode in al
mov byte ptr [oldVidMode], al
mov ax, 3
int 10h                                 ; set mode 3h
mov ah, 09h
mov dx, offset leetieText               ; print out the title bar
int 21h
push 0b800h                             ; set up es for the videosegment
pop es
push cs
pop ds
call update_screen                      ; print out the screen
@@win_main:                     ; a message loop of sorts
push es
push 0040h
pop es
mov al, byte ptr es:[17h]
mov byte ptr [currentflags], al         ; get the keyshift states flag
pop es
and al, 8
or al, al                       ; if this is zero, the alt key is not pressed
setz al
push altlen
push offset alttext
call changedata
add esp, 3
mov al, byte ptr [currentflags]
and al, 4
or al, al                       ; if this is zero, the ctrl key is not pressed
setz al
push ctrllen
push offset ctrltext
call changedata
add esp, 4

mov al, byte ptr [currentflags]
and al, 2
or al, al                       ; if this is zero, the lsh key is not pressed
setz al
push leftlen
push offset lefttext
call changedata
add esp, 4

mov al, byte ptr [currentflags]
and al, 1
or al, al                       ; if this is zero, the rsh key is not pressed
setz al
push rightlen
push offset righttext
call changedata
add esp, 4

mov al, byte ptr [currentflags]
and al, 80h
or al, al
setz al
push inslen
push offset instext
call changedata
add esp, 4

mov al, byte ptr [currentflags]
and al, 40h
or al, al
setz al
push capslen
push offset capstext
call changedata
add esp, 4

mov al, byte ptr [currentflags]
and al, 20h
or al, al
setz al
push numlen
push offset numtext
call changedata
add esp, 4

mov al, byte ptr [currentflags]
and al, 10h
or al, al 
setz al
push scrolllen
push offset scrolltext
call changedata
add esp, 4

call update_screen
inc esp                                 ; this is needed, just trust me
in al, 60h
dec al                                  ; was the scancode 1h? (esc)
jnz @@win_main
mov al, byte ptr [oldVidMode]           ; set old video mode
int 10h
mov ax, 200h
xor bx, bx
mov dx, 0a01h
int 10h
push 0040h                              ; set up es for bios data
pop es
mov ax, word ptr es:[1ah]
mov word ptr es:[1ch], ax               ; 'erase' the buffer
ret

update_screen PROC
mov edi, 320
mov esi, offset instext
mov ecx, inslen
repnz movsb
mov edi, 480
mov esi, offset capstext
mov ecx, capslen
repnz movsb
mov edi, 640
mov esi, offset numtext
mov ecx, numlen
repnz movsb
mov edi, 800
mov esi, offset scrolltext
mov ecx, scrolllen
repnz movsb
mov edi, 960
mov esi, offset alttext
mov ecx, altlen
repnz movsb
mov edi, 1120
mov esi, offset ctrltext
mov ecx, ctrllen
repnz movsb
mov edi, 1280
mov esi, offset lefttext
mov ecx, leftlen
repnz movsb
mov edi, 1440
mov esi, offset righttext
mov ecx, rightlen
repnz movsb
ret
update_screen endp

changedata proc
or al, al                               ; if al = 0, the bit was set
jnz @@changedata_over
mov ah, 13h
jmp @@changedata_over2
@@changedata_over:
mov ah, 7
@@changedata_over2:
movzx edi, word ptr [esp+2]
movzx ecx, word ptr [esp+4]
shr ecx, 1
inc edi
mov ds:[edi], ah
dec ecx
@@changedata_loopy:
add edi, 2
mov byte ptr [edi], ah
dec ecx
jnz @@changedata_loopy
ret
changedata endp
end start
