;----------------------------------------------------------------------;
;                               Process Walk                           ;
;----------------------------------------------------------------------;
; This program shows how to make use of toolhelp32 functions. More     ;
; specifically, it demonstrates how to enumerate processes and modules ;
; It shows a simple dialog box with a combobox and a listbox. The      ;
; combobox will be filled with the names of the processes in the system;
; and the listbox will be filled with the names of the modules in each ;
; process.                                                             ;
; Coded by Iczelion   (Iczelion@galaxycorp.com                         ;
;----------------------------------------------------------------------;
.386
.model flat,stdcall

include windows.inc
include user32.inc
include kernel32.inc
include th32.inc
includelib user32.lib
includelib kernel32.lib
includelib th32.lib

ShowModule PROTO hDlg:DWORD             ; Function prototype

.data?                                  ; uninitialized data section
hSnapshot HANDLE ?                      ; snapshot handle
ProcIDArray dd 1024 dup(?)              ; array of processId

.const                                  ; constant section
IDD_PROC              equ 101           ; ID of the dialog box
IDC_PROCESS           equ 1001          ; ID of the process combobox
IDC_MODULE            equ 1002          ; ID of the module listbox


.code
start:
        invoke GetModuleHandle, NULL    ; Retrieve the instance handle
        mov   edx, OFFSET DlgProc               
        invoke DialogBoxParam,eax, IDD_PROC,NULL,edx,NULL       ; Create the main dialog box
        invoke ExitProcess,eax
        
DlgProc proc uses edi esi hDlg:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM
        LOCAL pe32:PROCESSENTRY32       ; create a structure of type PROCESSENTRY32
        LOCAL buffer[261]:BYTE          ; allocate an block of memory for the names of the processes
        mov   eax,uMsg
        .if eax==WM_INITDIALOG          ; When the dialog box is initalized
                mov esi,offset ProcIDArray      ; We use esi as the current offset of the first empty dword in ProcIDArray
                invoke CreateToolhelp32Snapshot,TH32CS_SNAPPROCESS,NULL  ; Create the snapshot handle for process enumeration. 
                mov hSnapshot,eax
                mov pe32.dwSize,sizeof PROCESSENTRY32   ; dwSize is the only member we must fill in
                invoke Process32First,hSnapshot,addr pe32  ; Retrieve the info about the first process
                .while eax==TRUE                ; If there are some processes left, continue enumeration
                
                        push pe32.th32ProcessID ; Save the processId into ProcIDArray for enumeration of modules in each process
                        pop dword ptr [esi]
                        add esi,4
                        ;---------------------------------------------------------;
                        ; szExeFile contains the full pathname of the executable  ;
                        ; But we want only the filename so we must search for the ;
                        ; last "\" character. The string following the last "\" is;
                        ; the filename                                            ;
                        ;---------------------------------------------------------;
                        invoke lstrlen,addr pe32.szExeFile
                        std             ; Reverse the direction of the search
                        lea edi,pe32.szExeFile
                        add edi,eax
                        dec edi         ; starting from the last character in szExeFile
                        mov ecx,MAX_PATH
                        mov al,"\"
                        repne scasb
                        inc edi
                        inc edi
                        cld
                        
                        invoke lstrcpy,addr buffer,edi
                        invoke CharLower,addr buffer    ; convert the name to lower case so that it's easy for the eye ;)
                        invoke SendDlgItemMessage,hDlg,IDC_PROCESS,CB_ADDSTRING,NULL,addr buffer ; add the filename into the combobox
                        invoke Process32Next,hSnapshot,addr pe32        ; Retrieve the info on the next process
                .endw
                invoke SendDlgItemMessage,hDlg,IDC_PROCESS,CB_SETCURSEL,0,NULL ; Select the first process
                invoke CloseHandle,hSnapshot    ; close snapshot handle
                invoke ShowModule,hDlg          ; enumerate the modules in the selected process
        .elseif eax==WM_CLOSE
                invoke EndDialog,hDlg,0         ; Close the dialog box when the user presses "x" button
        .elseif eax==WM_COMMAND
                mov eax,wParam
                .if ax==IDC_PROCESS
                        shr eax,16
                        .if eax==CBN_SELCHANGE          ; If the user changes the selection in the process combobox
                                invoke ShowModule,hDlg  ; enumerate the modules in that process
                        .endif
                .endif
        .else
                mov eax,FALSE
                ret
        .endif
        mov eax,TRUE
        ret
DlgProc endp

ShowModule PROC hDlg:DWORD
        LOCAL ProcessID:DWORD
        LOCAL me32:MODULEENTRY32
        LOCAL buffer[261]:BYTE
        invoke SendDlgItemMessage,hDlg,IDC_MODULE,LB_RESETCONTENT,0,0 ; clear all content of the listbox
        invoke SendDlgItemMessage,hDlg,IDC_PROCESS,CB_GETCURSEL,0,0  ; Retrieve the index of the currently selected item in the combobox
        mov ecx,4       ; We use the returned index as the index into ProcIDArray
        mul ecx
        add eax,offset ProcIDArray
        push dword ptr [eax]
        pop ProcessID
        invoke CreateToolhelp32Snapshot,TH32CS_SNAPMODULE,ProcessID ; Create the snapshot for module enumeration
        mov hSnapshot,eax
        mov me32.dwSize,sizeof MODULEENTRY32    ; This is the only member of MODULEENTRY32 that must be initialized
        invoke Module32First,hSnapshot,addr me32 ; Retrieve the info on the first module
        .while eax==TRUE
                invoke SendDlgItemMessage,hDlg,IDC_MODULE,LB_ADDSTRING,NULL,addr me32.szModule ; add the module name to the listbox
                invoke Module32Next,hSnapshot,addr me32 ; Retrieve info on the next module
        .endw
        invoke CloseHandle,hSnapshot  ; Close snapshot handle
        ret
ShowModule ENDP

end start


