
// Accompanies 'socket2.html' from http://cornsoup.cjb.net/   w00000.

#include <winsock2.h>
#include <windows.h>

WSADATA Wsinfo;
SOCKET s,connected;
struct sockaddr_in host;
struct timeval timeout;
fd_set s_set;

char myhost[128];
char buf[1024];

void xlate_host( struct sockaddr_in *sa, char *hostname, unsigned int port )
{
   struct hostent *hp;
   unsigned long ip;

   hp = gethostbyname( hostname );
   if( hp == NULL )
   {
      ip = inet_addr( hostname );
      memcpy( (char*)&sa->sin_addr,&ip,4 );
   }
   else memcpy( (char*)&sa->sin_addr,hp->h_addr,hp->h_length );

   sa->sin_family = AF_INET;
   sa->sin_port = htons( port );
}

void main( void )
{
   WSAStartup( MAKEWORD(2,0),&Wsinfo );

   gethostname( myhost,sizeof(myhost) );
   xlate_host( &host,myhost,6969 );
   
   s = socket( AF_INET,SOCK_STREAM,0 );
   bind( s,(struct sockaddr*)&host,sizeof(host) );
   listen( s,1 );
   connected = accept( s,NULL,NULL );

   timeout.tv_sec = 0;
   timeout.tv_usec = 500;

   while( !(strchr( buf,'X' )) )
   {
      FD_ZERO( &s_set );
      FD_SET( connected,&s_set );

      if( select( 0,&s_set,NULL,NULL,&timeout ) )       // read notification
      {
         memset( buf,0,sizeof(buf) );
         recv( connected,buf,sizeof(buf),0 );
         printf( "%s",buf );
         send( connected,buf,sizeof(buf),0 );
      }
   }

   closesocket( connected );

   WSACleanup();
}

