# coloreipred.py - deroko of ARTeam
#
# Small script to color all eip redirection EIPs inside of a 
# procedure inside of IDA
# Colors are as follows:
#       blue   - call instructions
#       yellow - jcc/jmp instructions
#       red    - ret instruction
#       green  - call/jmp [mem/reg]
#
#       Maybe it will be useful to somebody, it binds to key "i"
#       but it can be changed at the bottom of source code
#                               deroko of ARTeam
import	idaapi
import	idc
import  colorsys

#stop insts
stop_list = [
        idaapi.NN_retn,
        idaapi.NN_retf,
        idaapi.NN_retnq,
        idaapi.NN_retfq
        ];
	
#list of jcc instructions
jcc_list = [
        idaapi.NN_ja,
        idaapi.NN_jae,
        idaapi.NN_jb,
        idaapi.NN_jbe,
        idaapi.NN_jc,
        idaapi.NN_je,
        idaapi.NN_jg,
        idaapi.NN_jge,
        idaapi.NN_jl,
        idaapi.NN_jle,
        idaapi.NN_jna,
        idaapi.NN_jnae,
        idaapi.NN_jnb,
        idaapi.NN_jnbe,
        idaapi.NN_jnc,
        idaapi.NN_jne,
        idaapi.NN_jng,
        idaapi.NN_jnge,
        idaapi.NN_jnl,
        idaapi.NN_jnle,
        idaapi.NN_jno,
        idaapi.NN_jnp,
        idaapi.NN_jns,
        idaapi.NN_jnz,
        idaapi.NN_jo,
        idaapi.NN_jp,
        idaapi.NN_jpe,
        idaapi.NN_jpo,
        idaapi.NN_js,
        idaapi.NN_jz,
        idaapi.NN_jcxz,
        idaapi.NN_jecxz,
        idaapi.NN_jrcxz,
        idaapi.NN_jmp,
        idaapi.NN_jmpni,
        idaapi.NN_jmpshort,
        idaapi.NN_loop,
        idaapi.NN_loopq,
        idaapi.NN_loope,
        idaapi.NN_loopqe,
        idaapi.NN_loopne,
        idaapi.NN_loopqne
        ];

def get_yellow():
        r = 0xFF/255.0;
        g = 0xFF/255.0;
        b = 0x00/255.0;
        
        (h,s,v) = colorsys.rgb_to_hsv(r,g,b);
        s -= 0.6;
        (r,g,b) = colorsys.hsv_to_rgb(h,s,v);
        ida_color = (int(b*255) << 16) + (int(g*255)<<8) + int(r*255);
	return ida_color;
	
def get_blue():
	r = 0x00/255.0;
        g = 0x00/255.0;
        b = 0xff/255.0;
        
        (h,s,v) = colorsys.rgb_to_hsv(r,g,b);
        s -= 0.7;
        (r,g,b) = colorsys.hsv_to_rgb(h,s,v);
        #it's BGR
        ida_color = (int(b*255) << 16) + (int(g*255)<<8) + int(r*255);
        return ida_color;

def get_green():
	r = 0x00/255.0;
        g = 0xff/255.0;
        b = 0x00/255.0;
        
        (h,s,v) = colorsys.rgb_to_hsv(r,g,b);
        s -= 0.7;
        (r,g,b) = colorsys.hsv_to_rgb(h,s,v);
        #it's BGR
        ida_color = (int(b*255) << 16) + (int(g*255)<<8) + int(r*255);
        return ida_color;

def get_red():
	r = 0xff/255.0;
        g = 0x00/255.0;
        b = 0x00/255.0;
        
        (h,s,v) = colorsys.rgb_to_hsv(r,g,b);
        s -= 0.7;
        (r,g,b) = colorsys.hsv_to_rgb(h,s,v);
        #it's BGR
        ida_color = (int(b*255) << 16) + (int(g*255)<<8) + int(r*255);
        return ida_color;
        
def inst_is_jcc():
        i = idaapi.cmd.itype;
        for x in jcc_list:
                if x == i: return True;
        return False;
def inst_is_call():
        i = idaapi.cmd.itype;
        if i == idaapi.NN_call or i == idaapi.NN_callfi or i == idaapi.NN_callni:
                return True;
        return False;

def inst_is_ret():
        i = idaapi.cmd.itype;
        for x in stop_list:
                if x == i: return True;
        return False;

def is_indirect():
	op = idaapi.cmd.Operands[0];
	if not op:
		return False;
	if op.type in [idaapi.o_mem, idaapi.o_displ, idaapi.o_reg, idaapi.o_phrase]:
		return True;
	return False;

def main():
        eip = idaapi.get_screen_ea();
        function = idaapi.func_item_iterator_t();
        function.set(idaapi.get_func(eip));
        	
        b_ok = function.first();
        while b_ok:
                eip = function.current();
                inslen = idaapi.decode_insn(function.current());
                if inslen == 0:
                        b_ok = function.next_code();
                        continue;	
                if inst_is_call():
			color = get_blue();
			if is_indirect():
				color = get_green();
			idc.SetColor(eip, CIC_ITEM, color);	
                elif inst_is_jcc():                                      
                        color = get_yellow();
			if is_indirect():
				color = get_green();
			idc.SetColor(eip, CIC_ITEM, color);
                elif inst_is_ret():			                      
                        color = get_red();
			idc.SetColor(eip, CIC_ITEM, color);
                b_ok = function.next_code();		

if __name__ == "__main__":
	idaapi.CompileLine('static color_key() { RunPythonStatement("main()"); }')
        # Add the hotkey
        AddHotkey("i", 'color_key');


