/*
        Dream Of Every Reverser
                        deroko of ARTeam

        History:
        - development started 5-May-2007
        - stable version      6-May-2007
        
        - both addressing modes supported (PAE and "normal")
        - engine uses User/SuperVisor flag to catch access to specified
          range, and P bit for access to not present pages... This is 
          r3 memory so both cases should be handled!!!!
        
        - win2k3 not supported
        - MP support (optional)
        - no kaspersky shit support
        - public version only traces eip
*/



#include "ntddk.h"
#include "ntimage.h"
#include "my_ring0.h"
#include "tracer.h"
#include "pe.h"

#define CURRENT_VERSION 0x00010000                        //1.0

#define true  1
#define false 0 

__declspec(dllimport) KeService KeServiceDescriptorTable; //for future use
__declspec(dllimport) DWORD NtBuildNumber;                //for future use
__declspec(dllimport) DWORD NtCreateFile;                 //one export for ntos base seacrhing...

__declspec(dllimport) NTSTATUS PsLookupProcessByProcessId(IN DWORD, OUT PEPROCESS);
__declspec(dllimport) NTSTATUS PsSetCreateProcessNotifyRotuine(IN PCREATE_PROCESS_NOTIFY_ROUTINE, IN BOOLEAN);
__declspec(dllimport) void KeAttachProcess(IN PEPROCESS);
__declspec(dllimport) void KeDetachProcess();

DWORD   SwapContext = 0;
DWORD   c_SwapContext = 0;
DWORD   Old_Int0E;
DWORD   Old_Int01;
DWORD   EipInRangeAddress;
DWORD   tracerStatus;
DWORD   NumberOfBreaks;
DWORD   BreakCount;
BOOLEAN PaeEnabled;

/*
 change device name/symlink name to bypass any checks for tracer name
 */
WCHAR   szDevice[]  = L"\\Device\\tracer";
WCHAR   szSymlink[] = L"\\DosDevices\\tracer";
char EipInRange[] = "eip in range at 0x%.08X\n";

BreakPoint Bpx;
PEPROCESS  GlobalEprocess;
PMDL mdl;

#define SET_RANGE   CTL_CODE(FILE_DEVICE_UNKNOWN, 0x820, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define GET_VERSION CTL_CODE(FILE_DEVICE_UNKNOWN, 0x830, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define STOP_TRACER CTL_CODE(FILE_DEVICE_UNKNOWN, 0x840, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define GET_REGS    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x850, METHOD_BUFFERED, FILE_ANY_ACCESS) //not used atm in public version
#define CON_TRACE   CTL_CODE(FILE_DEVICE_UNKNOWN, 0x860, METHOD_BUFFERED, FILE_ANY_ACCESS) //not used atm in public version

BYTE SwapContextPatern[] = {
                           0x0A, 0xC9,                          //or cl, cl
                           0X26, 0xC6, 0x46, 0x2D, 0x02,        //mov byte ptr es:[esi+2dh], 2
                           0x9c                                 //pushfd
                           };
                        
void __stdcall NotifyRoutine(IN HANDLE ParentId, IN HANDLE ProcessId, IN BOOLEAN Create){
        DWORD c_Cr3;
        
        __asm   mov     eax, cr3
        __asm   mov     c_Cr3, eax
        
        if (Bpx.Cr3 != c_Cr3)
                return;
        if (!Create){
                __asm mov  eax, false
                __asm lock xchg Bpx.Active, al          
                        
                Bpx.Cr3 = 0;                            //kill breakpoint :)
                Bpx.StartRange = 0;
                Bpx.Size = 0;
                GlobalEprocess = 0;                
        }
        return;
}            
NTSTATUS ServiceHandle(IN PDEVICE_OBJECT pDevice, IN PIRP pIrp){
        PIO_STACK_LOCATION StackLocation;
        DWORD status = 0;
        DWORD information = 0;
        ProcessInfo *pinfo;
        NTSTATUS retStatus;
        PEPROCESS eprocess;
        DWORD current;
        
        StackLocation = IoGetCurrentIrpStackLocation (pIrp);
        switch(StackLocation->Parameters.DeviceIoControl.IoControlCode){
                case SET_RANGE:
                        if (StackLocation->Parameters.DeviceIoControl.InputBufferLength < sizeof (ProcessInfo)){
                                status = STATUS_INVALID_PARAMETER;
                                break;
                        }
                        
                        pinfo = (ProcessInfo *)pIrp->AssociatedIrp.SystemBuffer;
                        
                        Bpx.StartRange = pinfo->StartRange & 0xFFFFF000;                 //round to 4kb
                        
                        //ring0 pages not supported!!!
                        if (Bpx.StartRange > 0x80000000){
                                DbgPrint("No r0 memory tracing is supported atm\n");
                                status = STATUS_INVALID_PARAMETER;
                                break;
                        }
                        //round size to 1PAGE (on ia32 it is alwas 4kb for r3)
                        if ((pinfo->Size % 0x1000))
                                Bpx.Size = pinfo->Size + 0x1000 - (pinfo->Size % 0x1000);
                        else
                                Bpx.Size = pinfo->Size;
                        
                        retStatus = PsLookupProcessByProcessId(pinfo->Pid, (PEPROCESS)&eprocess);                    
                        
                        if (retStatus != 0){
                                DbgPrint("Failed to obtain EPROCESS of process : 0x%.08X\n", pinfo->Pid);
                                status = STATUS_INVALID_PARAMETER;
                                break;
                        }
                        
                        KeAttachProcess(eprocess);

                        __try{
                                //simply load pages by accessing them
                                //this will page in pages which are paged out
                                //not needed, but I'm checking addresses range!!!!
                                ProbeForRead((void *)Bpx.StartRange, Bpx.Size,  1);
                                current = Bpx.StartRange;
                                while (current < Bpx.StartRange + Bpx.Size){
                                        __asm mov eax, current
                                        __asm mov eax, [eax]
                                        current+=0x1000;
                                }
                                
                        }__except(EXCEPTION_EXECUTE_HANDLER){
                                DbgPrint("faild to access pages...\n");
                                KeDetachProcess();
                                ObDereferenceObject(eprocess);
                                status = STATUS_INVALID_PARAMETER;
                                break;
                        }
                        NumberOfBreaks = pinfo->NumberOfBreaks;
                        BreakCount = 0;
                        
                        __asm mov eax, cr3
                        __asm mov Bpx.Cr3, eax
                        Bpx.Pid = pinfo->Pid;                        
                        //MemoryBreak points are set by SwapContext hook         
                        KeDetachProcess();
                        ObDereferenceObject(eprocess);
                        GlobalEprocess = eprocess;

                        __asm mov eax, true
                        __asm lock xchg Bpx.Active, al          ;tell int 0e hook that it should trace now!!!!
                                                                
                        status = STATUS_SUCCESS;
                        break;
                        
                case STOP_TRACER:
                        __asm mov eax, false
                        __asm lock xchg Bpx.Active, al          ;tell int 0e hook to do not perform any action!!!!
                        
                        Bpx.Cr3 = 0;                            //kill breakpoint :)
                        Bpx.StartRange = 0;
                        Bpx.Size = 0;
                        GlobalEprocess = 0;

                        status = STATUS_SUCCESS;
                        break;
                        
                case GET_VERSION:
                        if (StackLocation->Parameters.DeviceIoControl.OutputBufferLength < 4){
                                status = STATUS_INVALID_PARAMETER;
                                break;
                        }
                        *(DWORD *)pIrp->AssociatedIrp.SystemBuffer = CURRENT_VERSION;
                        information = 4;
                        status = STATUS_SUCCESS;
                        break;
                case CON_TRACE:
                        if (StackLocation->Parameters.DeviceIoControl.InputBufferLength < 4){
                                status = STATUS_INVALID_PARAMETER;
                                break;
                        }
                        tracerStatus = *(DWORD *)pIrp->AssociatedIrp.SystemBuffer;
                        status = STATUS_SUCCESS;
                        break;  
                case GET_REGS:
                        if (StackLocation->Parameters.DeviceIoControl.OutputBufferLength < 4){
                                status = STATUS_INVALID_PARAMETER;
                                break;
                        }
                        *(DWORD *)pIrp->AssociatedIrp.SystemBuffer = EipInRangeAddress;
                        information = 4;
                        status = STATUS_SUCCESS;
                        break;
                default:
                        DbgPrint("unknown IOCTL sent...");
                        status =  STATUS_NOT_IMPLEMENTED;
                        break;
                }
                
        pIrp->IoStatus.Status = status;
        pIrp->IoStatus.Information = information;
        IofCompleteRequest(pIrp, IO_NO_INCREMENT);
        return status;
}


DWORD __stdcall NumBreaksReached(){
        BreakCount++;
        if (NumberOfBreaks == BreakCount)
                return 1;
         return 0;
        }
        
void DeactivateAll_NoPAE(){
        DWORD current;
        current = Bpx.StartRange;
        while (current < Bpx.StartRange + Bpx.Size){
                __asm{
                        mov     eax, current
                        shr     eax, 22
                        test    dword ptr[eax*4+0C0300000h], 1
                        jz      __next_danp
                        mov     eax, current
                        shr     eax, 12
                        lea     eax, [eax*4+0C0000000h]
                        test    dword ptr[eax], 1
                        jz      __next_danp
                        or      dword ptr[eax], 04h              ;set user bit in pte

__next_danp:                        
                }
                current += 0x1000;
        }
        return;       
}        

void DeactivateAll_PAE(){
        DWORD current;
        current = Bpx.StartRange;
        while (current < Bpx.StartRange + Bpx.Size){
                __asm{
                        mov     eax, current
                        shr     eax, 21
                        test    dword ptr[eax*8+0C0600000h], 1
                        jz      __next_da
                        mov     eax, current
                        shr     eax, 12
                        lea     eax, [eax*8+0C0000000h]
                        test    dword ptr[eax], 1
                        jz      __next_da
                        or      dword ptr[eax], 04h              ;set user bit in pte

__next_da:                        
                }
                current += 0x1000;
        }
        return;       
}

void ActivateAll_NoPAE(){
        DWORD current;
        current = Bpx.StartRange;
        while (current < Bpx.StartRange + Bpx.Size){
                __asm{
                        mov     eax, current
                        shr     eax, 22
                        test    [eax*4+0C0300000h], 1
                        jz      __next_aanp
                        mov     eax, current
                        shr     eax, 12
                        lea     eax, [eax*4+0C0000000h]
                        test    dword ptr[eax], 1
                        jz      __next_aanp
                        and     dword ptr[eax], 0FFFFFFFBh              ;wipe user bit from PTE

__next_aanp:        
                }
                current += 0x1000;
        }
        __asm   mov     eax, cr3                        ;flush TLB... make sure that translation goes trough PTE
        __asm   mov     cr3, eax                        ;which will force cpu to see supervisor page...        
        return;       
}

void ActivateAll_PAE(){
        DWORD current;
        current = Bpx.StartRange;
        while (current < Bpx.StartRange + Bpx.Size){
                __asm{
                        mov     eax, current
                        shr     eax, 21
                        test    [eax*8+0C0600000h], 1
                        jz      __next_aa
                        mov     eax, current
                        shr     eax, 12
                        lea     eax, [eax*8+0C0000000h]
                        test    dword ptr[eax], 1
                        jz      __next_aa
                        and     dword ptr[eax], 0FFFFFFFBh              ;wipe user bit from PTE

__next_aa:        
                }
                current += 0x1000;
        }
        __asm   mov     eax, cr3                        ;flush TLB... make sure that translation goes trough PTE
        __asm   mov     cr3, eax                        ;which will force cpu to see supervisor page...        
        return;       
}


void DeactivateAll(){
        if (PaeEnabled)
                DeactivateAll_PAE();
        else
                DeactivateAll_NoPAE();
        return;
}

void ActivateAll(){
        if (PaeEnabled)
                ActivateAll_PAE();
        else
                ActivateAll_NoPAE();
        return;
}


DWORD __stdcall PaeSpecialCase(DWORD c_cr2){
       DWORD retStatus;
       if (!PaeEnabled)         //no PAE so we return 0
                return 0;
        // special case of handling PAE page permissions
        // windows uses high bits of PAE PTE to do some
        // operations, in this case even if everything is 
        // logged execution should be transfered to KiTrap0E
       
       // page is present in memory otherwise we wouldn't be here!!
       __asm{
                mov     eax, c_cr2
                shr     eax, 12
                mov     eax, [eax*8+0C0000004h]
                shr     eax, 4
                mov     retStatus, eax
        }
        return retStatus;
}        
                
__declspec(naked) void New_Int0E_PAE(){
        __asm{
                pushad                                  ;r0 prolog
                push    fs
                push    ds
                push    es
                mov     eax, 30h                        ;KPCR
                mov     fs, ax
                mov     eax, 23h
                mov     ds, ax
                mov     es, ax
                
                cmp     Bpx.Active, true
                jne     __old_int0e
                cmp     [esp.regEip], 80000000h
                ja      __old_int0e                
                
                call    PsGetCurrentProcessId
                cmp     Bpx.Pid, eax
                jne     __old_int0e
                               
                mov     eax, cr2                        ;determine if it is traced range...
                cmp     eax, 80000000h                  ;dont handle kernel memory
                ja      __old_int0e                     
                mov     ecx, Bpx.StartRange
                cmp     eax, ecx
                jb      __old_int0e
                add     ecx, Bpx.Size
                cmp     eax, ecx
                jae     __old_int0e
              
                test    [esp.regErrorCode], 1           ;pf occured because user tried to access supervisor page :)
                jnz     __fault_supervisor        
                                                        ;otherwise it is fault because this page is paged out...
                mov     eax, cr2
                cmp     [esp.regEip], eax              
                jne     __readwritePbit
                
                call    NumBreaksReached
                test    eax, eax
                jz      __readwritePbit
                
                mov     eax, cr2
                push    eax
                push    offset EipInRange
                call    DbgPrint
                add     esp, 8
                call    DeactivateAll
                mov     al, false
                lock    xchg    Bpx.Active, al
                jmp     __old_int0e                     ;handle P bit by default handler...
                
__readwritePbit:
                call    DeactivateAll
                or      Bpx.Flags, SINGLE_STEP_MODE
                mov     eax, [esp.regEip]
                mov     Bpx.ReadWriteEip, eax
                or      [esp.regEflags], 100h
                jmp     __old_int0e


__fault_supervisor:
                mov     eax, cr2
                cmp     [esp.regEip], eax
                jne     __readwrite
                
                call    NumBreaksReached
                test    eax, eax
                jz      __readwrite                
                
                mov     eax, cr2
                push    eax
                push    offset EipInRange
                call    DbgPrint
                add     esp, 8
                
                call    DeactivateAll
                mov     al, false
                lock    xchg    Bpx.Active, al
                jmp     __invlpg
                
__readwrite:    

                call    DeactivateAll                   ;remove all breaks while copying is in progress!!!
                or      Bpx.Flags, SINGLE_STEP_MODE     ;
                mov     eax, [esp.regEip]
                mov     Bpx.ReadWriteEip, eax
                or      [esp.regEflags], 100h           ;set T flag and execute code!!!!
__invlpg:
                mov     eax, cr2
                invlpg  [eax]                           ;flush tlb and use new set of permissions for this page...
                push    eax
                call    PaeSpecialCase                  ;handle special case when PAE is enabled
                test    eax, eax
                jnz     __old_int0e
                test    [esp.regErrorCode], 2           ;if exception occured due to write call old int handler!!!
                jnz     __old_int0e                     ;since on PAE r/w bit is not set but is managed by windows
                pop     es                              ;internaly so still old handler should be called
                pop     ds
                pop     fs
                popad
                add     esp, 4
                iretd
        
        
        
__old_int0e:    pop     es
                pop     ds
                pop     fs
                popad
                jmp     [Old_Int0E]
        }
}

__declspec(naked) void New_Int01(){
        __asm{
                pushad
                push    fs
                push    ds
                push    es
                mov     eax, 30h
                mov     fs, ax
                mov     eax, 23h
                mov     ds, ax
                mov     es, ax
                
                cmp     Bpx.Active, 0
                je      __old_int01     
                ;use same struct as above but keep in mind that here is not present ErrorCode, so ErrorCode is eip now :)
                call    PsGetCurrentProcessId
                cmp     eax, Bpx.Pid
                jne     __old_int01
                ;allow softice debugging of hooks, dont handle TF in kernel memory
                cmp     [esp.regErrorCode], 80000000h
                ja      __old_int01              ;call sice... 
                test    Bpx.Flags, SINGLE_STEP_MODE
                jz      __old_int01               
                mov     eax, [esp.regErrorCode]  ;instruction is completly executed
                cmp     eax, Bpx.ReadWriteEip
                jne     __stoptf
                or      [esp.regCs], 100h
                pop     es
                pop     ds
                pop     fs
                popad
                iretd

__stoptf:       mov     Bpx.Flags, 0
                mov     Bpx.ReadWriteEip, 0
                call    ActivateAll             ;activate all breakpoints on memory
                and     [esp.regCs], 0FFFFFEFFh
                pop     es
                pop     ds
                pop     fs
                popad
                iretd                

__old_int01:    pop     es
                pop     ds
                pop     fs
                popad
                jmp     [Old_Int01]
        }
}

__declspec(naked) void SetWP(){
        __asm{
                push    eax
                mov     eax, cr0
                or      eax, 10000h
                mov     cr0, eax
                pop     eax
                ret
        }
}

__declspec(naked) void ClearWP(){
        __asm{
                push    eax
                mov     eax, cr0
                and     eax, 0FFFEFFFFh
                mov     cr0, eax
                pop     eax
                ret
        }
}

/*
        hooking SwapContext with faking ret address on stack is good way to gain
        control over SwapContext on exit, but it also makes driver unloadable!!!
        We don't know how many threads have changed ret address on stack, and
        once scheduled to run those will return to unexisting code if driver is
        unloaded. 
*/

//ret in SwapContext returns here
__declspec(naked) void Hook_SwapContextOnExit(){
        __asm{
                pushad                                          ;save all registers
                pushfd                                          ;save eflags
                
                cmp     Bpx.Active, 0
                je      __dontactivate 
                mov     eax, cr3
                cmp     Bpx.Cr3, eax
                jne     __dontactivate
                test    Bpx.Flags, SINGLE_STEP_MODE             ;singlesteping?
                jnz     __dontactivate                          ;dont activate breakpoints now...
                
                call    ActivateAll

__dontactivate:                
                popfd                                           ;restore eflags
                popad                                           ;restore all registers
                retn                                            ;take return address of stack (old ret address)
        }
}


__declspec(naked) void Hook_SwapContext(){
        __asm{
                push    offset Hook_SwapContextOnExit           ;set new ret address on stack
                                                                ;old address will be picked up by OnExitHook
                pushad                                          ;save registers
                pushfd                                          ;save eflags
                
                cmp     Bpx.Active, 0
                je      __dontdeactivate
                mov     eax, cr3
                cmp     Bpx.Cr3, eax
                jne     __dontdeactivate
                
                call    DeactivateAll
                
__dontdeactivate:
                popfd                                           ;restore registers
                popad                                           ;restore eflags
                
                or      cl, cl                                  ;old bytes of SwapContext
                mov     byte ptr es:[esi+2dh], 2                ;KTHREAD.State 
                pushfd                                          
                
                jmp     [c_SwapContext]                         ;jmp to rest of SwapContext
        }
}

__declspec(naked) void HookSwapContext(){
        __asm{
                pushad
                
                cli
                call    ClearWP
                
                mov     esi, SwapContext
                mov     byte ptr[esi], 0e9h
                add     esi, 5
                mov     eax, offset Hook_SwapContext
                sub     eax, esi
                mov     dword ptr[esi-4], eax
                mov     esi, SwapContext
                add     esi, 8
                mov     c_SwapContext, esi
                
                call    SetWP
                sti
                
                popad
                retn
        }
}

void __stdcall HookInterrupt(DWORD IDT_Vector, DWORD NewIntHandler, DWORD* OldHandler){
        DWORD OldIntHandler;
        __asm{
                push    ecx
                sidt    fword ptr[esp-2]
                pop     ecx
                
                mov     eax, IDT_Vector
                lea     ecx, [eax*8+ecx]
                
                cli
                
                movzx   ebx, word ptr[ecx+6]
                shl     ebx, 16
                mov     bx, word ptr[ecx]
                mov     eax, OldHandler
                mov     [eax], ebx
                
                mov     ebx, NewIntHandler
                mov     word ptr[ecx], bx
                shr     ebx, 16
                mov     word ptr[ecx+6], bx
                
                sti
        }
        return;
}


NTSTATUS UnloadMe(IN PDRIVER_OBJECT pDriverObject){
        UNICODE_STRING symlink;

        RtlInitUnicodeString(&symlink, szSymlink);
        IoDeleteSymbolicLink(&symlink);
        IoDeleteDevice(pDriverObject->DeviceObject);
    
        return STATUS_SUCCESS;
}
                 
NTSTATUS CreateCloseHandler(IN PDEVICE_OBJECT pDevice, IN PIRP pIrp){
        pIrp->IoStatus.Status = STATUS_SUCCESS;
        pIrp->IoStatus.Information = 0;
        IofCompleteRequest(pIrp, IO_NO_INCREMENT);
        return STATUS_SUCCESS;
}

NTSTATUS DriverEntry(IN PDRIVER_OBJECT pDriverObject, IN PUNICODE_STRING pRegPath){ 
        UNICODE_STRING device, symlink;
        PDEVICE_OBJECT pDeviceObject;
        DWORD ntosbase, current, c_Cr4;
        IMAGE_DOS_HEADER *mz;
        peheader_struct *pe;
        
        DbgPrint("Dream Of Every Reverser tracing engine\n");
        DbgPrint("             (c) 2007 deroko of ARTeam\n");    
        /* 
                mov eax, cr4
                need to detect if PAE is enabled or not
        */
        __asm  _emit  0x0F           
        __asm  _emit  0x20
        __asm  _emit  0xE0
        __asm   mov c_Cr4, eax
        
        if (c_Cr4 & 0x20){
                DbgPrint("PAE Enabled\n");
                PaeEnabled = true;
        }else{
                DbgPrint("PAE Disabled\n");
                PaeEnabled = false;
        }
                     
                     
        //__try/__except protects us from memory searchg page faults
        //if those go fine, then there is nothing that can stop us
        //form hooking code :)
        __try{        
                ntosbase = (DWORD)&NtCreateFile;
                ntosbase &= 0xFFFFF000;
        
                while (*(WORD *)ntosbase != 'ZM')
                        ntosbase-=0x1000; 
      
                mz = (IMAGE_DOS_HEADER *)ntosbase;
                pe = (peheader_struct *)(ntosbase + mz->e_lfanew);  
        
                //find SwapContext
                current = ntosbase;
                while (!(current > ntosbase + pe->pe_sizeofimage - sizeof(SwapContextPatern))){
                        if (!(memcmp((void *)current, (void *)SwapContextPatern, sizeof(SwapContextPatern)))){
                                SwapContext = current;
                                DbgPrint("ntoskrnl base located at 0x%.08X\n", ntosbase);
                                DbgPrint("SwapContext located at 0x%.08X\n", SwapContext);
                                HookSwapContext();
                                DbgPrint("Hooking SwapContext\n");
                                //MP Support
                                //PKTHREAD cthread;
                                //UCHAR i;
                                //for (i = 0; i < KeNumberProcessors; i++){
                                //      KeSetAffinityThread(cthread, 1 << i);
                                HookInterrupt(0x0E, (DWORD)New_Int0E_PAE, &Old_Int0E );
                                DbgPrint("Hooking Int 0Eh\n");
                                HookInterrupt(0x01, (DWORD)New_Int01, &Old_Int01);
                                DbgPrint("Hooking Int 01h\n");
                                //}
                                PsSetCreateProcessNotifyRoutine((PCREATE_PROCESS_NOTIFY_ROUTINE)NotifyRoutine, FALSE);
                                DbgPrint("Installing onexit notify routine...\n");
                                break;
                        }
                        current++;
                }
        }__except(EXCEPTION_EXECUTE_HANDLER){
                DbgPrint("Failed to retrive SwapContext and ntosbase\n");
                return STATUS_DEVICE_CONFIGURATION_ERROR;
        }
             
        RtlInitUnicodeString(&device, szDevice);
        IoCreateDevice(pDriverObject, 0, &device, FILE_DEVICE_UNKNOWN, 0, 0, &pDeviceObject); 
        RtlInitUnicodeString(&symlink, szSymlink);
        IoCreateSymbolicLink(&symlink,&device);
        
        pDriverObject->MajorFunction[IRP_MJ_DEVICE_CONTROL] = ServiceHandle;
        pDriverObject->MajorFunction[IRP_MJ_CREATE] = \
        pDriverObject->MajorFunction[IRP_MJ_CLOSE] = CreateCloseHandler;
        /* 
         Due to hook in SwapContext this driver must not be unloaded
        */
        //pDriverObject->DriverUnload = UnloadMe;
        DbgPrint("Tracing engine loaded...\n");
        return STATUS_SUCCESS;
}

