/****************************************************************************
 *   dotnet dumper
 *   Copyright (C) 2011  deroko of ARTeam
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************/
 
struct container_struct{
        CHAR    *Name;
        CHAR    *Type;
};

struct containers{
        CHAR    *Name;
        struct  container_struct *pcont;
};

struct container_struct  Assembly_Table[] = {
        {"HashAlgId",      "dword"      },
        {"MajorVersion",   "word"       },
        {"MinorVersion",   "word"       },
        {"BuildNumber",    "word"       },
        {"RevisionNumber", "word"       },
        {"Flags",          "dword"      },
        {"PublicKey",      "index blob" },
        {"Name",           "index string"},
        {"Culture",        "index string"},
        {NULL,             NULL          }
};

struct container_struct AssemblyOS_Table[] = {
        {"OSPlatformID",        "dword"},
        {"OSMajorVersion",      "dword"},
        {"OSMinorVersion",      "dword"},
        {NULL,                  NULL   }
};

struct container_struct  AssemblyProcessor_Table[] = {
        {"Processor",    "dword"},
        {NULL,           NULL   }
};

struct container_struct  AssemblyRef_Table[]  = {
        {"MajorVersion",        "word"},
        {"MinorVersion",        "word"},
        {"BuildNumber",         "word"},
        {"RevisionNumber",      "word"},
        {"Flags",               "dword"},
        {"PublicKeyOrToken",    "index blob"},
        {"Name",                "index string"},
        {"Culture",             "index string"},
        {"HashValue",           "index blob"},
        {NULL,               NULL}
};

struct  container_struct Module_Table[]  = {
        {"Generation",  "word"          },
        {"Name",        "index string"  },
        {"Mvid",        "index guid"    },
        {"EncId",       "index guid"    },
        {"EncBaseId",   "index guid"    },
        {NULL,          NULL            }
};

struct  container_struct TypeRef_Table[] = {
        {"ResolutionScope", "index coded ResolutionScope"},
        {"TypeName",        "index string"},
        {"TypeNamespace",   "index string"},
        {NULL,              NULL          }
};

struct  container_struct TypeSpec_Table[] = {
        {"Signature",       "index blob"},
        {NULL,               NULL}
};

struct  container_struct TypeDef_Table[]  = {
        {"Flags",               "dword"},
        {"TypeName",            "index string"},
        {"TypeNamespace",       "index string"},
        {"Extends",             "index coded TypeDefOrRef"},
        {"FieldList",           "index simple Field"},
        {"MethodList",          "index simple MethodDef"},
        {NULL,                   NULL}   
};

struct  container_struct StandAloneSig_Table[] = {
        {"Signature",           "index blob"},
        {NULL,                  NULL}
};

struct  container_struct PropertyMap_Table[] = {
        {"Parent",              "index simple TypeDef"},
        {"PropertyList",        "index simple Property"},
        {NULL,                  NULL}
};

struct  container_struct Property_Table[] = {
        {"Flags",               "word"},
        {"Name",                "index string"},
        {"Type",                "index blob"},
        {NULL,                  NULL}
};

struct  container_struct Param_Table[] = {
        {"Flags",               "word"},
        {"Sequence",            "word"},
        {"Name",                "index string"},
        {NULL,                  NULL}
};

struct  container_struct NestedClass_Table[] = {
        {"NestedClass",         "index simple TypeDef"},
        {"EnclosingClass",      "index simple TypeDef"},
        {NULL,                  NULL}
};

struct  container_struct ModuleRef_Table[] = {
        {"Name",                "index string"},
        {NULL,                  NULL}
};

struct  container_struct MethodSpec_Table[] = {
        {"Methood",             "index coded MethodDefOrRef"},
        {"Instatiation",        "index blob"},
        {NULL,                  NULL}
};

struct  container_struct MethodSemantics_Table[] = {
        {"Semantics",           "word"},
        {"Method",              "index simple MethodDef"},
        {"Association",         "index coded HasSemantics"},
        {NULL,                  NULL}
};

struct container_struct MethodImpl_Table[] = {
        {"Class",               "index simple TypeDef"},
        {"MethodBody",          "index coded MethodDefOrRef"},
        {"MethodDeclaration",   "index coded MethodDefOrRef"},
        {NULL,                  NULL},
};

struct container_struct MethodDef_Table[] = {
        {"RVA",                 "dword"},
        {"ImplFlags",           "word"},
        {"Flags",               "word"},
        {"Name",                "index string"},
        {"Signature",           "index blob"},
        {"ParamList",           "index simple Param"},
        {NULL,                  NULL}
};

struct  container_struct MemberRef_Table[] = {
        {"Class",               "index coded MemberRefParent"},
        {"Name",                "index string"},
        {"Signature",           "index blob"},
        {NULL,                  NULL}
};

struct  container_struct ManifestResource_Table[] = {
        {"Offset",              "dword"},
        {"Flags",               "dword"},
        {"Name",                "index string"},
        {"Implementation",      "index coded Implementation"},
        {NULL,                 NULL}
};

struct  container_struct InterfaceImpl_Table[] = {
        {"Class",               "index simple TypeDef"},
        {"Interface",           "index coded TypeDefOrRef"},
        {NULL,                  NULL}
};

struct  container_struct ImplMap_Table[] = {
        {"MappingFlags",        "word"},
        {"MemberForwared",      "index coded MemberForwarded"},
        {"ImportName",          "index string"},
        {"ImportScope",         "index simple ModuleRef"},
        {NULL,                  NULL}
};

struct container_struct GenericParamConstraint_Table[] = {
        {"Owner",               "index simple GenericParam"},
        {"Constraint",          "index coded TypeDefOrRef"},
        {NULL,                  NULL}
};

struct container_struct GenericParam_Table[] = {
        {"Number",              "word"},
        {"Flags",               "word"},
        {"Owner",               "index coded TypeOrMethodDef"},
        {"Name",                "index string"},
        {NULL,                  NULL}
};

struct container_struct File_Table[] = {
        {"Flags",               "dword"},
        {"Name",                "index string"},
        {"HashValue",           "index blob"},
        {NULL,                  NULL}
};         

struct container_struct FieldRVA_Table[] = {
        {"RVA",                 "dword"},
        {"Field",               "index simple Field"},
        {NULL,                  NULL}
};

struct container_struct FieldMarshal_Table[] = {
        {"Parent",              "index coded HasFieldMarshall"},
        {"NativeType",          "index blob"},
        {NULL,                  NULL}
};  

struct container_struct FieldLayout_Table[] = {
        {"Offset",              "dword"},
        {"Field",               "index simple Field"},
        {NULL,                  NULL}
};          

struct container_struct Field_Table[] = {
        {"Flags",               "word"},
        {"Name",                "index string"},
        {"Signature",           "index blob"},
        {NULL,                  NULL}
};

struct container_struct ExportedType_Table[] = {
        {"Flags",               "dword"},
        {"TypeDefId",           "dword"},  //a 4-byte index into a TypeDef table of another module in this Assembly
        {"TypeName",            "index string"},
        {"TypeNamespace",       "index string"},
        {"Implementation",      "index coded Implementation"},
        {NULL,                  NULL}
};

struct container_struct Event_Table[] = {
        {"EventFlags",          "word"},
        {"Name",                "index string"},
        {"EventType",           "index coded TypeDefOrRef"},
        {NULL,                  NULL}
};

struct container_struct EventMap_Table[] = {
        {"Parent",              "index simple TypeDef"},
        {"EventList",           "index simple Event"},
        {NULL,                  NULL}
};

struct container_struct DeclSecurity_Table[] = {
        {"Action",              "word"},
        {"Parent",              "index coded HasDeclSecurity"},
        {"PermissionSet",       "index blob"},
        {NULL,                  NULL}
};         

struct container_struct CustomAttribute_Table[] = {
        {"Parent",              "index coded HasCustomAttribute"},
        {"Type",                "index coded CustomAttributeType"},
        {"Value",               "index blob"},
        {NULL,                  NULL}
};

struct container_struct Constant_Table[] = {
        {"Type",                "byte"},
        {"padding",             "byte"},                //just padding always 0
        {"Parent",              "index coded HasConstant"},
        {"Value",               "index blob"},
        {NULL,                  NULL}
};  

struct container_struct ClassLayout_Table[] = {
        {"PackingSize",         "word"},
        {"ClassSize",           "dword"},
        {"Parent",              "index simple TypeDef"},
        {NULL,                  NULL}
};

struct container_struct AssemblyRefProcessor_Table[] = {
        {"Processor",           "dword"},
        {"AssemblyRef",         "index simple AssemblyRef"},
        {NULL,                  NULL}
};       

struct container_struct AssemblyRefOS_Table[] = {
        {"OSPlatformId",        "dword"},
        {"OSMajorVersion",      "dword"},
        {"OSMinorVersion",      "dword"},
        {"AssemblyRef",         "index simple AssemblyRef"},
        {NULL,                  NULL}
};

struct  containers      containers[] = {
        {"Module",              Module_Table       },
        {"Assembly",            Assembly_Table     },
        {"AssemblyOS",          AssemblyOS_Table },
        {"AssemblyProcessor",   AssemblyProcessor_Table},
        {"AssemblyRef",         AssemblyRef_Table},
        {"TypeRef",             TypeRef_Table},
        {"TypeSpec",            TypeSpec_Table},
        {"TypeDef",             TypeDef_Table},
        {"StandAloneSig",       StandAloneSig_Table},
        {"PropertyMap",         PropertyMap_Table},
        {"Property",            Property_Table},
        {"Param",               Param_Table},
        {"NestedClass",         NestedClass_Table},
        {"ModuleRef",           ModuleRef_Table},
        {"MethodSpec",          MethodSpec_Table},
        {"MethodSemantics",     MethodSemantics_Table},
        {"MethodImpl",          MethodImpl_Table},
        {"MethodDef",           MethodDef_Table},
        {"MemberRef",           MemberRef_Table},
        {"ManifestResource",    ManifestResource_Table},
        {"InterfaceImpl",       InterfaceImpl_Table},
        {"ImplMap",             ImplMap_Table},
        {"GenericParamConstraint", GenericParamConstraint_Table},
        {"GenericParam",        GenericParam_Table},
        {"File",                File_Table},    
        {"FieldRVA",            FieldRVA_Table},
        {"FieldMarshal",        FieldMarshal_Table},
        {"FieldLayout",         FieldLayout_Table},
        {"Field",               Field_Table},
        {"ExportedType",        ExportedType_Table},
        {"Event",               Event_Table},
        {"EventMap",            EventMap_Table},
        {"DeclSecurity",        DeclSecurity_Table},
        {"CustomAttribute",     CustomAttribute_Table},
        {"Constant",            Constant_Table},
        {"ClassLayout",         ClassLayout_Table},
        {"AssemblyRefProcessor", AssemblyRefProcessor_Table},
        {"AssemblyRefOS",       AssemblyRefOS_Table},        
        {NULL,       NULL               }
};


/******************************************************************
 * Define some info to parse coded indexes...
 ******************************************************************/
typedef struct _index_coded_table{
        CHAR    *Name;
        DWORD   BitsUsed;
        const char    **Values;
};


static const char *TypeDefOrRef_Name[] = {
        "TypeDef",
        "TypeRef",
        "TypeSpec",
        NULL
};

static const char *HasConstant_Name[]  = {
        "Field",
        "Param",
        "Property",
        NULL
};  

static const char *HasCustomAttribute_Name[] = {
        "MethodDef",
        "Field",
        "TypeRef",
        "TypeDef",
        "Param",
        "InterfaceImpl",
        "MemberRef",
        "Module",
        "Permission",                  //NEEDS INVESTIGATION //there is this filed so I assume it's DeclSecurity - "Permission",
        "Property",
        "Event",
        "StandAloneSig",
        "ModuleRef",
        "TypeSpec",
        "Assembly",
        "AssemblyRef",
        "File",
        "ExportedType",  
        "ManifestResource",
        NULL
};

static const char *HasFieldMarshall_Name[] = {
        "Field",
        "Param",
        NULL
};

static const char *HasDeclSecurity_Name[] = {
        "TypeDef",
        "MethodDef",
        "Assembly",
        NULL
};

static const char *MemberRefParent_Name[] = {
        "TypeDef",
        "TypeRef",
        "ModuleRef",
        "MethodDef",
        "TypeSpec",
        NULL
};

static const char *HasSemantics_Name[] = {
        "Event",
        "Property",
        NULL
};

static const char *MethodDefOrRef_Name[] = {
        "MethodDef",
        "MemberRef",
        NULL
};

static const char *MemberForwarded_Name[] = {
        "Field",
        "MethodDef",
        NULL
};

static const char *Implementation_Name[] = {
        "File",
        "AssemblyRef",
        "ExportedType",
        NULL
};

static const char *CustomAttributeType_Name[] = {
        "MethodDef", 
        "MemberRef",
        NULL
};

static const char *ResolutionScope_Name[] = {
        "Module",
        "ModuleRef",
        "AssemblyRef",
        "TypeRef",
        NULL
};

static const char *TypeOrMethodDef_Name[] = {
        "TypeDef",
        "MethodDef",
        NULL
};


struct _index_coded_table  index_coded[] = {
        {"TypeDefOrRef",        2,      TypeDefOrRef_Name},
        {"HasConstant",         2,      HasConstant_Name},
        {"HasCustomAttribute",  5,      HasCustomAttribute_Name},
        {"HasFieldMarshall",    1,      HasFieldMarshall_Name},
        {"HasDeclSecurity",     2,      HasDeclSecurity_Name},
        {"MemberRefParent",     3,      MemberRefParent_Name},
        {"HasSemantics",        1,      HasSemantics_Name},
        {"MethodDefOrRef",      1,      MethodDefOrRef_Name},
        {"MemberForwarded",     1,      MemberForwarded_Name},
        {"Implementation",      2,      Implementation_Name},
        {"CustomAttributeType", 3,      CustomAttributeType_Name},
        {"ResolutionScope",     2,      ResolutionScope_Name},
        {"TypeOrMethodDef",     1,      TypeOrMethodDef_Name},
        {NULL,                  0,      NULL}
};
        
          
        



  
