#ifndef __ASSEMBLE__
#define __ASSEMBLE__

#define REG_EAX     0
#define REG_ECX     1
#define REG_EDX     2
#define REG_EBX     3
#define REG_ESP     4
#define REG_EBP     5
#define REG_ESI     6
#define REG_EDI     7

void *asm_pushad(__in void *p);
void *asm_pushfd(__in void *p);
void *asm_popad(__in void *p);
void *asm_popfd(__in void *p);
void *asm_push_imm32(__in void *p, unsigned long imm32);
void *asm_push_reg(__in void *p, __in unsigned long reg);
void *asm_pop_reg(__in void *p, __in unsigned long reg);
void *asm_mov_reg_imm32(__in void *p, __in unsigned long reg, __in unsigned long imm32);
void *asm_mov_reg_mem32(__in void *p, __in unsigned long reg, __in unsigned long mem32);
void *asm_mov_mem32_reg(__in void *p, __in unsigned long mem32, __in unsigned long reg);
void *asm_xchg_esp_teb(__in void *p, __in unsigned long imm32);
void *asm_add_fs_prefix(__in void *p);
void *asm_mov_mem32_imm32(__in void *p, __in unsigned long mem32, __in unsigned long imm32);
void *asm_push_mem32(__in void *p, __in unsigned long mem32);   
void *asm_call_mem32(__in void *p, __in unsigned long mem32);
void *asm_call_reg(__in void *p, __in unsigned long reg);

void *asm_jmp_mem32(__in void *p, __in unsigned long mem32);
void *asm_add_reg_imm(__in void *p, __in unsigned long reg, __in unsigned long imm32);
void *asm_sub_reg_imm(__in void *p, __in unsigned long reg, __in unsigned long imm32);
void *asm_int(__in void *p, __in unsigned long imm32);

void *asm_mov_reg_mem32_reg(__in void *p, __in unsigned long reg_dst, __in unsigned long mem_dest, __in unsigned long reg_src);
void *asm_mov_reg_reg_mem32(__in void *p, __in unsigned long reg_dst, __in unsigned long reg_src, __in unsigned long mem_src);  
void *asm_mov_reg_mem32_imm(__in void *p, __in unsigned long reg_dst, __in unsigned long mem_dest, __in unsigned long imm_src);
void *asm_sysenter(__in void *p);  
void *asm_ret(__in void *p, __in unsigned long imm32);
void *asm_jcc_short(__in void *p, __in unsigned long iclass, __in unsigned long offset);

  
#define F_CF    0
#define F_PF    2
#define F_AF    4
#define F_ZF    6
#define F_SF    7
#define F_TF    8
#define F_IF    9
#define F_DF    10
#define F_OF    11
#define F_NT    14
#define F_RF    16
#define F_VM    17
#define F_AC    18
#define F_VIF   19
#define F_VIP   20
#define F_ID    21      

#endif