o                                  equ  offset

SYNCHRONIZE                        equ           100000h
READ_CONTROL                       equ 20000h
STANDARD_RIGHTS_READ               equ READ_CONTROL
STANDARD_RIGHTS_WRITE              equ READ_CONTROL
STANDARD_RIGHTS_EXECUTE            equ READ_CONTROL
STANDARD_RIGHTS_REQUIRED           equ 0F0000h
STANDARD_RIGHTS_ALL                equ 1F0000h
SPECIFIC_RIGHTS_ALL                equ 0FFFFh

SECURITY_NT_AUTHORITY              equ           00000005h
LOGON32_LOGON_INTERACTIVE          equ           00000002h
SECURITY_BUILTIN_DOMAIN_RID        equ           00000020h
DOMAIN_ALIAS_RID_ADMINS            equ           00000220h
TOKEN_ADJUST_PRIVILEGES            equ	       00000020h
SE_PRIVILEGE_ENABLED               equ	       00000002h
TOKEN_ASSIGN_PRIMARY               equ           00000001h
TOKEN_DUPLICATE                    equ           00000002h
TOKEN_IMPERSONATE                  equ           00000004h
TOKEN_QUERY                        equ           00000008h
TOKEN_QUERY_SOURCE                 equ           00000010h
TOKEN_ADJUST_GROUPS                equ           00000040h
TOKEN_ADJUST_DEFAULT               equ           00000080h
TOKEN_ADJUST_SESSIONID             equ           00000100h
STANDARD_RIGHTS_REQUIRED           equ           000F0000h
TOKEN_ALL_ACCESS                   equ           0000F01FFh

;TOKEN_ALL_ACCESS            equ (STANDARD_RIGHTS_REQUIRED+TOKEN_ASSIGN_PRIMARY+TOKEN_DUPLICATE+ \
;                                TOKEN_IMPERSONATE+TOKEN_QUERY+TOKEN_QUERY_SOURCE+ \
;                                TOKEN_ADJUST_PRIVILEGES+TOKEN_ADJUST_GROUPS+TOKEN_ADJUST_SESSIONID+ \
;                                TOKEN_ADJUST_DEFAULT)


;section stuff
SECTION_QUERY                   equ          0001h
SECTION_MAP_WRITE       equ     0002h
SECTION_MAP_READ        equ     0004h
SECTION_MAP_EXECUTE     equ     0008h
SECTION_EXTEND_SIZE     equ     0010h
SECTION_MAP_EXECUTE_EXPLICIT  equ 0020h
SECTION_ALL_ACCESS      equ     (STANDARD_RIGHTS_REQUIRED + SECTION_QUERY + SECTION_MAP_WRITE + SECTION_MAP_READ +\
                                 SECTION_MAP_EXECUTE + SECTION_EXTEND_SIZE)

MUTANT_QUERY_STATE                 equ          0001h
MUTANT_ALL_ACCESS                  equ          (STANDARD_RIGHTS_REQUIRED+SYNCHRONIZE+ MUTANT_QUERY_STATE)
MUTEX_ALL_ACCESS                   equ          MUTANT_ALL_ACCESS

SID_IDENTIFIER_AUTHORITY    STRUCT
       ;SIA_Value     db     6 dup    (?)
       SIA_s1          db     ?                    ;for easier initialization
       SIA_s2          db     ?
       SIA_s3          db     ?
       SIA_s4          db     ?
       SIA_s5          db     ?
       SIA_s6          db     ?
SID_IDENTIFIER_AUTHORITY    ENDS

TOKEN_PRIVILEGES STRUCT
       tp_count    dd ?
       tp_luid     dq ?
       tp_attrib   dd ?
TOKEN_PRIVILEGES  ENDS


callW                macro  __xxx
                     extrn  __xxx:proc
                     call   __xxx
endm

@pushvar             macro  variable, empty
                     local  next_instr
                     ifnb <empty>
                     %out too much arguments in macro '@pushvar'
                     .err
                     endif
                     call   next_instr
                     variable
next_instr:
endm

@ansi2unicode        macro 
                     xor    eax, eax
                     lodsb
                     stosw
                     test   al, al
                     jnz    $-5
endm

@unicode2ansi        macro
                     xor    eax, eax
                     lodsw
                     stosb
                     test   eax, eax
                     jnz    $-5
endm

@sysenter            macro  syscall, parameters
                     local  __@@1, __@@2
                     push   eax                  
                     jmp    __@@2      
__@@1:    
                     mov    eax, syscall    
                     mov    edx, esp
                     dw     340Fh                   ;sysenter 0F34h 
__@@2:
                     call   __@@1
                     add    esp, (parameters*4) + 4 ; + 1 for dummy EIP
endm



whash	macro	p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11
              irp k, <p1, p2, p3, p4, p5, p6, p7, p8, p9, p10>
                     ifnb <k>
                            hash = 0
                            irpc c, <k>
                                   hash = ((hash shl 7) and 0FFFFFFFFh) or (hash shr (32-7))
                                   hash = hash xor "&c"
                            endm
                            dd	hash
                     else
                            exitm
                     endif
              endm
endm

gethash	macro	p1, p2
              hash = 0
              irpc c, <p1>
                     hash = ((hash shl 7) and 0FFFFFFFFh) or (hash shr (32-7))
                     hash = hash xor "&c"
              endm
endm
	
;syscalls for WinXP
	
;NtTerminateProcess                   equ    101h
;NtCreateFile                         equ     25h
;NtOpenFile                           equ     74h
;NtClose                              equ     19h
;NtWriteFile                          equ    112h
;NtCreateSection                      equ     32h
;NtMapViewOfSection                   equ     6Ch     
;NtUnmapViewOfSection                 equ    10Bh
;NtQueryDirectoryFile                 equ     91h
;NtQueryInformationFile               equ     97h	
;NtAllocateVirtualMemory              equ     11h
;NtFreeVirtualMemory                  equ     53h
;NtOpenSection                        equ     7Dh

@NtVirtualAlloc      macro  rsize
                     pushad
                     push   rsize
                     mov    edi, esp
                     push   0
                     mov    esi, esp
                     push   PAGE_READWRITE
                     push   MEM_COMMIT
                     push   edi
                     push   0
                     push   esi
                     push   -1
                     @sysenter     NtAllocateVirtualMemory, 6
                     pop    eax
                     add    esp, 4
                     mov    dword ptr[esp+1Ch], eax            ;esp.Pushad_eax
                     popad
endm

STARTUPINFO	STRUCT				;used by CreateProcessA API
	si_cb		DWORD	?
	si_lpReserved	DWORD	?
	si_lpDesktop	DWORD	?
	si_lpTitle		DWORD	?
	si_dwX		DWORD	?
	si_dwY		DWORD	?
	si_dwXSize		DWORD	?
	si_dwYSize		DWORD	?
	si_dwXCountChars	DWORD	?
	si_dwYCountChars	DWORD	?
	si_dwFillAttribute	DWORD	?
	si_dwFlags		DWORD	?
	si_wShowWindow	WORD	?
	si_cbReserved2	WORD	?
	si_lpReserved2	DWORD	?
	si_hStdInput	DWORD	?
	si_hStdOutput	DWORD	?
	si_hStdError	DWORD	?
STARTUPINFO	ENDS
PROCESS_INFORMATION	STRUCT
	pi_hProcess	DWORD	?
	pi_hThread		DWORD	?
	pi_dwProcessId	DWORD	?
	pi_dwThreadId	DWORD	?
PROCESS_INFORMATION	ENDS

startupinfo	struct				;used by CreateProcessA API
	si_cb		dd	?
	si_lpReserved	dd	?
	si_lpDesktop	dd	?
	si_lpTitle	dd	?
	si_dwX		dd	?
	si_dwY		dd	?
	si_dwXSize	dd	?
	si_dwYSize	dd	?
	si_dwXCountChars dd	?
	si_dwYCountChars dd	?
	si_dwFillAttribute dd	?
	si_dwFlags	dd	?
	si_wShowWindow	dw	?
	si_cbReserved2	dw	?
	si_lpReserved2	dd	?
	si_hStdInput	dd	?
	si_hStdOutput	dd	?
	si_hStdError	dd	?
startupinfo	ends
process_information	struct
	pi_hProcess	dd	?
	pi_hThread	dd	?
	pi_dwProcessId	dd	?
	pi_dwThreadId	dd	?
process_information     ends

;AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
; for WNetEnum and other LAN APIs
NETRESOURCE STRUCT
  nr_dwScope           DWORD      ?
  nr_dwType            DWORD      ?
  nr_dwDisplayType     DWORD      ?
  nr_dwUsage           DWORD      ?
  nr_lpLocalName       DWORD      ?
  nr_lpRemoteName      DWORD      ?
  nr_lpComment         DWORD      ?
  nr_lpProvider        DWORD      ?
NETRESOURCE ENDS

RESOURCE_CONNECTED                   equ 1h
RESOURCE_PUBLICNET                   equ 2h
RESOURCE_GLOBALNET                   equ 2h
RESOURCE_REMEMBERED                  equ 3h
RESOURCE_RECENT                      equ 4h
RESOURCE_CONTEXT                     equ 5h
RESOURCETYPE_ANY                     equ 0h
RESOURCETYPE_DISK                    equ 1h
RESOURCETYPE_PRINT                   equ 2h
RESOURCETYPE_UNKNOWN                 equ 0FFFFh
RESOURCEUSAGE_CONNECTABLE            equ 1h
RESOURCEUSAGE_CONTAINER              equ 2h
RESOURCEUSAGE_RESERVED               equ 80000000h
RESOURCEDISPLAYTYPE_GENERIC          equ 0h
RESOURCEDISPLAYTYPE_DOMAIN           equ 1h
RESOURCEDISPLAYTYPE_SERVER           equ 2h
RESOURCEDISPLAYTYPE_SHARE            equ 3h
RESOURCEDISPLAYTYPE_FILE             equ 4h
RESOURCEDISPLAYTYPE_GROUP            equ 5h
CONNECT_UPDATE_PROFILE               equ 1h
;AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA

GMEM_FIXED                           equ 0h
GMEM_MOVEABLE                        equ 2h
GMEM_NOCOMPACT                       equ 10h
GMEM_NODISCARD                       equ 20h
GMEM_ZEROINIT                        equ 40h
GMEM_MODIFY                          equ 80h
GMEM_DISCARDABLE                     equ 100h
GMEM_NOT_BANKED                      equ 1000h
GMEM_SHARE                           equ 2000h
GMEM_DDESHARE                        equ 2000h
GMEM_NOTIFY                          equ 4000h
GMEM_LOWER                           equ GMEM_NOT_BANKED
GMEM_VALID_FLAGS                     equ 7F72h
GMEM_INVALID_HANDLE                  equ 8000h
GMEM_DISCARDED                       equ 4000h
GMEM_LOCKCOUNT                       equ 0FFh
GHND                                 equ GMEM_MOVEABLE OR GMEM_ZEROINIT
GPTR                                 equ GMEM_FIXED OR GMEM_ZEROINIT
;AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA

;PRIVILEGES START from ntddk.h
SE_MIN_WELL_KNOWN_PRIVILEGE     equ     2
SE_CREATE_TOKEN_PRIVILEGE       equ     2
SE_ASSIGNPRIMARYTOKEN_PRIVILEGE equ     3
SE_LOCK_MEMORY_PRIVILEGE        equ     4
SE_INCREASE_QUOTA_PRIVILEGE     equ     5

SE_UNSOLICITED_INPUT_PRIVILEGE  equ     6

SE_MACHINE_ACCOUNT_PRIVILEGE    equ     6
SE_TCB_PRIVILEGE                equ     7
SE_SECURITY_PRIVILEGE           equ     8
SE_TAKE_OWNERSHIP_PRIVILEGE     equ     9
SE_LOAD_DRIVER_PRIVILEGE        equ     10
SE_SYSTEM_PROFILE_PRIVILEGE     equ     11
SE_SYSTEMTIME_PRIVILEGE         equ     12
SE_PROF_SINGLE_PROCESS_PRIVILEGE equ    13
SE_INC_BASE_PRIORITY_PRIVILEGE   equ    14
SE_CREATE_PAGEFILE_PRIVILEGE     equ    15
SE_CREATE_PERMANENT_PRIVILEGE    equ    16
SE_BACKUP_PRIVILEGE              equ    17
SE_RESTORE_PRIVILEGE             equ    18
SE_SHUTDOWN_PRIVILEGE            equ    19
SE_DEBUG_PRIVILEGE               equ    20
SE_AUDIT_PRIVILEGE               equ    21
SE_SYSTEM_ENVIRONMENT_PRIVILEGE  equ    22
SE_CHANGE_NOTIFY_PRIVILEGE       equ    23
SE_REMOTE_SHUTDOWN_PRIVILEGE     equ    24
SE_UNDOCK_PRIVILEGE              equ    25
SE_SYNC_AGENT_PRIVILEGE          equ    26
SE_ENABLE_DELEGATION_PRIVILEGE   equ    27
SE_MANAGE_VOLUME_PRIVILEGE       equ    28
SE_MAX_WELL_KNOWN_PRIVILEGE      equ    SE_MANAGE_VOLUME_PRIVILEGE


;PRIVILEGES END

;REGISTRY START
REG_OPTION_RESERVED                  equ 0
REG_OPTION_NON_VOLATILE              equ 0
REG_OPTION_VOLATILE                  equ 1
REG_OPTION_CREATE_LINK               equ 2
REG_OPTION_BACKUP_RESTORE            equ 4
REG_NONE                             equ 0
REG_SZ                               equ 1
REG_EXPAND_SZ                        equ 2
REG_BINARY                           equ 3
REG_DWORD                            equ 4
REG_DWORD_LITTLE_ENDIAN              equ 4
REG_DWORD_BIG_ENDIAN                 equ 5
REG_LINK                             equ 6
REG_MULTI_SZ                         equ 7
REG_RESOURCE_LIST                    equ 8
REG_FULL_RESOURCE_DESCRIPTOR         equ 9
REG_RESOURCE_REQUIREMENTS_LIST       equ 10
REG_CREATED_NEW_KEY                  equ 1h
REG_OPENED_EXISTING_KEY              equ 2h
REG_WHOLE_HIVE_VOLATILE              equ 1h
REG_REFRESH_HIVE                     equ 2h
REG_NOTIFY_CHANGE_NAME               equ 1h
REG_NOTIFY_CHANGE_ATTRIBUTES         equ 2h
REG_NOTIFY_CHANGE_LAST_SET           equ 4h
REG_NOTIFY_CHANGE_SECURITY           equ 8h
REG_LEGAL_CHANGE_FILTER              equ REG_NOTIFY_CHANGE_NAME OR REG_NOTIFY_CHANGE_ATTRIBUTES OR REG_NOTIFY_CHANGE_LAST_SET OR REG_NOTIFY_CHANGE_SECURITY
REG_LEGAL_OPTION                     equ REG_OPTION_RESERVED OR REG_OPTION_NON_VOLATILE OR REG_OPTION_VOLATILE OR REG_OPTION_CREATE_LINK OR REG_OPTION_BACKUP_RESTORE

HKEY_CLASSES_ROOT                    equ 80000000h
HKEY_CURRENT_USER                    equ 80000001h
HKEY_LOCAL_MACHINE                   equ 80000002h
HKEY_USERS                           equ 80000003h
HKEY_PERFORMANCE_DATA                equ 80000004h
HKEY_CURRENT_CONFIG                  equ 80000005h
HKEY_DYN_DATA                        equ 80000006h


;REGISTRY END

jmp_jz          equ     1 
jmp_jnz         equ     2 
jmp_jb          equ     3 
jmp_jnb         equ     4    
jmp_jmp         equ     5 
jmp_jne         equ     jmp_jnz
jmp_je          equ     jmp_jz
jmp_jc          equ     jmp_jb
jmp_jnc         equ     jmp_jnb

signature       equ     'ored'

pushs macro __xxx                                ; push string...
       local blah                                ;
       call blah                                 ;
       db __xxx, 0                               ;
blah:                                            ;
endm                                             ;   
                                                 ;
pushv macro __xxx                                ; push var...
       local blah                                ;
       call blah                                 ;
       __xxx                                     ;
blah:                                            ;
endm                                             ;
                                                 ;
pushus macro string                              ; push unicode string
       local blah                                ;
       call blah                                 ;
       irpc _x, <string>                         ;
       db '&_x&',0                               ;
       endm                                      ;
       dw 0                                      ;
blah:                                            ;
endm                                             ;  
                                                 ;
nots macro string                                ;NOT a string
       irpc _x,<string>                          ;
       notbyte = not('&_x&')                     ;
       db notbyte                                ;
       endm                                      ;
       db not(0)                                 ;
endm                                             ;
                                                 ;
unis macro string                                ;build unicode string 
       irpc _x,<string>                          ;if needed
       db '&_x&', 0                              ;
       endm                                      ;
       dw 0                                      ;
endm                                             ; 

DIZZY           STRUCT
                dizzy_start     dd      ?
                dizzy_end       dd      ?
DIZZY           ENDS


MCI_OPEN_PARMS STRUCT
  mo_dwCallback        DWORD      ?
  mo_wDeviceID         DWORD      ?
  mo_lpstrDeviceType   DWORD      ?
  mo_lpstrElementName  DWORD      ?
  mo_lpstrAlias        DWORD      ?
MCI_OPEN_PARMS ENDS

MCI_PLAY_PARMS STRUCT
  mp_dwCallback    DWORD      ?
  mp_dwFrom        DWORD      ?
  mp_dwTo          DWORD      ?
MCI_PLAY_PARMS ENDS

MCI_OPEN_TYPE                        equ 2000h
MCI_OPEN_ELEMENT                     equ 200h
MCI_WAIT                             equ 2h
MCI_OPEN                             equ 803h
MCI_CLOSE                            equ 804h
MCI_PLAY                             equ 806h

WNDCLASSEX STRUCT
  cbSize            DWORD      ?
  style             DWORD      ?
  lpfnWndProc       DWORD      ?
  cbClsExtra        DWORD      ?
  cbWndExtra        DWORD      ?
  hInstance         DWORD      ?
  hIcon             DWORD      ?
  hCursor           DWORD      ?
  hbrBackground     DWORD      ?
  lpszMenuName      DWORD      ?
  lpszClassName     DWORD      ?
  hIconSm           DWORD      ?
WNDCLASSEX ENDS

POINT STRUCT
  x  DWORD ?
  y  DWORD ?
POINT ENDS

MSG STRUCT
  hwnd1      DWORD      ?
  message1   DWORD      ?
  wParam1    DWORD      ?
  lParam1    DWORD      ?
  time      DWORD      ?
  pt        POINT      <>
MSG ENDS

RECT STRUCT
  left    dd      ?
  top     dd      ?
  right   dd      ?
  bottom  dd      ?
RECT ENDS

PAINTSTRUCT STRUCT
  hdc           DWORD      ?
  fErase        DWORD      ?
  rcPaint       RECT       <>
  fRestore      DWORD      ?
  fIncUpdate    DWORD      ?
  rgbReserved   BYTE 32 dup(?)
PAINTSTRUCT ENDS

SYSTEMTIME STRUCT
    st_wYear            dw ? 
    st_wMonth           dw ?
    st_wDayOfWeek       dw ?
    st_wDay             dw ?
    st_wHour            dw ?
    st_wMinute          dw ?
    st_wSecond          dw ?
    st_wMilliseconds    dw ?
SYSTEMTIME ENDS

DT_TOP                               equ 0h
DT_LEFT                              equ 0h
DT_CENTER                            equ 1h
DT_RIGHT                             equ 2h
DT_VCENTER                           equ 4h
DT_BOTTOM                            equ 8h
DT_WORDBREAK                         equ 10h
DT_SINGLELINE                        equ 20h

WM_DESTROY                           equ 2h
WM_PAINT                             equ 0Fh
WM_CLOSE                             equ 10h

CW_USEDEFAULT                        equ 80000000h
CS_VREDRAW                           equ 1h
CS_HREDRAW                           equ 2h
COLOR_WINDOW                         equ 5
COLOR_BTNFACE                        equ 15
IDI_APPLICATION                      equ 32512
IDC_ARROW                            equ 32512
WS_OVERLAPPED                        equ 0h
WS_POPUP                             equ 80000000h
WS_CHILD                             equ 40000000h
WS_MINIMIZE                          equ 20000000h
WS_VISIBLE                           equ 10000000h
WS_DISABLED                          equ 8000000h
WS_CLIPSIBLINGS                      equ 4000000h
WS_CLIPCHILDREN                      equ 2000000h
WS_MAXIMIZE                          equ 1000000h
WS_CAPTION                           equ 0C00000h
WS_BORDER                            equ 800000h
WS_DLGFRAME                          equ 400000h
WS_VSCROLL                           equ 200000h
WS_HSCROLL                           equ 100000h
WS_SYSMENU                           equ 80000h
WS_THICKFRAME                        equ 40000h
WS_GROUP                             equ 20000h
WS_TABSTOP                           equ 10000h
WS_MINIMIZEBOX                       equ 20000h
WS_MAXIMIZEBOX                       equ 10000h
WS_TILED                             equ WS_OVERLAPPED
WS_ICONIC                            equ WS_MINIMIZE
WS_SIZEBOX                           equ WS_THICKFRAME
WS_OVERLAPPEDWINDOW                  equ WS_OVERLAPPED OR WS_CAPTION OR WS_SYSMENU OR WS_THICKFRAME OR WS_MINIMIZEBOX OR WS_MAXIMIZEBOX
WS_TILEDWINDOW                       equ WS_OVERLAPPEDWINDOW

SW_SHOWDEFAULT                       equ 10
SW_SHOWNORMAL                        equ 1
;AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
OPENFILENAME  STRUCT
  ofn_lStructSize        DWORD      ?
  ofn_hwndOwner          DWORD      ?
  ofn_hInstance          DWORD      ?
  ofn_lpstrFilter        DWORD      ?
  ofn_lpstrCustomFilter  DWORD      ?
  ofn_nMaxCustFilter     DWORD      ?
  ofn_nFilterIndex       DWORD      ?
  ofn_lpstrFile          DWORD      ?
  ofn_nMaxFile           DWORD      ?
  ofn_lpstrFileTitle     DWORD      ?
  ofn_nMaxFileTitle      DWORD      ?
  ofn_lpstrInitialDir    DWORD      ?
  ofn_lpstrTitle         DWORD      ?
  ofn_Flags              DWORD      ?
  ofn_nFileOffset         WORD      ?
  ofn_nFileExtension      WORD      ?
  ofn_lpstrDefExt        DWORD      ?
  ofn_lCustData          DWORD      ?
  ofn_lpfnHook           DWORD      ?
  ofn_lpTemplateName     DWORD      ?
OPENFILENAME  ENDS

openfilename  STRUCT
  ofn_lStructSize        DWORD      ?
  ofn_hwndOwner          DWORD      ?
  ofn_hInstance          DWORD      ?
  ofn_lpstrFilter        DWORD      ?
  ofn_lpstrCustomFilter  DWORD      ?
  ofn_nMaxCustFilter     DWORD      ?
  ofn_nFilterIndex       DWORD      ?
  ofn_lpstrFile          DWORD      ?
  ofn_nMaxFile           DWORD      ?
  ofn_lpstrFileTitle     DWORD      ?
  ofn_nMaxFileTitle      DWORD      ?
  ofn_lpstrInitialDir    DWORD      ?
  ofn_lpstrTitle         DWORD      ?
  ofn_Flags              DWORD      ?
  ofn_nFileOffset         WORD      ?
  ofn_nFileExtension      WORD      ?
  ofn_lpstrDefExt        DWORD      ?
  ofn_lCustData          DWORD      ?
  ofn_lpfnHook           DWORD      ?
  ofn_lpTemplateName     DWORD      ?
openfilename  ENDS

OFN_ALLOWMULTISELECT    equ 00000200h
OFN_CREATEPROMPT        equ 00002000h
OFN_ENABLEHOOK          equ 00000020h
OFN_ENABLETEMPLATE      equ 00000040h
OFN_ENABLETEMPLATEHANDLE                equ 00000080h
OFN_EXPLORER            equ 00080000h
OFN_EXTENSIONDIFFERENT  equ 00000400h
OFN_FILEMUSTEXIST       equ 00001000h
OFN_HIDEREADONLY        equ 00000004h
OFN_LONGNAMES           equ 00200000h
OFN_NOCHANGEDIR         equ 00000008h
OFN_NODEREFERENCELINKS  equ 00100000h
OFN_NOLONGNAMES         equ 00040000h
OFN_NONETWORKBUTTON     equ 00020000h
OFN_NOREADONLYRETURN    equ 00008000h
OFN_NOTESTFILECREATE    equ 00010000h
OFN_NOVALIDATE          equ 00000100h
OFN_OVERWRITEPROMPT     equ 00000002h
OFN_PATHMUSTEXIST       equ 00000800h
OFN_READONLY            equ 00000001h
OFN_SHAREAWARE          equ 00004000h
OFN_SHOWHELP            equ 00000010h
OFN_SHAREFALLTHROUGH    equ 2
OFN_SHARENOWARN         equ 1
OFN_SHAREWARN           equ 0
;AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
MB_OK                                equ 0h
MB_OKCANCEL                          equ 1h
MB_ABORTRETRYIGNORE                  equ 2h
MB_YESNOCANCEL                       equ 3h
MB_YESNO                             equ 4h
MB_RETRYCANCEL                       equ 5h
MB_ICONHAND                          equ 10h
MB_ICONQUESTION                      equ 20h
MB_ICONEXCLAMATION                   equ 30h
MB_ICONASTERISK                      equ 40h
MB_USERICON					  equ 80h
MB_ICONERROR                         equ MB_ICONHAND
MB_ICONINFORMATION                   equ MB_ICONASTERISK
MB_ICONSTOP                          equ MB_ICONHAND
MB_ICONWARNING                       equ MB_ICONEXCLAMATION
MB_DEFBUTTON1                        equ 0h
MB_DEFBUTTON2                        equ 100h
MB_DEFBUTTON3                        equ 200h
MB_DEFBUTTON4               		  equ 300h
MB_APPLMODAL                         equ 0h
MB_SYSTEMMODAL                       equ 1000h
MB_TASKMODAL                         equ 2000h
MB_HELP						  equ 4000h
MB_NOFOCUS                           equ 8000h
MB_SETFOREGROUND                     equ 10000h
MB_DEFAULT_DESKTOP_ONLY              equ 20000h
MB_TYPEMASK                          equ 0Fh
MB_ICONMASK                          equ 0F0h
MB_DEFMASK                           equ 0F00h
MB_MODEMASK                          equ 3000h
MB_MISCMASK                          equ 0C000h
MB_TOPMOST                  		  equ 40000h
MB_RIGHT                    		  equ 80000h
MB_RTLREADING               		  equ 100000h
MB_SERVICE_NOTIFICATION          	  equ 200000h
;AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
;PROCESSS
;AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
PROCESS_TERMINATE equ (0001h)  
PROCESS_CREATE_THREAD equ (0002h)  
PROCESS_SET_SESSIONID equ (0004h)  
PROCESS_VM_OPERATION equ (0008h)  
PROCESS_VM_READ equ (0010h)  
PROCESS_VM_WRITE equ (0020h)  
PROCESS_DUP_HANDLE equ (0040h)  
PROCESS_CREATE_PROCESS equ (0080h)  
PROCESS_SET_QUOTA equ (0100h)  
PROCESS_SET_INFORMATION equ (0200h)  
PROCESS_QUERY_INFORMATION equ (0400h)  
PROCESS_ALL_ACCESS equ (STANDARD_RIGHTS_REQUIRED + SYNCHRONIZE + 0FFFh)
;AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
;THREAD
;AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
THREAD_TERMINATE equ (0001h)  
THREAD_SUSPEND_RESUME equ (0002h)  
THREAD_GET_CONTEXT equ (0008h)  
THREAD_SET_CONTEXT equ (0010h)  
THREAD_SET_INFORMATION equ (0020h)  
THREAD_QUERY_INFORMATION equ (0040h)  
THREAD_SET_THREAD_TOKEN equ (0080h)
THREAD_IMPERSONATE equ (0100h)
THREAD_DIRECT_IMPERSONATION equ (0200h)
THREAD_ALL_ACCESS equ (STANDARD_RIGHTS_REQUIRED + SYNCHRONIZE +  3FFh) 

;AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
;CreateProcess Flags
;AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
;DEBUG_PROCESS			equ	00000001h   <-- defined in debug.inc
;DEBUG_ONLY_THIS_PROCESS		equ	00000002h   <-- defined in debug.inc
CREATE_SUSPENDED		equ	00000004h
DETACHED_PROCESS		equ	00000008h
CREATE_NEW_CONSOLE		equ	00000010h
NORMAL_PRIORITY_CLASS		equ	00000020h
IDLE_PRIORITY_CLASS		equ	00000040h
HIGH_PRIORITY_CLASS		equ	00000080h
REALTIME_PRIORITY_CLASS		equ	00000100h
;
CREATE_NEW_PROCESS_GROUP	equ	00000200h
CREATE_UNICODE_ENVIRONMENT	equ	00000400h
CREATE_SEPARATE_WOW_VDM		equ	00000800h
CREATE_SHARED_WOW_VDM		equ	00001000h
CREATE_DEFAULT_ERROR_MODE	equ	04000000h
CREATE_NO_WINDOW		equ	08000000h
;
PROFILE_USER			equ	10000000h
PROFILE_KERNEL			equ	20000000h
PROFILE_SERVER			equ	40000000h

;LOWERCASE STRUCTS... fuck uppercase...
SIZE_OF_80387_REGISTERS         EQU     80

FLOATING_SAVE_AREA              STRUC
        ControlWord             DD      ?
        StatusWord              DD      ?
        TagWord                 DD      ?
        ErrorOffset             DD      ?
        ErrorSelector           DD      ?
        DataOffset              DD      ?
        DataSelector            DD      ?
        RegisterArea            DB      SIZE_OF_80387_REGISTERS DUP (?)
        Cr0NpxState             DD      ?
FLOATING_SAVE_AREA              ENDS

context                         struct

        context_ContextFlags    DD      ?       ;00h

        context_dr0             DD      ?       ;04h
        context_dr1             DD      ?       ;08h
        context_dr2             DD      ?       ;0Ch
        context_dr3             DD      ?       ;10h
        context_dr6             DD      ?       ;14h
        context_dr7             DD      ?       ;18h

; This section is specified/returned if the
; ContextFlags word contains the flag CONTEXT_FLOATING_POINT:

        context_FloatSave       FLOATING_SAVE_AREA      <?>

; This section is specified/returned if the
; ContextFlags word contains the flag CONTEXT_SEGMENTS:

        context_segGs           DD      ?       ;08Ch
        context_segFs           DD      ?       ;090h
        context_segEs           DD      ?       ;094h
        context_segDs           DD      ?       ;098h

; This section is specified/returned if the
; ContextFlags word contains the flag CONTEXT_INTEGER:

        context_edi             DD      ?       ;09Ch
        context_esi             DD      ?       ;0A0h
        context_ebx             DD      ?       ;0A4h
        context_edx             DD      ?       ;0A8h
        context_ecx             DD      ?       ;0ACh
        context_eax             DD      ?       ;0B0h

; This section is specified/returned if the
; ContextFlags word contains the flag CONTEXT_CONTROL:

        context_ebp             DD      ?       ;0B4h
        context_eip             DD      ?       ;0B8h
        context_segCs           DD      ?       ;0BCh MUST BE SANITIZED
        context_eflags          DD      ?       ;0C0h MUST BE SANITIZED
        context_esp             DD      ?       ;0C4h
        context_segSs           DD      ?       ;0C8h

context                         ENDS

peheader_struct                 struct
        pe_signature            dd      ?       
        ;FILE_HEADER
        pe_machine              dw      ?
        pe_numberofsections     dw      ?
        pe_timedatastamp        dd      ?
        pe_pointertosymboltalbe dd      ?
        pe_numberofsymbols      dd      ?
        pe_sizeofoptionalheader dw      ?
        pe_characteristics      dw      ?
        ;OPTIONAL_HEADER
        pe_magic                dw      ?
        pe_majorlinkerversion   db      ?
        pe_minorlinkerversion   db      ?
        pe_sizeofcode           dd      ?
        pe_sizeofidata          dd      ?
        pe_sizeofudata          dd      ?
        pe_addressofentrypoint  dd      ?
        pe_baseofcode           dd      ?
        pe_baseofdata           dd      ?       
        pe_imagebase            dd      ?
        pe_sectionalignment     dd      ?
        pe_filealignment        dd      ?
        pe_majorosversion       dw      ?
        pe_minorosversion       dw      ?
        pe_majorimgversion      dw      ?
        pe_minorimgversion      dw      ?        
        pe_majorsubsystemver    dw      ?
        pe_minorsubsystemver    dw      ?
        pe_reserved1            dd      ?
        pe_sizeofimage          dd      ?
        pe_sizeofheaders        dd      ?
        pe_checksum             dd      ?
        pe_subsystem            dw      ?
        pe_dllcharacteristics   dw      ?
        pe_sizeofstackreserve   dd      ?
        pe_sizeofstackcommit    dd      ?
        pe_sizeofheapreserve    dd      ?
        pe_sizeofhealcommit     dd      ?
        pe_loaderflags          dd      ?
        pe_numberofrvaandsizes  dd      ?
        ;data directories
        pe_export               dd      ?
        pe_exportsize           dd      ?
        pe_import               dd      ?
        pe_importsize           dd      ?                        
        pe_resource             dd      ?
        pe_resourcesize         dd      ?
        pe_exception            dd      ?
        pe_exceptionsize        dd      ?
        pe_security             dd      ?
        pe_securitysize         dd      ?
        pe_reloc                dd      ?
        pe_relocsize            dd      ?
        pe_debug                dd      ?
        pe_debugsize            dd      ?        
        pe_copyright            dd      ?
        pe_copyrightsize        dd      ?
        pe_globalptr            dd      ?
        pe_globalptrsize        dd      ?
        pe_tls                  dd      ?
        pe_tlssize              dd      ?
        pe_loadconfig           dd      ?
        pe_loadconfigsize       dd      ?
        pe_boundimport          dd      ?
        pe_boundimportsize      dd      ?
        pe_iat                  dd      ?
        pe_iatsize              dd      ?        
peheader_struct                 ends

export_directory                struct
        ed_characteristics      dd      ?       ;0
        ed_timedatastamp        dd      ?       ;4
        ed_majorversion         dw      ?       ;8
        ed_minorversion         dw      ?       ;0A
        ed_name                 dd      ?       ;0C
        ed_base                 dd      ?       ;10
        ed_numberoffunctions    dd      ?       ;14
        ed_numberofnames        dd      ?       ;18
        ed_addressoffunctions   dd      ?       ;1C
        ed_addressofnames       dd      ?       ;20
        union
        ed_addressofnameoridnals dd     ?       ;24
        ed_addressofordinals    dd      ?
        ends
export_directory                ends

import_directory                struct
        union
        id_characteristics      dd      ?
        id_originalfirstthunk   dd      ?
        ends
        id_timedatastamp        dd      ?
        id_forwardchain         dd      ?
        id_name                 dd      ?
        id_firstthunk           dd      ?
import_directory                ends

relocation_directory            struct
        reloc_virtualaddress    dd      ?
        reloc_sizeofblock       dd      ?
relocation_directory            ends

image_section_header            struct
        sh_name                 db      8       dup(?)
        union
        sh_physicaladdress      dd      ?
        sh_virtualsize          dd      ?
        ends
        sh_virtualaddress       dd      ?
        sh_sizeofrawdata        dd      ?
        sh_pointertorawdata     dd      ?
        sh_pointertorelocations dd      ?
        sh_pointertolinenumbers dd      ?
        sh_numberofrelocations  dw      ?
        sh_numberoflinenumbers  dw      ?
        sh_characteristics      dd      ?
image_section_header            ends


memory_basic_information        struct
        mbi_baseaddress         dd      ?
        mbi_allocationbase      dd      ?
        mbi_allocationprotect   dd      ?
        mbi_regionsize          dd      ?
        mbi_state               dd      ?
        mvi_protect             dd      ?
        mbi_type                dd      ?
memory_basic_information        ends


        
;describe resource directory and resource entry
resource_directory              struct
        rd_characteristics      dd      ?
        rd_timedatastamp        dd      ?
        rd_majorversion         dw      ?
        rd_minorversion         dw      ?
        rd_numberofnamedentries dw      ?
        rd_numberofidentries    dw      ?
resource_directory              ends

resource_directory_entry        struct
        union
        re_name                 dd      ?
        re_id                   dd      ?       
        ends
        re_offsettodata         dd      ?       ;RVA of data entry of directory entry relative to VA of
resource_directory_entry        ends            ;resource directory from PE header!!!!!!!!!!!

resource_data_entry             struct
        rd_datatooffset         dd      ?       ;RVA of resource data!!!!!!!!!!!!!!!!!!!!!
        rd_size                 dd      ?
        rd_codepage             dd      ?
        rd_reserved             dd      ?
resource_data_entry             ends


pushad_struct            struct
        pushad_edi      dd      ?
        pushad_esi      dd      ?
        pushad_ebp      dd      ?
        pushad_esp      dd      ?
        pushad_ebx      dd      ?
        pushad_edx      dd      ?
        pushad_ecx      dd      ?
        pushad_eax      dd      ?
pushad_struct            ends

exception_record        struct
        er_exceptioncode        dd      ?
        er_exceptionflags       dd      ?
        er_exceptionrecord      dd      ?
        er_exceptionaddress     dd      ?
        er_numberparameters     dd      ?
        er_exceptioninformation dd      15      dup(?)
exception_record        ends


callW           macro   xxx,p00,p01,p02,p03,p04,p05,p06,p07,p08,p09,p10,p11,p12,p13,p14,p15,p16,p17,p18,p19
                i = 0
                irp    arg ,<p19,p18,p17,p16,p15,p14,p13,p12,p11,p10,p09,p08,p07,p06,p05,p04,p03,p02, p01, p00>
                ifnb  <arg>
                        push    arg
                endif
                endm
                call    xxx
                endm