.586p
.model  flat, stdcall
locals
jumps

include                 c:\tasm32\include\shitheap.inc
include                 apimacro.mac
include                 ring0.inc

public  C start

dumper_struct           struct
                        dump_start              dd      ?
                        dump_range              dd      ?
                        dump_fname              db      512     dup(0)
dumper_struct           ends            


.data
driver:                 unis    <\Device\dumper>
symlink:                unis    <\??\dumper>
driver_us               unicode_string <0>
sym_us                  unicode_string <0>
pdeviceobject           dd      ?
.code
public  C start
start:            ;[ebp+8] pDriverObject [ebp+0ch] pRegPatch
                        push    ebp
                        mov     ebp, esp
                        pushad
                        
                        push    offset driver
                        push    offset driver_us
                        iWin32  RtlInitUnicodeString
                        
                        push    offset pdeviceobject
                        push    0
                        push    0
                        push    FILE_DEVICE_UNKNOWN
                        push    offset driver_us
                        push    0
                        push    dword ptr[ebp+8]
                        iWin32  IoCreateDevice
                        test    eax, eax
                        jnz     __failinit
                        
                        push    offset symlink
                        push    offset sym_us
                        iWin32  RtlInitUnicodeString
                        
                        push    offset driver_us
                        push    offset sym_us
                        iWin32  IoCreateSymbolicLink
                        test    eax, eax
                        jnz     __deletedevice
                        
                        mov     eax, [ebp+8]                    ;pDriverObject

                        mov     [eax.dro_majorfunctions.irp_mj_create], offset RequestHandler     ; DRIVER_OBJECT.PDISPATCH_IRP_MJ_CREATE
                        mov     [eax.dro_majorfunctions.irp_mj_close], offset RequestHandler     ; DRIVER_OBJECT.PDISPATCH_IRP_MJ_CLOSE
                        mov     [eax.dro_majorfunctions.irp_mj_device_control], offset ServiceHandler     ; DRIVER_OBJECT.PDISPATCH_IRP_MJ_DEVICE_CONTROL
                        mov     [eax.dro_DriverUnload], offset DriverUnload       ; DRIVER_OBJECT.PDRIVER_UNLOAD                       
                                                
                        xor     eax, eax
                        jmp     __exitinit                        
                        
__deletedevice:         push    pdeviceobject
                        iWin32  IoDeleteDevice      
                        
__failinit:             mov     eax, 1
                        
__exitinit:             mov     [esp.Pushad_eax], eax
                        popad
                        pop     ebp
                        ret     8
                        
RequestHandler:         ;[esp+4] pDeviceObject, [esp+8] pIrp
                        mov     ecx, [esp+8]
                        mov     [ecx.irp_iostatus.iob_status], 0
                        mov     [ecx.irp_iostatus.iob_information], 0
                        xor     edx, edx
                        iWin32  IofCompleteRequest
                        xor     eax, eax
                        ret     8

DriverUnload:           ;pDriverObject  [esp+4]
                        push    offset sym_us
                        iWin32  IoDeleteSymbolicLink

                        mov     eax, [esp+4]
                        push    [eax.dro_deviceobject]
                        iWin32  IoDeleteDevice
                        ret     4

ServiceHandler:         ;[ebp+8] pDeviceObject, [ebp+0ch] pIrp
                        push    ebp
                        mov     ebp, esp
                        pushad
                        
                        mov     ebx, [ebp+0ch]  ;pIrp
                        mov     edx, [ebx.irp_tail.t_CurrentStackLocation]  
                        mov     eax, [edx.isl_IoControlCode ]
                        
                        cmp     eax, 20h
                        jne     __sh_fail
                        
                        mov     eax, [ebx.irp_systembuffer]

                        push    [eax.dump_start]
                        pop     c_start
                        push    [eax.dump_range]
                        pop     c_range
                        lea     ebx, [eax.dump_fname]
                        push    ebx
                        pop     fname

                        call    dumpkernel                        
                        jb      __sh_fail
                                               
__sh_oki:               mov     ecx, [ebp+0ch]
                        mov     edi, [ecx.irp_systembuffer]
                        mov     esi, offset dumpoki
                        push    ecx
                        mov     ecx, szdumpoki
                        rep     movsb
                        pop     ecx
                        mov     [ecx.irp_iostatus.iob_information], szdumpoki
                        mov     [ecx.irp_iostatus.iob_status], 0
                        xor     edx, edx
                        iWin32  IofCompleteRequest
                        xor     eax, eax
                        jmp     __sh_exit
                        
__sh_fail:              mov     ecx, [ebp+0ch]
                        mov     edi, [ecx.irp_systembuffer]
                        mov     esi, offset dumpfail
                        push    ecx
                        mov     ecx, szdumpfail
                        cld
                        rep     movsb
                        pop     ecx
                        mov     [ecx.irp_iostatus.iob_information], szdumpfail
                        mov     [ecx.irp_iostatus.iob_status], 0
                        xor     edx, edx
                        iWin32  IofCompleteRequest                       
                        mov     eax, 1            
                                    
__sh_exit:              mov     [esp.Pushad_eax], eax
                        popad
                        pop     ebp
                        ret     8                        

c_start                 dd      ?               ;start...
c_range                 dd      ?               ;range...
fname                   dd      ?               ;ptr to fname...
fnameus                 unicode_string  ?
object                  object_attributes       ?
ioblock                 io_status_block         ?
fhandle                 dd      ?  
mhandle                 dd      ? 
dumpoki                 db      "memory dumped", 0
szdumpoki               =       $-dumpoki
dumpfail                db      "memory dumping failed", 0
szdumpfail              =       $-dumpfail

;carry set on error
dumpkernel:             push    fname
                        push    offset fnameus
                        iWin32  RtlInitUnicodeString
                                               
                        mov     object.oa_length, size object_attributes
                        mov     object.oa_rootdir, 0
                        mov     object.oa_objectname, offset fnameus
                        mov     object.oa_attributes, OBJ_CASE_INSENSITIVE
                        mov     object.oa_securitydesc, 0
                        mov     object.oa_secqualityofs, 0
                        
                        call    probeforreadrange
                        jb      __set_cf
                        
                        push    0
                        push    0
                        push    FILE_SYNCHRONOUS_IO_NONALERT
                        push    FILE_SUPERSEDE
                        push    0
                        push    FILE_ATTRIBUTE_NORMAL
                        push    0
                        push    offset ioblock
                        push    offset object
                        push    GENERIC_WRITE or SYNCHRONIZE
                        push    offset fhandle
                        iWin32  ZwCreateFile 
                        test    eax, eax
                        jnz     __set_cf
                        
                        push    0
                        push    0
                        push    c_range
                        push    mhandle
                        push    offset ioblock
                        push    0
                        push    0
                        push    0
                        push    fhandle
                        iWin32  ZwWriteFile
                                               
                        push    fhandle
                        iWin32  ZwClose
                        
                        push    mhandle
                        iWin32  ExFreePool
                        
                        push    c_range
                        push    c_start
                        pushs   <"Dumped : 0x%.08X range : 0x%.08X", 13, 10>
                        iWin32  DbgPrint
                        add     esp, 0ch
                        clc                  
                        jmp     __exit_dump
                        
__set_cf:               push    c_range
                        push    c_start
                        pushs   <"***** ERROR occured while dumping :", 13, 10,"***** address : 0x%.08X range : 0x%.08X ", 13, 10>
                        iWin32  DbgPrint
                        add     esp, 0ch
                        stc
__exit_dump:            ret


;probe for read certain range of memory
;cf set on error
probeforreadrange:      mov     esi, c_start
                        mov     ecx, c_range
                        mov     edi, esi
                        add     edi, ecx        
                        
__checkpresence:        cmp     esi, edi
                        jnb     __oki
                        mov     eax, esi
                        shr     eax, 22
                        test    dword ptr[eax*4+0C0300000h], 1     ;pde present?
                        jz      __probe_fail
                        test    dword ptr[eax*4+0C0300000h], 80h   ;4mb pages?
                        jnz     __checkrangelarge                             ;whos gona dump more then 4mb?
                        mov     eax, esi
                        shr     eax, 12
                        test    dword ptr[eax*4+0C0000000h], 1     ;page present?
                        jz      __probe_fail
__checkrangelarge:      add     esi, 1000h
                        jmp     __checkpresence
                        
__oki:                  push    c_range
                        push    0
                        iWin32  ExAllocatePool
                        test    eax, eax
                        jz      __probe_fail
                        mov     mhandle, eax
                        
                        mov     ecx, c_range
                        mov     esi, c_start
                        mov     edi, eax
                        cld
                                                 
                        rep     movsb
                        
                        clc
                        jmp     __exit_probeforread
                                                
__probe_fail:           stc
__exit_probeforread:    ret                                                
end                     start