                        ;stealth nonintrusive tracer
                        ;concept and practice (c) ARTeam 2006
                        ;
                        ;        S verom u Boga, deroko/ARTeam
                        ;
                        .586p
                        .model  flat, stdcall
                        locals
                        jumps

include                 c:\tasm32\include\shitheap.inc
include                 apimacro.mac
include                 ring0.inc
      
kiusershareddata        equ     0ffdf0000h
kiusershareddataring3   equ     07ffe0000h
     
                        .data
driver:                 unis    <\Device\shareddata>
symlink:                unis    <\??\shareddata>
driver_us               unicode_string <0>
sym_us                  unicode_string <0>
pdeviceobject           dd      ?

                        .code
                        public  C start
                        
start:                  ;[ebp+8] pDriverObject [ebp+0ch] pRegPatch
                        push    ebp
                        mov     ebp, esp
                        pushad
                        
                        push    offset driver
                        push    offset driver_us
                        iWin32  RtlInitUnicodeString
                        
                        push    offset pdeviceobject
                        push    0
                        push    0
                        push    FILE_DEVICE_UNKNOWN
                        push    offset driver_us
                        push    0
                        push    dword ptr[ebp+8]
                        iWin32  IoCreateDevice
                        test    eax, eax
                        jnz     __failinit
                        
                        push    offset symlink
                        push    offset sym_us
                        iWin32  RtlInitUnicodeString
                        
                        push    offset driver_us
                        push    offset sym_us
                        iWin32  IoCreateSymbolicLink
                        test    eax, eax
                        jnz     __deletedevice
                        
                        mov     eax, [ebp+8]                    ;pDriverObject

                        mov     [eax.dro_majorfunctions.irp_mj_create], offset RequestHandler     
                        mov     [eax.dro_majorfunctions.irp_mj_close], offset RequestHandler     
                        mov     [eax.dro_majorfunctions.irp_mj_device_control], offset ServiceHandler     
                        mov     [eax.dro_DriverUnload], offset DriverUnload                              
                                                
                        xor     eax, eax
                        jmp     __exitinit                        
                        
__deletedevice:         push    pdeviceobject
                        iWin32  IoDeleteDevice      
                        
__failinit:             mov     eax, 1
                        
__exitinit:             mov     [esp.Pushad_eax], eax
                        popad
                        pop     ebp
                        ret     8
                        
RequestHandler:         ;[esp+4] pDeviceObject, [esp+8] pIrp
                        mov     ecx, [esp+8]
                        mov     [ecx.irp_iostatus.iob_status], 0
                        mov     [ecx.irp_iostatus.iob_information], 0
                        xor     edx, edx
                        iWin32  IofCompleteRequest
                        xor     eax, eax
                        ret     8

DriverUnload:           ;pDriverObject  [esp+4]
;
; remove tracer address from ntoskrnl!_KeUserExceptionDispatcher
; and store there address of KiUserExceptionDispatcher
;
                        mov     eax, cr0
                        and     eax, 0FFFEFFFFh
                        mov     cr0, eax
                        
                        mov     ecx, _KeUserExceptionDispatcher
                        mov     eax, KiUserExceptionDispatcher
                        mov     [ecx], eax
                        
                        mov     eax, cr0
                        or      eax, 10000h
                        mov     cr0, eax
                        
                        push    offset sym_us
                        iWin32  IoDeleteSymbolicLink

                        mov     eax, [esp+4]
                        push    [eax.dro_deviceobject]
                        iWin32  IoDeleteDevice
                        ret     4

ServiceHandler:         ;[ebp+8] pDeviceObject, [ebp+0ch] pIrp
                        push    ebp
                        mov     ebp, esp
                        pushad
                        
                        mov     ebx, [ebp+0ch]  ;pIrp
                        mov     edx, [ebx.irp_tail.t_CurrentStackLocation]  
                        mov     eax, [edx.isl_IoControlCode ]

;
; check IoControlCodes to see which one is for hooking 
; and when we should store PID in KiUserSharedData for 
; tracing. 
; IoControlCodes:
;       - 10h perform hooking:
;         - SystemBuffer : 4bytes
;           - ntdll!KiUserExceptionDispatcher
;       - 20h change PID and address of nonintrusive tracer
;         - SystemBuffer : 8 bytes
;           - PID
;           - address of nonintrusive tracer
;       - 30h disable nonintrusive tracer
;         - SystemBuffer : none
; Note: whole code stays here for good(UserSharedData) even if driver
;      is unloaded but pid in hook is set to -1
; Note2:This is demo code so that's why I don't restore data in
;       ntoskrnl.exe (only address of KiUserExceptionDispatcher is 
;                     restored when driver is unloaded)
; Note3:Once installed driver should be called from nonintrusivetracer
;       with right IOCTL code (check sample bla.asm)
;                                                
                        cmp     eax, 10h
                        je      __prepare_ki_user
                        cmp     eax, 20h
                        je      __change_pid     
                        cmp     eax, 30h
                        jne     __sh_fail
                        
                        mov     eax, kiusershareddata+100h
                        add     eax, hookedpid-shareddatahook
                        mov     dword ptr[eax], -1

__change_pid:           mov     ecx, [ebp+0ch]
                        mov     eax, [ecx.irp_systembuffer]

;
; get pid and address of nonintrusive
;                        
                        mov     ecx, [eax]
                        mov     edx, [eax+4]
                        
;
; write them to KiUserSharedData
;                        
                        mov     eax, kiusershareddata+100h
                        add     eax, nonintrusive-shareddatahook
                        mov     [eax], edx
                        mov     [eax+4], ecx
                        
                        jmp     __sh_oki
                        
__prepare_ki_user:
;
; Find base of ntoskrnl.exe
;
                        mov     ecx, [ebp+0ch]
                        mov     eax, [ecx.irp_systembuffer]
                        mov     eax, [eax]
                        mov     KiUserExceptionDispatcher, eax
                        
                        iMOV    esi, ZwCreateFile
                        and     esi, 0FFFFF000h
                        
__find_base:            cmp     word ptr[esi],'ZM'
                        je      __ntoskrnlbase
                        sub     esi, 1000h
                        jmp     __find_base
                        
__ntoskrnlbase:         mov     ntoskrnlbase, esi

;
; Locate KiUserExceptionDispatcher stored in ntoskrnl.exe
;
                        mov     edi, esi
                        mov     ebx, esi
                        add     ebx, dword ptr[ebx+3ch] ;go to PE in ntoskrnl.exe
                        mov     ecx, [ebx.NT_OptionalHeader.OH_SizeOfImage]
                        shr     ecx, 2
                        cld                        
                        mov     eax, KiUserExceptionDispatcher
                        repnz   scasd           
                        sub     edi, 4
                        
                        mov     _KeUserExceptionDispatcher, edi
;
; disable write protection and insert hook into KiUserSharedData
; 
                                               
                        mov     eax, cr0
                        and     eax, 0FFFEFFFFh
                        mov     cr0, eax
                        
                        push    edi                                     ;save address of KiUserExce...
                          
                        mov     edi, kiusershareddata+100h              ;we start from shared data + 100h
                        mov     esi, offset shareddatahook                  
                        mov     ecx, shareddatahooksize
                        cld
                        rep     movsb                                   ;copy our "hook"
                        
                        pop     edi
                        mov     dword ptr[edi], kiusershareddataring3+100h
                                                                       
;
; enable write protection once we are done with this hook
;
                        mov     eax, cr0
                        or      eax, 10000h
                        mov     cr0, eax
                        
                                                                                               
__sh_oki:               mov     ecx, [ebp+0ch]
                        xor     edx, edx
                        iWin32  IofCompleteRequest
                        xor     eax, eax
                        jmp     __sh_exit
                        
__sh_fail:              mov     ecx, [ebp+0ch]
                        xor     edx, edx
                        iWin32  IofCompleteRequest                       
                        mov     eax, 1            
                                    
__sh_exit:              mov     [esp.Pushad_eax], eax
                        popad
                        pop     ebp
                        ret     8                        

ntoskrnlbase            dd      ?
_KeUserExceptionDispatcher dd   ?

                        ;we don't care about registers because context is sotred on stack
                        ;if saved pid == -1 we are sure that there is no traced process 
                        ;atm
shareddatahook          label   dword
                        call    shareddelta
shareddelta:            pop     edx
                        sub     edx, offset shareddelta
                        
                        mov     ecx, dword ptr fs:[20h] ;get pid
                        cmp     [edx+hookedpid], -1
                        je      __jmpkiuser
                        cmp     [edx+hookedpid], ecx
                        jne     __jmpkiuser
                        jmp     dword ptr[edx+nonintrusive]
__jmpkiuser:            jmp     dword ptr[edx+KiUserExceptionDispatcher]
                        
KiUserExceptionDispatcher dd    ?
nonintrusive            dd      ?
hookedpid               dd      -1                        
shareddatahooksize      =       $-shareddatahook

end                     start