#include        "dump.h"

/***************************************************************************
 * dump file as file alignment = section alignment
 ***************************************************************************/
BOOL    dumpPeFile(__in HANDLE phandle, __in ULONG_PTR imagebase,__in DWORD oeprva, __in WCHAR *wsOriginalFileName, __in WCHAR *wsDumpFileName)
{
        PIMAGE_DOS_HEADER       pmz;
        PPEHEADER32             pe32;
        PSECTION_HEADER         section;
        UCHAR                   peheader[0x1000];
        HANDLE                  hFile = INVALID_HANDLE_VALUE, hSection = NULL;
        ULONG_PTR               mhandle = 0;
        DWORD                   dwRead, index;
        BOOL                    b_ret = FALSE;
        
        hFile = CreateFile(wsOriginalFileName, GENERIC_READ, FILE_SHARE_READ, 0, OPEN_EXISTING, 0,0);
        if (hFile == INVALID_HANDLE_VALUE) return FALSE;
        ReadFile(hFile, peheader, 0x1000, &dwRead, 0);
        CloseHandle(hFile);
        
        pmz = (PIMAGE_DOS_HEADER)peheader;
        pe32= (PPEHEADER32)(peheader + pmz->e_lfanew);
        section = (PSECTION_HEADER)((ULONG_PTR)pe32 + 4 + sizeof(IMAGE_FILE_HEADER) + pe32->pe_sizeofoptionalheader);
        
        hFile = CreateFile(wsDumpFileName, GENERIC_READ | GENERIC_WRITE, 0,0, CREATE_ALWAYS, 0,0);
        if (hFile == INVALID_HANDLE_VALUE) goto __Exit0;
        hSection = CreateFileMapping(hFile, 0, PAGE_READWRITE, 0, pe32->pe_sizeofimage, 0);
        if (!hSection) goto __Exit0;
                
        mhandle = (ULONG_PTR)MapViewOfFile(hSection, FILE_MAP_ALL_ACCESS, 0,0, pe32->pe_sizeofimage);
        if (!mhandle) goto __Exit0;
        
        memcpy((PVOID)mhandle, peheader, pe32->pe_sizeofheaders);
        
        pmz = (PIMAGE_DOS_HEADER)mhandle;
        pe32= (PPEHEADER32)(mhandle + pmz->e_lfanew);
        section = (PSECTION_HEADER)((ULONG_PTR)pe32 + 4 + sizeof(IMAGE_FILE_HEADER) + pe32->pe_sizeofoptionalheader);
        
        for (index = 0; index < pe32->pe_numberofsections; index++){
                b_ret = ReadProcessMemory(phandle, 
                                         (PVOID)(imagebase + section[index].sh_virtualaddress), 
                                         (PVOID)(mhandle + section[index].sh_virtualaddress),
                                         section[index].sh_virtualsize,
                                         0);
                if (!b_ret) goto __Exit0;                                 
                
                //adjust section info :)
                if (section[index].sh_virtualsize % pe32->pe_sectionalignment)
                        section[index].sh_virtualsize = section[index].sh_virtualsize - (section[index].sh_virtualsize % pe32->pe_sectionalignment) + pe32->pe_sectionalignment;
                
                section[index].sh_sizeofrawdata = section[index].sh_virtualsize;
                section[index].sh_pointertorawdata = section[index].sh_virtualaddress;
        }

        //align also image base...
        if (pe32->pe_sizeofimage % pe32->pe_sectionalignment)
                pe32->pe_sizeofimage = pe32->pe_sizeofimage - (pe32->pe_sizeofimage % pe32->pe_sectionalignment) + pe32->pe_sectionalignment;
        
        pe32->pe_addressofentrypoint = oeprva;
        
        b_ret = TRUE;
__Exit0:
        if (mhandle)        
                UnmapViewOfFile((PVOID)mhandle);
        if (hSection)
                CloseHandle(hSection);
        if (hFile != INVALID_HANDLE_VALUE){
                FlushFileBuffers(hFile);
                CloseHandle(hFile);
                if (!b_ret)
                        DeleteFile(wsDumpFileName);
        }
        return b_ret;
}

/***************************************************************************
 * dump file, with proper alignment
 ***************************************************************************/
BOOL    dumpPeFileAlign(__in HANDLE phandle, __in WCHAR *wsOriginalFileName, __in WCHAR *wsDumpFileName);