#include        "import32.h"

VOID AddImportTable(WCHAR *wsDumpFileName, PIMPORT_STRUCT pImport){
        DWORD         iat_size, num_iids;
        PVOID         new_table;
        HANDLE        fhandle, shandle;
        ULONG         mhandle;
        PIMAGE_DOS_HEADER pmz;
        PPEHEADER32   pe32;
        PSECTION_HEADER section;
        ULONG         index;
        ULONG         fsize_new;
        ULONG         fsize_old;
        ULONG         new_iat_rva;

        iat_size      = CalculateImportSize(pImport, &num_iids);
        if (iat_size % 0x1000)
                iat_size = iat_size - (iat_size % 0x1000) + 0x1000;

        fhandle       = CreateFile(wsDumpFileName, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ, 0, OPEN_EXISTING, 0,0);
        if (fhandle == INVALID_HANDLE_VALUE) return;

        fsize_new     = GetFileSize(fhandle, 0) + iat_size;
        fsize_old     = fsize_new - iat_size;
        shandle       = CreateFileMappingA(fhandle, 0, PAGE_READWRITE, 0, fsize_new, 0);
        mhandle       = (ULONG_PTR)MapViewOfFile(shandle, FILE_MAP_ALL_ACCESS, 0,0, fsize_new);
        if (!mhandle){
                CloseHandle(shandle);
                CloseHandle(fhandle);
                return;
        }
        
        pmz           = (PIMAGE_DOS_HEADER)mhandle;
        pe32          = (PPEHEADER32)(pmz->e_lfanew + (ULONG_PTR)mhandle);
        section       = (PSECTION_HEADER)((ULONG)pe32 + 4 + pe32->pe_sizeofoptionalheader + sizeof(IMAGE_FILE_HEADER));
        index         = pe32->pe_numberofsections;

        strcpy((char *)&section[index].sh_name, ".imp");

        new_iat_rva   = pe32->pe_sizeofimage;

        new_table     = BuildImportTable(new_iat_rva, pImport, iat_size, num_iids);
        memcpy((void *)(mhandle + fsize_old), new_table, iat_size);
        VirtualFree(new_table, 0, MEM_DECOMMIT);
        VirtualFree(new_table, 0, MEM_RELEASE);

        section[index].sh_pointertorawdata = fsize_old;
        section[index].sh_sizeofrawdata    = section[index].sh_virtualsize = iat_size;
        section[index].sh_virtualaddress   = pe32->pe_sizeofimage;
        section[index].sh_characteristics  = 0xE0000020;
        
        pe32->pe_import = pe32->pe_sizeofimage;
        pe32->pe_importsize = iat_size;
        pe32->pe_numberofsections++;
        pe32->pe_sizeofimage += iat_size;

        UnmapViewOfFile((PVOID)mhandle);
        CloseHandle(shandle);
        CloseHandle(fhandle);
        AdjustFirstThunk(wsDumpFileName);
       
}

DWORD CalculateImportSize(PIMPORT_STRUCT pi, DWORD *p_numIIDs){
	PIMPORT_STRUCT pImport = pi;
	DWORD totalsize = 0;
	DWORD numIIDs = 0;

	while (pImport->is_address){
		totalsize+= sizeof(IMAGE_IMPORT_DESCRIPTOR);
		totalsize+= pImport->is_dlllen;
		totalsize+= pImport->is_apilen;
		totalsize+= 10;			//one for original first thunk, one for terminating 0 and 2 for HINT...!!!

		numIIDs++;
		pImport++;
	}
	totalsize+=sizeof(IMAGE_IMPORT_DESCRIPTOR);
	*p_numIIDs = numIIDs + 1;	//for NULL terminating IMAGE_IMPORT_DESCRIPTOR!!!
	return totalsize;
}

PVOID BuildImportTable(DWORD section_rva, PIMPORT_STRUCT pi, DWORD iat_size, DWORD numIIDs){
	PVOID new_iat;
	PIMAGE_IMPORT_DESCRIPTOR c_import;
	PIMPORT_STRUCT pImport;
	PUCHAR current;

	pImport = pi;
	new_iat = VirtualAlloc(0, iat_size, MEM_COMMIT, PAGE_READWRITE);
	c_import = (PIMAGE_IMPORT_DESCRIPTOR)new_iat;
	current = ((PUCHAR)c_import + numIIDs * sizeof(IMAGE_IMPORT_DESCRIPTOR));

	while (pImport->is_address){
		memcpy(current, &pImport->is_dllname, pImport->is_dlllen);
		c_import->Name = (section_rva + current - (PUCHAR)new_iat);
		c_import->FirstThunk = pImport->is_address;
		current += pImport->is_dlllen;

		c_import->OriginalFirstThunk = current - (PUCHAR)new_iat + section_rva;
		if (*(PULONG)&pImport->is_apiname & 0x80000000){
			*(PULONG)current = *(PULONG_PTR)&pImport->is_apiname;
			current+=8;
		}else{
			*(PULONG_PTR)current = current - (PUCHAR)new_iat + section_rva + 8;
			current+=10;
			memcpy(current, &pImport->is_apiname, pImport->is_apilen);
			current+= pImport->is_apilen;
		}
		pImport++;
		c_import++;

	}

	return new_iat;
}

VOID AdjustFirstThunk(WCHAR *dumpFileName){
	HANDLE fhandle, shandle;
	PVOID  mhandle;
	PIMAGE_DOS_HEADER pmz;
	PPEHEADER32       pe32;
	PSECTION_HEADER   section;
	PIMAGE_IMPORT_DESCRIPTOR c_import;
        ULONG     index;
	ULONG_PTR remapped;
	PULONG_PTR adjust_me, adjust_with;

	fhandle = CreateFile(dumpFileName, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ, 0, OPEN_EXISTING, 0,0);
	shandle = CreateFileMappingA(fhandle, 0, PAGE_READWRITE, 0,0,0);
	mhandle = MapViewOfFile(shandle, FILE_MAP_ALL_ACCESS, 0,0,0);

	pmz  = (PIMAGE_DOS_HEADER)mhandle;
	pe32 = (PPEHEADER32)((ULONG_PTR)mhandle + pmz->e_lfanew);
	section = (PSECTION_HEADER)((ULONG_PTR)pe32 + 4 + sizeof(IMAGE_FILE_HEADER) + pe32->pe_sizeofoptionalheader);

	remapped = (ULONG_PTR)VirtualAlloc(0, pe32->pe_sizeofimage, MEM_COMMIT, PAGE_READWRITE);
	
	for (index = 0; index < pe32->pe_numberofsections; index++)
		memcpy((PVOID)(remapped + section[index].sh_virtualaddress), (PVOID)((ULONG_PTR)mhandle + section[index].sh_pointertorawdata), section[index].sh_sizeofrawdata);

	c_import = (PIMAGE_IMPORT_DESCRIPTOR)(remapped + pe32->pe_import);

	while (c_import->Name){
		adjust_with = (PULONG_PTR)(c_import->OriginalFirstThunk + remapped);
		adjust_me = (PULONG_PTR)(c_import->FirstThunk + remapped);
		*adjust_me = 0xdeadc0de; //*adjust_with;
		c_import++;
	}
	for (index = 0; index < pe32->pe_numberofsections; index++)
		memcpy((PVOID)((ULONG_PTR)mhandle + section[index].sh_pointertorawdata), (PVOID)(remapped + section[index].sh_virtualaddress), section[index].sh_sizeofrawdata);

	VirtualFree((PVOID)remapped, 0, MEM_DECOMMIT);
	VirtualFree((PVOID)remapped, 0, MEM_RELEASE);
	UnmapViewOfFile(mhandle);
	CloseHandle(shandle);
	CloseHandle(fhandle);
}