#include        "importlist.h"

void  *importListInit(){
        return xmalloc(sizeof(IMPORT_LIST));
}

BOOL   importListFindByAddress(__in PVOID ihandle, __in ULONG_PTR lpApiAddress, __out LPSTR *szDllname, __out LPSTR *szApiname){
        PIMPORT_LIST    pimport = (PIMPORT_LIST)ihandle;        
        
        if (!pimport)
                return FALSE;
        
        pimport = pimport->Next;
        
        while (pimport){
                if (pimport->ApiAddress == lpApiAddress){
                        *szDllname = xmalloc(strlen(pimport->szDllname)+1);
                        strcpy(*szDllname, pimport->szDllname);
                        if ((ULONG_PTR)pimport->szApiname < 0x10000){
                                *szApiname = (LPSTR)pimport->szApiname;       
                        }else{
                                *szApiname = xmalloc(strlen(pimport->szApiname)+1);
                                strcpy(*szApiname, pimport->szApiname);
                        }
                        return TRUE;
                }
                pimport = pimport->Next;
        }
        return FALSE;
}

ULONG_PTR importListFindByName(__in PVOID ihandle, __in LPSTR szApiname){
        PIMPORT_LIST  pimport = (PIMPORT_LIST)ihandle;
        LONG          b_ordinal = FALSE;
        
        if ((ULONG_PTR)szApiname < 0x10000)
                b_ordinal = TRUE;
        
        pimport = pimport->Next;
        
        while (pimport){
                if ((ULONG_PTR)pimport->szApiname < 0x10000 && b_ordinal){
                        if ((ULONG_PTR)pimport->szApiname == (ULONG_PTR)szApiname)
                                return pimport->ApiAddress;
                }else{
                        if ((ULONG_PTR)pimport->szApiname > 0x10000)
                                if (!strcmp(pimport->szApiname, szApiname))
                                        return pimport->ApiAddress;        
                }
                
                pimport = pimport->Next;                
        }
        
        return 0;
}
void  importListFree(__in PVOID ihandle){
        PIMPORT_LIST    pimport = (PIMPORT_LIST)ihandle;
        PIMPORT_LIST    tmp;
        
        while (pimport){
                tmp = pimport->Next;
                if (pimport->szApiname)
                        xfree(pimport->szApiname);
                if (pimport->szDllname)
                        xfree(pimport->szDllname);
                xfree(pimport);
                pimport = tmp;
        }          
}
        

void   importListAddApi(__in PVOID ihandle, __in ULONG_PTR lpApiAddress, __in LPSTR szDllname, __in LPSTR szApiname){
        PIMPORT_LIST   pimport = (PIMPORT_LIST)ihandle;
        if (!pimport) return;
        
        while (pimport->Next != NULL)
                pimport = pimport->Next;
                        
        pimport->Next = xmalloc(sizeof(IMPORT_LIST));
        pimport = pimport->Next;
        if ((ULONG_PTR)szApiname < 0x10000){
                pimport->ordinal = (USHORT)szApiname;
        }else{
                pimport->szApiname = xmalloc(strlen(szApiname) + 1);
                strcpy(pimport->szApiname, szApiname);
        }
        
        pimport->szDllname = xmalloc(strlen(szDllname) + 1);
        strcpy(pimport->szDllname, szDllname);
        
        pimport->ApiAddress = lpApiAddress;
}


void    importListProcessDll(__in PVOID ihandle, __in LPSTR szDllname, __in PVOID  lpDllBase, __in PVOID lpDllRemoteBase){        
        PIMAGE_DOS_HEADER       pmz;
        PPEHEADER32             pe32;
        PIMAGE_EXPORT_DIRECTORY c_export;
        DWORD                   *AddressOfNames;
        DWORD                   *AddressOfFunctions;
        USHORT                  *AddressOfNameOrdinals;
        ULONG                   index;
        ULONG_PTR               lpApiAddress;
        ULONG_PTR               export_start, export_end;
        
        pmz = (PIMAGE_DOS_HEADER)lpDllBase;
        if (pmz->e_magic != IMAGE_DOS_SIGNATURE) return;
        pe32 = (PPEHEADER32)((ULONG_PTR)lpDllBase + pmz->e_lfanew);
        if (pe32->pe_signature != IMAGE_NT_SIGNATURE) return;
        if (!pe32->pe_export) return;
                
        c_export = (PIMAGE_EXPORT_DIRECTORY)((ULONG_PTR)lpDllBase + pe32->pe_export);
        
        export_start = pe32->pe_export + (ULONG_PTR)lpDllBase;
        export_end   = export_start + pe32->pe_exportsize;
                
        AddressOfNames          = (DWORD *)((ULONG_PTR)lpDllBase + c_export->AddressOfNames);
        AddressOfFunctions      = (DWORD *)((ULONG_PTR)lpDllBase + c_export->AddressOfFunctions);
        AddressOfNameOrdinals   =  (WORD *)((ULONG_PTR)lpDllBase + c_export->AddressOfNameOrdinals);
        
        for (index = 0; index < c_export->NumberOfFunctions; index++){
                
                lpApiAddress = AddressOfFunctions[AddressOfNameOrdinals[index]] + (ULONG_PTR)lpDllRemoteBase;
                //forwarded, will be resolved as part of some other dll
                if (lpApiAddress >= export_start && lpApiAddress < export_end) continue;
                
                if (index < c_export->NumberOfNames){
                        importListAddApi(ihandle, lpApiAddress, szDllname, (LPSTR)(AddressOfNames[index] + (ULONG_PTR)lpDllBase));              
                }else{
                        importListAddApi(ihandle, lpApiAddress, szDllname, (LPSTR)(AddressOfNameOrdinals[index] + c_export->Base));
                }  
                
        }
        
}
        
