/*
    timestop Copyright (c) 2013 deroko of ARTeam
    This file is part of timestop.

    timestop is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    timestop is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with timestop.  If not, see <http://www.gnu.org/licenses/>.

*/

#include        <ntifs.h>
__declspec(dllimport) NTSTATUS KeSetAffinityThread(IN PETHREAD, IN KAFFINITY);
__declspec(dllimport) NTSTATUS ZwYieldExecution(VOID);

#define KUSER_SHARED_DATA_RING0 0xFFDF0000
#define KUSER_SHARED_DATA_RING3 0x7FFE0000

typedef struct{
        unsigned __int64        Present:1;
        unsigned __int64        ReadWrite:1;
        unsigned __int64        UserSupervisor:1;
        unsigned __int64        WriteTrough:1;
        unsigned __int64        CacheDisabled:1;
        unsigned __int64        Accessed:1;
        unsigned __int64        Dirty:1;
        unsigned __int64        Reserved0:1;
        unsigned __int64        GlobalPage:1;        
        unsigned __int64        Available:3;
        unsigned __int64        PageBaseAddress:24;
        unsigned __int64        Reserved:27;
        unsigned __int64        NxBit:1;
}PTE, *PPTE;


typedef struct{
        unsigned __int64        Present:1;
        unsigned __int64        ReadWrite:1;
        unsigned __int64        UserSupervisor:1;
        unsigned __int64        WriteTrough:1;
        unsigned __int64        CacheDisabled:1;
        unsigned __int64        Accessed:1;
        unsigned __int64        Reserved0:1;
        unsigned __int64        PageSize:1;
        unsigned __int64        GlobalPage:1;
        unsigned __int64        Avaialble:3;
        unsigned __int64        PageTableBaseAddress:24;
        unsigned __int64        Reserved:27;
        unsigned __int64        NxBit:1;
}PDE, *PPDE;

typedef struct{
        unsigned        Present:1;
        unsigned        ReadWrite:1;
        unsigned        UserSupervisor:1;
        unsigned        WriteThrough:1;
        unsigned        CacheDisabled:1;
        unsigned        Accessed:1;
        unsigned        Reserved0:1;
        unsigned        PageSize:1;
        unsigned        GlobalPage:1;
        unsigned        Available:3;
        unsigned        PageTableBaseAddress:20;
}PDE_NOPAE, *PPDE_NOPAE;

typedef struct{
        unsigned        Present:1;
        unsigned        ReadWrite:1;
        unsigned        UserSupervisor:1;
        unsigned        WriteThroug:1;
        unsigned        CacheDisabled:1;
        unsigned        Accessed:1;
        unsigned        Dirty:1;
        unsigned        PageTableAttributeIndex:1;
        unsigned        GlobalPage:1;
        unsigned        Available:3;
        unsigned        PageBaseAddress:20;
}PTE_NOPAE, *PPTE_NOPAE;

typedef struct{
        unsigned Limit:16;
        unsigned IdtBaseLo:16;
        unsigned IdtBaseHi:16;
}IDT_BASE, *PIDT_BASE;

typedef struct{
        unsigned OffsetLow:16;
        unsigned SegmentSelector:16;
        unsigned Reserved:5;
        unsigned Reverved1:3;
        unsigned Type:3;
        unsigned Size:1;
        unsigned Reserved2:1;
        unsigned Dpl:2;
        unsigned Present:1;
        unsigned OffsetHigh:16;
}IDT_ENTRY, *PIDT_ENTRY;


//due to logic used in windows we need different set 
//for PAE LINEAR_ADDRESS as DirectoryPointer and Directory
//are used as a part of PDE located at 0xC0600000, so this
//basic layout is changed for windows mapping...
//typedef struct{
//        unsigned        Offset:12;
//        unsigned        Table:9;
//        unsigned        Directory:9;
//        unsigned        DirectoryPointer:2;
//}LINEAR_ADDRESS, *PLINEAR_ADDRESS;

typedef struct{
        unsigned        Offset:12;
        unsigned        Table:9;
        unsigned        Directory:11;
}LINEAR_ADDRESS, *PLINEAR_ADDRESS;

typedef struct{
        unsigned        Offset:12;
        unsigned        Table:20;
}LINEAR_ADDRESS_PTE, *PLINEAR_ADDRESS_PTE;

// LINEAR_ADDRESS and LINEAR_ADDRESS_PTE for NON_PAE system
typedef struct{
        unsigned        Offset:12;
        unsigned        Table:10;
        unsigned        Directory:10;
}LINEAR_ADDRESS_NOPAE, *PLINEAR_ADDRESS_NOPAE;

typedef struct{
        unsigned        Offset:12;
        unsigned        Table:20;
}LINEAR_ADDRESS_PTE_NOPAE, *PLINEAR_ADDRESS_PTE_NOPAE;

#define PTE_OFFSET (PPTE)0xC0000000
#define PDE_OFFSET (PPDE)0xC0600000
#define PTE_OFFSET_NOPAE  (PPTE_NOPAE)0xC0000000
#define PDE_OFFSET_NOPAE  (PPDE_NOPAE)0xC0300000

#define PAGE_SIZE   0x1000

typedef struct{
        ULONG   HandleCount;
}DEVICE_EXTENSION, *PDEVICE_EXTENSION;  

typedef NTSTATUS  (__stdcall *MMACCESSFAULT)(
                                ULONG   ErrorMask,
                                PVOID   VirtualAddress,
                                ULONG   ProcessorMode,
                                PVOID   KTrapInformation);

#define ABSOLUTE(wait) (wait)

#define RELATIVE(wait) (-(wait))

#define NANOSECONDS(nanos) \
(((signed __int64)(nanos)) / 100L)

#define MICROSECONDS(micros) \
(((signed __int64)(micros)) * NANOSECONDS(1000L))

#define MILLISECONDS(milli) \
(((signed __int64)(milli)) * MICROSECONDS(1000L))

#define SECONDS(seconds) \
(((signed __int64)(seconds)) * MILLISECONDS(1000L))              