/*************************************************************************
 *   tracer Copyright (c) 2008 deroko of ARTeam
 *   This file is part of tracer.
 *
 *   xtracer is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   xtracer is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with xtracer.  If not, see <http://www.gnu.org/licenses/>.
 *
 *************************************************************************/
 
#include        "defs.h"

CHAR    breaks[MAX_BREAK];
PVOID   breakid[MAX_BREAK];

HANDLE  hTracer;
HANDLE  hEvent;

VOID    BreakSet(__in HANDLE hProcess, __in PVOID lpMemory)
{
        ULONG   index;
        for (index = 0; index < MAX_BREAK; index++){
                if (breakid[index] == 0){
                        if (!ReadProcessMemory(hProcess, lpMemory, &breaks[index], 1, 0)) break;        
                        WriteProcessMemory(hProcess, lpMemory, "\xcc", 1, 0);
                        breakid[index] = lpMemory; 
                        break;
                }       
                
        }               
}

VOID    BreakRemove(__in HANDLE hProcess, __in PVOID lpMemory)
{
        ULONG   index;
        for (index = 0; index < MAX_BREAK; index++){
                if (breakid[index] == lpMemory){
                        WriteProcessMemory(hProcess, lpMemory, &breaks[index], 1, 0);
                        breakid[index] = NULL;
                        break;
                }
        }       
}


BOOL    DebugInitProcess(__in DWORD dwProcessId)
{
        INIT_PROCESS    init;
        DWORD           cbReturned;
        
        init.dwProcessId = (HANDLE)dwProcessId;
        init.hEvent      = hEvent = CreateEvent(NULL, 0,0, NULL);
        
        hTracer = CreateFile(L"\\\\.\\tracer", GENERIC_READ | GENERIC_WRITE, 0, 0, OPEN_EXISTING, 0,0);
        if (hTracer == INVALID_HANDLE_VALUE){
                wprintf(L"[X] Failed to open tracer device\n");
                return FALSE;
        }
                
        DeviceIoControl(hTracer, IOCTL_INIT_PROCESS, &init, sizeof(init), NULL, 0, &cbReturned, NULL);
        return TRUE; 
}


BOOL    DebugWait(PTRACER_DATA pdata)
{
        DWORD   cbReturned;
        WaitForSingleObject(hEvent, INFINITE);
        DeviceIoControl(hTracer, IOCTL_GET_REGISTERS, NULL, 0, pdata, sizeof(TRACER_DATA), &cbReturned, NULL);
        return TRUE;
}

BOOL    DebugContinue(PTRACER_DATA pdata)
{
        DWORD   cbReturned;
        DeviceIoControl(hTracer, IOCTL_SET_REGISTERS, pdata, sizeof(TRACER_DATA), NULL, 0, &cbReturned, NULL);
        return TRUE;
}

VOID    DebugStop()
{
        DWORD   cbReturned;
        DeviceIoControl(hTracer, IOCTL_STOP_PROCESS, NULL, 0, NULL, 0, &cbReturned, NULL);
        CloseHandle(hTracer);
        CloseHandle(hEvent);
}

