/*************************************************************************
 *   tracer driver Copyright (c) 2008 deroko of ARTeam
 *   This file is part of tracer driver.
 *
 *   xtracer is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   xtracer is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with xtracer.  If not, see <http://www.gnu.org/licenses/>.
 *
 *************************************************************************/
 
#include "defs.h"

/******************************************************
 * This module implements procedures responsible for
 * bit manipulation (set/clear/test)
 ******************************************************/
 
ULONG   SetBit(ULONG val, ULONG bit){
        return val | (1 << bit);
}

ULONG   ClearBit(ULONG val, ULONG bit){
        return val & ~(1 << bit);
}

BOOLEAN TestBit(ULONG val, ULONG bit){
        if (val & (1 << bit))
                return TRUE;
        return FALSE;
}