/*************************************************************************
 *   tracer driver Copyright (c) 2008 deroko of ARTeam
 *   This file is part of tracer driver.
 *
 *   xtracer is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   xtracer is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with xtracer.  If not, see <http://www.gnu.org/licenses/>.
 *
 *************************************************************************/
 
#include "defs.h"

extern PKEVENT ring3event;
extern HANDLE  traced_pid;
extern ULONG  tracer_init;
extern TRACER_DATA td;
extern FAST_MUTEX fast_mutex;
/***************************************************************
 * meaning of this routine is to stop tracer, and notify ring3 programm
 * that traced application has exited. This gives a ring3 program ability
 * to act before process is terminated, and eventually get a dump of a 
 * process at this point... Not very useful, but still can be used...
 ***************************************************************/
VOID CreateProcessNotifyRoutine(IN HANDLE  ParentId, IN HANDLE  ProcessId, IN BOOLEAN  Create){
        if (!tracer_init) return;
        if (ProcessId != traced_pid) return;
        if (Create) return;
        
        AcquireInternalLock();
        td.dwProcessId = ProcessId;
        td.dwThreadId  = 0;
        td.x86_regs.handler = 0xffffffff;
        InterlockedExchange(&td.dwStatus, StatusExit);
        KeSetEvent(ring3event, IO_NO_INCREMENT, FALSE);
        spin_loop();
        ReleaseInternalLock();
}

