/*************************************************************************
 *   tracer driver Copyright (c) 2008 deroko of ARTeam
 *   This file is part of tracer driver.
 *
 *   xtracer is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   xtracer is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with xtracer.  If not, see <http://www.gnu.org/licenses/>.
 *
 *************************************************************************/

#include        "ntifs.h"

__declspec(dllimport) NTSTATUS KeSetAffinityThread(IN PKTHREAD, IN KAFFINITY);
__declspec(dllimport) NTSTATUS ZwYieldExecution();

#define         pool_tag        0xdeadc0de

/*********************************************************
 * prcedures for setting/clearing bits
 *********************************************************/
ULONG SetBit(ULONG val, ULONG bit);
ULONG ClearBit(ULONG val, ULONG bit);
BOOLEAN TestBit(ULONG val, ULONG bit);

#define         DRIVER_VERSION  0x00000100

/*********************************************************
 * this procedures are used by the part of code which hansles
 * drX usage... we have to protect our drXes in such way that only
 * this driver, and ntoskrnl.exe may change them. 
 * if change comes from this driver then we are updating drX from our
 * driver, otherwise if check comes from ntoskrnl.exe then we are
 * updating drXes only, and only if that occurs in our process. In this
 * way we let protection to manipulate with drXes as it wants.
 *
 * note that this code is ripoff from dr7_mp_safe driver, and that's
 * why it's being used as separate int handler... don't worry, that's
 * also code written by me, so code is not stolen if that crossed your
 * mind...
 **********************************************************/
ULONG   ExtractDrByIndex(UCHAR);
ULONG   UpdateDrByIndex(UCHAR, ULONG);
UCHAR   ConvertRegIndexToStructIndex(UCHAR);
BOOLEAN IsSiceRange(ULONG);
VOID    HandleDebugReg(PREGISTERS, ULONG);
VOID    Int1Hook(VOID);

extern POBJECT_TYPE *IoDriverObjectType;

typedef NTSTATUS (__stdcall *OBREFERENCEOBJECTBYNAME)(
                IN PUNICODE_STRING ObjectPath,
                IN ULONG Attributes,
                IN PACCESS_STATE PassedAccessState OPTIONAL,
                IN ACCESS_MASK DesiredAccess OPTIONAL,
                IN POBJECT_TYPE ObjectType,
                IN KPROCESSOR_MODE AccessMode,
                IN OUT PVOID ParseContext OPTIONAL,
                OUT PVOID ObjectPtr
);


typedef struct{
        ULONG   reg_Es;
        ULONG   reg_Ds;
        ULONG   reg_Fs;
        ULONG   reg_Edi;
        ULONG   reg_Esi;
        ULONG   reg_Ebp;
        ULONG   reg_Esp;
        ULONG   reg_Ebx;
        ULONG   reg_Edx;
        ULONG   reg_Ecx;
        ULONG   reg_Eax;
        ULONG   reg_Eip;
        ULONG   reg_Cs;
        ULONG   reg_Eflags;
        ULONG   reg_EspR3;
        ULONG   reg_Ss;
}REGISTERS, *PREGISTERS; 

/*************************************************************************
 * IOCTL_INIT_PROCESS - tells tracer which process to use, and what event will
 *                      be used to sync communication between r0/r3
 *                      retrives struct : INIT_PROCESS
 * IOCTL_STOP_PROCESS - tells tracer to stop tracing. If there is no traced process
 *                      nothing happens
 * IOCTL_SET_REGISTERS- updates registers with data passed in TRACER_DATA,
 *                      state must be s_ready, s_softice to continue tracing
 *                      if regs are not modified, then just state should be changed
 * IOCTL_GET_REIGSTERS- gets registers and state. State can be s_except or s_exit
 *                      where on s_exit there is no more valid process
 * IOCTL_INIT_RDSTC   - not implemented. Was supposed to hook rdtsc so it can be used
 *                      as tick counter and break at the same time
 * IOCTL_STOP_RDTSC   - not implemented. Same as above, but never implemented
 * IOCTL_GET_VERSION  - get version info, in case that some later of unpackers
 *                      requires newer version of a driver (never used, as there
 *                      was never public release of such unpacker, although some
 *                      ppl had private version of aspr 2.3 and themida unpacker)
 **************************************************************************/
#define IOCTL_INIT_PROCESS    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STOP_PROCESS    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x810, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_INIT_RDTSC      CTL_CODE(FILE_DEVICE_UNKNOWN, 0x820, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STOP_RDTSC      CTL_CODE(FILE_DEVICE_UNKNOWN, 0x830, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SET_REGISTERS   CTL_CODE(FILE_DEVICE_UNKNOWN, 0x840, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_GET_REGISTERS   CTL_CODE(FILE_DEVICE_UNKNOWN, 0x850, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_GET_VERSION     CTL_CODE(FILE_DEVICE_UNKNOWN, 0x860, METHOD_BUFFERED, FILE_ANY_ACCESS)


typedef struct{
        unsigned Limit:16;
        unsigned IdtBaseLo:16;
        unsigned IdtBaseHi:16;
}IDT_BASE, *PIDT_BASE;

typedef struct{
        unsigned OffsetLow:16;
        unsigned SegmentSelector:16;
        unsigned Reserved:5;
        unsigned Reverved1:3;
        unsigned Type:3;
        unsigned Size:1;
        unsigned Reserved2:1;
        unsigned Dpl:2;
        unsigned Present:1;
        unsigned OffsetHigh:16;
}IDT_ENTRY, *PIDT_ENTRY;


/***************************************************
 * set of procedures used to synchronize access to tracer struct
 * InitializeSpinLock    - initializes driver event
 * AcquireInternalLock   - acquires lock, or perfrorms wait
 * ReleaseInternalLock   - releases lock
 * spin_loop             - spins on td.state for s_ready
 *                         uses ZwYieldExecution to release cpu instead
 *                         of using classic spin_lock
 *
 * All of these procedures has to run at PASSIVE_LEVEL, only 
 * one allowed to run at an > PASSIVE_LEVEL is ReleaseInternalLock
 * anyhow, all of them will be running at PASSIVE_LEVEL so...
 ***************************************************/ 
VOID InitializeInternalLock(VOID);
VOID AcquireInternalLock(VOID);
VOID ReleaseInternalLock(VOID);
VOID spin_loop(VOID);
VOID clean_up(VOID);


/****************************************************
 * hooks interupts, only used in DriverEntry
 ****************************************************/
VOID    hook_interups();

/****************************************************
 * This routien has no practical meaning except to notify tracer that
 * traced process has exited...
 ****************************************************/
VOID CreateProcessNotifyRoutine(IN HANDLE  ParentId, IN HANDLE  ProcessId, IN BOOLEAN  Create);


/*******************************************************
 * this routine is responsible for updating drxes on mp
 * machines, as each CPU has it's own set of drX registers
 *******************************************************/
VOID set_drx_dpc(IN struct _KDPC  *Dpc,
                 IN PVOID  DeferredContext,
                 IN PVOID  SystemArgument1,
                 IN PVOID  SystemArgument2);
// procedure used to send DPC to all cpus!!!
VOID fire_dpc();

/******************************************************
 * Registers for x86 interupt gate when there is no ErrorCode
 ******************************************************/
typedef struct{
        ULONG   regEs;
        ULONG   regDs;
        ULONG   regFs;
        ULONG   regEdi;
        ULONG   regEsi;
        ULONG   regEbp;
        ULONG   regEsp;
        ULONG   regEbx;
        ULONG   regEdx;
        ULONG   regEcx;
        ULONG   regEax;
        ULONG   reg_handler_index;
        ULONG   reg_handler_address;
        ULONG   regEip;
        ULONG   regCs;
        ULONG   regEflags;
        ULONG   regEspR3;
        ULONG   regSs;
}REGSX8686, *PREGSX86;

ULONG   HandleException(ULONG vector, PREGSX86 pregs32);

/*******************************************************
 * Use this struct to pass data via INIT_TRACER
 * pid   - handle of a process which should be logged
 * event - auto-reset ring3 created event
 *******************************************************/                  
typedef struct _INIT_PROCESS{
        HANDLE  dwProcessId;
        HANDLE  hEvent;
}INIT_PROCESS, *PINIT_PROCESS;

/*******************************************************
 * define states used by debugger
 * StatusException     - defines that exception occured
 * StatusContinue      - send only by user mode program to tell
 *                       that debugging can continue
 * StatusDefault       - call original handler, sent by user mode
 *                      program to tell that debugging can continue
 * StatusExecuteSoftice    - send only  by user mode program to tell
 *                      tracer to stop, and generates int 3
 * StatusExit          - state is set when traced process exits
 *******************************************************/
typedef enum{
        StatusException,                         
        StatusContinue,                
        StatusDefault,
        StatusExecuteSoftice,
        StatusExit
}STATUS_ENUM;

/*******************************************************
 * This struct is used to control registers of a current
 * thread
 *******************************************************/

typedef struct{
        ULONG   reg_eax;
        ULONG   reg_ecx;
        ULONG   reg_edx;
        ULONG   reg_ebx;
        ULONG   reg_esp;
        ULONG   reg_ebp;
        ULONG   reg_esi;
        ULONG   reg_edi;
        ULONG   reg_eip;
        ULONG   reg_eflags;
        ULONG   reg_dr0;
        ULONG   reg_dr1;
        ULONG   reg_dr2;
        ULONG   reg_dr3;
        ULONG   reg_dr6;
        ULONG   reg_dr7;
        ULONG   handler;                //handler index which caused exception
                                        //in case of exit, defined as 0xFFFFFFFF
}EXCEPTION, *PEXCEPTION;

 
typedef struct _TRACER_DATA{
        HANDLE  dwProcessId;
        HANDLE  dwThreadId;
        ULONG   dwStatus;
        EXCEPTION  x86_regs; 
}TRACER_DATA, *PTRACER_DATA;
                        
