/*************************************************************************
 *   tracer driver Copyright (c) 2008 deroko of ARTeam
 *   This file is part of tracer driver.
 *
 *   xtracer is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   xtracer is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with xtracer.  If not, see <http://www.gnu.org/licenses/>.
 *
 *************************************************************************/
 
#include        "defs.h"

extern  TRACER_DATA td;
extern  ULONG   rdr0, rdr1, rdr2, rdr3, rdr6, rdr7;

// user decided what to do with drX, we only assure
// that reserved bit is set to 1
// note that it's better to set G bits, instead of L
// bits, as G bits stay across task switch, while L
// are cleared... anyhow, this is only important when
// running softice on the mp machines, as only then
// TaskSwitch will occur due to IPI via NMI...
void    set_drx(void){
        __asm{
                xor     eax, eax
                or      eax, 400h
                mov     dr7, eax
                mov     eax, rdr0
                mov     dr0, eax
                mov     eax, rdr1
                mov     dr1, eax
                mov     eax, rdr2
                mov     dr2, eax
                mov     eax, rdr3
                mov     dr3, eax
                mov     eax, rdr6
                mov     dr6, eax
                mov     eax, rdr7
                or      eax, 400h
                mov     dr7, eax
        }
}

VOID set_drx_dpc(IN struct _KDPC  *Dpc, IN PVOID  DeferredContext, IN PVOID  SystemArgument1, IN PVOID  SystemArgument2){
        PKEVENT pkevent = (PKEVENT)SystemArgument1;
        
        // update drX register on this processor...
        set_drx();
        KeSetEvent(pkevent, IO_NO_INCREMENT, FALSE);
}

KDPC    kdpc[32];
PKEVENT dpc_event[32];                
/***********************************************
 * this routine fires DPC to all cpus, to update
 * drX on all of them... used only, and only when
 * drX are being changed by the user. 
 ***********************************************/                        
VOID fire_dpc(){
        UCHAR i;
        ULONG event_count, max_user_mem;
        PVOID WaitBlock;

        // before drX are set, make sure that those are in ring3 memory 
        // range
        max_user_mem = (ULONG)MmHighestUserAddress;
        if (rdr0 > max_user_mem) rdr0 = 0;
        if (rdr1 > max_user_mem) rdr1 = 0;
        if (rdr2 > max_user_mem) rdr2 = 0;
        if (rdr3 > max_user_mem) rdr3 = 0;
        
        for (i = 0; i < KeNumberProcessors; i++){
                dpc_event[i] = ExAllocatePoolWithTag(NonPagedPool, sizeof(KEVENT), pool_tag);
                KeInitializeEvent(dpc_event[i], NotificationEvent, FALSE);
        }
                
        for (i = 0; i < KeNumberProcessors; i++){
                KeInitializeDpc(&kdpc[i], set_drx_dpc, 0);       
                KeSetTargetProcessorDpc(&kdpc[i],i); 
                KeInsertQueueDpc(&kdpc[i], dpc_event[i],0);
        }

        WaitBlock = ExAllocatePoolWithTag(NonPagedPool, sizeof(KWAIT_BLOCK) * KeNumberProcessors, pool_tag);
        event_count = KeNumberProcessors;
        KeWaitForMultipleObjects(event_count, (PVOID)&dpc_event, WaitAll, Executive, KernelMode, FALSE, NULL, WaitBlock);
        ExFreePoolWithTag(WaitBlock, pool_tag);
        
        for (i = 0; i < KeNumberProcessors; i++)
                ExFreePoolWithTag(dpc_event[i], pool_tag);        
}                        
