/*************************************************************************
 *   tracer driver Copyright (c) 2008 deroko of ARTeam
 *   This file is part of tracer driver.
 *
 *   xtracer is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   xtracer is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with xtracer.  If not, see <http://www.gnu.org/licenses/>.
 *
 *************************************************************************/
 
#include        "defs.h"

WCHAR *szDevice  = L"\\Device\\tracer";
WCHAR *szSymLink = L"\\DosDevices\\tracer";

FAST_MUTEX       fast_mutex;
PKEVENT          ring3event;
HANDLE           traced_pid;
ULONG            tracer_init;
PVOID            ImageName;
ULONG            ImageName_size;
TRACER_DATA      td;


ULONG   OldInt1Handlers[32];
ULONG   OldInt1Handler;
ULONG   KiTrap0D;

ULONG   dr6_state[32];         //initial value for dr6...
BOOLEAN hook_active = FALSE;
BOOLEAN sice_present = FALSE;
BOOLEAN cpthook_present = FALSE;
BOOLEAN test_present    = FALSE;
ULONG sice_start, sice_end;
ULONG cpthook_start, cpthook_end;
ULONG test_start, test_end;

WCHAR *szObReferenceObjectByName = L"ObReferenceObjectByName";
OBREFERENCEOBJECTBYNAME ObReferenceObjectByName;
/*************************************************
 * IRP_MJ_DEVICE_CONTROL
 * This handler uses user defined codes to setup tracing...
 **************************************************/ 
NTSTATUS control_device(IN PDEVICE_OBJECT pDeviceObject, IN PIRP pIrp){
        PIO_STACK_LOCATION cur_sl      = IoGetCurrentIrpStackLocation(pIrp);
        NTSTATUS           status      = STATUS_NOT_IMPLEMENTED;
        ULONG              information = 0;
        PINIT_PROCESS      pinit;
        PEPROCESS          peprocess;
        PKEVENT            tmp_event;
        ULONG              tmp_state;
        PTRACER_DATA       ptd;
        
        
        switch (cur_sl->Parameters.DeviceIoControl.IoControlCode)
        {
        case IOCTL_INIT_PROCESS:
                if (cur_sl->Parameters.DeviceIoControl.InputBufferLength != sizeof(INIT_PROCESS)){
                        status = STATUS_INVALID_PARAMETER;
                        break;
                }
                pinit  = (PINIT_PROCESS)pIrp->AssociatedIrp.SystemBuffer;
                // check if this process exists
                status = PsLookupProcessByProcessId(pinit->dwProcessId, &peprocess);
                if (!NT_SUCCESS(status))
                        break;
                ObDereferenceObject(peprocess);
                
                // try to refference handle
                status = ObReferenceObjectByHandle(pinit->hEvent, EVENT_ALL_ACCESS, *ExEventObjectType, KernelMode, &tmp_event, NULL);
                if (!NT_SUCCESS(status))
                        break;
                // at this point event is refferenced and pid is valid, so continue
                // by activating this pid in global varialbe, and by setting event used flag in global configuration
                // variable
                ExAcquireFastMutex(&fast_mutex);                        
                ring3event = tmp_event;
                traced_pid = pinit->dwProcessId;
                status = STATUS_SUCCESS;
                InterlockedExchange(&tracer_init, 1);
                ExReleaseFastMutex(&fast_mutex);
                break;
        case IOCTL_STOP_PROCESS:
                if (!tracer_init)
                        break;
                clean_up();
                status = STATUS_SUCCESS;
                break;
        case IOCTL_GET_VERSION:
                if (cur_sl->Parameters.DeviceIoControl.OutputBufferLength < sizeof(ULONG)){
                        status = STATUS_BUFFER_TOO_SMALL;
                        break;
                }
                
                *(PULONG)pIrp->AssociatedIrp.SystemBuffer = DRIVER_VERSION;
                status      = STATUS_SUCCESS;
                information = sizeof(ULONG);
                break;               
        case IOCTL_GET_REGISTERS:
                if (!tracer_init)
                        break;

                if (cur_sl->Parameters.DeviceIoControl.OutputBufferLength < sizeof(TRACER_DATA)){
                        status = STATUS_BUFFER_TOO_SMALL;
                        break;
                }
                
                memcpy(pIrp->AssociatedIrp.SystemBuffer, &td, sizeof(TRACER_DATA));
                status      = STATUS_SUCCESS;
                information = sizeof(TRACER_DATA);
                break;
        case IOCTL_SET_REGISTERS:
                if (!tracer_init)
                        break;
                        
                if (cur_sl->Parameters.DeviceIoControl.InputBufferLength < sizeof(TRACER_DATA)){
                        status = STATUS_BUFFER_TOO_SMALL;
                        break;
                }
                //don't copy state here, as other thread is spining waiting for data
                ptd = (PTRACER_DATA)pIrp->AssociatedIrp.SystemBuffer;
                
                //td.dwProcessId = ptd->dwProcessId;
                //td.dwThreadId  = ptd->dwThreadId;
                
                //only care here about registers!!!
                memcpy(&td.x86_regs, &ptd->x86_regs, sizeof(EXCEPTION));

                ptd = (PTRACER_DATA)pIrp->AssociatedIrp.SystemBuffer;
                tmp_state = ptd->dwStatus;
                //update state, so spin_loop will not exit before copy occurs...
                InterlockedExchange(&td.dwStatus, tmp_state);
                status = STATUS_SUCCESS;
                break;
        default:
                break;
        }
        
        pIrp->IoStatus.Status      = status;
        pIrp->IoStatus.Information = information;
        IofCompleteRequest(pIrp, IO_NO_INCREMENT);
        return status;
}
/*************************************************
 * IRP_MJ_READ handler
 * Purpose is yet undefined
 *************************************************/
NTSTATUS ReadTracerData(IN PDEVICE_OBJECT pDeviceObject, IN PIRP pIrp){
        NTSTATUS           status      = STATUS_NOT_IMPLEMENTED;
        ULONG              information = 0;
        PIO_STACK_LOCATION cur_sl      = IoGetCurrentIrpStackLocation(pIrp);
        
        pIrp->IoStatus.Information     = information;
        pIrp->IoStatus.Status          = status;
        IofCompleteRequest(pIrp, IO_NO_INCREMENT);
        return status;
}

/*************************************************
 * IRP_MJ_WRITE handler
 * Purpose is yet undefined 
 *************************************************/
NTSTATUS WriteTracerData(IN PDEVICE_OBJECT pDeviceObject, IN PIRP pIrp){
        NTSTATUS           status      = STATUS_NOT_IMPLEMENTED;
        ULONG              information = 0;
        PIO_STACK_LOCATION cur_sl      = IoGetCurrentIrpStackLocation(pIrp);
        
        pIrp->IoStatus.Information     = information;
        pIrp->IoStatus.Status          = status;
        IofCompleteRequest(pIrp, IO_NO_INCREMENT);
        return status;
}

/*************************************************
 * IRP_MJ_CREATE/IRP_MJ_CLOSE handler
 *
 * This code allows only one handle to be opened, and in
 * other cases returns STATUS_NO_SUCH_FILE indicating, that
 * this device is not present on the system, so protection 
 * which might use NtCreateFile to access us, will fail
 *************************************************/
ULONG   create_close_ref = 0;
NTSTATUS create_close(IN PDEVICE_OBJECT pDeviceObject, IN PIRP pIrp){
        NTSTATUS status;
        PIO_STACK_LOCATION cur_sl = IoGetCurrentIrpStackLocation( pIrp );
        
        switch (cur_sl->MajorFunction){
                case IRP_MJ_CREATE:
                        if (InterlockedIncrement(&create_close_ref) > 1){
                                status = STATUS_NO_SUCH_FILE;
                                InterlockedDecrement(&create_close_ref);
                                break;
                        }
                        status = STATUS_SUCCESS;
                        break;
                case IRP_MJ_CLOSE:
                        clean_up();
                        InterlockedDecrement(&create_close_ref);
                        status = STATUS_SUCCESS;
                        break;
        }
        
        pIrp->IoStatus.Status      = status;
        pIrp->IoStatus.Information = 0;
        IofCompleteRequest(pIrp, IO_NO_INCREMENT);
        return status;
}

NTSTATUS DriverEntry(IN PDRIVER_OBJECT pDriverObject, IN PUNICODE_STRING pRegPath){
        UCHAR          i;
        PKTHREAD       cur_thread;
        UNICODE_STRING us_device, us_symlink, usApi, usNtIce;
        NTSTATUS       status;
        PDEVICE_OBJECT pDeviceObject;
        PDRIVER_OBJECT pNtIceDriverObject;
        
        RtlInitUnicodeString(&us_device, szDevice);
        RtlInitUnicodeString(&us_symlink, szSymLink);
        
        for (i = 0; i < 32; i++)
                dr6_state[i] = 0xFFFF0FF0;
                        
        status = IoCreateDevice(pDriverObject,
                                0,
                                &us_device,
                                FILE_DEVICE_UNKNOWN,
                                0,
                                FALSE,
                                &pDeviceObject);
        
        if (!NT_SUCCESS(status))
                return status;
        
        status = IoCreateSymbolicLink(&us_symlink, &us_device);
        if (!NT_SUCCESS(status)){
                IoDeleteDevice(pDeviceObject);
                return status;
        }
        
        pDeviceObject->Flags |= DO_BUFFERED_IO;
        
        pDriverObject->MajorFunction[IRP_MJ_CREATE] = \
        pDriverObject->MajorFunction[IRP_MJ_CLOSE]  = create_close;
        pDriverObject->MajorFunction[IRP_MJ_READ]   = ReadTracerData;
        pDriverObject->MajorFunction[IRP_MJ_WRITE]  = WriteTracerData;
        pDriverObject->MajorFunction[IRP_MJ_DEVICE_CONTROL] = control_device;
        //pDriverObject->DriverUnload = unloadme;
        
        ExInitializeFastMutex(&fast_mutex);
        PsSetCreateProcessNotifyRoutine(CreateProcessNotifyRoutine, FALSE);
        //PsSetLoadImageNotifyRoutine(LoadImageNotifyRoutine);
        //PsSetCreateThreadNotifyRoutine(ThreadCreateNotifyRoutine);
        InitializeInternalLock();
        
        test_present = TRUE;
        test_start = (ULONG)pDriverObject->DriverStart;
        test_end   = test_start + pDriverObject->DriverSize;
        hook_active = TRUE;

        RtlInitUnicodeString(&usApi, szObReferenceObjectByName);
        ObReferenceObjectByName = (OBREFERENCEOBJECTBYNAME)MmGetSystemRoutineAddress(&usApi);        
        RtlInitUnicodeString(&usNtIce, L"\\Driver\\NTice");
        status = ObReferenceObjectByName(&usNtIce, OBJ_CASE_INSENSITIVE, NULL, 0, *IoDriverObjectType, KernelMode, NULL, &pNtIceDriverObject);
        if (!status){
                sice_present = TRUE;
                sice_start   = (ULONG)pNtIceDriverObject->DriverStart;
                sice_end     = sice_start + pNtIceDriverObject->DriverSize;
                ObDereferenceObject(pNtIceDriverObject);
        }
        
        RtlInitUnicodeString(&usNtIce, L"\\Driver\\cpthook");
        status = ObReferenceObjectByName(&usNtIce, OBJ_CASE_INSENSITIVE, NULL, 0, *IoDriverObjectType, KernelMode, NULL, &pNtIceDriverObject);
        if (!status){
                cpthook_present = TRUE;
                cpthook_start   = (ULONG)pNtIceDriverObject->DriverStart;
                cpthook_end     = cpthook_start + pNtIceDriverObject->DriverSize;
                ObDereferenceObject(pNtIceDriverObject);
        }
        
        hook_interups();
        return STATUS_SUCCESS;      
}