/****************************************************************************
 *   win32k SDT resolver
 *   Copyright (C) 2010  deroko of ARTeam
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************/
 
#include        "defs.h"

SYMBOL_LIST Head;

VOID    InsertIntoList(__in WCHAR *wsSymName, __in DWORD64 lpAddress){
        PSYMBOL_LIST  plist;
        size_t        len;
        
        plist = &Head;
        
        while (plist->Next != NULL)
                plist = plist->Next;
                         
        StringCbLength(wsSymName, STRSAFE_MAX_CCH * sizeof(TCHAR), &len);
        len += sizeof(WCHAR);
        
        plist->Next = GlobalAlloc(GPTR, sizeof(SYMBOL_LIST));
        plist = plist->Next;
        plist->Next = NULL;
        
        plist->wsSymbolName = GlobalAlloc(GPTR, len);
        memset(plist->wsSymbolName, 0, len);
        StringCchCopy(plist->wsSymbolName, len/sizeof(WCHAR), wsSymName);
        plist->lpSymbolAddress = lpAddress; 
        
}

DWORD64 AddressFromName(__in WCHAR *wsName){
        PSYMBOL_LIST plist;
        
        plist = Head.Next;
        
        while (plist){
                if (!wcscmp(wsName, plist->wsSymbolName))
                        return plist->lpSymbolAddress;
                plist = plist->Next;        
        }        
        return 0;
        
}

BOOL    NameFromAddress(__in DWORD64 lpAddress, __out WCHAR *wsSymbolName, __in ULONG index)
{
        PSYMBOL_LIST plist;
        DWORD        lindex = 0;
        
        plist = Head.Next;
        
        while (plist){
                if (plist->lpSymbolAddress == lpAddress){
                        if (lindex == index){
                                StringCchCopy(wsSymbolName, MAX_PATH, plist->wsSymbolName);
                                return TRUE;
                        }else
                                lindex++;
                }
                plist = plist->Next;        
        }        
        return FALSE;
}

BOOL    NameFromAddressNt(__in DWORD64 lpAddress, __out WCHAR *wsSymbolName)
{
        PSYMBOL_LIST plist;
        
        plist = Head.Next;
        
        while (plist){
                if (plist->lpSymbolAddress == lpAddress){
                        if (!wcsncmp(plist->wsSymbolName, L"Nt", 2)){
                                StringCchCopy(wsSymbolName, MAX_PATH, plist->wsSymbolName);
                                return TRUE;
                        }
                }
                plist = plist->Next;        
        }        
        return FALSE;
}


BOOL CALLBACK SymEnumSymbolsProc(PSYMBOL_INFOW pSymInfo, ULONG dwSymbolSize, PVOID UserContext)
{
        InsertIntoList(pSymInfo->Name, pSymInfo->Address);               
        return TRUE;
}


PVOID   xLoadLibraryExW(__in WCHAR *wsFileName){
        HANDLE hFile = INVALID_HANDLE_VALUE, hSection = NULL;
        PVOID  mhandle = NULL, lpMappedImage = NULL;
        PIMAGE_DOS_HEADER       pmz;
        PPEHEADER32             pe32;
        PPEHEADER64             pe64;
        PSECTION_HEADER         section;
        DWORD                   index;
        BOOL                    b_pe64;
        
        hFile = CreateFile(wsFileName, GENERIC_READ, FILE_SHARE_READ, 0, OPEN_EXISTING, 0,0);
        if (hFile == INVALID_HANDLE_VALUE) goto __Exit0;
        hSection = CreateFileMapping(hFile, NULL, PAGE_READONLY, 0,0,0);
        if (!hSection) goto __Exit0;
        mhandle = MapViewOfFile(hSection, FILE_MAP_READ, 0,0,0);
        if (!mhandle) goto __Exit0;
        
        pmz = (PIMAGE_DOS_HEADER)mhandle;
        pe32= (PPEHEADER32)((ULONG_PTR)mhandle + pmz->e_lfanew);
        pe64= (PPEHEADER64)((ULONG_PTR)mhandle + pmz->e_lfanew);
        
        //section offset is calculated same for pe32 and pe64 as those fields are on same offset in PE/PE+ but just to make
        //everything nice and clean we do it like this :)
        if (pe32->pe_magic == 0x20b){
                b_pe64 = TRUE;
                section = (PSECTION_HEADER)((ULONG_PTR)pe64 + 4 + sizeof(IMAGE_FILE_HEADER) + pe64->pe_sizeofoptionalheader);
                lpMappedImage = VirtualAlloc(0, pe64->pe_sizeofimage, MEM_COMMIT, PAGE_READWRITE);
        }else{
                section = (PSECTION_HEADER)((ULONG_PTR)pe32 + 4 + sizeof(IMAGE_FILE_HEADER) + pe32->pe_sizeofoptionalheader);
                lpMappedImage = VirtualAlloc(0, pe32->pe_sizeofimage, MEM_COMMIT, PAGE_READWRITE);
        }

        if (!lpMappedImage) goto __Exit0;
                
        if (b_pe64)            
                memcpy(lpMappedImage, mhandle, pe64->pe_sizeofheaders);
        else
                memcpy(lpMappedImage, mhandle, pe32->pe_sizeofheaders);
        
        for (index = 0; index < pe32->pe_numberofsections; index++)
                memcpy((void *)((ULONG_PTR)lpMappedImage + section[index].sh_virtualaddress),
                       (void *)((ULONG_PTR)mhandle       + section[index].sh_pointertorawdata),
                       section[index].sh_sizeofrawdata);

__Exit0:
        if (mhandle)
                UnmapViewOfFile(mhandle);
        if (hSection)
                CloseHandle(hSection);
        if (hFile != INVALID_HANDLE_VALUE)
                CloseHandle(hFile);
                
        return lpMappedImage;
}

LONG    b_displayed = FALSE;

VOID    DumpList(HWND hwnd, HWND hlist){
        HANDLE  hSym = (HANDLE)0xDEADC0DE;
        HMODULE hwin32k;
        ULONG   index, *pindex, dwServiceCount, dwNameIndex, jndex;
        PIMAGE_DOS_HEADER pmz;
        PPEHEADER32       pe32;
        PPEHEADER64       pe64;
        PULONG_PTR        pservice;
        DWORD64           *pservice64;
        WCHAR             wsSymName[MAX_PATH];
        WCHAR             *wsBuffer;
        WCHAR             wsWin32kPath[MAX_PATH];
        CHAR              szWin32kPath[MAX_PATH];
        LVITEM            LvItem; 
        DWORD             dwItemCount, dwItem;
        LONG              b_res;
        BOOL              b_pe64, b_ret, b_wow64;
        WCHAR             wsTempPath[MAX_PATH];
        WCHAR             wsTempFileName[MAX_PATH];
        WOW64ENABLEWOW64FSREDIRECTION fnWow64EnableWow64FsRedirection;
        WOW64DISABLEWOW64FSREDIRECTION fnWow64DisableWow64FsRedirection;
        WOW64REVERTWOW64FSREDIRECTION  fnWow64RevertWow64FsRedirection;
        ISWOW64PROCESS                fnIsWow64Process;
        PVOID                         lpOldValue;
        WCHAR                         *wsNtSymbolPath;
        DWORD                         dwSize;
        
        b_res = InterlockedExchange((volatile LONG *)&b_displayed, TRUE);
        if (b_res == TRUE) return;
                
        fnWow64EnableWow64FsRedirection = (WOW64ENABLEWOW64FSREDIRECTION) GetProcAddress(GetModuleHandle(L"kernel32.dll"), "Wow64EnableWow64FsRedirection");
        fnWow64DisableWow64FsRedirection= (WOW64DISABLEWOW64FSREDIRECTION)GetProcAddress(GetModuleHandle(L"kernel32.dll"), "Wow64DisableWow64FsRedirection");
        fnWow64RevertWow64FsRedirection = (WOW64REVERTWOW64FSREDIRECTION) GetProcAddress(GetModuleHandle(L"kernel32.dll"), "Wow64RevertWow64FsRedirection");
        fnIsWow64Process                = (ISWOW64PROCESS)                GetProcAddress(GetModuleHandle(L"kernel32.dll"), "IsWow64Process");
        
        if (fnIsWow64Process)
                fnIsWow64Process(GetCurrentProcess(), &b_wow64);
        else
                b_wow64 = FALSE;
        
        SymSetOptions(SYMOPT_LOAD_LINES|SYMOPT_FAVOR_COMPRESSED|SYMOPT_UNDNAME);
        
        dwSize = GetEnvironmentVariable(L"_NT_SYMBOL_PATH", NULL, 0);
        if (dwSize == 0)
                SymInitializeW(hSym, L"SRV*C:\\Symbols*http://msdl.microsoft.com/download/symbols", FALSE);        
        else{
                wsNtSymbolPath = GlobalAlloc(GPTR, dwSize * sizeof(WCHAR));
                GetEnvironmentVariable(L"_NT_SYMBOL_PATH", wsNtSymbolPath, dwSize);       
                SymInitializeW(hSym, wsNtSymbolPath, FALSE);
                GlobalFree(wsNtSymbolPath);
        }
        
        memset(wsWin32kPath, 0, sizeof(wsWin32kPath));
        memset(szWin32kPath, 0, sizeof(szWin32kPath));
        memset(wsTempPath,   0, sizeof(wsTempPath));
        memset(wsTempFileName,0, sizeof(wsTempFileName));
                
        GetSystemDirectory(wsWin32kPath, MAX_PATH);
        StringCchCat(wsWin32kPath, MAX_PATH, L"\\win32k.sys");
        WideCharToMultiByte(CP_ACP, 0, wsWin32kPath, -1, szWin32kPath, sizeof(szWin32kPath), NULL, NULL);
        
        if (b_wow64)
                fnWow64DisableWow64FsRedirection(&lpOldValue);
                //fnWow64EnableWow64FsRedirection(FALSE);
        
        if (b_wow64){
                GetTempPath(MAX_PATH, wsTempPath);
                GetTempFileName(wsTempPath, L"win", 0, wsTempFileName);
                CopyFile(wsWin32kPath, wsTempFileName, FALSE);
                WideCharToMultiByte(CP_ACP, 0, wsTempFileName, -1, szWin32kPath, sizeof(szWin32kPath), NULL, NULL); 
        }
        
        hwin32k = xLoadLibraryExW(wsWin32kPath); //, NULL, DONT_RESOLVE_DLL_REFERENCES);
        if (!hwin32k){
                MessageBoxW(hwnd, L"Failed to find win32k.sys on disk", L"error", MB_ICONWARNING);
                return;
        }
        
        if (b_wow64)
                fnWow64RevertWow64FsRedirection(lpOldValue);
                //fnWow64EnableWow64FsRedirection(TRUE);
        
                
        if (!SymLoadModule64(hSym, NULL, szWin32kPath, NULL, (DWORD64)hwin32k, 0)){
                MessageBoxW(hwnd, L"Failed to load symbols from win32k", L"error", MB_ICONWARNING);
                return;
        }
        
        SymEnumSymbolsW(hSym, (DWORD64)hwin32k, NULL, SymEnumSymbolsProc, NULL);       

        pindex = (PULONG)AddressFromName(L"W32pServiceLimit");
        if (!pindex){
                MessageBoxW(hwnd, L"Failed to find _W32pServiceLimit", L"error", MB_ICONWARNING);
                return;
        }
        
        dwServiceCount = *pindex;
        
        
        pservice =(PULONG_PTR)AddressFromName(L"W32pServiceTable");
        if (!pservice){
                MessageBoxW(hwnd, L"Failed to find _W32pServiceTable", L"error", MB_ICONWARNING);
                return;
        }
        
        pservice64 = (DWORD64 *)AddressFromName(L"W32pServiceTable");
        
        pmz = (PIMAGE_DOS_HEADER)hwin32k;
        pe32= (PPEHEADER32)((ULONG_PTR)hwin32k + pmz->e_lfanew);
        pe64= (PPEHEADER64)((ULONG_PTR)hwin32k + pmz->e_lfanew);
        if (pe32->pe_magic == 0x20b)
                b_pe64 = TRUE;
        else
                b_pe64 = FALSE;
        
        //process all functions which belong to this address... yes, indeed more symbols are poiting to same function,
        //I guess this is optimization related... if function return 0, why not redirect all of them to one place :)
        //and this is reason why in some lists of syscall tables we see garbage/dummy function names which have nothing
        //to do with real Shadow Table...
        wsBuffer= GlobalAlloc(GPTR, MAX_PATH * sizeof(WCHAR));
        memset(wsBuffer, 0, MAX_PATH * sizeof(WCHAR));

	// Remove existing entries on the List.
        ListView_DeleteAllItems(hlist);

        wsBuffer = GlobalAlloc(GPTR, MAX_PATH * sizeof(WCHAR));
        memset(wsBuffer, 0, MAX_PATH * sizeof(WCHAR));
        
        dwItemCount = 0;
        for (index = 0; index < dwServiceCount; index++){
                if (b_pe64)
                        b_ret = NameFromAddressNt(pservice64[index] - pe64->pe_imagebase + (ULONG_PTR)hwin32k, wsSymName);
                else
                        b_ret = NameFromAddressNt((DWORD64)(pservice[index] - pe32->pe_imagebase + (ULONG_PTR)hwin32k), wsSymName);
                if (b_ret){
                        memset(&LvItem, 0, sizeof(LvItem));
                        LvItem.mask     = LVIF_TEXT;
                        LvItem.iItem    = dwItemCount;
                        LvItem.iSubItem = 0;
                        StringCchPrintf(wsBuffer, MAX_PATH, L"%.04X", index + SYSCALL_INDEX);
                        LvItem.pszText  = wsBuffer;
                        dwItem          = SendMessage(hlist, LVM_INSERTITEM, (WPARAM)0, (LPARAM)&LvItem);
                        
                        memset(&LvItem, 0, sizeof(LvItem));
                        LvItem.mask     = LVIF_TEXT;
                        LvItem.iItem    = dwItem;
                        LvItem.iSubItem = 1;
                        StringCchCopy(wsBuffer, MAX_PATH, wsSymName);
                        LvItem.pszText  = wsBuffer;
                        SendMessage(hlist, LVM_SETITEM, (WPARAM)0, (LPARAM)&LvItem);
                        dwItemCount++;
                        continue;
                } 
                //to get more names under which one function is known use this small loop...
                
                
                if (b_pe64)
                        b_ret = NameFromAddressNt(pservice64[index] - pe64->pe_imagebase + (ULONG_PTR)hwin32k, wsSymName);
                else
                        b_ret = NameFromAddress((DWORD64)(pservice[index] - pe32->pe_imagebase + (ULONG_PTR)hwin32k), wsSymName, 0);
                
                if (!b_ret) continue;
                                
                memset(&LvItem, 0, sizeof(LvItem));
                LvItem.mask     = LVIF_TEXT;
                LvItem.iItem    = dwItemCount;
                LvItem.iSubItem = 0;
                StringCchPrintf(wsBuffer, MAX_PATH, L"%.04X", index + SYSCALL_INDEX);
                LvItem.pszText  = wsBuffer;
                dwItem          = SendMessage(hlist, LVM_INSERTITEM, (WPARAM)0, (LPARAM)&LvItem);
                
                
                LvItem.iItem    = dwItem;
                LvItem.iSubItem = 1;
                StringCchCopy(wsBuffer, MAX_PATH, wsSymName);
                LvItem.pszText  = wsBuffer;
                SendMessage(hlist, LVM_SETITEM, (WPARAM)0, (LPARAM)&LvItem);
                
                dwItemCount++;
                
                jndex = 1;
                for (;;){
                        if (b_pe64)
                                b_ret = NameFromAddress(pservice64[index] - pe64->pe_imagebase + (ULONG_PTR)hwin32k, wsSymName, jndex);
                        else
                                b_ret = NameFromAddress((DWORD64)(pservice[index] - pe32->pe_imagebase + (ULONG_PTR)hwin32k), wsSymName, jndex);
                        if (!b_ret)
                                break; 
                        memset(&LvItem, 0, sizeof(LvItem));
                        LvItem.mask     = LVIF_TEXT;
                        LvItem.iItem    = dwItemCount;
                        LvItem.iSubItem = 0;
                        StringCchCopy(wsBuffer, MAX_PATH, L"    ");
                        LvItem.pszText  = wsBuffer;
                        dwItem = SendMessage(hlist, LVM_INSERTITEM, (WPARAM)0, (LPARAM)&LvItem);
                                
                        memset(&LvItem, 0,  sizeof(LvItem));
                        LvItem.mask     = LVIF_TEXT;
                        LvItem.iItem    = dwItem;
                        LvItem.iSubItem = 1;
                        StringCchCopy(wsBuffer, MAX_PATH, wsSymName);
                        LvItem.pszText  = wsBuffer;
                        SendMessage(hlist, LVM_SETITEM, (WPARAM)0, (LPARAM)&LvItem);
                        dwItemCount++;
                        jndex++;
                }
        }
        
        SymUnloadModule64(hSym, (DWORD64)hwin32k);
        SymCleanup(hSym);
        VirtualFree(hwin32k, 0, MEM_DECOMMIT);
        VirtualFree(hwin32k, 0, MEM_RELEASE);
        
        if (b_wow64)
                DeleteFile(wsTempFileName);
        
        GlobalFree(wsBuffer);
}