; Small bootsector example

; Copyright 1999 X-Calibre

.Model Tiny
.code
org 7C00h
start:
	jmp		short program		; Jump over header

	nop							; Pad for start of header (required for some DOS)

	; DOS Header
org	7C03h
Header:
	OEMIdendifier		db	"Diamond!"
	BytesPerSector		dw	512
	SectorsPerCluster	db	1
	ReservedSectors		dw	1
	NumberOfFATs		db	2
	RootEntries			dw	0E0h
	SectorsInVolume		dw	0B40h
	MediaDescriptor		db	0F0h
	SectorsPerFAT		dw	9
	SectorsPerTrack		dw	18
	NumberOfHeads		dw	2
	SpecialHidden		dw	0
	HiddenSectors		dw	0
	TotalSize			dd	0
	PhysicalDrive		dw	0
	BootSignature		db	29h
	VolumeID			dd	12345678h
	DiskLabel			db	"DiamondCrew"
	FATType				db	"FAT-12  "

	program:
	; Create stack
	cli	
	xor		ax, ax
	mov		ss, ax
	mov		sp, 7C00h
	sti

	; Write to screen
	mov		ax, 0B800h
	push	ds
	mov		ds, ax

	xor		di, di
	mov		si, offset StartMessage
	mov		dh, 17h					; White on blue chars

	mov		cx, 25

	@@WriteScreen:
	push	cx
	mov		cx, 80

	@@WriteLine:
	mov		dl, cs:[si]
	or		dl, dl
	jz		@@EndOfLine				; String terminator encountered
	mov		ds:[di], dx
	inc		si
	add		di, 2
	dec		cx
	jnz		@@WriteLine

	@@EndOfLine:
	mov		ds:[di], dx
	add		di, 2
	dec		cx
	jnz		@@EndOfLine
	inc		si

	pop		cx
	dec		cx
	jnz		@@WriteScreen
	pop		ds

	; Wait 5 seconds
	mov		ah, 86h
	mov		cx, 50
	xor		dx, dx
	int		15h

	; Relocate program
	mov		si, offset continue
	mov		di, offset continue + 200h
	mov		cx, offset EndOfCode - offset start
	rep		movsw
	jmp		continue + 200h

continue:
	; Load bootsector
	mov		ax, 201h
	mov		cx, 1
	mov		dx, 80h	; First harddisk, sector 00
	mov		bx, 7C00h
	int		13h		; DISK - READ SECTORS INTO MEMORY
					; AL = number of sectors to read, CH = track, CL = sector
					; DH = head, DL	= drive, ES:BX -> buffer to fill
					; Return: CF set on error, AH =	status (see AH=01h), AL	= number of sectors read
	jc		ExitAndReboot
	cmp		word ptr [BootFlag], 0AA55h
	jne		ExitAndReboot
	jmp		start - 200h

ExitAndReboot:
	xor		dx, dx
	int		19h
EndOFCode:

StartMessage	db	"This is a DiamondCrew Disk!",0
				db	0
				db	"Although you have booted from this disk, it really is not a boot disk",0
				db	0
				db	"Harddisk 80h will be booted up in a few seconds.",0
				db	"If it is not bootable, the computer will be restarted.",0
				db	19 dup (0)

org 7DFEh
	BootFlag	db	55h,0AAh

end start