#include <windows.h>

LRESULT CALLBACK CreateClassProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
  if(uMsg == WM_DESTROY)
    PostQuitMessage(0);
  else
    return DefWindowProc(hwnd, uMsg, wParam, lParam);
  return 0;
}    

__declspec(dllexport) char ClassName[] = "CreateClass";

WNDCLASS CreateClass =
{CS_GLOBALCLASS, CreateClassProc, 0, 0, NULL, NULL, NULL,
 (HBRUSH)(COLOR_WINDOW+1), NULL, ClassName};

BOOL APIENTRY DllMain(HANDLE hModule, DWORD ul_reason_for_call, LPVOID lpReserved) {
  if(ul_reason_for_call == DLL_PROCESS_ATTACH) {
    CreateClass.hInstance = hModule;
    CreateClass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    CreateClass.hCursor = LoadCursor(NULL, IDC_ARROW);  
    RegisterClass(&CreateClass);
  }
  return TRUE;
}