COMMENT  $

Author
------
EliCZ

Observation
-----------
My AMD K6 is TOO good in recognizing instructions when DRX system is active.

Conditions
----------
AMD K6 CPU (all modes), ES and CS address the same space, DRX active,
instruction REPE/REPNE STOSB/MOVSB  must be overwritten by itself

	 $

.MODEL SMALL
.586P

.CODE
START:
PUSH @DATA
POP  DS
;ASSUME DS:_DATA
MOV AH,9
LEA DX, Info
INT 21H
;----------------------------activate DRX system------------------------------
SUB EAX,EAX
DEC EAX
MOV DR0,EAX
INC EAX
INC EAX
MOV DR7,EAX

;or set hardware breakpoint in debugger
;-----------------------------------------------------------------------------

CLC
MOV AL,0F9H		 ;STC  ( NOP (90H) is the only safe clearing byte )
			 ;you can use for example AL=66H and after CodeChange
			 ;POP Reg16
			 ;then AMD executes POP Reg32

;ES=CS
PUSH CS
POP  ES

CLD
MOV CX,CLength
LEA DI,CodeChange

LEA DX,NoEffect

CodeChange:
REP STOSB		 ;AMD recognizes NEW instruction
CLength EQU $-CodeChange ;on IP=CodeChange+1 (STOSB) when DRX system is active
			 ;in CX is not 0 but 1 !!!!
			 ;OR CX,CX
			 ;JE NoAMDBug

			 ;you can use also MOVSB:
			 ;LEA SI,NewCode   ;NewCode DB 0F9H, 0F9H
			 ;REP MOVSB
JNC NoAMDBug

LEA DX,Effect

NoAMDBug:
SUB EAX,EAX
MOV DR7,EAX
MOV AH,9
INT 21H
.EXIT

.DATA
Info	 DB 13,10,"AMD K6 Bug Test by EliCZ",36
Effect	 DB 13,10,7,"I'm sorry, but test is POSITIVE! :-(",36
NoEffect DB 13,10,"Test is NEGATIVE! :o)",36

.STACK	 256

END	 START
