#include <stdio.h>
#include <windows.h>
#include "resource.h"
#include "md5c.c"
#include "global.h"
#include <miracl.h>

HINSTANCE	hInst;

BOOL CALLBACK DialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{	

	unsigned char szName[100] = {0};
	unsigned char szHash[41] = {0};
	unsigned char szSerial[33] = "4B45042B684BCBD1";
	long dtLength;
	MD5_CTX context;
	big M,p,y,x,a;
	miracl *mip=mirsys(100,0);

	switch (message)
	{    
	case WM_CLOSE:
		EndDialog(hWnd,0);
		break;
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{ 
		case IDC_GENERATE:
			dtLength=GetDlgItemText(hWnd, IDC_EDITNAME, szName, 100);
			if (dtLength<5) {
				SetDlgItemText(hWnd, IDC_EDITSERIAL, "at least 5 characters");
				break;
			}
			MD5Init(&context);
			MD5Update(&context, szName, dtLength);
			MD5Final(szHash, &context);

			mip->IOBASE=16;
			M=mirvar(0);
			p=mirvar(0);
			y=mirvar(0);
			x=mirvar(0);
			a=mirvar(0);

			bytes_to_big(16,&szHash,M);
			cinstr(p,"037A218F214C32D79");
			power(M,3,p,M);  // compute the message to sign

			cinstr(p,"0C9D94F46D0984F43");
			cinstr(y,"091D4D6EF46B05C78");
			cinstr(x,"06C18DA28FDD8FEF1");
			cinstr(a,"04B45042B684BCBD1");  // g^k mod (p)

			decr(p,1,p);  // we need p-1
			mad(a,x,a,p,p,a);  // a=x*a mod (p-1)
			dtLength=compare(M,a);
			// M>a : b=M-a
			// M<a : b=M-(a-p)
			if (dtLength<0){
				subtract(a,p,a);
			}
			subtract(M,a,M);  // b such that M=(xa+kb) mod (p-1)

			big_to_bytes(0,M,&szName);
			for(dtLength=0; dtLength < 8; dtLength++)
			sprintf(&szSerial[2*dtLength+16], "%02X", szName[dtLength]);
			SetDlgItemText(hWnd, IDC_EDITSERIAL, szSerial);
			mirkill(M);
			mirkill(p);
			mirkill(y);
			mirkill(x);
			mirkill(a);
			mirexit();
			break;
		case IDC_ABOUT:
			MessageBox(hWnd, "keygenerator for TMG official keygenme 3\nprotection: md5 and elgamal", "about", MB_OK);
			break;
		}
		break;
	case WM_INITDIALOG:
		SendMessageA(hWnd,WM_SETICON,(WPARAM) 1,(LPARAM) LoadIconA(hInst,MAKEINTRESOURCE(IDI_ICON)));
		break;
	}
     return 0;
}

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	hInst=hInstance;
	DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_DIALOG1), NULL, (DLGPROC)DialogProc,0);
	return 0;
}
