;::::::::::::::::::::::::::::::::::::::: B i g D i v 3 2 ::::::::::::::::::::::::::::::::::::::::
; (big)y = (big)x / (dword)value
; (big)r = (big)x mod (dword)value
; if pBigz is 0, then only remainder is returned
; if pBigr is 0, then only quotient is returned
; returns r, -1 if division by zero
; coded-like-a-pig

_BigDiv32		proc	uses ebx ecx edi esi,pBigx:dword,dtValue:dword,pBigy:dword,pBigr:dword
			local	pBigSwapy:dword,dtSwapr:dword

			mov	ebx,dtValue

			; check division by zero
			test	ebx,ebx
			jz	__divisionbyzero

			mov	esi,pBigx
			mov	ecx,dword ptr [esi]

			invoke	_BigCreate,0
			mov	pBigSwapy,eax

			dec	ecx
			jz	__samelength
			js	__null

__initdiv:		inc	ecx
			shl	ecx,5
			dec	ecx

			mov	edi,pBigSwapy
			mov	dword ptr [edi],1
			mov	ebx,0

			; search for first set bit
			ALIGN	4
__search:		bt	dword ptr [esi+4],ecx
			jc	__divloop
			dec	ecx
			jmp	__search

			; perform division
__divloop:		push	ebx
;invoke	_BigShl,edi,edi
; uses ebx,edx
;_BigShl_________________________________________________________________________
			mov	edx,dword ptr [edi]
			mov	ebx,edi
			add	ebx,4
			clc
			ALIGN	4
__BShl_loop:		rcl	dword ptr [ebx],1
			lea	ebx,[ebx+4]
			dec	edx
			jnz	__BShl_loop
			jnc	__DShl
			inc	dword ptr [ebx]
			inc	dword ptr [edi]
;

__DShl:			pop	ebx
			shl	ebx,1

			bt	dword ptr [esi+4],ecx
			setc	al
			movzx	eax,al
			or	ebx,eax

			cmp	ebx,dtValue
			jl	__less

			sub	ebx,dtValue
			or	byte ptr [edi+4],1

__less:			dec	ecx
			jns	__divloop

__divend:		cmp	pBigy,0
			jz	__noy
			invoke	_BigCopy,pBigSwapy,pBigy
__noy:			cmp	pBigr,0
			jz	__nor
			invoke	_BigIn32,ebx,pBigr

__nor:			invoke	_BigDestroy,pBigSwapy

			mov	eax,ebx
			ret

__samelength:		mov	eax,dword ptr [esi+4]
			xor	edx,edx
			div	ebx
			mov	ebx,edx

			invoke	_BigIn32,eax,pBigSwapy
			jmp	__divend

			; (dword)value = 0
__divisionbyzero:	mov	eax,-1
			ret

			; (big)x = 0
__null:			cmp	pBigy,0
			jz	__nullnoy
			_BIGM_BIGCLEAR pBigy
__nullnoy:		cmp	pBigr,0
			jz	__nullnor
			_BIGM_BIGCLEAR pBigr
__nullnor:		xor	eax,eax
			ret

_BigDiv32		endp

;::::::::::::::::::::::::::::::::::::::::: B i g D i v ::::::::::::::::::::::::::::::::::::::::::
; (big)z = (big)x / (big)y
; (big)r = (big)x mod (big)y
; if pBigz is 0, then only remainder is returned
; if pBigr is 0, then only quotient is returned
; returns 0 if no error, -1 if division by zero
; coded-like-a-pig

_BigDiv			proc	uses ebx ecx edi esi,pBigx:dword,pBigy:dword,pBigz:dword,pBigr:dword
			local	pBigSwapz:dword,pBigSwapr:dword

			mov	edi,pBigy
			mov	ebx,dword ptr [edi]

			; check division by zero
			test	ebx,ebx
			jz	__divisionbyzero

			mov	esi,pBigx
			mov	ecx,dword ptr [esi]

			invoke	_BigCreate,0
			mov	pBigSwapz,eax
			invoke	_BigCreate,0
			mov	pBigSwapr,eax

			; check easy cases
			cmp	ebx,1
			jz	__dworddiv

			sub	ecx,ebx
			jz	__samelength
			js	__quotientnull

__initdiv:		mov	ecx,dword ptr [esi]
			shl	ecx,5
			dec	ecx

			mov	ebx,pBigSwapz
			mov	edi,pBigSwapr
			mov	dword ptr [edi],1
			mov	dword ptr [ebx],1

			; search for first set bit
			ALIGN	4
__search:		bt	dword ptr [esi+4],ecx
			jc	__divloop
			dec	ecx
			jmp	__search

			; perform division
__divloop:
;invoke	_BigShl,ebx,ebx
; uses ebx,edx
;_BigShl_________________________________________________________________________
			mov	edx,dword ptr [ebx]
			add	ebx,4
			clc
			ALIGN	4
__BShl1_loop:		rcl	dword ptr [ebx],1
			lea	ebx,[ebx+4]
			dec	edx
			jnz	__BShl1_loop
			jnc	__BShl2
			inc	dword ptr [ebx]
			mov	ebx,pBigSwapz
			inc	dword ptr [ebx]
;

__BShl2:		
;invoke	_BigShl,edi,edi
; uses ebx,edx
;_BigShl_________________________________________________________________________
			mov	edx,dword ptr [edi]
			lea	ebx,[edi+4]
			clc
			ALIGN	4
__BShl2_loop:		rcl	dword ptr [ebx],1
			lea	ebx,[ebx+4]
			dec	edx
			jnz	__BShl2_loop
			jnc	__testbit
			inc	dword ptr [ebx]
			inc	dword ptr [edi]
;

__testbit:		bt	dword ptr [esi+4],ecx
			setc	al
			or	byte ptr [edi+4],al

;invoke	_BigCompare,edi,pBigy
;jl	__less
; uses ebx edx
;_BigCompare_____________________________________________________________________
			mov	edx,pBigy
			mov	ebx,dword ptr [edx]
			cmp	dword ptr [edi],ebx
			jb	__less
			ja	__sub

			push	ecx
			mov	ecx,dword ptr [edi]
			lea	ebx,[ecx*4]
			add	edi,ebx
			mov	esi,edx
			add	esi,ebx
			std
			repz	cmpsd
			cld
			pop	ecx
			mov	esi,pBigx
			mov	edi,pBigSwapr
			ja	__less
;

__sub:
;invoke	_BigSub,edi,pBigy,edi
; uses ebx edx
;_BigSub_________________________________________________________________________
			push	ecx
			mov	esi,pBigy
			mov	ebx,dword ptr [edi]
			mov	ecx,dword ptr [esi]
			sub	ebx,ecx
			add	esi,4
			add	edi,4

			clc
			ALIGN	4
__BSub_subloop:		mov	edx,dword ptr [esi]
			sbb	dword ptr [edi],edx
			lea	esi,[esi+4]
			lea	edi,[edi+4]
			dec	ecx
			jnz	__BSub_subloop

			jnc	__BSub_doresize

			ALIGN	4
__BSub_subcarry:	sbb	dword ptr [edi],0
			lea	edi,[edi+4]
			dec	ebx
			jc	__BSub_subcarry

__BSub_doresize:	mov	esi,pBigSwapr
			ALIGN	4
__BSub_resize:		cmp	dword ptr [edi-4],0
			jnz	__BSub_done
			dec	dword ptr [esi]
			jz	__BSub_makesize
			sub	edi,4
			jmp	__BSub_resize

__BSub_makesize:	inc	dword ptr [esi]

__BSub_done:		pop	ecx
			mov	esi,pBigx
			mov	edi,pBigSwapr
			mov	ebx,pBigSwapz
;
			mov	ebx,pBigSwapz
			or	byte ptr [ebx+4],1

__less:			mov	ebx,pBigSwapz
			dec	ecx
			jns	__divloop

__divend:		cmp	pBigz,0
			jz	__noz
			invoke	_BigCopy,pBigSwapz,pBigz
__noz:			cmp	pBigr,0
			jz	__nor
			invoke	_BigCopy,pBigSwapr,pBigr

__nor:			invoke	_BigDestroy,pBigSwapz
			invoke	_BigDestroy,pBigSwapr

			xor	eax,eax
			ret

__samelength:		invoke	_BigCompare,pBigx,pBigy
			jl	__quotientnull
			jg	__initdiv

			; (big)x = (big)y
			invoke	_BigIn32,1,pBigSwapz
			jmp	__divend

			; (big)x < (big)y
__quotientnull:		invoke	_BigCopy,pBigx,pBigSwapr
			jmp	__divend

			; (big)y = 0
__divisionbyzero:	mov	eax,-1
			ret

			; (big)x = 0
__null:			cmp	pBigz,0
			jz	__nullnoz
			_BIGM_BIGCLEAR pBigz
__nullnoz:		cmp	pBigr,0
			jz	__nullnor
			_BIGM_BIGCLEAR pBigr
__nullnor:		xor	eax,eax
			ret

__dworddiv:		invoke	_BigDiv32,pBigx,dword ptr [edi+4],pBigz,pBigr
			xor	eax,eax
			ret

_BigDiv			endp
