;::::::::::::::::::::::::::::::::::::::: B i g M u l 3 2 ::::::::::::::::::::::::::::::::::::::::
; (big)y = (big)x * (dword)dtValue
; coded-like-a-pig

_BigMul32		proc	uses ebx ecx edi esi,pBigx:dword,dtValue:dword,pBigy:dword
			local	pBigSwap:dword

			mov	esi,pBigx
			mov	ecx,dword ptr [esi]

			test	ecx,ecx
			jz	__null
			cmp	dtValue,0
			jz	__null

			invoke	_BigCreate,0
			mov	pBigSwap,eax

			mov	ebx,dtValue
			mov	edi,eax

			ALIGN	4
__loop:			add	esi,4
			add	edi,4
			mov	eax,dword ptr [esi]
			xor	edx,edx
			mul	ebx
			add	dword ptr [edi],eax
			jnc	__addoverflow

			inc	edx

__addoverflow:		add	dword ptr [edi+4],edx
			lea	edx,[edi+8]

			ALIGN	4
__addcarry:		jnc	__nocarry
			adc	dword ptr [edx],0
			lea	edx,[edx+4]
			jmp	__addcarry

__nocarry:		dec	ecx
			jnz	__loop

			add	edi,4
			cmp	dword ptr [edi],0
			jnz	__addsize

			sub	edi,4

__addsize:		sub	edi,pBigSwap
			shr	edi,2
			mov	ebx,pBigSwap
			mov	dword ptr [ebx],edi

			invoke	_BigCopy,pBigSwap,pBigy
			invoke	_BigDestroy,pBigSwap

			ret

__null:			_BIGM_BIGCLEAR pBigy

			ret

_BigMul32		endp

;::::::::::::::::::::::::::::::::::::::::: B i g M u l ::::::::::::::::::::::::::::::::::::::::::
; (big)z = (big)x * (big)y
; coded-like-a-pig

_BigMul			proc	uses ebx ecx edi esi,pBigx:dword,pBigy:dword,pBigz:dword
			local	pBigSwap:dword,dtOuterCount:dword,dtInnerCount:dword

			mov	esi,pBigx
			mov	edi,pBigy
			mov	ecx,dword ptr [esi]

			test	ecx,ecx
			jz	__null
			cmp	dword ptr [edi],0
			jz	__null

			invoke	_BigCreate,0
			mov	pBigSwap,eax

			mov	dtOuterCount,ecx

			ALIGN	4
__outerloop:		add	esi,4

			mov	ecx,dword ptr [esi]

			mov	ebx,esi
			sub	ebx,pBigx
			add	ebx,pBigSwap

			mov	edi,pBigy
			mov	edx,dword ptr [edi]
			mov	dtInnerCount,edx

			ALIGN	4
__innerloop:		add	edi,4

			mov	eax,dword ptr [edi]
			xor	edx,edx
			mul	ecx
			add	dword ptr [ebx],eax
			jnc	__addoverflow

			inc	edx

__addoverflow:		add	dword ptr [ebx+4],edx
			lea	edx,[ebx+8]

			ALIGN	4
__addcarry:		jnc	__nocarry
			adc	dword ptr [edx],0
			lea	edx,[edx+4]
			jmp	__addcarry

__nocarry:		add	ebx,4

			dec	dtInnerCount
			jnz	__innerloop

			dec	dtOuterCount
			jnz	__outerloop

			cmp	dword ptr [ebx],0
			jnz	__addsize

			sub	ebx,4

__addsize:		sub	ebx,pBigSwap
			shr	ebx,2
			mov	edi,pBigSwap
			mov	dword ptr [edi],ebx

			invoke	_BigCopy,pBigSwap,pBigz
			invoke	_BigDestroy,pBigSwap

			ret

__null:			_BIGM_BIGCLEAR pBigz

			ret

_BigMul			endp
