;::::::::::::::::::::::::::::::::::::::: B i g S u b 3 2 ::::::::::::::::::::::::::::::::::::::::
; (big)y = |(big)x - (dword)dtValue|

_BigSub32		proc	uses ebx ecx edi esi,pBigx:dword,dtValue:dword,pBigy:dword

			invoke	_BigCopy,pBigx,pBigy

			mov	ecx,dtValue
			test	ecx,ecx
			jz	__ret

			mov	edi,pBigy
			mov	edx,dword ptr [edi]

			cmp	edx,1
			jz	__dword
			jb	__less

			clc
			add	edi,4
			sub	dword ptr [edi],ecx
			lea	edi,[edi+4]
			jnc	__doresize

			ALIGN	4
__subcarry:		sbb	dword ptr [edi],0
			lea	edi,[edi+4]
			jc	__subcarry

__doresize:		mov	esi,pBigy
			ALIGN	4
__resize:		cmp	dword ptr [edi-4],0
			jnz	__ret
			dec	dword ptr [esi]
			sub	edi,4
			jmp	__resize

__ret:			ret

__less:			inc	dword ptr [edi]
			mov	dword ptr [edi+4],ecx

			ret

__dword:		sub	dword ptr [edi+4],ecx

			jz	__null
			jnc	__ret

			neg	dword ptr [edi+4]

			jmp	__ret

__null:			dec	dword ptr [edi]

			ret

_BigSub32		endp

;::::::::::::::::::::::::::::::::::::::::: B i g S u b ::::::::::::::::::::::::::::::::::::::::::
; (big)z = |(big)x - (big)y|

_BigSub			proc	uses ebx ecx edi esi,pBigx:dword,pBigy:dword,pBigz:dword
			local	pBigSwap:dword

			mov	esi,pBigx
			mov	edi,pBigy

			cmp	esi,edi
			jz	__equals			; bignumbers are the same, result is 0

			invoke	_BigCompare,esi,edi
			jg	__bigsordered
			jz	__equals			; bignumbers are the same, result is 0

			xchg	esi,edi

			; subs edi from esi
__bigsordered:		invoke	_BigCreate,0			; edi < esi
			mov	pBigSwap,eax

			invoke	_BigCopy,esi,eax

			mov	ecx,dword ptr [edi]
			test	ecx,ecx
			jz	__copy				; edi=0, result=esi

			mov	esi,pBigSwap
			add	esi,4
			add	edi,4

			clc
			ALIGN	4
__subloop:		mov	edx,dword ptr [edi]		; sub edi from esi
			sbb	dword ptr [esi],edx
			lea	esi,[esi+4]
			lea	edi,[edi+4]
			dec	ecx
			jnz	__subloop

			jnc	__doresize

			ALIGN	4
__subcarry:		sbb	dword ptr [esi],0		; sub carry if any
			lea	esi,[esi+4]
			jc	__subcarry

__doresize:		mov	edi,pBigSwap
			ALIGN	4
__resize:		cmp	dword ptr [esi-4],0
			jnz	__copy
			dec	dword ptr [edi]
			sub	esi,4
			jmp	__resize

__copy:			invoke	_BigCopy,pBigSwap,pBigz
			invoke	_BigDestroy,pBigSwap
			
			ret

__equals:		_BIGM_BIGCLEAR pBigz

			ret

_BigSub			endp
