;:::::::::::::::::::::::::::::::::::::: B i g I n B 2 5 6 :::::::::::::::::::::::::::::::::::::::
; fills Big with dtLen bytes at ptData in base 256

_BigInB256		proc	uses ebx ecx edi esi,ptData:dword,dtLen:dword,pBig:dword

			_BIGM_BIGCLEAR pBig

			mov	ecx,dtLen
			test	ecx,ecx
			jz	__ret

			_BIGM_MEMALLOC _BIG_BIGSIZE*4

			; get size of data, subtract size of leading zeros
			mov	ecx,dtLen
			mov	esi,ptData

__removezeros:		cmp	byte ptr [esi],0
			jnz	__padd

			inc	esi
			dec	ecx
			jnz	__removezeros
			jmp	__filled

			; padd with zeros
__padd:			mov	ebx,ecx
			and	ebx,3

			test	bl,bl
			jz	__copy

			neg	bl
			add	bl,4

			; copy the data
__copy:			mov	edi,eax
			add	edi,ebx
			add	ebx,ecx

			rep	movsb

			shr	ebx,2

			mov	edi,pBig
			mov	dword ptr [edi],ebx
			add	edi,4

			dec	ebx

			; fill the bignum with the data
__fillbignum:		mov	ecx,dword ptr [eax+ebx*4]
			bswap	ecx
			mov	dword ptr [edi],ecx
			add	edi,4
			dec	ebx
			jns	__fillbignum

__filled:		_BIGM_MEMDEALLOC eax

__ret:			ret

_BigInB256		endp

;:::::::::::::::::::::::::::::::::::::::: B i g I n 3 2 :::::::::::::::::::::::::::::::::::::::::
; fills Big with dtValue

_BigIn32		proc	uses ecx edi esi,dtValue:dword,pBig:dword

			_BIGM_BIGCLEAR pBig

			mov	ecx,dtValue
			test	ecx,ecx
			jz	__ret

			mov	edi,pBig
			mov	dword ptr [edi],1
			mov	dword ptr [edi+4],ecx

__ret:			ret

_BigIn32		endp

;:::::::::::::::::::::::::::::::::::::::::: B i g I n :::::::::::::::::::::::::::::::::::::::::::
; fill a bignum with a string in a given base (2-62)
; base 2 to 62 are the characters in [0..9][A..Z][a..z]
; returns 0 if no error, -1 if base isn' t supported
; coded-like-a-pig

_BigIn			proc	uses ebx ecx edi esi,ptBuffer:dword,dtBase:dword,pBig:dword
			local	dtLen:dword,dtCount:dword,dtBasePow:dword,pBigSwap:dword

			cmp	dtBase,62
			jg	__basenotsupported
			cmp	dtBase,2
			jl	__basenotsupported

			_BIGM_BIGCLEAR pBig

			_BIGM_STRLEN ptBuffer
			mov	dtLen,ecx

			mov	dtCount,1
			mov	ebx,dtBase
			mov	eax,ebx

__loopbasepow:		mov	ecx,eax
			imul	eax,ebx
			jc	__init
			inc	dtCount
			jmp	__loopbasepow

__init:			mov	dtBasePow,ecx
			mov	edi,offset dtBaseConvertTable
			mov	esi,ptBuffer

			invoke	_BigCreate,0
			mov	pBigSwap,eax

			ALIGN	4
__outerloop:		mov	edx,dtCount
			xor	eax,eax
			xor	ecx,ecx

			ALIGN	4
__innerloop:		cmp	dtLen,0
			jz	__addlast
			dec	dtLen
			mov	cl,byte ptr [esi]
			inc	esi
			mov	cl,byte ptr [edi+ecx]
			test	cl,cl
			js	__addlast
			imul	eax,ebx
			add	eax,ecx
			dec	edx
			jnz	__innerloop

			mov	ecx,eax
			invoke	_BigMul32,pBigSwap,dtBasePow,pBigSwap
			invoke	_BigAdd32,pBigSwap,ecx,pBigSwap

			jmp	__outerloop

__addlast:		mov	ecx,eax
			mov	eax,1

__looplast:		cmp	edx,dtCount
			jz	__addbig
			imul	eax,ebx
			inc	edx
			jmp	__looplast

__addbig:		invoke	_BigMul32,pBigSwap,eax,pBigSwap
			invoke	_BigAdd32,pBigSwap,ecx,pBigSwap

			invoke	_BigCopy,pBigSwap,pBig
			invoke	_BigDestroy,pBigSwap

			xor	eax,eax
			ret

__basenotsupported:	mov	eax,-1
			ret

_BigIn			endp

;::::::::::::::::::::::::::::::::::::: B i g I n B y t e s ::::::::::::::::::::::::::::::::::::::
; fill a bignum with data in a given base (2-256)
; returns 0 if no error, -1 if base isn' t supported
; coded-like-a-pig

_BigInBytes		proc	uses ebx ecx edi esi,ptBuffer:dword,dtLength:dword,dtBase:dword,pBig:dword
			local	dtCount:dword,dtBasePow:dword,pBigSwap:dword

			cmp	dtBase,256
			jg	__basenotsupported
			cmp	dtBase,2
			jl	__basenotsupported

			_BIGM_BIGCLEAR pBig

			mov	edi,dtLength

			mov	dtCount,1
			mov	ebx,dtBase
			mov	eax,ebx

__loopbasepow:		mov	ecx,eax
			imul	eax,ebx
			jc	__init
			inc	dtCount
			jmp	__loopbasepow

__init:			mov	dtBasePow,ecx
			mov	esi,ptBuffer

			invoke	_BigCreate,0
			mov	pBigSwap,eax

			ALIGN	4
__outerloop:		mov	edx,dtCount
			xor	eax,eax
			xor	ecx,ecx

			ALIGN	4
__innerloop:		test	edi,edi
			jz	__addlast
			dec	edi
			mov	cl,byte ptr [esi]
			inc	esi
			imul	eax,ebx
			add	eax,ecx
			dec	edx
			jnz	__innerloop

			mov	ecx,eax
			invoke	_BigMul32,pBigSwap,dtBasePow,pBigSwap
			invoke	_BigAdd32,pBigSwap,ecx,pBigSwap

			jmp	__outerloop

__addlast:		mov	ecx,eax
			mov	eax,1

__looplast:		cmp	edx,dtCount
			jz	__addbig
			imul	eax,ebx
			inc	edx
			jmp	__looplast

__addbig:		invoke	_BigMul32,pBigSwap,eax,pBigSwap
			invoke	_BigAdd32,pBigSwap,ecx,pBigSwap

			invoke	_BigCopy,pBigSwap,pBig
			invoke	_BigDestroy,pBigSwap

			xor	eax,eax
			ret

__basenotsupported:	mov	eax,-1
			ret

_BigInBytes		endp

;::::::::::::::::::::::::::::::::::::: B i g O u t B 2 5 6 ::::::::::::::::::::::::::::::::::::::
; stores pBig in ptBuffer in base 256
; returns size of stored data in bytes

_BigOutB256		proc	uses ebx ecx edi esi,pBig:dword,ptBuffer:dword

			mov	ebx,pBig
			xor	edx,edx
			mov	ecx,dword ptr [ebx]

			test	ecx,ecx
			jz	__ret

			mov	edi,ptBuffer
			mov	eax,dword ptr [ebx+4*ecx]

			; check if all the bytes of the higher dword are set
			xor	cl,cl
			bswap	eax

__loophigher:		test	al,0ffh
			jnz	__storehigher
			ror	eax,8
			inc	cl
			and	cl,3
			jnz	__loophigher

__storehigher:		stosb
			ror	eax,8
			inc	dl
			inc	cl
			and	cl,3
			jnz	__storehigher

			mov	ecx,dword ptr [ebx]
__storeloop:		dec	ecx
			jz	__ret

			lea	esi,[ebx+4*ecx]
			lodsd
			bswap	eax
			stosd

			add	edx,4
			jmp	__storeloop

__ret:			mov	eax,edx
			ret

_BigOutB256		endp

;:::::::::::::::::::::::::::::::::::::: B i g O u t B 1 6 :::::::::::::::::::::::::::::::::::::::
; store Big as an hexadecimal string at ptBuffer
; returns the size of the string without the last null byte
; coded-like-a-pig

_BigOutB16		proc	uses ebx ecx edi esi,pBig:dword,ptBuffer:dword
			local	ptMem

			mov	esi,pBig
			mov	ecx,dword ptr [esi]

			test	ecx,ecx
			jz	__null

			shl	ecx,3
			inc	ecx

			_BIGM_MEMALLOC ecx
			mov	ptMem,eax
			mov	edi,eax

			mov	ecx,dword ptr [esi]
			xor	edx,edx

			; convert the bignumber in hex
__convert:		mov	eax,[esi+ecx*4]
			bswap	eax

__writedword:		mov	bl,al
			shr	bl,4
			and	bl,0fh
			cmp	bl,10
			jb	__writenibble1
			add	bl,'A' - 10 - '0'

__writenibble1:		add	bl,'0'
			mov	byte ptr [edi],bl
			inc	edi

			and	al,0fh
			cmp	al,10
			jb	__writenibble2
			add	al,'A' - 10 - '0'

__writenibble2:		add	al,'0'
			mov	byte ptr [edi],al
			inc	edi

			shr	eax,8
			inc	dl
			and	dl,3
			jnz	__writedword

			dec	ecx
			jnz	__convert

			mov	ecx,dword ptr [esi]
			shl	ecx,3

			mov	esi,ptMem
__removezeros:		cmp	byte ptr [esi],'0'
			jnz	__copy

			dec	ecx
			inc	esi
			jmp	__removezeros

__copy:			mov	ebx,ecx
			mov	edi,ptBuffer
			rep	movsb

			and	byte ptr [edi],0

			_BIGM_MEMDEALLOC ptMem

			mov	eax,ebx

			ret

__null:			mov	edi,ptBuffer
			mov	word ptr [edi],'0'
			mov	eax,1
			ret

_BigOutB16		endp

;::::::::::::::::::::::::::::::::::::::::: B i g O u t ::::::::::::::::::::::::::::::::::::::::::
; store Big as a string in a given base (2-62 and 256) at ptBuffer
; returns the size of the string without the last null byte, -1 if base isn' t supported
; coded-like-a-pig

_BigOut			proc	uses ebx ecx edi esi,pBig:dword,dtBase:dword,ptBuffer:dword
			local	dtCount:dword,dtBasePow:dword,pBigSwap:dword,ptMem:dword

			cmp	dtBase,256
			jz	__base256
			cmp	dtBase,16
			jz	__base16
			cmp	dtBase,62
			jg	__basenotsupported
			cmp	dtBase,2
			jl	__basenotsupported

			mov	ecx,pBig
			mov	ecx,dword ptr [ecx]
			test	ecx,ecx
			jz	__null

			shl	ecx,5
			_BIGM_MEMALLOC ecx
			mov	ptMem,eax
			mov	edi,eax

			invoke	_BigCreate,0
			mov	pBigSwap,eax
			invoke	_BigCopy,pBig,pBigSwap

			mov	dtCount,1
			mov	ebx,dtBase
			mov	eax,ebx

__loopbasepow:		mov	ecx,eax
			imul	eax,ebx
			jc	__init
			inc	dtCount
			jmp	__loopbasepow

__init:			mov	dtBasePow,ecx
			mov	esi,offset szBaseAlphabet

			mov	ebx,dtBase
			ALIGN	4
__outerloop:		invoke	_BigDiv32,pBigSwap,dtBasePow,pBigSwap,0
			mov	ecx,dtCount

			ALIGN	4
__innerloop:		xor	edx,edx
			div	ebx
			mov	dl,byte ptr [esi+edx]
			mov	byte ptr [edi],dl
			inc	edi
			dec	ecx
			jnz	__innerloop

			mov	ecx,pBigSwap
			cmp	dword ptr [ecx],0
			jnz	__outerloop

			dec	edi
			mov	al,byte ptr [esi]
			mov	ecx,-1
			std
			repz	scasb
			cld
			inc	edi

			mov	esi,ptBuffer
			mov	ebx,edi
			sub	ebx,ptMem
			inc	ebx
			mov	ecx,ebx

__loopreverse:		mov	al,byte ptr [edi]
			mov	byte ptr [esi],al
			dec	edi
			inc	esi
			dec	ecx
			jnz	__loopreverse

			and	byte ptr [esi],0

			_BIGM_MEMDEALLOC ptMem

			mov	eax,ebx
			ret

__null:			mov	esi,offset szBaseAlphabet
			movzx	eax,byte ptr [esi]
			mov	esi,ptBuffer
			mov	word ptr [esi],ax
			mov	al,1
			ret

__base256:		invoke	_BigOutB256,pBig,ptBuffer
			mov	esi,ptBuffer
			and	byte ptr [esi+eax],0
			ret

__base16:		invoke	_BigOutB16,pBig,ptBuffer
			ret

__basenotsupported:	mov	eax,-1
			ret

_BigOut			endp

;:::::::::::::::::::::::::::::::::::: B i g O u t B y t e s :::::::::::::::::::::::::::::::::::::
; store Big as data in a given base (2-256) at ptBuffer
; returns the size of the string without the last null byte, -1 if base isn' t supported
; coded-like-a-pig

_BigOutBytes		proc	uses ebx ecx edi esi,pBig:dword,dtBase:dword,ptBuffer:dword
			local	dtCount:dword,dtBasePow:dword,pBigSwap:dword,ptMem:dword

			cmp	dtBase,256
			jz	__base256
			jg	__basenotsupported
			cmp	dtBase,2
			jl	__basenotsupported

			mov	ecx,pBig
			mov	ecx,dword ptr [ecx]
			test	ecx,ecx
			jz	__null

			shl	ecx,5
			_BIGM_MEMALLOC ecx
			mov	ptMem,eax
			mov	edi,eax

			invoke	_BigCreate,0
			mov	pBigSwap,eax
			invoke	_BigCopy,pBig,pBigSwap

			mov	dtCount,1
			mov	ebx,dtBase
			mov	eax,ebx

__loopbasepow:		mov	ecx,eax
			imul	eax,ebx
			jc	__init
			inc	dtCount
			jmp	__loopbasepow

__init:			mov	dtBasePow,ecx

			mov	ebx,dtBase
			ALIGN	4
__outerloop:		invoke	_BigDiv32,pBigSwap,dtBasePow,pBigSwap,0
			mov	ecx,dtCount

			ALIGN	4
__innerloop:		xor	edx,edx
			div	ebx
			mov	byte ptr [edi],dl
			inc	edi
			dec	ecx
			jnz	__innerloop

			mov	ecx,pBigSwap
			cmp	dword ptr [ecx],0
			jnz	__outerloop

			dec	edi
			xor	al,al
			mov	ecx,-1
			std
			repz	scasb
			cld
			inc	edi

			mov	esi,ptBuffer
			mov	ebx,edi
			sub	ebx,ptMem
			inc	ebx
			mov	ecx,ebx

__loopreverse:		mov	al,byte ptr [edi]
			mov	byte ptr [esi],al
			dec	edi
			inc	esi
			dec	ecx
			jnz	__loopreverse

			and	byte ptr [esi],0

			_BIGM_MEMDEALLOC ptMem

			mov	eax,ebx
			ret

__null:			xor	eax,eax
			mov	word ptr [esi],ax
			mov	al,1
			ret

__base256:		invoke	_BigOutB256,pBig,ptBuffer
			mov	esi,ptBuffer
			and	byte ptr [esi+eax],0
			ret

__basenotsupported:	mov	eax,-1
			ret

_BigOutBytes		endp
