;::::::::::::::: c o n s t a n t s ,   s t r u c t u r e s   a n d   m a c r o s ::::::::::::::::
_BIG_BIGSIZE		equ	20 + 1		; maximal number of dwords, and size dword

; _BIGM_MEMALLOC
; allocates memory, returns address in eax
_BIGM_MEMALLOC		MACRO	dtSize
			invoke	VirtualAlloc,0,dtSize,MEM_COMMIT,PAGE_READWRITE
ENDM

; _BIGM_MEMDEALLOC
; deallocates memory
; uses eax
_BIGM_MEMDEALLOC	MACRO	ptMem
			invoke	VirtualFree,ptMem,0,MEM_RELEASE
ENDM

; _BIGM_BIGCLEAR
; clears a bignumber
; uses eax ecx edi
; on exit, eax=0, ecx=0
_BIGM_BIGCLEAR		MACRO	pBig
			mov	edi,pBig
			xor	eax,eax
			mov	ecx,dword ptr [edi]
			inc	ecx
			rep	stosd
ENDM

; _BIGM_STRLEN
; returns length of a null-terminated string in ecx
; uses al, ecx, edi
; on exit, al=0, ecx=length
_BIGM_STRLEN		MACRO	ptString
			mov	edi,ptString
			mov	ecx,-1
			xor	al,al
			repnz	scasb
			not	ecx
			dec	ecx
ENDM
