; Very short example how to use HandleError
;
; #########################################################################

		.386
		.model flat, stdcall
		option casemap :none   ; case sensitive
      
		; Macro to define a zero terminated string in data section
		; works better than the szText macro sometimes
		dsText MACRO Name, Text:VARARG
			.data
			Name db Text,0
			.code
		ENDM

		; some includes and libraries
		include \masm32\include\windows.inc
		include \masm32\include\user32.inc
		include \masm32\include\kernel32.inc
		
		includelib \masm32\lib\user32.lib
		includelib \masm32\lib\kernel32.lib
		
		; code for HandleError
		include handleEr.asm

; #########################################################################

.data
		; use first line to test error message if file doesn't exist
		; use second line to test what happens if you can't open file
		; because it's already in use
		
		;szFile	db "test.exe",0		; file shouldn't exist
		szFile	db "example.exe",0	; this file exits :)
		
.data?
		hFile 	HANDLE ?

.code

; #########################################################################

start:
		; open file with flag OPEN_EXISTING and no sharing allowed
		invoke CreateFile, ADDR szFile, GENERIC_READ,
				0, NULL, OPEN_EXISTING, 0, NULL

		.if eax == INVALID_HANDLE_VALUE
			dsText szCreateFile, "CreateFile"		; name of function that failed
			invoke HandleError, ADDR szCreateFile	; display messagebox with error!
		.else
			mov hFile, eax							; save file handle (eax)
			
			; now open file again, should fail (no share-mode is set)
			invoke CreateFile, ADDR szFile, GENERIC_WRITE,
				0, NULL, OPEN_EXISTING, 0, NULL
			
			.if eax == INVALID_HANDLE_VALUE
				invoke HandleError, ADDR szCreateFile ; get error message, display it
			
			.else
				; very strange, shouldn't have worked :)
				push eax							; file-handle still in eax
				call CloseHandle
			
			.endif
			
			invoke CloseHandle, hFile				; close file-handle in hFile
		
		.endif

		invoke ExitProcess, 0

; #########################################################################

end start
