;This Dynamic Link Library contains 5 functios which calculate the Checksums for the following
;protocols: IP, TCP, UDP, ICMP and PPP. 
;It also includes a bonus function which encapsulates data for PPP packets so that the packet is
;ready to be sent.
;This DLL file was made by J. Daniel Pino (Daniel_2). If you have any comments, questions
;or whatever, let me know at: daniel_2@fibertel.com.ar
;I really, really hope that people working on the Internet in a "low level" find this stuff 
;useful.

;For more details, take a look at the file Reference.doc.

;Esta libreria de enlace dinamico (DLL) contiene 5 funciones que calculan las sumas de 
;comprobacin (Checksums) para los protocolos IP, TCP, UDP, ICMP y PPP respectivamente. 
;Tambien contiene una funcion extra la cual se encarga del encapsulamiento de los datos de un 
;paquete PPP y dejarlo listo para ser enviado. 
;Esta DLL fue creada por J. Daniel Pino (Daniel_2). Ante cualquier sugerencia o lo que sea, 
;escribanme a: daniel_2@fibertel.com.ar. Espero que esto realmente le sea de gran utilidad a 
;aquellas personas que esten trabando la Internet "en un bajo nivel".

;Para una referencia mas detallada, lease el documento Reference.doc adjunto a este archivo.

.386
.MODEL FLAT, STDCALL
OPTION  CASEMAP:NONE

;---------------------------------------------------------------------------------------------------------------------
                    ;Includes
;---------------------------------------------------------------------------------------------------------------------                    
INCLUDE    C:\MASM32\INCLUDE\WINDOWS.INC
INCLUDE    C:\MASM32\INCLUDE\KERNEL32.INC

INCLUDELIB C:\MASM32\LIB\KERNEL32.LIB
;---------------------------------------------------------------------------------------------------------------------
;                   Prototypes-Prototipos
;---------------------------------------------------------------------------------------------------------------------

ip_checksum  PROTO ip_pointer:DWORD
tcp_checksum PROTO p_tcp_header:DWORD, p_tcp_options_data:DWORD, len_options_data:DWORD, p_ip_header:DWORD 
data_checksum  PROTO   p_data:DWORD, len_data:DWORD
ip_pseudohdr_checksum PROTO   p_ip_header:DWORD
icmp_checksum PROTO p_icmp_header:DWORD, p_icmp_data:DWORD, len_icmp_data:DWORD
udp_checksum PROTO p_udp_header:DWORD, p_udp_data:DWORD, len_data:DWORD, p_ip_header:DWORD
ppp_checksum PROTO p_ppp_data:DWORD, len_ppp_data:DWORD
ppp_fcstab_load PROTO
ppp_encapsulate_data PROTO p_ppp_data:DWORD, len_ppp_data:DWORD
;---------------------------------------------------------------------------------------------------------------------
                    .DATA 
;---------------------------------------------------------------------------------------------------------------------
fcstab WORD 256 DUP (0)
fcs  WORD 0
temp_array BYTE 1000 DUP (0)

;---------------------------------------------------------------------------------------------------------------------
                    .CONST ;Consts-constantes
;---------------------------------------------------------------------------------------------------------------------
p               WORD   8408H
pppinitfcs16    WORD   0FFFFH
pppgoodfcs16    WORD   0F0B8H

;---------------------------------------------------------------------------------------------------------------------
                    .CODE
;---------------------------------------------------------------------------------------------------------------------
dll_entry     PROC    hInstDLL:HINSTANCE, reason:DWORD, reserved1:DWORD

              INVOKE  ppp_fcstab_load
              MOV     EAX, TRUE
                
              RET
dll_entry     ENDP
;---------------------------------------------------------------------------------------------------------------------                    
ip_checksum   PROC USES EBX ECX ip_pointer:DWORD 

              ;The register are reset.
	        XOR EAX, EAX
              XOR ECX, ECX
                    
              MOV EBX, ip_pointer

              MOV AX, WORD PTR [EBX]
              XCHG   AL, AH

              MOV CX, WORD PTR [EBX + 2]
              ADD EAX, ECX

              MOV CX, WORD PTR [EBX + 4]
              ADD EAX, ECX

              MOV CX, WORD PTR [EBX + 6]
              ADD EAX, ECX

              MOV CX, WORD PTR [EBX + 8]
              XCHG CL, CH
              ADD EAX, ECX

              MOV CX, WORD PTR [EBX + 10]
              ADD EAX, ECX

              MOV CX, WORD PTR [EBX + 12]
              ADD EAX, ECX

              MOV CX, WORD PTR [EBX + 14]
              ADD EAX, ECX

              MOV CX, WORD PTR [EBX + 16]
              ADD EAX, ECX
                    
              MOV CX, WORD PTR [EBX + 18]
              ADD EAX, ECX

              MOV ECX, EAX
              SHR ECX, 16

              ADD EAX, ECX

              NOT AX

              AND EAX, 0FFFFH

              RET
ip_checksum   ENDP

;---------------------------------------------------------------------------------------------------------------------
;This functios calculates the checksum for TCP segments. To do so, it also calls others functions
;that partially calculates the checksum for each structure that compose a TCP segment
;(Optios-data, IP-Pseudo-header). Once it gets all the partials results, the function carries out
;the corresponding final operations.


;Esta funcion calcula la suma de comprobacion para un segmento TCP determinado. Para ello,
;se vale de otras funciones las cuales van calculando de forma parcial
;la suma de comprobacion por cada estructura que componen un segmento TCP (opciones-data, 
;IP-Pseudo-header). Una vez obtenido cada resultado de cada parte, efectua la suma y
;operaciones correpondientes.
;---------------------------------------------------------------------------------------------------------------------
tcp_checksum        PROC USES EBX ECX p_tcp_header:DWORD, p_tcp_options_data:DWORD, len_options_data:DWORD, p_ip_header:DWORD
                    LOCAL temp:DWORD

                    ;Register are reset.
                    XOR EAX, EAX
                    XOR EBX, EBX
                    XOR ECX, ECX

                    MOV EBX, p_tcp_header

                    MOV AX, WORD PTR [EBX]          ;Source Port
                    MOV CX, WORD PTR [EBX + 2]      ;Destination Port

                    NOT AX
                    NOT CX
                    ADD EAX, ECX

                    MOV CX, WORD PTR [EBX + 4]      ;Secuence Number (Part1)
                    NOT CX
                    ADD EAX, ECX

                    MOV CX, WORD PTR [EBX + 6]      ;Secuence Number (Part 2)
                    NOT CX
                    ADD EAX, ECX

                    MOV CX, WORD PTR [EBX + 8]      ;Aknowledgement Number (Part 1)
                    NOT CX
                    ADD EAX, ECX

                    MOV CX, WORD PTR [EBX + 10]     ;Aknowledgement Number (Part 2)
                    NOT CX
                    ADD EAX, ECX

                    MOV CX, WORD PTR [EBX + 12]     ;Len-Unused-Flag 
                    XCHG CL, CH
                    NOT CX
                    ADD EAX, ECX

                    MOV CX, WORD PTR [EBX + 14]     ;Window Size 
                    NOT CX
                    ADD EAX, ECX

                    MOV CX, WORD PTR [EBX + 16]     ;CheckSum 
                    NOT CX
                    ADD EAX, ECX


                    MOV CX, WORD PTR [EBX + 18]     ;Urgent Pointer 
                    NOT CX
                    ADD EAX, ECX


                    MOV temp, EAX

                    .IF p_tcp_options_data==0    ;If there is no Options-Data,
                        JMP skip_1               ;skip Options-data calculations
                    .ENDIF

                    INVOKE data_checksum, p_tcp_options_data, len_options_data
                    ADD temp, EAX
                                                          
skip_1:                  
                   
                    INVOKE ip_pseudohdr_checksum, p_ip_header
                    ADD temp, EAX

                    ;Now, with the sum of all the "partial checksums", operations with the carry 
                    ;value are carried out to get the final result
                                        
                    MOV EAX, temp
                    SHR EAX, 16
                    ADD temp, EAX
                    AND temp, 0FFFFH

                    MOV EAX, temp


                    RET
tcp_checksum        ENDP

;---------------------------------------------------------------------------------------------------------------------
;This function calculates the partial checksum for data that TCP-UDP segements and ICMP 
;datagrams may include. It receives two parameters: a pointer to an array of bytes and the size
;of such array.

;Esta funcion se encarga de calcular la suma de comprobacion (CheckSum) para los datos que 
;los segmento TCP, UDP y datagramas ICMP pueden tener adjuntos. La misma recibe como parametros 
;un puntero a una matriz de bytes donde se almacenan los datos y otro con la longitud de dicha
;matriz.
;---------------------------------------------------------------------------------------------------------------------
data_checksum               PROC USES EBX ECX EDX EDI p_data:DWORD, len_options_data:DWORD
              
                            ;Registers that will be used are reset
                            XOR EAX, EAX
                            XOR EBX, EBX
                            XOR ECX, ECX
                            XOR EDI, EDI
                            XOR EDX, EDX
                        
                            MOV EBX, p_data  ;Now EBX points to the start of the array of bytes 
                                             

                            MOV EAX, len_options_data
                            AND EAX, 1

                            .IF EAX == 1  ;If len_options is an odd value

                                .IF len_options_data == 1
                                    XOR EAX, EAX
                                    MOV AH, BYTE PTR [EBX]
                                    NOT AX
                                    RET
                                .ENDIF

                               
                                MOV AX, WORD PTR [EBX]
                                XCHG AL, AH
                                NOT AX

                                MOV EDI, 2
                                MOV EDX, len_options_data
                                DEC EDX

                                .WHILE EDI != EDX
                                    MOV CX, WORD PTR [EBX + EDI]
                                    XCHG CL, CH
                                    NOT CX
                                    ADD EAX, ECX
                                    ADD EDI, 2
                                .ENDW
                            
                                XOR ECX, ECX
                                MOV CH, BYTE PTR [EBX + EDI]
                                NOT CX
                                ADD EAX, ECX
                                RET

                            .ELSE       ;If len_options_data isn't an odd value

                                MOV AX, WORD PTR [EBX]
                                XCHG AL, AH
                                NOT AX

                                MOV EDI, 2
                                MOV EDX, len_options_data

                                .WHILE EDI != EDX
                                    MOV CX, WORD PTR [EBX + EDI]
                                    XCHG CL, CH
                                    NOT CX
                                    ADD EAX, ECX
                                    ADD EDI, 2
                                .ENDW
                                

                            .ENDIF

                            RET
data_checksum ENDP

;---------------------------------------------------------------------------------------------------------------------
;This functions calculates the checksum for Ip_Pseudo-header. Such task is carried out by receiving 
;a pointer to the IP-header structure.

;Esta funcion se encarga de calcular la suma de comprobacion para el pseudo-header IP. El mismo
;se obtiene a partir de un puntero hacia el encabezado IP.
;---------------------------------------------------------------------------------------------------------------------
ip_pseudohdr_checksum   PROC    USES EBX ECX    p_ip_header:DWORD

                        ;EAX and ECX are reset.
                        XOR EAX, EAX
                        XOR ECX, ECX
                        
                        MOV EBX, p_ip_header	 ;Now EBX poinst to the start of the IP-header structure.

                        MOV AX, WORD PTR [EBX + 12]     ;Source IP Part 1
                        NOT AX

                        MOV CX, WORD PTR [EBX + 14]     ;Source IP Part 2
                        NOT CX
                        ADD EAX, ECX

                        MOV CX, WORD PTR [EBX + 16]     ;Destination IP Part 1
                        NOT CX
                        ADD EAX, ECX

                        MOV CX, WORD PTR [EBX + 18]     ;Destination IP Part 2
                        NOT CX
                        ADD EAX, ECX

                        XOR ECX, ECX
                        MOV CL, BYTE PTR [EBX + 9]     ;Protocol
                        NOT CX
                        ADD EAX, ECX
                        
                        MOV CX, WORD PTR [EBX + 2]     ;Length of IP datagram.
                        SUB CX, 20                     ;The size of the IP-header (20 bytes) 
                        NOT CX		             ;is substracted.

                        ADD EAX, ECX

                        RET
ip_pseudohdr_checksum   ENDP    

;---------------------------------------------------------------------------------------------------------------------
;This function calculates the checksum for the ICMP protocol. The data_checksum function is called
;if the ICMP datagram includes data.

;Esta funcion calcula la suma de comprobacion (CheckSum) para el protocolo ICMP. Para los datos
;(icmp_data), esta funcion se vale de otra funcion (data_checksum).
;---------------------------------------------------------------------------------------------------------------------
icmp_checksum           PROC  USES EBX ECX  p_icmp_header:DWORD, p_icmp_data:DWORD, len_icmp_data:DWORD
                        LOCAL temp:DWORD

                        XOR EAX, EAX
                        XOR EBX, EBX
                        XOR ECX, ECX

                        MOV EBX, p_icmp_header
                        MOV AH, BYTE PTR [EBX]
                        MOV AL, BYTE PTR [EBX+1]    ;Type-Code
                        NOT AX

                        MOV CX, WORD PTR [EBX+2]    ;CheckSum (must be zero)
                        NOT CX
                        ADD EAX, ECX

                        MOV CX, WORD PTR [EBX+4]    ;ID
                        NOT CX
                        ADD EAX, ECX
                        
                        MOV CX, WORD PTR [EBX+6]    ;Seq
                        NOT CX
                        ADD EAX, ECX
                      
                        MOV CH, BYTE PTR [EBX+8]    ;Data

                        
                        .IF p_icmp_data == 0
                            MOV CL, 0
                            NOT CX
                            ADD EAX, ECX
                            JMP skip_1
                        .ENDIF

                        MOV EBX, p_icmp_data
                        MOV CL, BYTE PTR [EBX]
                        NOT CX
                        ADD EAX, ECX
                        MOV temp, EAX


                        ;If the ICMP datagram's data has the size of just one byte: 
                                               
                        .IF len_icmp_data == 1
                            JMP skip_1
                        .ENDIF

                        MOV ECX, len_icmp_data
                        DEC ECX
                        INC p_icmp_data
                        INVOKE  data_checksum, p_icmp_data, ECX
                        MOV ECX, EAX
                        MOV EAX, temp
                        ADD EAX, ECX

skip_1:                        
                        MOV ECX, EAX
                        SHR ECX, 16

                        ADD EAX, ECX
                        AND EAX, 0FFFFH

                        RET
icmp_checksum           ENDP

;---------------------------------------------------------------------------------------------------------------------
;This function calculates the checksum for UDP protocol. Since the calculation of UDP checksum
;are the same 

;Esta funcion calcula la suma de comprobacion (CheckSum) para el protocolo UDP. Puesto que el
;calculo del CheckSum del protocolo UDP es exactamente el mismo que para el protocolo TCP, esta
;funcion se vale de las mismas funciones que la funcion tcp_checksum. (data_checksum, 
;ip_pseudohdr_checksum).
;---------------------------------------------------------------------------------------------------------------------
udp_checksum        PROC USES EBX ECX p_udp_header:DWORD, p_udp_data:DWORD, len_data:DWORD, p_ip_header:DWORD
                    LOCAL temp:DWORD

                    ;Registers are reset
                    XOR EAX, EAX
                    XOR EBX, EBX
                    XOR ECX, ECX


                    MOV EBX, p_udp_header

                    MOV AX, WORD PTR [EBX]          ;Source Port
                    MOV CX, WORD PTR [EBX + 2]      ;Destination Port
                    NOT AX
                    NOT CX
                    ADD EAX, ECX

                    MOV CX, WORD PTR [EBX + 4]      ;Length
                    NOT CX
                    ADD EAX, ECX

                    MOV CX, WORD PTR [EBX + 6]      ;CheckSum (must be zero)
                    NOT CX
                    ADD EAX, ECX

                    MOV temp, EAX

                    .IF p_udp_data==0        ;If there is no data, 
                        JMP skip_1      	   ;skip data calculation
                    .ENDIF

                    INVOKE data_checksum, p_udp_data, len_data
                    ADD temp, EAX
                                                          
skip_1:                  
                   
                    INVOKE ip_pseudohdr_checksum, p_ip_header
                    ADD temp, EAX

                    ;Now, with the sum of all the "partial checksums", operations with the carry 
                    ;value are carried out to get the final result
                    
                    MOV EAX, temp
                    SHR EAX, 16
                    ADD temp, EAX
                    AND temp, 0FFFFH

                    MOV EAX, temp

                    RET
udp_checksum        ENDP

;---------------------------------------------------------------------------------------------------------------------
;This function calculates the chacksum for PPP packets. Two registers will be used as indexes
;to address the elements of two different arrays of bytes: EBX and ECX. EBX will be used to point
;to the elements of the fctab[256] table while ECX will be used to point to the elements of the array of 
;bytes with the PPP data.
;Since the PPP chekcsum calculation is quite complex, the original expression (that was written in a high
;level language) was divided in 2 parts.

;Esta funcion calcula la suma de comprobacion para paquetes PPP. Se utilizaran dos registros 
;como indices para apuntar a los elementos de dos matrices diferentes: EBX y ECX. EBX sera
;utilizado para apuntar a los elementos de la tabla fcstab[256], mientras que ECX sera
;utilizado para apuntar a los elementos de la matriz de datos del paquete.
;Puesto que el caculo de la suma de comprobacion del protocolo PPP resulta ser bastante
;complejo, a la expresion original (escrita en un lenjuaje de alto nivel) se la dividio en
;2 partes.
;---------------------------------------------------------------------------------------------------------------------
ppp_checksum        PROC    USES EBX ECX   p_ppp_data:DWORD, len_ppp_data:DWORD
                    LOCAL counter_1:DWORD, temp_1:WORD, temp_2:WORD

                    ;Variables and registers are reset
                    XOR EAX, EAX
                    XOR EBX, EBX
                    XOR ECX, ECX
                    AND counter_1, 0
                    AND temp_1, 0
                    
                    MOV EBX, p_ppp_data  ;Now EBX points to the array of bytes.

                    MOV ECX, EBX         

                    MOV AX, pppinitfcs16
                    MOV fcs, AX

                    MOV EAX, len_ppp_data
                    MOV counter_1, EAX

                    .WHILE counter_1 != 0

	                                    ;_____________________________
                        MOV AX, fcs     	;Part I: the result is stored
                        SHR AX, 8       	;in the variable temp_1
                        MOV temp_1, AX  	;_____________________________

                        XOR EBX, EBX
                        
                                        	;_____________________________
                        MOV BX, fcs     	;
                        XOR EAX, EAX    	;Part II: the result of this part 
                        MOV AL, [ECX]   	;will be used as an index 
                        XOR BX, AX      	;for addressing a value
                        AND BX, 0FFH    	;in the fcstab[256] table
                                        	;
                        SHL BX, 1       	;_____________________________
                                        		
                        


                        MOV AX, fcstab[EBX] 	;Now AX stores the value of one of the 
                                            	;elemens of the fctab table pointed by EBX.
                                            
                        XOR AX, temp_1      	;Final operation (An XOR between the first and  
                                           	;second part.

                        MOV fcs, AX         	;The result is asigned to the variable fcs
                                           		
                                        
                        INC ECX
                        DEC counter_1
                    .ENDW

                    MOV AX, fcs

                    ;Now, the final operations

                    XOR AX, 0FFFFH
                    AND EAX, 0FFFFH
                    XCHG AL, AH

                    RET
ppp_checksum        ENDP

;---------------------------------------------------------------------------------------------------------------------
;This function receives a pointer to an array of bytes with the PPP data. Later, by using a temporal array, 
;it encapsulates the PPP data and leaves it ready to be sent. The new size of the array of bytes is returned 
;in EAX.

;Este procedimiento recibe una matriz con los datos PPP para luego, utilizando otra matriz
;temporal, encapsula los datos y los prepara para ser enviados. EL nuevo tamao de la matriz de bytes
;es almacenado en EAX al devolver el control al procedimiento que efectuo la llamada.
;---------------------------------------------------------------------------------------------------------------------
ppp_encapsulate_data    PROC  USES EBX ECX EDX   p_ppp_data:DWORD, len_ppp_data:DWORD
                        LOCAL counter:DWORD

                        ;Registes and variables are reset.
                        XOR ECX, ECX
                        XOR EDX, EDX
                        AND counter, 0

                        MOV EBX, p_ppp_data
                        
                        MOV temp_array[ECX], 7EH    ;First byte of the PPP packet
                        INC ECX

                        .WHILE EDX != len_ppp_data
                        
                            MOV AL, BYTE PTR [EBX + EDX]
                              
                            
                            .IF ((AL < 20H) || (AL == 7EH) || (AL == 7DH))
                                MOV temp_array[ECX], 7DH
                                INC ECX
                                XOR AL, 20H
                                MOV temp_array[ECX], AL
                            .ELSE
                                MOV temp_array[ECX], AL
                            .ENDIF                                

                            INC EDX
                            INC ECX

                        .ENDW

                        MOV temp_array[ECX], 7EH    ;The last byte of the PPP packet.

                                               
                        MOV counter, ECX
                        INC counter

	      		;The register that will be used as a counter (EDX) and the register that will
	                  ;will be used as an index over the temporal array are reset.
                                                                            
                        XOR EDX, EDX  
                        XOR ECX, ECX
          
	      		;Now, the bytes of the temporal array will be put into the array that will
                        ;actually store the PPP data.
                       
                        .WHILE EDX != counter
                            MOV AL, temp_array[ECX]
                            MOV [EBX + EDX], AL
                            INC EDX
                            INC ECX
                        .ENDW

                        MOV EAX, EDX

                        RET
ppp_encapsulate_data    ENDP

;---------------------------------------------------------------------------------------------------------------------
;This procedure calculates and stores the values of the fctab[256] table, which is used 
;when calculating the checksum for the PPP protocol. This procedure is called at the Dll entry point
;procedure.

;Este procedimiento calcula y carga los valores correpondientes a los elementos de la matriz 
;fctab[256] la cual es utilizada para el calculo de la suma de comprobacion del protocolo PPP. 
;El mismo es llamado al comienzo del programa.
;---------------------------------------------------------------------------------------------------------------------
ppp_fcstab_load      PROC USES EBX EAX
                     LOCAL counter_1:WORD, counter_2:WORD, temp_1:WORD, temp_2:DWORD
                
                     ;Registers and variables are reset.
                     AND counter_1, 0
                     AND counter_2, 0
                     AND temp_1, 0
                     AND temp_2, 0
                     XOR EBX, EBX

                     .WHILE counter_1 != 256
                        MOV AX, counter_1
                        MOV temp_1, AX

                        .WHILE counter_2 != 8
                            AND temp_1, 1
                            
                            .IF temp_1 != 0 
                                SHR AX, 1
                                XOR AX, p
                            .ELSE
                                SHR AX, 1
                            .ENDIF
                            INC counter_2
                            MOV temp_1, AX
                        .ENDW
                        
                        AND counter_2, 0
                        INC counter_1
                        MOV fcstab[EBX], AX
                        ADD EBX, 2
                     .ENDW
                     
                     RET
ppp_fcstab_load      ENDP
;---------------------------------------------------------------------------------------------------------------------

END                 dll_entry