.386
.model flat,stdcall
option casemap:none

include \masm32\include\windows.inc
include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib

DlgProc      PROTO :DWORD,:DWORD,:DWORD,:DWORD

.const
CM_EXIT	equ 101
EB_DATA	equ 101
PB_ADD	equ 102
PB_RETURN	equ 103
PB_NEXT     equ 104

ACCESS_TYPE equ GMEM_MOVEABLE ;Type of memory allocation
MAX_TEXT    equ 16            ;Maximum characters in the edit box


NODE STRUCT
    next DWORD ?
    data db (MAX_TEXT + 1) DUP (?)
NODE ENDS


.data
DlgName  db "MainDlg",0
stub     DWORD 0     ;Address of the root node

.data?
hInstance HINSTANCE ?
hNext     HWND ?     ;Handle of the Next button
hReturn   HWND ?     ;Handle of the Return button
current   DWORD ?    ;Address of the current node

.code
start:
    invoke GetModuleHandle, NULL
    mov hInstance, eax

    invoke DialogBoxParam, eax, ADDR DlgName, NULL, ADDR DlgProc, NULL
    invoke ExitProcess, eax

DlgProc PROC hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM
    .IF uMsg==WM_INITDIALOG
        invoke GetDlgItem, hWnd, PB_NEXT ;Get the handle to the "Next" button
        mov hNext, eax
        invoke EnableWindow, eax, FALSE  ;Disable the "Next" button

        invoke GetDlgItem, hWnd, PB_RETURN ;Get the handle of the "Return" button
        mov hReturn, eax
        invoke EnableWindow, eax, FALSE    ;Disable it!

        invoke GetDlgItem, hWnd, EB_DATA   ;Get the handle of the edit box
        invoke SendMessage, eax, EM_LIMITTEXT, MAX_TEXT, 0 ;Limit it to MAX_TEXT characters
        
    .ELSEIF uMsg==WM_CLOSE
	  invoke SendMessage,hWnd,WM_COMMAND,CM_EXIT,0
        ;If closed, act like it was the "Exit" command from the menu

    .ELSEIF uMsg==WM_COMMAND
	  mov eax,wParam
        .IF lParam==0
	      .IF ax==CM_EXIT ;Menu - exit
                mov edx, stub ;Start at the root node

                .WHILE edx != 0
                    invoke GlobalLock, current
                    push (NODE PTR [eax]).next ;Store the next pointer
                    invoke GlobalUnlock, current

                    invoke GlobalFree, current ;Delete current pointer
                    pop edx ;Move on to the next
                .ENDW

		    invoke EndDialog, hWnd,NULL ;Exit the dialog box proc
	      .ENDIF
        .ELSE
		mov edx,wParam
		shr edx,16
		.IF dx==BN_CLICKED
		   .IF ax==PB_ADD
                    .IF stub==0 ;If there is no root
                        invoke GlobalAlloc, ACCESS_TYPE, SIZEOF NODE ;Create one
                        mov stub, eax       ;Set the root pointer
                        mov current, eax    ;Set the current pointer

                        invoke GlobalLock, eax ;Lock new node for access

                        mov (NODE PTR [eax]).next, 0 ;Set the terminator

                        lea eax, (NODE PTR [eax]).data
                        invoke GetDlgItemText, hWnd, EB_DATA, eax, MAX_TEXT
                        ;Fill the allocated space with the text from EB_DATA (the edit box)

                        invoke GlobalUnlock, current
                        ;Unlock data, text has been copied

                    .ELSE ;A linked list already exists!
                        invoke GlobalLock, current
                        push eax
                        push eax

                        invoke GlobalAlloc, ACCESS_TYPE, SIZEOF NODE ;Create a new node
                        pop edx
                        push eax

                        push (NODE PTR [edx]).next
                        mov (NODE PTR [edx]).next, eax

                        invoke GlobalLock, eax
                        pop edx
                        mov (NODE PTR [eax]).next, edx

                        lea eax, (NODE PTR [eax]).data
                        invoke GetDlgItemText, hWnd, EB_DATA, eax, MAX_TEXT
                        ;Fill the allocated space with the data from the edit box

                        pop eax
                        invoke GlobalUnlock, eax     ;Unlock the newly allocated space

                        pop edx
                        lea eax, (NODE PTR [edx]).data
                        invoke SetDlgItemText, hWnd, EB_DATA, eax
                        ;Restore the text to that of the current node

                        invoke GlobalUnlock, current ;Unlock the current pointer

                        invoke EnableWindow, hNext, TRUE
                        ;Make sure the "Next" button is enabled
                    .ENDIF

               .ELSEIF ax==PB_RETURN
                        mov eax, stub
                        mov current, eax ;Make current = stub

                        invoke GlobalLock, eax
                        lea eax, (NODE PTR [eax]).data

                        invoke SetDlgItemText, hWnd, EB_DATA, eax

                        invoke GlobalUnlock, stub

                        invoke EnableWindow, hReturn, FALSE
                        invoke EnableWindow, hNext, TRUE
                        ;Update buttons etc.

               .ELSEIF ax==PB_NEXT
                        invoke GlobalLock, current

                        push (NODE PTR [eax]).next

                        invoke GlobalUnlock, current

                        pop eax
                        mov current, eax
                        invoke GlobalLock, eax
                        push eax

                        lea eax, (NODE PTR [eax]).data
                        invoke SetDlgItemText, hWnd, EB_DATA, eax
                        ;Get appropriate text

                        pop edx
                        mov eax, (NODE PTR [edx]).next
                        .IF eax==0 ;If the next node is the null terminator
                            invoke EnableWindow, hNext, FALSE ;Disable the "Next" button
                        .ENDIF

                        invoke EnableWindow, hReturn, TRUE ;Enable the "Return" button

                        invoke GlobalUnlock, current
		   .ENDIF
		.ENDIF
	  .ENDIF
    .ELSE
        mov eax, FALSE
	  ret
    .ENDIF
    mov eax,TRUE
    ret
DlgProc endp

end start
